/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPlanRequest extends GlueRequest implements ToCopyableBuilder<GetPlanRequest.Builder, GetPlanRequest> {
    private static final SdkField<List<MappingEntry>> MAPPING_FIELD = SdkField
            .<List<MappingEntry>> builder(MarshallingType.LIST)
            .memberName("Mapping")
            .getter(getter(GetPlanRequest::mapping))
            .setter(setter(Builder::mapping))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MappingEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(MappingEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CatalogEntry> SOURCE_FIELD = SdkField.<CatalogEntry> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(GetPlanRequest::source)).setter(setter(Builder::source))
            .constructor(CatalogEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<List<CatalogEntry>> SINKS_FIELD = SdkField
            .<List<CatalogEntry>> builder(MarshallingType.LIST)
            .memberName("Sinks")
            .getter(getter(GetPlanRequest::sinks))
            .setter(setter(Builder::sinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sinks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CatalogEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(CatalogEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Location> LOCATION_FIELD = SdkField.<Location> builder(MarshallingType.SDK_POJO)
            .memberName("Location").getter(getter(GetPlanRequest::location)).setter(setter(Builder::location))
            .constructor(Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(GetPlanRequest::languageAsString)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<Map<String, String>> ADDITIONAL_PLAN_OPTIONS_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdditionalPlanOptionsMap")
            .getter(getter(GetPlanRequest::additionalPlanOptionsMap))
            .setter(setter(Builder::additionalPlanOptionsMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalPlanOptionsMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAPPING_FIELD, SOURCE_FIELD,
            SINKS_FIELD, LOCATION_FIELD, LANGUAGE_FIELD, ADDITIONAL_PLAN_OPTIONS_MAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MappingEntry> mapping;

    private final CatalogEntry source;

    private final List<CatalogEntry> sinks;

    private final Location location;

    private final String language;

    private final Map<String, String> additionalPlanOptionsMap;

    private GetPlanRequest(BuilderImpl builder) {
        super(builder);
        this.mapping = builder.mapping;
        this.source = builder.source;
        this.sinks = builder.sinks;
        this.location = builder.location;
        this.language = builder.language;
        this.additionalPlanOptionsMap = builder.additionalPlanOptionsMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the Mapping property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMapping() {
        return mapping != null && !(mapping instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of mappings from a source table to target tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMapping} method.
     * </p>
     * 
     * @return The list of mappings from a source table to target tables.
     */
    public final List<MappingEntry> mapping() {
        return mapping;
    }

    /**
     * <p>
     * The source table.
     * </p>
     * 
     * @return The source table.
     */
    public final CatalogEntry source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sinks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSinks() {
        return sinks != null && !(sinks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSinks} method.
     * </p>
     * 
     * @return The target tables.
     */
    public final List<CatalogEntry> sinks() {
        return sinks;
    }

    /**
     * <p>
     * The parameters for the mapping.
     * </p>
     * 
     * @return The parameters for the mapping.
     */
    public final Location location() {
        return location;
    }

    /**
     * <p>
     * The programming language of the code to perform the mapping.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link Language#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageAsString}.
     * </p>
     * 
     * @return The programming language of the code to perform the mapping.
     * @see Language
     */
    public final Language language() {
        return Language.fromValue(language);
    }

    /**
     * <p>
     * The programming language of the code to perform the mapping.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link Language#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageAsString}.
     * </p>
     * 
     * @return The programming language of the code to perform the mapping.
     * @see Language
     */
    public final String languageAsString() {
        return language;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalPlanOptionsMap property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalPlanOptionsMap() {
        return additionalPlanOptionsMap != null && !(additionalPlanOptionsMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map to hold additional optional key-value parameters.
     * </p>
     * <p>
     * Currently, these key-value pairs are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>inferSchema</code>  —  Specifies whether to set <code>inferSchema</code> to true or false for the default
     * script generated by an Glue job. For example, to set <code>inferSchema</code> to true, pass the following key
     * value pair:
     * </p>
     * <p>
     * <code>--additional-plan-options-map '{"inferSchema":"true"}'</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalPlanOptionsMap} method.
     * </p>
     * 
     * @return A map to hold additional optional key-value parameters.</p>
     *         <p>
     *         Currently, these key-value pairs are supported:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>inferSchema</code>  —  Specifies whether to set <code>inferSchema</code> to true or false for the
     *         default script generated by an Glue job. For example, to set <code>inferSchema</code> to true, pass the
     *         following key value pair:
     *         </p>
     *         <p>
     *         <code>--additional-plan-options-map '{"inferSchema":"true"}'</code>
     *         </p>
     *         </li>
     */
    public final Map<String, String> additionalPlanOptionsMap() {
        return additionalPlanOptionsMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMapping() ? mapping() : null);
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasSinks() ? sinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalPlanOptionsMap() ? additionalPlanOptionsMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlanRequest)) {
            return false;
        }
        GetPlanRequest other = (GetPlanRequest) obj;
        return hasMapping() == other.hasMapping() && Objects.equals(mapping(), other.mapping())
                && Objects.equals(source(), other.source()) && hasSinks() == other.hasSinks()
                && Objects.equals(sinks(), other.sinks()) && Objects.equals(location(), other.location())
                && Objects.equals(languageAsString(), other.languageAsString())
                && hasAdditionalPlanOptionsMap() == other.hasAdditionalPlanOptionsMap()
                && Objects.equals(additionalPlanOptionsMap(), other.additionalPlanOptionsMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPlanRequest").add("Mapping", hasMapping() ? mapping() : null).add("Source", source())
                .add("Sinks", hasSinks() ? sinks() : null).add("Location", location()).add("Language", languageAsString())
                .add("AdditionalPlanOptionsMap", hasAdditionalPlanOptionsMap() ? additionalPlanOptionsMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mapping":
            return Optional.ofNullable(clazz.cast(mapping()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Sinks":
            return Optional.ofNullable(clazz.cast(sinks()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Language":
            return Optional.ofNullable(clazz.cast(languageAsString()));
        case "AdditionalPlanOptionsMap":
            return Optional.ofNullable(clazz.cast(additionalPlanOptionsMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Mapping", MAPPING_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("Sinks", SINKS_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        map.put("AdditionalPlanOptionsMap", ADDITIONAL_PLAN_OPTIONS_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPlanRequest, T> g) {
        return obj -> g.apply((GetPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPlanRequest> {
        /**
         * <p>
         * The list of mappings from a source table to target tables.
         * </p>
         * 
         * @param mapping
         *        The list of mappings from a source table to target tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapping(Collection<MappingEntry> mapping);

        /**
         * <p>
         * The list of mappings from a source table to target tables.
         * </p>
         * 
         * @param mapping
         *        The list of mappings from a source table to target tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapping(MappingEntry... mapping);

        /**
         * <p>
         * The list of mappings from a source table to target tables.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.MappingEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.MappingEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.MappingEntry.Builder#build()} is called immediately and its
         * result is passed to {@link #mapping(List<MappingEntry>)}.
         * 
         * @param mapping
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.MappingEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapping(java.util.Collection<MappingEntry>)
         */
        Builder mapping(Consumer<MappingEntry.Builder>... mapping);

        /**
         * <p>
         * The source table.
         * </p>
         * 
         * @param source
         *        The source table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(CatalogEntry source);

        /**
         * <p>
         * The source table.
         * </p>
         * This is a convenience method that creates an instance of the {@link CatalogEntry.Builder} avoiding the need
         * to create one manually via {@link CatalogEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CatalogEntry.Builder#build()} is called immediately and its
         * result is passed to {@link #source(CatalogEntry)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link CatalogEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(CatalogEntry)
         */
        default Builder source(Consumer<CatalogEntry.Builder> source) {
            return source(CatalogEntry.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The target tables.
         * </p>
         * 
         * @param sinks
         *        The target tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinks(Collection<CatalogEntry> sinks);

        /**
         * <p>
         * The target tables.
         * </p>
         * 
         * @param sinks
         *        The target tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinks(CatalogEntry... sinks);

        /**
         * <p>
         * The target tables.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.CatalogEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.CatalogEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.CatalogEntry.Builder#build()} is called immediately and its
         * result is passed to {@link #sinks(List<CatalogEntry>)}.
         * 
         * @param sinks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.CatalogEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sinks(java.util.Collection<CatalogEntry>)
         */
        Builder sinks(Consumer<CatalogEntry.Builder>... sinks);

        /**
         * <p>
         * The parameters for the mapping.
         * </p>
         * 
         * @param location
         *        The parameters for the mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(Location location);

        /**
         * <p>
         * The parameters for the mapping.
         * </p>
         * This is a convenience method that creates an instance of the {@link Location.Builder} avoiding the need to
         * create one manually via {@link Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Location.Builder#build()} is called immediately and its result is
         * passed to {@link #location(Location)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(Location)
         */
        default Builder location(Consumer<Location.Builder> location) {
            return location(Location.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The programming language of the code to perform the mapping.
         * </p>
         * 
         * @param language
         *        The programming language of the code to perform the mapping.
         * @see Language
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Language
         */
        Builder language(String language);

        /**
         * <p>
         * The programming language of the code to perform the mapping.
         * </p>
         * 
         * @param language
         *        The programming language of the code to perform the mapping.
         * @see Language
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Language
         */
        Builder language(Language language);

        /**
         * <p>
         * A map to hold additional optional key-value parameters.
         * </p>
         * <p>
         * Currently, these key-value pairs are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>inferSchema</code>  —  Specifies whether to set <code>inferSchema</code> to true or false for the
         * default script generated by an Glue job. For example, to set <code>inferSchema</code> to true, pass the
         * following key value pair:
         * </p>
         * <p>
         * <code>--additional-plan-options-map '{"inferSchema":"true"}'</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param additionalPlanOptionsMap
         *        A map to hold additional optional key-value parameters.</p>
         *        <p>
         *        Currently, these key-value pairs are supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>inferSchema</code>  —  Specifies whether to set <code>inferSchema</code> to true or false for
         *        the default script generated by an Glue job. For example, to set <code>inferSchema</code> to true,
         *        pass the following key value pair:
         *        </p>
         *        <p>
         *        <code>--additional-plan-options-map '{"inferSchema":"true"}'</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalPlanOptionsMap(Map<String, String> additionalPlanOptionsMap);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private List<MappingEntry> mapping = DefaultSdkAutoConstructList.getInstance();

        private CatalogEntry source;

        private List<CatalogEntry> sinks = DefaultSdkAutoConstructList.getInstance();

        private Location location;

        private String language;

        private Map<String, String> additionalPlanOptionsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlanRequest model) {
            super(model);
            mapping(model.mapping);
            source(model.source);
            sinks(model.sinks);
            location(model.location);
            language(model.language);
            additionalPlanOptionsMap(model.additionalPlanOptionsMap);
        }

        public final List<MappingEntry.Builder> getMapping() {
            List<MappingEntry.Builder> result = MappingListCopier.copyToBuilder(this.mapping);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMapping(Collection<MappingEntry.BuilderImpl> mapping) {
            this.mapping = MappingListCopier.copyFromBuilder(mapping);
        }

        @Override
        public final Builder mapping(Collection<MappingEntry> mapping) {
            this.mapping = MappingListCopier.copy(mapping);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(MappingEntry... mapping) {
            mapping(Arrays.asList(mapping));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(Consumer<MappingEntry.Builder>... mapping) {
            mapping(Stream.of(mapping).map(c -> MappingEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CatalogEntry.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(CatalogEntry.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(CatalogEntry source) {
            this.source = source;
            return this;
        }

        public final List<CatalogEntry.Builder> getSinks() {
            List<CatalogEntry.Builder> result = CatalogEntriesCopier.copyToBuilder(this.sinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSinks(Collection<CatalogEntry.BuilderImpl> sinks) {
            this.sinks = CatalogEntriesCopier.copyFromBuilder(sinks);
        }

        @Override
        public final Builder sinks(Collection<CatalogEntry> sinks) {
            this.sinks = CatalogEntriesCopier.copy(sinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(CatalogEntry... sinks) {
            sinks(Arrays.asList(sinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(Consumer<CatalogEntry.Builder>... sinks) {
            sinks(Stream.of(sinks).map(c -> CatalogEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Location.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(Language language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final Map<String, String> getAdditionalPlanOptionsMap() {
            if (additionalPlanOptionsMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalPlanOptionsMap;
        }

        public final void setAdditionalPlanOptionsMap(Map<String, String> additionalPlanOptionsMap) {
            this.additionalPlanOptionsMap = AdditionalPlanOptionsMapCopier.copy(additionalPlanOptionsMap);
        }

        @Override
        public final Builder additionalPlanOptionsMap(Map<String, String> additionalPlanOptionsMap) {
            this.additionalPlanOptionsMap = AdditionalPlanOptionsMapCopier.copy(additionalPlanOptionsMap);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPlanRequest build() {
            return new GetPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
