/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSchemaVersionsRequest extends GlueRequest implements
        ToCopyableBuilder<DeleteSchemaVersionsRequest.Builder, DeleteSchemaVersionsRequest> {
    private static final SdkField<SchemaId> SCHEMA_ID_FIELD = SdkField.<SchemaId> builder(MarshallingType.SDK_POJO)
            .memberName("SchemaId").getter(getter(DeleteSchemaVersionsRequest::schemaId)).setter(setter(Builder::schemaId))
            .constructor(SchemaId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()).build();

    private static final SdkField<String> VERSIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Versions").getter(getter(DeleteSchemaVersionsRequest::versions)).setter(setter(Builder::versions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Versions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD,
            VERSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SchemaId schemaId;

    private final String versions;

    private DeleteSchemaVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.schemaId = builder.schemaId;
        this.versions = builder.versions;
    }

    /**
     * <p>
     * This is a wrapper structure that may contain the schema name and Amazon Resource Name (ARN).
     * </p>
     * 
     * @return This is a wrapper structure that may contain the schema name and Amazon Resource Name (ARN).
     */
    public final SchemaId schemaId() {
        return schemaId;
    }

    /**
     * <p>
     * A version range may be supplied which may be of the format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * a single version number, 5
     * </p>
     * </li>
     * <li>
     * <p>
     * a range, 5-8 : deletes versions 5, 6, 7, 8
     * </p>
     * </li>
     * </ul>
     * 
     * @return A version range may be supplied which may be of the format:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         a single version number, 5
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         a range, 5-8 : deletes versions 5, 6, 7, 8
     *         </p>
     *         </li>
     */
    public final String versions() {
        return versions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(versions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSchemaVersionsRequest)) {
            return false;
        }
        DeleteSchemaVersionsRequest other = (DeleteSchemaVersionsRequest) obj;
        return Objects.equals(schemaId(), other.schemaId()) && Objects.equals(versions(), other.versions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteSchemaVersionsRequest").add("SchemaId", schemaId()).add("Versions", versions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaId":
            return Optional.ofNullable(clazz.cast(schemaId()));
        case "Versions":
            return Optional.ofNullable(clazz.cast(versions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SchemaId", SCHEMA_ID_FIELD);
        map.put("Versions", VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSchemaVersionsRequest, T> g) {
        return obj -> g.apply((DeleteSchemaVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteSchemaVersionsRequest> {
        /**
         * <p>
         * This is a wrapper structure that may contain the schema name and Amazon Resource Name (ARN).
         * </p>
         * 
         * @param schemaId
         *        This is a wrapper structure that may contain the schema name and Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaId(SchemaId schemaId);

        /**
         * <p>
         * This is a wrapper structure that may contain the schema name and Amazon Resource Name (ARN).
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaId.Builder} avoiding the need to
         * create one manually via {@link SchemaId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaId.Builder#build()} is called immediately and its result is
         * passed to {@link #schemaId(SchemaId)}.
         * 
         * @param schemaId
         *        a consumer that will call methods on {@link SchemaId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaId(SchemaId)
         */
        default Builder schemaId(Consumer<SchemaId.Builder> schemaId) {
            return schemaId(SchemaId.builder().applyMutation(schemaId).build());
        }

        /**
         * <p>
         * A version range may be supplied which may be of the format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * a single version number, 5
         * </p>
         * </li>
         * <li>
         * <p>
         * a range, 5-8 : deletes versions 5, 6, 7, 8
         * </p>
         * </li>
         * </ul>
         * 
         * @param versions
         *        A version range may be supplied which may be of the format:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        a single version number, 5
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        a range, 5-8 : deletes versions 5, 6, 7, 8
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(String versions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private SchemaId schemaId;

        private String versions;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSchemaVersionsRequest model) {
            super(model);
            schemaId(model.schemaId);
            versions(model.versions);
        }

        public final SchemaId.Builder getSchemaId() {
            return schemaId != null ? schemaId.toBuilder() : null;
        }

        public final void setSchemaId(SchemaId.BuilderImpl schemaId) {
            this.schemaId = schemaId != null ? schemaId.build() : null;
        }

        @Override
        public final Builder schemaId(SchemaId schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final String getVersions() {
            return versions;
        }

        public final void setVersions(String versions) {
            this.versions = versions;
        }

        @Override
        public final Builder versions(String versions) {
            this.versions = versions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSchemaVersionsRequest build() {
            return new DeleteSchemaVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
