/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a compaction optimizer. This configuration defines how data files in your table will be
 * compacted to improve query performance and reduce storage costs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompactionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CompactionConfiguration.Builder, CompactionConfiguration> {
    private static final SdkField<IcebergCompactionConfiguration> ICEBERG_CONFIGURATION_FIELD = SdkField
            .<IcebergCompactionConfiguration> builder(MarshallingType.SDK_POJO).memberName("icebergConfiguration")
            .getter(getter(CompactionConfiguration::icebergConfiguration)).setter(setter(Builder::icebergConfiguration))
            .constructor(IcebergCompactionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("icebergConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ICEBERG_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IcebergCompactionConfiguration icebergConfiguration;

    private CompactionConfiguration(BuilderImpl builder) {
        this.icebergConfiguration = builder.icebergConfiguration;
    }

    /**
     * <p>
     * The configuration for an Iceberg compaction optimizer.
     * </p>
     * 
     * @return The configuration for an Iceberg compaction optimizer.
     */
    public final IcebergCompactionConfiguration icebergConfiguration() {
        return icebergConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(icebergConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompactionConfiguration)) {
            return false;
        }
        CompactionConfiguration other = (CompactionConfiguration) obj;
        return Objects.equals(icebergConfiguration(), other.icebergConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompactionConfiguration").add("IcebergConfiguration", icebergConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "icebergConfiguration":
            return Optional.ofNullable(clazz.cast(icebergConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("icebergConfiguration", ICEBERG_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompactionConfiguration, T> g) {
        return obj -> g.apply((CompactionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompactionConfiguration> {
        /**
         * <p>
         * The configuration for an Iceberg compaction optimizer.
         * </p>
         * 
         * @param icebergConfiguration
         *        The configuration for an Iceberg compaction optimizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icebergConfiguration(IcebergCompactionConfiguration icebergConfiguration);

        /**
         * <p>
         * The configuration for an Iceberg compaction optimizer.
         * </p>
         * This is a convenience method that creates an instance of the {@link IcebergCompactionConfiguration.Builder}
         * avoiding the need to create one manually via {@link IcebergCompactionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IcebergCompactionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #icebergConfiguration(IcebergCompactionConfiguration)}.
         * 
         * @param icebergConfiguration
         *        a consumer that will call methods on {@link IcebergCompactionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #icebergConfiguration(IcebergCompactionConfiguration)
         */
        default Builder icebergConfiguration(Consumer<IcebergCompactionConfiguration.Builder> icebergConfiguration) {
            return icebergConfiguration(IcebergCompactionConfiguration.builder().applyMutation(icebergConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IcebergCompactionConfiguration icebergConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CompactionConfiguration model) {
            icebergConfiguration(model.icebergConfiguration);
        }

        public final IcebergCompactionConfiguration.Builder getIcebergConfiguration() {
            return icebergConfiguration != null ? icebergConfiguration.toBuilder() : null;
        }

        public final void setIcebergConfiguration(IcebergCompactionConfiguration.BuilderImpl icebergConfiguration) {
            this.icebergConfiguration = icebergConfiguration != null ? icebergConfiguration.build() : null;
        }

        @Override
        public final Builder icebergConfiguration(IcebergCompactionConfiguration icebergConfiguration) {
            this.icebergConfiguration = icebergConfiguration;
            return this;
        }

        @Override
        public CompactionConfiguration build() {
            return new CompactionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
