/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.CreateIcebergTableInput;
import software.amazon.awssdk.services.glue.model.MetadataOperation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergInput> {
    private static final SdkField<String> METADATA_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataOperation").getter(IcebergInput.getter(IcebergInput::metadataOperationAsString)).setter(IcebergInput.setter(Builder::metadataOperation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOperation").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(IcebergInput.getter(IcebergInput::version)).setter(IcebergInput.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<CreateIcebergTableInput> CREATE_ICEBERG_TABLE_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreateIcebergTableInput").getter(IcebergInput.getter(IcebergInput::createIcebergTableInput)).setter(IcebergInput.setter(Builder::createIcebergTableInput)).constructor(CreateIcebergTableInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateIcebergTableInput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_OPERATION_FIELD, VERSION_FIELD, CREATE_ICEBERG_TABLE_INPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metadataOperation;
    private final String version;
    private final CreateIcebergTableInput createIcebergTableInput;

    private IcebergInput(BuilderImpl builder) {
        this.metadataOperation = builder.metadataOperation;
        this.version = builder.version;
        this.createIcebergTableInput = builder.createIcebergTableInput;
    }

    public final MetadataOperation metadataOperation() {
        return MetadataOperation.fromValue(this.metadataOperation);
    }

    public final String metadataOperationAsString() {
        return this.metadataOperation;
    }

    public final String version() {
        return this.version;
    }

    public final CreateIcebergTableInput createIcebergTableInput() {
        return this.createIcebergTableInput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataOperationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.createIcebergTableInput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergInput)) {
            return false;
        }
        IcebergInput other = (IcebergInput)obj;
        return Objects.equals(this.metadataOperationAsString(), other.metadataOperationAsString()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.createIcebergTableInput(), other.createIcebergTableInput());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergInput").add("MetadataOperation", (Object)this.metadataOperationAsString()).add("Version", (Object)this.version()).add("CreateIcebergTableInput", (Object)this.createIcebergTableInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetadataOperation": {
                return Optional.ofNullable(clazz.cast(this.metadataOperationAsString()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "CreateIcebergTableInput": {
                return Optional.ofNullable(clazz.cast(this.createIcebergTableInput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetadataOperation", METADATA_OPERATION_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("CreateIcebergTableInput", CREATE_ICEBERG_TABLE_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergInput, T> g) {
        return obj -> g.apply((IcebergInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metadataOperation;
        private String version;
        private CreateIcebergTableInput createIcebergTableInput;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergInput model) {
            this.metadataOperation(model.metadataOperation);
            this.version(model.version);
            this.createIcebergTableInput(model.createIcebergTableInput);
        }

        public final String getMetadataOperation() {
            return this.metadataOperation;
        }

        public final void setMetadataOperation(String metadataOperation) {
            this.metadataOperation = metadataOperation;
        }

        @Override
        public final Builder metadataOperation(String metadataOperation) {
            this.metadataOperation = metadataOperation;
            return this;
        }

        @Override
        public final Builder metadataOperation(MetadataOperation metadataOperation) {
            this.metadataOperation(metadataOperation == null ? null : metadataOperation.toString());
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final CreateIcebergTableInput.Builder getCreateIcebergTableInput() {
            return this.createIcebergTableInput != null ? this.createIcebergTableInput.toBuilder() : null;
        }

        public final void setCreateIcebergTableInput(CreateIcebergTableInput.BuilderImpl createIcebergTableInput) {
            this.createIcebergTableInput = createIcebergTableInput != null ? createIcebergTableInput.build() : null;
        }

        @Override
        public final Builder createIcebergTableInput(CreateIcebergTableInput createIcebergTableInput) {
            this.createIcebergTableInput = createIcebergTableInput;
            return this;
        }

        public IcebergInput build() {
            return new IcebergInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergInput> {
        public Builder metadataOperation(String var1);

        public Builder metadataOperation(MetadataOperation var1);

        public Builder version(String var1);

        public Builder createIcebergTableInput(CreateIcebergTableInput var1);

        default public Builder createIcebergTableInput(Consumer<CreateIcebergTableInput.Builder> createIcebergTableInput) {
            return this.createIcebergTableInput((CreateIcebergTableInput)((CreateIcebergTableInput.Builder)CreateIcebergTableInput.builder().applyMutation(createIcebergTableInput)).build());
        }
    }
}

