/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ConnectionsList;
import software.amazon.awssdk.services.glue.model.OrchestrationArgumentsMapCopier;
import software.amazon.awssdk.services.glue.model.SessionCommand;
import software.amazon.awssdk.services.glue.model.SessionStatus;
import software.amazon.awssdk.services.glue.model.WorkerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Session
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Session> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Session.getter(Session::id)).setter(Session.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedOn").getter(Session.getter(Session::createdOn)).setter(Session.setter(Builder::createdOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedOn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Session.getter(Session::statusAsString)).setter(Session.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(Session.getter(Session::errorMessage)).setter(Session.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Session.getter(Session::description)).setter(Session.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(Session.getter(Session::role)).setter(Session.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<SessionCommand> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Command").getter(Session.getter(Session::command)).setter(Session.setter(Builder::command)).constructor(SessionCommand::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build()}).build();
    private static final SdkField<Map<String, String>> DEFAULT_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DefaultArguments").getter(Session.getter(Session::defaultArguments)).setter(Session.setter(Builder::defaultArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultArguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ConnectionsList> CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Connections").getter(Session.getter(Session::connections)).setter(Session.setter(Builder::connections)).constructor(ConnectionsList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connections").build()}).build();
    private static final SdkField<Double> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Progress").getter(Session.getter(Session::progress)).setter(Session.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").build()}).build();
    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxCapacity").getter(Session.getter(Session::maxCapacity)).setter(Session.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityConfiguration").getter(Session.getter(Session::securityConfiguration)).setter(Session.setter(Builder::securityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build()}).build();
    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlueVersion").getter(Session.getter(Session::glueVersion)).setter(Session.setter(Builder::glueVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfWorkers").getter(Session.getter(Session::numberOfWorkers)).setter(Session.setter(Builder::numberOfWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()}).build();
    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkerType").getter(Session.getter(Session::workerTypeAsString)).setter(Session.setter(Builder::workerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()}).build();
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedOn").getter(Session.getter(Session::completedOn)).setter(Session.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()}).build();
    private static final SdkField<Double> EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ExecutionTime").getter(Session.getter(Session::executionTime)).setter(Session.setter(Builder::executionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()}).build();
    private static final SdkField<Double> DPU_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DPUSeconds").getter(Session.getter(Session::dpuSeconds)).setter(Session.setter(Builder::dpuSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DPUSeconds").build()}).build();
    private static final SdkField<Integer> IDLE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IdleTimeout").getter(Session.getter(Session::idleTimeout)).setter(Session.setter(Builder::idleTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleTimeout").build()}).build();
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileName").getter(Session.getter(Session::profileName)).setter(Session.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CREATED_ON_FIELD, STATUS_FIELD, ERROR_MESSAGE_FIELD, DESCRIPTION_FIELD, ROLE_FIELD, COMMAND_FIELD, DEFAULT_ARGUMENTS_FIELD, CONNECTIONS_FIELD, PROGRESS_FIELD, MAX_CAPACITY_FIELD, SECURITY_CONFIGURATION_FIELD, GLUE_VERSION_FIELD, NUMBER_OF_WORKERS_FIELD, WORKER_TYPE_FIELD, COMPLETED_ON_FIELD, EXECUTION_TIME_FIELD, DPU_SECONDS_FIELD, IDLE_TIMEOUT_FIELD, PROFILE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Session.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Instant createdOn;
    private final String status;
    private final String errorMessage;
    private final String description;
    private final String role;
    private final SessionCommand command;
    private final Map<String, String> defaultArguments;
    private final ConnectionsList connections;
    private final Double progress;
    private final Double maxCapacity;
    private final String securityConfiguration;
    private final String glueVersion;
    private final Integer numberOfWorkers;
    private final String workerType;
    private final Instant completedOn;
    private final Double executionTime;
    private final Double dpuSeconds;
    private final Integer idleTimeout;
    private final String profileName;

    private Session(BuilderImpl builder) {
        this.id = builder.id;
        this.createdOn = builder.createdOn;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.description = builder.description;
        this.role = builder.role;
        this.command = builder.command;
        this.defaultArguments = builder.defaultArguments;
        this.connections = builder.connections;
        this.progress = builder.progress;
        this.maxCapacity = builder.maxCapacity;
        this.securityConfiguration = builder.securityConfiguration;
        this.glueVersion = builder.glueVersion;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.workerType = builder.workerType;
        this.completedOn = builder.completedOn;
        this.executionTime = builder.executionTime;
        this.dpuSeconds = builder.dpuSeconds;
        this.idleTimeout = builder.idleTimeout;
        this.profileName = builder.profileName;
    }

    public final String id() {
        return this.id;
    }

    public final Instant createdOn() {
        return this.createdOn;
    }

    public final SessionStatus status() {
        return SessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String description() {
        return this.description;
    }

    public final String role() {
        return this.role;
    }

    public final SessionCommand command() {
        return this.command;
    }

    public final boolean hasDefaultArguments() {
        return this.defaultArguments != null && !(this.defaultArguments instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> defaultArguments() {
        return this.defaultArguments;
    }

    public final ConnectionsList connections() {
        return this.connections;
    }

    public final Double progress() {
        return this.progress;
    }

    public final Double maxCapacity() {
        return this.maxCapacity;
    }

    public final String securityConfiguration() {
        return this.securityConfiguration;
    }

    public final String glueVersion() {
        return this.glueVersion;
    }

    public final Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public final WorkerType workerType() {
        return WorkerType.fromValue(this.workerType);
    }

    public final String workerTypeAsString() {
        return this.workerType;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public final Double executionTime() {
        return this.executionTime;
    }

    public final Double dpuSeconds() {
        return this.dpuSeconds;
    }

    public final Integer idleTimeout() {
        return this.idleTimeout;
    }

    public final String profileName() {
        return this.profileName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultArguments() ? this.defaultArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connections());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dpuSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.createdOn(), other.createdOn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.command(), other.command()) && this.hasDefaultArguments() == other.hasDefaultArguments() && Objects.equals(this.defaultArguments(), other.defaultArguments()) && Objects.equals(this.connections(), other.connections()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && Objects.equals(this.glueVersion(), other.glueVersion()) && Objects.equals(this.numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(this.workerTypeAsString(), other.workerTypeAsString()) && Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.executionTime(), other.executionTime()) && Objects.equals(this.dpuSeconds(), other.dpuSeconds()) && Objects.equals(this.idleTimeout(), other.idleTimeout()) && Objects.equals(this.profileName(), other.profileName());
    }

    public final String toString() {
        return ToString.builder((String)"Session").add("Id", (Object)this.id()).add("CreatedOn", (Object)this.createdOn()).add("Status", (Object)this.statusAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("Description", (Object)this.description()).add("Role", (Object)this.role()).add("Command", (Object)this.command()).add("DefaultArguments", this.hasDefaultArguments() ? this.defaultArguments() : null).add("Connections", (Object)this.connections()).add("Progress", (Object)this.progress()).add("MaxCapacity", (Object)this.maxCapacity()).add("SecurityConfiguration", (Object)this.securityConfiguration()).add("GlueVersion", (Object)this.glueVersion()).add("NumberOfWorkers", (Object)this.numberOfWorkers()).add("WorkerType", (Object)this.workerTypeAsString()).add("CompletedOn", (Object)this.completedOn()).add("ExecutionTime", (Object)this.executionTime()).add("DPUSeconds", (Object)this.dpuSeconds()).add("IdleTimeout", (Object)this.idleTimeout()).add("ProfileName", (Object)this.profileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "CreatedOn": {
                return Optional.ofNullable(clazz.cast(this.createdOn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "Command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "DefaultArguments": {
                return Optional.ofNullable(clazz.cast(this.defaultArguments()));
            }
            case "Connections": {
                return Optional.ofNullable(clazz.cast(this.connections()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
            case "GlueVersion": {
                return Optional.ofNullable(clazz.cast(this.glueVersion()));
            }
            case "NumberOfWorkers": {
                return Optional.ofNullable(clazz.cast(this.numberOfWorkers()));
            }
            case "WorkerType": {
                return Optional.ofNullable(clazz.cast(this.workerTypeAsString()));
            }
            case "CompletedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "ExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.executionTime()));
            }
            case "DPUSeconds": {
                return Optional.ofNullable(clazz.cast(this.dpuSeconds()));
            }
            case "IdleTimeout": {
                return Optional.ofNullable(clazz.cast(this.idleTimeout()));
            }
            case "ProfileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("CreatedOn", CREATED_ON_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("Command", COMMAND_FIELD);
        map.put("DefaultArguments", DEFAULT_ARGUMENTS_FIELD);
        map.put("Connections", CONNECTIONS_FIELD);
        map.put("Progress", PROGRESS_FIELD);
        map.put("MaxCapacity", MAX_CAPACITY_FIELD);
        map.put("SecurityConfiguration", SECURITY_CONFIGURATION_FIELD);
        map.put("GlueVersion", GLUE_VERSION_FIELD);
        map.put("NumberOfWorkers", NUMBER_OF_WORKERS_FIELD);
        map.put("WorkerType", WORKER_TYPE_FIELD);
        map.put("CompletedOn", COMPLETED_ON_FIELD);
        map.put("ExecutionTime", EXECUTION_TIME_FIELD);
        map.put("DPUSeconds", DPU_SECONDS_FIELD);
        map.put("IdleTimeout", IDLE_TIMEOUT_FIELD);
        map.put("ProfileName", PROFILE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Session, T> g) {
        return obj -> g.apply((Session)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Instant createdOn;
        private String status;
        private String errorMessage;
        private String description;
        private String role;
        private SessionCommand command;
        private Map<String, String> defaultArguments = DefaultSdkAutoConstructMap.getInstance();
        private ConnectionsList connections;
        private Double progress;
        private Double maxCapacity;
        private String securityConfiguration;
        private String glueVersion;
        private Integer numberOfWorkers;
        private String workerType;
        private Instant completedOn;
        private Double executionTime;
        private Double dpuSeconds;
        private Integer idleTimeout;
        private String profileName;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            this.id(model.id);
            this.createdOn(model.createdOn);
            this.status(model.status);
            this.errorMessage(model.errorMessage);
            this.description(model.description);
            this.role(model.role);
            this.command(model.command);
            this.defaultArguments(model.defaultArguments);
            this.connections(model.connections);
            this.progress(model.progress);
            this.maxCapacity(model.maxCapacity);
            this.securityConfiguration(model.securityConfiguration);
            this.glueVersion(model.glueVersion);
            this.numberOfWorkers(model.numberOfWorkers);
            this.workerType(model.workerType);
            this.completedOn(model.completedOn);
            this.executionTime(model.executionTime);
            this.dpuSeconds(model.dpuSeconds);
            this.idleTimeout(model.idleTimeout);
            this.profileName(model.profileName);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getCreatedOn() {
            return this.createdOn;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final SessionCommand.Builder getCommand() {
            return this.command != null ? this.command.toBuilder() : null;
        }

        public final void setCommand(SessionCommand.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        @Override
        public final Builder command(SessionCommand command) {
            this.command = command;
            return this;
        }

        public final Map<String, String> getDefaultArguments() {
            if (this.defaultArguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.defaultArguments;
        }

        public final void setDefaultArguments(Map<String, String> defaultArguments) {
            this.defaultArguments = OrchestrationArgumentsMapCopier.copy(defaultArguments);
        }

        @Override
        public final Builder defaultArguments(Map<String, String> defaultArguments) {
            this.defaultArguments = OrchestrationArgumentsMapCopier.copy(defaultArguments);
            return this;
        }

        public final ConnectionsList.Builder getConnections() {
            return this.connections != null ? this.connections.toBuilder() : null;
        }

        public final void setConnections(ConnectionsList.BuilderImpl connections) {
            this.connections = connections != null ? connections.build() : null;
        }

        @Override
        public final Builder connections(ConnectionsList connections) {
            this.connections = connections;
            return this;
        }

        public final Double getProgress() {
            return this.progress;
        }

        public final void setProgress(Double progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(Double progress) {
            this.progress = progress;
            return this;
        }

        public final Double getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final String getGlueVersion() {
            return this.glueVersion;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final String getWorkerType() {
            return this.workerType;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final Double getExecutionTime() {
            return this.executionTime;
        }

        public final void setExecutionTime(Double executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public final Builder executionTime(Double executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final Double getDpuSeconds() {
            return this.dpuSeconds;
        }

        public final void setDpuSeconds(Double dpuSeconds) {
            this.dpuSeconds = dpuSeconds;
        }

        @Override
        public final Builder dpuSeconds(Double dpuSeconds) {
            this.dpuSeconds = dpuSeconds;
            return this;
        }

        public final Integer getIdleTimeout() {
            return this.idleTimeout;
        }

        public final void setIdleTimeout(Integer idleTimeout) {
            this.idleTimeout = idleTimeout;
        }

        @Override
        public final Builder idleTimeout(Integer idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public final String getProfileName() {
            return this.profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public Session build() {
            return new Session(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Session> {
        public Builder id(String var1);

        public Builder createdOn(Instant var1);

        public Builder status(String var1);

        public Builder status(SessionStatus var1);

        public Builder errorMessage(String var1);

        public Builder description(String var1);

        public Builder role(String var1);

        public Builder command(SessionCommand var1);

        default public Builder command(Consumer<SessionCommand.Builder> command) {
            return this.command((SessionCommand)((SessionCommand.Builder)SessionCommand.builder().applyMutation(command)).build());
        }

        public Builder defaultArguments(Map<String, String> var1);

        public Builder connections(ConnectionsList var1);

        default public Builder connections(Consumer<ConnectionsList.Builder> connections) {
            return this.connections((ConnectionsList)((ConnectionsList.Builder)ConnectionsList.builder().applyMutation(connections)).build());
        }

        public Builder progress(Double var1);

        public Builder maxCapacity(Double var1);

        public Builder securityConfiguration(String var1);

        public Builder glueVersion(String var1);

        public Builder numberOfWorkers(Integer var1);

        public Builder workerType(String var1);

        public Builder workerType(WorkerType var1);

        public Builder completedOn(Instant var1);

        public Builder executionTime(Double var1);

        public Builder dpuSeconds(Double var1);

        public Builder idleTimeout(Integer var1);

        public Builder profileName(String var1);
    }
}

