/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.AdditionalOptionsCopier;
import software.amazon.awssdk.services.glue.model.AutoDataQuality;
import software.amazon.awssdk.services.glue.model.CatalogSchemaChangePolicy;
import software.amazon.awssdk.services.glue.model.GlueSchema;
import software.amazon.awssdk.services.glue.model.GlueSchemasCopier;
import software.amazon.awssdk.services.glue.model.GlueStudioPathListCopier;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3HudiCatalogTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3HudiCatalogTarget> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(S3HudiCatalogTarget.getter(S3HudiCatalogTarget::name)).setter(S3HudiCatalogTarget.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(S3HudiCatalogTarget.getter(S3HudiCatalogTarget::inputs)).setter(S3HudiCatalogTarget.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<List<String>>> PARTITION_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionKeys").getter(S3HudiCatalogTarget.getter(S3HudiCatalogTarget::partitionKeys)).setter(S3HudiCatalogTarget.setter(Builder::partitionKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Table").getter(S3HudiCatalogTarget.getter(S3HudiCatalogTarget::table)).setter(S3HudiCatalogTarget.setter(Builder::table)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(S3HudiCatalogTarget.getter(S3HudiCatalogTarget::database)).setter(S3HudiCatalogTarget.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalOptions").getter(S3HudiCatalogTarget.getter(S3HudiCatalogTarget::additionalOptions)).setter(S3HudiCatalogTarget.setter(Builder::additionalOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<CatalogSchemaChangePolicy> SCHEMA_CHANGE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaChangePolicy").getter(S3HudiCatalogTarget.getter(S3HudiCatalogTarget::schemaChangePolicy)).setter(S3HudiCatalogTarget.setter(Builder::schemaChangePolicy)).constructor(CatalogSchemaChangePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaChangePolicy").build()}).build();
    private static final SdkField<AutoDataQuality> AUTO_DATA_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoDataQuality").getter(S3HudiCatalogTarget.getter(S3HudiCatalogTarget::autoDataQuality)).setter(S3HudiCatalogTarget.setter(Builder::autoDataQuality)).constructor(AutoDataQuality::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDataQuality").build()}).build();
    private static final SdkField<List<GlueSchema>> OUTPUT_SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputSchemas").getter(S3HudiCatalogTarget.getter(S3HudiCatalogTarget::outputSchemas)).setter(S3HudiCatalogTarget.setter(Builder::outputSchemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSchemas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlueSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, PARTITION_KEYS_FIELD, TABLE_FIELD, DATABASE_FIELD, ADDITIONAL_OPTIONS_FIELD, SCHEMA_CHANGE_POLICY_FIELD, AUTO_DATA_QUALITY_FIELD, OUTPUT_SCHEMAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3HudiCatalogTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final List<List<String>> partitionKeys;
    private final String table;
    private final String database;
    private final Map<String, String> additionalOptions;
    private final CatalogSchemaChangePolicy schemaChangePolicy;
    private final AutoDataQuality autoDataQuality;
    private final List<GlueSchema> outputSchemas;

    private S3HudiCatalogTarget(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.partitionKeys = builder.partitionKeys;
        this.table = builder.table;
        this.database = builder.database;
        this.additionalOptions = builder.additionalOptions;
        this.schemaChangePolicy = builder.schemaChangePolicy;
        this.autoDataQuality = builder.autoDataQuality;
        this.outputSchemas = builder.outputSchemas;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final boolean hasPartitionKeys() {
        return this.partitionKeys != null && !(this.partitionKeys instanceof SdkAutoConstructList);
    }

    public final List<List<String>> partitionKeys() {
        return this.partitionKeys;
    }

    public final String table() {
        return this.table;
    }

    public final String database() {
        return this.database;
    }

    public final boolean hasAdditionalOptions() {
        return this.additionalOptions != null && !(this.additionalOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalOptions() {
        return this.additionalOptions;
    }

    public final CatalogSchemaChangePolicy schemaChangePolicy() {
        return this.schemaChangePolicy;
    }

    public final AutoDataQuality autoDataQuality() {
        return this.autoDataQuality;
    }

    public final boolean hasOutputSchemas() {
        return this.outputSchemas != null && !(this.outputSchemas instanceof SdkAutoConstructList);
    }

    public final List<GlueSchema> outputSchemas() {
        return this.outputSchemas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionKeys() ? this.partitionKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalOptions() ? this.additionalOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaChangePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoDataQuality());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputSchemas() ? this.outputSchemas() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3HudiCatalogTarget)) {
            return false;
        }
        S3HudiCatalogTarget other = (S3HudiCatalogTarget)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && this.hasPartitionKeys() == other.hasPartitionKeys() && Objects.equals(this.partitionKeys(), other.partitionKeys()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.database(), other.database()) && this.hasAdditionalOptions() == other.hasAdditionalOptions() && Objects.equals(this.additionalOptions(), other.additionalOptions()) && Objects.equals(this.schemaChangePolicy(), other.schemaChangePolicy()) && Objects.equals(this.autoDataQuality(), other.autoDataQuality()) && this.hasOutputSchemas() == other.hasOutputSchemas() && Objects.equals(this.outputSchemas(), other.outputSchemas());
    }

    public final String toString() {
        return ToString.builder((String)"S3HudiCatalogTarget").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("PartitionKeys", this.hasPartitionKeys() ? this.partitionKeys() : null).add("Table", (Object)this.table()).add("Database", (Object)this.database()).add("AdditionalOptions", this.hasAdditionalOptions() ? this.additionalOptions() : null).add("SchemaChangePolicy", (Object)this.schemaChangePolicy()).add("AutoDataQuality", (Object)this.autoDataQuality()).add("OutputSchemas", this.hasOutputSchemas() ? this.outputSchemas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "PartitionKeys": {
                return Optional.ofNullable(clazz.cast(this.partitionKeys()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "AdditionalOptions": {
                return Optional.ofNullable(clazz.cast(this.additionalOptions()));
            }
            case "SchemaChangePolicy": {
                return Optional.ofNullable(clazz.cast(this.schemaChangePolicy()));
            }
            case "AutoDataQuality": {
                return Optional.ofNullable(clazz.cast(this.autoDataQuality()));
            }
            case "OutputSchemas": {
                return Optional.ofNullable(clazz.cast(this.outputSchemas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("PartitionKeys", PARTITION_KEYS_FIELD);
        map.put("Table", TABLE_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("AdditionalOptions", ADDITIONAL_OPTIONS_FIELD);
        map.put("SchemaChangePolicy", SCHEMA_CHANGE_POLICY_FIELD);
        map.put("AutoDataQuality", AUTO_DATA_QUALITY_FIELD);
        map.put("OutputSchemas", OUTPUT_SCHEMAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3HudiCatalogTarget, T> g) {
        return obj -> g.apply((S3HudiCatalogTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private List<List<String>> partitionKeys = DefaultSdkAutoConstructList.getInstance();
        private String table;
        private String database;
        private Map<String, String> additionalOptions = DefaultSdkAutoConstructMap.getInstance();
        private CatalogSchemaChangePolicy schemaChangePolicy;
        private AutoDataQuality autoDataQuality;
        private List<GlueSchema> outputSchemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3HudiCatalogTarget model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.partitionKeys(model.partitionKeys);
            this.table(model.table);
            this.database(model.database);
            this.additionalOptions(model.additionalOptions);
            this.schemaChangePolicy(model.schemaChangePolicy);
            this.autoDataQuality(model.autoDataQuality);
            this.outputSchemas(model.outputSchemas);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final Collection<? extends Collection<String>> getPartitionKeys() {
            if (this.partitionKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionKeys;
        }

        public final void setPartitionKeys(Collection<? extends Collection<String>> partitionKeys) {
            this.partitionKeys = GlueStudioPathListCopier.copy(partitionKeys);
        }

        @Override
        public final Builder partitionKeys(Collection<? extends Collection<String>> partitionKeys) {
            this.partitionKeys = GlueStudioPathListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Collection<String> ... partitionKeys) {
            this.partitionKeys((Collection<? extends Collection<String>>)Arrays.asList(partitionKeys));
            return this;
        }

        public final String getTable() {
            return this.table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final Map<String, String> getAdditionalOptions() {
            if (this.additionalOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalOptions;
        }

        public final void setAdditionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = AdditionalOptionsCopier.copy(additionalOptions);
        }

        @Override
        public final Builder additionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = AdditionalOptionsCopier.copy(additionalOptions);
            return this;
        }

        public final CatalogSchemaChangePolicy.Builder getSchemaChangePolicy() {
            return this.schemaChangePolicy != null ? this.schemaChangePolicy.toBuilder() : null;
        }

        public final void setSchemaChangePolicy(CatalogSchemaChangePolicy.BuilderImpl schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy != null ? schemaChangePolicy.build() : null;
        }

        @Override
        public final Builder schemaChangePolicy(CatalogSchemaChangePolicy schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy;
            return this;
        }

        public final AutoDataQuality.Builder getAutoDataQuality() {
            return this.autoDataQuality != null ? this.autoDataQuality.toBuilder() : null;
        }

        public final void setAutoDataQuality(AutoDataQuality.BuilderImpl autoDataQuality) {
            this.autoDataQuality = autoDataQuality != null ? autoDataQuality.build() : null;
        }

        @Override
        public final Builder autoDataQuality(AutoDataQuality autoDataQuality) {
            this.autoDataQuality = autoDataQuality;
            return this;
        }

        public final List<GlueSchema.Builder> getOutputSchemas() {
            List<GlueSchema.Builder> result = GlueSchemasCopier.copyToBuilder(this.outputSchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSchemas(Collection<GlueSchema.BuilderImpl> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copyFromBuilder(outputSchemas);
        }

        @Override
        public final Builder outputSchemas(Collection<GlueSchema> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copy(outputSchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(GlueSchema ... outputSchemas) {
            this.outputSchemas(Arrays.asList(outputSchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(Consumer<GlueSchema.Builder> ... outputSchemas) {
            this.outputSchemas(Stream.of(outputSchemas).map(c -> (GlueSchema)((GlueSchema.Builder)GlueSchema.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public S3HudiCatalogTarget build() {
            return new S3HudiCatalogTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3HudiCatalogTarget> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder partitionKeys(Collection<? extends Collection<String>> var1);

        public Builder partitionKeys(Collection<String> ... var1);

        public Builder table(String var1);

        public Builder database(String var1);

        public Builder additionalOptions(Map<String, String> var1);

        public Builder schemaChangePolicy(CatalogSchemaChangePolicy var1);

        default public Builder schemaChangePolicy(Consumer<CatalogSchemaChangePolicy.Builder> schemaChangePolicy) {
            return this.schemaChangePolicy((CatalogSchemaChangePolicy)((CatalogSchemaChangePolicy.Builder)CatalogSchemaChangePolicy.builder().applyMutation(schemaChangePolicy)).build());
        }

        public Builder autoDataQuality(AutoDataQuality var1);

        default public Builder autoDataQuality(Consumer<AutoDataQuality.Builder> autoDataQuality) {
            return this.autoDataQuality((AutoDataQuality)((AutoDataQuality.Builder)AutoDataQuality.builder().applyMutation(autoDataQuality)).build());
        }

        public Builder outputSchemas(Collection<GlueSchema> var1);

        public Builder outputSchemas(GlueSchema ... var1);

        public Builder outputSchemas(Consumer<GlueSchema.Builder> ... var1);
    }
}

