/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CatalogEncryptionMode {
    DISABLED("DISABLED"),
    SSE_KMS("SSE-KMS"),
    SSE_KMS_WITH_SERVICE_ROLE("SSE-KMS-WITH-SERVICE-ROLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CatalogEncryptionMode> VALUE_MAP;
    private final String value;

    private CatalogEncryptionMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CatalogEncryptionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CatalogEncryptionMode> knownValues() {
        EnumSet<CatalogEncryptionMode> knownValues = EnumSet.allOf(CatalogEncryptionMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CatalogEncryptionMode.class, CatalogEncryptionMode::toString);
    }
}

