/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DdbExportType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DDBELTConnectionOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DDBELTConnectionOptions> {
    private static final SdkField<String> DYNAMODB_EXPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamodbExport").getter(DDBELTConnectionOptions.getter(DDBELTConnectionOptions::dynamodbExportAsString)).setter(DDBELTConnectionOptions.setter(Builder::dynamodbExport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbExport").build()}).build();
    private static final SdkField<Boolean> DYNAMODB_UNNEST_DDB_JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DynamodbUnnestDDBJson").getter(DDBELTConnectionOptions.getter(DDBELTConnectionOptions::dynamodbUnnestDDBJson)).setter(DDBELTConnectionOptions.setter(Builder::dynamodbUnnestDDBJson)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbUnnestDDBJson").build()}).build();
    private static final SdkField<String> DYNAMODB_TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamodbTableArn").getter(DDBELTConnectionOptions.getter(DDBELTConnectionOptions::dynamodbTableArn)).setter(DDBELTConnectionOptions.setter(Builder::dynamodbTableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbTableArn").build()}).build();
    private static final SdkField<String> DYNAMODB_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamodbS3Bucket").getter(DDBELTConnectionOptions.getter(DDBELTConnectionOptions::dynamodbS3Bucket)).setter(DDBELTConnectionOptions.setter(Builder::dynamodbS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbS3Bucket").build()}).build();
    private static final SdkField<String> DYNAMODB_S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamodbS3Prefix").getter(DDBELTConnectionOptions.getter(DDBELTConnectionOptions::dynamodbS3Prefix)).setter(DDBELTConnectionOptions.setter(Builder::dynamodbS3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbS3Prefix").build()}).build();
    private static final SdkField<String> DYNAMODB_S3_BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamodbS3BucketOwner").getter(DDBELTConnectionOptions.getter(DDBELTConnectionOptions::dynamodbS3BucketOwner)).setter(DDBELTConnectionOptions.setter(Builder::dynamodbS3BucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbS3BucketOwner").build()}).build();
    private static final SdkField<String> DYNAMODB_STS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamodbStsRoleArn").getter(DDBELTConnectionOptions.getter(DDBELTConnectionOptions::dynamodbStsRoleArn)).setter(DDBELTConnectionOptions.setter(Builder::dynamodbStsRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbStsRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMODB_EXPORT_FIELD, DYNAMODB_UNNEST_DDB_JSON_FIELD, DYNAMODB_TABLE_ARN_FIELD, DYNAMODB_S3_BUCKET_FIELD, DYNAMODB_S3_PREFIX_FIELD, DYNAMODB_S3_BUCKET_OWNER_FIELD, DYNAMODB_STS_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DDBELTConnectionOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dynamodbExport;
    private final Boolean dynamodbUnnestDDBJson;
    private final String dynamodbTableArn;
    private final String dynamodbS3Bucket;
    private final String dynamodbS3Prefix;
    private final String dynamodbS3BucketOwner;
    private final String dynamodbStsRoleArn;

    private DDBELTConnectionOptions(BuilderImpl builder) {
        this.dynamodbExport = builder.dynamodbExport;
        this.dynamodbUnnestDDBJson = builder.dynamodbUnnestDDBJson;
        this.dynamodbTableArn = builder.dynamodbTableArn;
        this.dynamodbS3Bucket = builder.dynamodbS3Bucket;
        this.dynamodbS3Prefix = builder.dynamodbS3Prefix;
        this.dynamodbS3BucketOwner = builder.dynamodbS3BucketOwner;
        this.dynamodbStsRoleArn = builder.dynamodbStsRoleArn;
    }

    public final DdbExportType dynamodbExport() {
        return DdbExportType.fromValue(this.dynamodbExport);
    }

    public final String dynamodbExportAsString() {
        return this.dynamodbExport;
    }

    public final Boolean dynamodbUnnestDDBJson() {
        return this.dynamodbUnnestDDBJson;
    }

    public final String dynamodbTableArn() {
        return this.dynamodbTableArn;
    }

    public final String dynamodbS3Bucket() {
        return this.dynamodbS3Bucket;
    }

    public final String dynamodbS3Prefix() {
        return this.dynamodbS3Prefix;
    }

    public final String dynamodbS3BucketOwner() {
        return this.dynamodbS3BucketOwner;
    }

    public final String dynamodbStsRoleArn() {
        return this.dynamodbStsRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamodbExportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamodbUnnestDDBJson());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamodbTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamodbS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamodbS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamodbS3BucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamodbStsRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DDBELTConnectionOptions)) {
            return false;
        }
        DDBELTConnectionOptions other = (DDBELTConnectionOptions)obj;
        return Objects.equals(this.dynamodbExportAsString(), other.dynamodbExportAsString()) && Objects.equals(this.dynamodbUnnestDDBJson(), other.dynamodbUnnestDDBJson()) && Objects.equals(this.dynamodbTableArn(), other.dynamodbTableArn()) && Objects.equals(this.dynamodbS3Bucket(), other.dynamodbS3Bucket()) && Objects.equals(this.dynamodbS3Prefix(), other.dynamodbS3Prefix()) && Objects.equals(this.dynamodbS3BucketOwner(), other.dynamodbS3BucketOwner()) && Objects.equals(this.dynamodbStsRoleArn(), other.dynamodbStsRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"DDBELTConnectionOptions").add("DynamodbExport", (Object)this.dynamodbExportAsString()).add("DynamodbUnnestDDBJson", (Object)this.dynamodbUnnestDDBJson()).add("DynamodbTableArn", (Object)this.dynamodbTableArn()).add("DynamodbS3Bucket", (Object)this.dynamodbS3Bucket()).add("DynamodbS3Prefix", (Object)this.dynamodbS3Prefix()).add("DynamodbS3BucketOwner", (Object)this.dynamodbS3BucketOwner()).add("DynamodbStsRoleArn", (Object)this.dynamodbStsRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DynamodbExport": {
                return Optional.ofNullable(clazz.cast(this.dynamodbExportAsString()));
            }
            case "DynamodbUnnestDDBJson": {
                return Optional.ofNullable(clazz.cast(this.dynamodbUnnestDDBJson()));
            }
            case "DynamodbTableArn": {
                return Optional.ofNullable(clazz.cast(this.dynamodbTableArn()));
            }
            case "DynamodbS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.dynamodbS3Bucket()));
            }
            case "DynamodbS3Prefix": {
                return Optional.ofNullable(clazz.cast(this.dynamodbS3Prefix()));
            }
            case "DynamodbS3BucketOwner": {
                return Optional.ofNullable(clazz.cast(this.dynamodbS3BucketOwner()));
            }
            case "DynamodbStsRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dynamodbStsRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DynamodbExport", DYNAMODB_EXPORT_FIELD);
        map.put("DynamodbUnnestDDBJson", DYNAMODB_UNNEST_DDB_JSON_FIELD);
        map.put("DynamodbTableArn", DYNAMODB_TABLE_ARN_FIELD);
        map.put("DynamodbS3Bucket", DYNAMODB_S3_BUCKET_FIELD);
        map.put("DynamodbS3Prefix", DYNAMODB_S3_PREFIX_FIELD);
        map.put("DynamodbS3BucketOwner", DYNAMODB_S3_BUCKET_OWNER_FIELD);
        map.put("DynamodbStsRoleArn", DYNAMODB_STS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DDBELTConnectionOptions, T> g) {
        return obj -> g.apply((DDBELTConnectionOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dynamodbExport;
        private Boolean dynamodbUnnestDDBJson;
        private String dynamodbTableArn;
        private String dynamodbS3Bucket;
        private String dynamodbS3Prefix;
        private String dynamodbS3BucketOwner;
        private String dynamodbStsRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DDBELTConnectionOptions model) {
            this.dynamodbExport(model.dynamodbExport);
            this.dynamodbUnnestDDBJson(model.dynamodbUnnestDDBJson);
            this.dynamodbTableArn(model.dynamodbTableArn);
            this.dynamodbS3Bucket(model.dynamodbS3Bucket);
            this.dynamodbS3Prefix(model.dynamodbS3Prefix);
            this.dynamodbS3BucketOwner(model.dynamodbS3BucketOwner);
            this.dynamodbStsRoleArn(model.dynamodbStsRoleArn);
        }

        public final String getDynamodbExport() {
            return this.dynamodbExport;
        }

        public final void setDynamodbExport(String dynamodbExport) {
            this.dynamodbExport = dynamodbExport;
        }

        @Override
        public final Builder dynamodbExport(String dynamodbExport) {
            this.dynamodbExport = dynamodbExport;
            return this;
        }

        @Override
        public final Builder dynamodbExport(DdbExportType dynamodbExport) {
            this.dynamodbExport(dynamodbExport == null ? null : dynamodbExport.toString());
            return this;
        }

        public final Boolean getDynamodbUnnestDDBJson() {
            return this.dynamodbUnnestDDBJson;
        }

        public final void setDynamodbUnnestDDBJson(Boolean dynamodbUnnestDDBJson) {
            this.dynamodbUnnestDDBJson = dynamodbUnnestDDBJson;
        }

        @Override
        public final Builder dynamodbUnnestDDBJson(Boolean dynamodbUnnestDDBJson) {
            this.dynamodbUnnestDDBJson = dynamodbUnnestDDBJson;
            return this;
        }

        public final String getDynamodbTableArn() {
            return this.dynamodbTableArn;
        }

        public final void setDynamodbTableArn(String dynamodbTableArn) {
            this.dynamodbTableArn = dynamodbTableArn;
        }

        @Override
        public final Builder dynamodbTableArn(String dynamodbTableArn) {
            this.dynamodbTableArn = dynamodbTableArn;
            return this;
        }

        public final String getDynamodbS3Bucket() {
            return this.dynamodbS3Bucket;
        }

        public final void setDynamodbS3Bucket(String dynamodbS3Bucket) {
            this.dynamodbS3Bucket = dynamodbS3Bucket;
        }

        @Override
        public final Builder dynamodbS3Bucket(String dynamodbS3Bucket) {
            this.dynamodbS3Bucket = dynamodbS3Bucket;
            return this;
        }

        public final String getDynamodbS3Prefix() {
            return this.dynamodbS3Prefix;
        }

        public final void setDynamodbS3Prefix(String dynamodbS3Prefix) {
            this.dynamodbS3Prefix = dynamodbS3Prefix;
        }

        @Override
        public final Builder dynamodbS3Prefix(String dynamodbS3Prefix) {
            this.dynamodbS3Prefix = dynamodbS3Prefix;
            return this;
        }

        public final String getDynamodbS3BucketOwner() {
            return this.dynamodbS3BucketOwner;
        }

        public final void setDynamodbS3BucketOwner(String dynamodbS3BucketOwner) {
            this.dynamodbS3BucketOwner = dynamodbS3BucketOwner;
        }

        @Override
        public final Builder dynamodbS3BucketOwner(String dynamodbS3BucketOwner) {
            this.dynamodbS3BucketOwner = dynamodbS3BucketOwner;
            return this;
        }

        public final String getDynamodbStsRoleArn() {
            return this.dynamodbStsRoleArn;
        }

        public final void setDynamodbStsRoleArn(String dynamodbStsRoleArn) {
            this.dynamodbStsRoleArn = dynamodbStsRoleArn;
        }

        @Override
        public final Builder dynamodbStsRoleArn(String dynamodbStsRoleArn) {
            this.dynamodbStsRoleArn = dynamodbStsRoleArn;
            return this;
        }

        public DDBELTConnectionOptions build() {
            return new DDBELTConnectionOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DDBELTConnectionOptions> {
        public Builder dynamodbExport(String var1);

        public Builder dynamodbExport(DdbExportType var1);

        public Builder dynamodbUnnestDDBJson(Boolean var1);

        public Builder dynamodbTableArn(String var1);

        public Builder dynamodbS3Bucket(String var1);

        public Builder dynamodbS3Prefix(String var1);

        public Builder dynamodbS3BucketOwner(String var1);

        public Builder dynamodbStsRoleArn(String var1);
    }
}

