/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.TimestampedInclusionAnnotation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatisticAnnotation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatisticAnnotation> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(StatisticAnnotation.getter(StatisticAnnotation::profileId)).setter(StatisticAnnotation.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final SdkField<String> STATISTIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatisticId").getter(StatisticAnnotation.getter(StatisticAnnotation::statisticId)).setter(StatisticAnnotation.setter(Builder::statisticId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticId").build()}).build();
    private static final SdkField<Instant> STATISTIC_RECORDED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StatisticRecordedOn").getter(StatisticAnnotation.getter(StatisticAnnotation::statisticRecordedOn)).setter(StatisticAnnotation.setter(Builder::statisticRecordedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticRecordedOn").build()}).build();
    private static final SdkField<TimestampedInclusionAnnotation> INCLUSION_ANNOTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InclusionAnnotation").getter(StatisticAnnotation.getter(StatisticAnnotation::inclusionAnnotation)).setter(StatisticAnnotation.setter(Builder::inclusionAnnotation)).constructor(TimestampedInclusionAnnotation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionAnnotation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD, STATISTIC_ID_FIELD, STATISTIC_RECORDED_ON_FIELD, INCLUSION_ANNOTATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StatisticAnnotation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String profileId;
    private final String statisticId;
    private final Instant statisticRecordedOn;
    private final TimestampedInclusionAnnotation inclusionAnnotation;

    private StatisticAnnotation(BuilderImpl builder) {
        this.profileId = builder.profileId;
        this.statisticId = builder.statisticId;
        this.statisticRecordedOn = builder.statisticRecordedOn;
        this.inclusionAnnotation = builder.inclusionAnnotation;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final String statisticId() {
        return this.statisticId;
    }

    public final Instant statisticRecordedOn() {
        return this.statisticRecordedOn;
    }

    public final TimestampedInclusionAnnotation inclusionAnnotation() {
        return this.inclusionAnnotation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticRecordedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusionAnnotation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticAnnotation)) {
            return false;
        }
        StatisticAnnotation other = (StatisticAnnotation)obj;
        return Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.statisticId(), other.statisticId()) && Objects.equals(this.statisticRecordedOn(), other.statisticRecordedOn()) && Objects.equals(this.inclusionAnnotation(), other.inclusionAnnotation());
    }

    public final String toString() {
        return ToString.builder((String)"StatisticAnnotation").add("ProfileId", (Object)this.profileId()).add("StatisticId", (Object)this.statisticId()).add("StatisticRecordedOn", (Object)this.statisticRecordedOn()).add("InclusionAnnotation", (Object)this.inclusionAnnotation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "StatisticId": {
                return Optional.ofNullable(clazz.cast(this.statisticId()));
            }
            case "StatisticRecordedOn": {
                return Optional.ofNullable(clazz.cast(this.statisticRecordedOn()));
            }
            case "InclusionAnnotation": {
                return Optional.ofNullable(clazz.cast(this.inclusionAnnotation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("StatisticId", STATISTIC_ID_FIELD);
        map.put("StatisticRecordedOn", STATISTIC_RECORDED_ON_FIELD);
        map.put("InclusionAnnotation", INCLUSION_ANNOTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatisticAnnotation, T> g) {
        return obj -> g.apply((StatisticAnnotation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String profileId;
        private String statisticId;
        private Instant statisticRecordedOn;
        private TimestampedInclusionAnnotation inclusionAnnotation;

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticAnnotation model) {
            this.profileId(model.profileId);
            this.statisticId(model.statisticId);
            this.statisticRecordedOn(model.statisticRecordedOn);
            this.inclusionAnnotation(model.inclusionAnnotation);
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getStatisticId() {
            return this.statisticId;
        }

        public final void setStatisticId(String statisticId) {
            this.statisticId = statisticId;
        }

        @Override
        public final Builder statisticId(String statisticId) {
            this.statisticId = statisticId;
            return this;
        }

        public final Instant getStatisticRecordedOn() {
            return this.statisticRecordedOn;
        }

        public final void setStatisticRecordedOn(Instant statisticRecordedOn) {
            this.statisticRecordedOn = statisticRecordedOn;
        }

        @Override
        public final Builder statisticRecordedOn(Instant statisticRecordedOn) {
            this.statisticRecordedOn = statisticRecordedOn;
            return this;
        }

        public final TimestampedInclusionAnnotation.Builder getInclusionAnnotation() {
            return this.inclusionAnnotation != null ? this.inclusionAnnotation.toBuilder() : null;
        }

        public final void setInclusionAnnotation(TimestampedInclusionAnnotation.BuilderImpl inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation != null ? inclusionAnnotation.build() : null;
        }

        @Override
        public final Builder inclusionAnnotation(TimestampedInclusionAnnotation inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation;
            return this;
        }

        public StatisticAnnotation build() {
            return new StatisticAnnotation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatisticAnnotation> {
        public Builder profileId(String var1);

        public Builder statisticId(String var1);

        public Builder statisticRecordedOn(Instant var1);

        public Builder inclusionAnnotation(TimestampedInclusionAnnotation var1);

        default public Builder inclusionAnnotation(Consumer<TimestampedInclusionAnnotation.Builder> inclusionAnnotation) {
            return this.inclusionAnnotation((TimestampedInclusionAnnotation)((TimestampedInclusionAnnotation.Builder)TimestampedInclusionAnnotation.builder().applyMutation(inclusionAnnotation)).build());
        }
    }
}

