/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.StartingPosition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisStreamingSourceOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisStreamingSourceOptions> {
    private static final SdkField<String> ENDPOINT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointUrl").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::endpointUrl)).setter(KinesisStreamingSourceOptions.setter(Builder::endpointUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointUrl").build()}).build();
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::streamName)).setter(KinesisStreamingSourceOptions.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Classification").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::classification)).setter(KinesisStreamingSourceOptions.setter(Builder::classification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()}).build();
    private static final SdkField<String> DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Delimiter").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::delimiter)).setter(KinesisStreamingSourceOptions.setter(Builder::delimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").build()}).build();
    private static final SdkField<String> STARTING_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartingPosition").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::startingPositionAsString)).setter(KinesisStreamingSourceOptions.setter(Builder::startingPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPosition").build()}).build();
    private static final SdkField<Long> MAX_FETCH_TIME_IN_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxFetchTimeInMs").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::maxFetchTimeInMs)).setter(KinesisStreamingSourceOptions.setter(Builder::maxFetchTimeInMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFetchTimeInMs").build()}).build();
    private static final SdkField<Long> MAX_FETCH_RECORDS_PER_SHARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxFetchRecordsPerShard").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::maxFetchRecordsPerShard)).setter(KinesisStreamingSourceOptions.setter(Builder::maxFetchRecordsPerShard)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFetchRecordsPerShard").build()}).build();
    private static final SdkField<Long> MAX_RECORD_PER_READ_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxRecordPerRead").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::maxRecordPerRead)).setter(KinesisStreamingSourceOptions.setter(Builder::maxRecordPerRead)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecordPerRead").build()}).build();
    private static final SdkField<Boolean> ADD_IDLE_TIME_BETWEEN_READS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AddIdleTimeBetweenReads").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::addIdleTimeBetweenReads)).setter(KinesisStreamingSourceOptions.setter(Builder::addIdleTimeBetweenReads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddIdleTimeBetweenReads").build()}).build();
    private static final SdkField<Long> IDLE_TIME_BETWEEN_READS_IN_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("IdleTimeBetweenReadsInMs").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::idleTimeBetweenReadsInMs)).setter(KinesisStreamingSourceOptions.setter(Builder::idleTimeBetweenReadsInMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleTimeBetweenReadsInMs").build()}).build();
    private static final SdkField<Long> DESCRIBE_SHARD_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DescribeShardInterval").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::describeShardInterval)).setter(KinesisStreamingSourceOptions.setter(Builder::describeShardInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DescribeShardInterval").build()}).build();
    private static final SdkField<Integer> NUM_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumRetries").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::numRetries)).setter(KinesisStreamingSourceOptions.setter(Builder::numRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumRetries").build()}).build();
    private static final SdkField<Long> RETRY_INTERVAL_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RetryIntervalMs").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::retryIntervalMs)).setter(KinesisStreamingSourceOptions.setter(Builder::retryIntervalMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryIntervalMs").build()}).build();
    private static final SdkField<Long> MAX_RETRY_INTERVAL_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxRetryIntervalMs").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::maxRetryIntervalMs)).setter(KinesisStreamingSourceOptions.setter(Builder::maxRetryIntervalMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetryIntervalMs").build()}).build();
    private static final SdkField<Boolean> AVOID_EMPTY_BATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AvoidEmptyBatches").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::avoidEmptyBatches)).setter(KinesisStreamingSourceOptions.setter(Builder::avoidEmptyBatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvoidEmptyBatches").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamArn").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::streamArn)).setter(KinesisStreamingSourceOptions.setter(Builder::streamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::roleArn)).setter(KinesisStreamingSourceOptions.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> ROLE_SESSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleSessionName").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::roleSessionName)).setter(KinesisStreamingSourceOptions.setter(Builder::roleSessionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleSessionName").build()}).build();
    private static final SdkField<String> ADD_RECORD_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddRecordTimestamp").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::addRecordTimestamp)).setter(KinesisStreamingSourceOptions.setter(Builder::addRecordTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddRecordTimestamp").build()}).build();
    private static final SdkField<String> EMIT_CONSUMER_LAG_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmitConsumerLagMetrics").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::emitConsumerLagMetrics)).setter(KinesisStreamingSourceOptions.setter(Builder::emitConsumerLagMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmitConsumerLagMetrics").build()}).build();
    private static final SdkField<Instant> STARTING_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartingTimestamp").getter(KinesisStreamingSourceOptions.getter(KinesisStreamingSourceOptions::startingTimestamp)).setter(KinesisStreamingSourceOptions.setter(Builder::startingTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_URL_FIELD, STREAM_NAME_FIELD, CLASSIFICATION_FIELD, DELIMITER_FIELD, STARTING_POSITION_FIELD, MAX_FETCH_TIME_IN_MS_FIELD, MAX_FETCH_RECORDS_PER_SHARD_FIELD, MAX_RECORD_PER_READ_FIELD, ADD_IDLE_TIME_BETWEEN_READS_FIELD, IDLE_TIME_BETWEEN_READS_IN_MS_FIELD, DESCRIBE_SHARD_INTERVAL_FIELD, NUM_RETRIES_FIELD, RETRY_INTERVAL_MS_FIELD, MAX_RETRY_INTERVAL_MS_FIELD, AVOID_EMPTY_BATCHES_FIELD, STREAM_ARN_FIELD, ROLE_ARN_FIELD, ROLE_SESSION_NAME_FIELD, ADD_RECORD_TIMESTAMP_FIELD, EMIT_CONSUMER_LAG_METRICS_FIELD, STARTING_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KinesisStreamingSourceOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String endpointUrl;
    private final String streamName;
    private final String classification;
    private final String delimiter;
    private final String startingPosition;
    private final Long maxFetchTimeInMs;
    private final Long maxFetchRecordsPerShard;
    private final Long maxRecordPerRead;
    private final Boolean addIdleTimeBetweenReads;
    private final Long idleTimeBetweenReadsInMs;
    private final Long describeShardInterval;
    private final Integer numRetries;
    private final Long retryIntervalMs;
    private final Long maxRetryIntervalMs;
    private final Boolean avoidEmptyBatches;
    private final String streamArn;
    private final String roleArn;
    private final String roleSessionName;
    private final String addRecordTimestamp;
    private final String emitConsumerLagMetrics;
    private final Instant startingTimestamp;

    private KinesisStreamingSourceOptions(BuilderImpl builder) {
        this.endpointUrl = builder.endpointUrl;
        this.streamName = builder.streamName;
        this.classification = builder.classification;
        this.delimiter = builder.delimiter;
        this.startingPosition = builder.startingPosition;
        this.maxFetchTimeInMs = builder.maxFetchTimeInMs;
        this.maxFetchRecordsPerShard = builder.maxFetchRecordsPerShard;
        this.maxRecordPerRead = builder.maxRecordPerRead;
        this.addIdleTimeBetweenReads = builder.addIdleTimeBetweenReads;
        this.idleTimeBetweenReadsInMs = builder.idleTimeBetweenReadsInMs;
        this.describeShardInterval = builder.describeShardInterval;
        this.numRetries = builder.numRetries;
        this.retryIntervalMs = builder.retryIntervalMs;
        this.maxRetryIntervalMs = builder.maxRetryIntervalMs;
        this.avoidEmptyBatches = builder.avoidEmptyBatches;
        this.streamArn = builder.streamArn;
        this.roleArn = builder.roleArn;
        this.roleSessionName = builder.roleSessionName;
        this.addRecordTimestamp = builder.addRecordTimestamp;
        this.emitConsumerLagMetrics = builder.emitConsumerLagMetrics;
        this.startingTimestamp = builder.startingTimestamp;
    }

    public final String endpointUrl() {
        return this.endpointUrl;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String classification() {
        return this.classification;
    }

    public final String delimiter() {
        return this.delimiter;
    }

    public final StartingPosition startingPosition() {
        return StartingPosition.fromValue(this.startingPosition);
    }

    public final String startingPositionAsString() {
        return this.startingPosition;
    }

    public final Long maxFetchTimeInMs() {
        return this.maxFetchTimeInMs;
    }

    public final Long maxFetchRecordsPerShard() {
        return this.maxFetchRecordsPerShard;
    }

    public final Long maxRecordPerRead() {
        return this.maxRecordPerRead;
    }

    public final Boolean addIdleTimeBetweenReads() {
        return this.addIdleTimeBetweenReads;
    }

    public final Long idleTimeBetweenReadsInMs() {
        return this.idleTimeBetweenReadsInMs;
    }

    public final Long describeShardInterval() {
        return this.describeShardInterval;
    }

    public final Integer numRetries() {
        return this.numRetries;
    }

    public final Long retryIntervalMs() {
        return this.retryIntervalMs;
    }

    public final Long maxRetryIntervalMs() {
        return this.maxRetryIntervalMs;
    }

    public final Boolean avoidEmptyBatches() {
        return this.avoidEmptyBatches;
    }

    public final String streamArn() {
        return this.streamArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String roleSessionName() {
        return this.roleSessionName;
    }

    public final String addRecordTimestamp() {
        return this.addRecordTimestamp;
    }

    public final String emitConsumerLagMetrics() {
        return this.emitConsumerLagMetrics;
    }

    public final Instant startingTimestamp() {
        return this.startingTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFetchTimeInMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFetchRecordsPerShard());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecordPerRead());
        hashCode = 31 * hashCode + Objects.hashCode(this.addIdleTimeBetweenReads());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleTimeBetweenReadsInMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.describeShardInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.numRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryIntervalMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetryIntervalMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.avoidEmptyBatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleSessionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.addRecordTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.emitConsumerLagMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamingSourceOptions)) {
            return false;
        }
        KinesisStreamingSourceOptions other = (KinesisStreamingSourceOptions)obj;
        return Objects.equals(this.endpointUrl(), other.endpointUrl()) && Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.classification(), other.classification()) && Objects.equals(this.delimiter(), other.delimiter()) && Objects.equals(this.startingPositionAsString(), other.startingPositionAsString()) && Objects.equals(this.maxFetchTimeInMs(), other.maxFetchTimeInMs()) && Objects.equals(this.maxFetchRecordsPerShard(), other.maxFetchRecordsPerShard()) && Objects.equals(this.maxRecordPerRead(), other.maxRecordPerRead()) && Objects.equals(this.addIdleTimeBetweenReads(), other.addIdleTimeBetweenReads()) && Objects.equals(this.idleTimeBetweenReadsInMs(), other.idleTimeBetweenReadsInMs()) && Objects.equals(this.describeShardInterval(), other.describeShardInterval()) && Objects.equals(this.numRetries(), other.numRetries()) && Objects.equals(this.retryIntervalMs(), other.retryIntervalMs()) && Objects.equals(this.maxRetryIntervalMs(), other.maxRetryIntervalMs()) && Objects.equals(this.avoidEmptyBatches(), other.avoidEmptyBatches()) && Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.roleSessionName(), other.roleSessionName()) && Objects.equals(this.addRecordTimestamp(), other.addRecordTimestamp()) && Objects.equals(this.emitConsumerLagMetrics(), other.emitConsumerLagMetrics()) && Objects.equals(this.startingTimestamp(), other.startingTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisStreamingSourceOptions").add("EndpointUrl", (Object)this.endpointUrl()).add("StreamName", (Object)this.streamName()).add("Classification", (Object)this.classification()).add("Delimiter", (Object)this.delimiter()).add("StartingPosition", (Object)this.startingPositionAsString()).add("MaxFetchTimeInMs", (Object)this.maxFetchTimeInMs()).add("MaxFetchRecordsPerShard", (Object)this.maxFetchRecordsPerShard()).add("MaxRecordPerRead", (Object)this.maxRecordPerRead()).add("AddIdleTimeBetweenReads", (Object)this.addIdleTimeBetweenReads()).add("IdleTimeBetweenReadsInMs", (Object)this.idleTimeBetweenReadsInMs()).add("DescribeShardInterval", (Object)this.describeShardInterval()).add("NumRetries", (Object)this.numRetries()).add("RetryIntervalMs", (Object)this.retryIntervalMs()).add("MaxRetryIntervalMs", (Object)this.maxRetryIntervalMs()).add("AvoidEmptyBatches", (Object)this.avoidEmptyBatches()).add("StreamArn", (Object)this.streamArn()).add("RoleArn", (Object)this.roleArn()).add("RoleSessionName", (Object)this.roleSessionName()).add("AddRecordTimestamp", (Object)this.addRecordTimestamp()).add("EmitConsumerLagMetrics", (Object)this.emitConsumerLagMetrics()).add("StartingTimestamp", (Object)this.startingTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointUrl": {
                return Optional.ofNullable(clazz.cast(this.endpointUrl()));
            }
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "Classification": {
                return Optional.ofNullable(clazz.cast(this.classification()));
            }
            case "Delimiter": {
                return Optional.ofNullable(clazz.cast(this.delimiter()));
            }
            case "StartingPosition": {
                return Optional.ofNullable(clazz.cast(this.startingPositionAsString()));
            }
            case "MaxFetchTimeInMs": {
                return Optional.ofNullable(clazz.cast(this.maxFetchTimeInMs()));
            }
            case "MaxFetchRecordsPerShard": {
                return Optional.ofNullable(clazz.cast(this.maxFetchRecordsPerShard()));
            }
            case "MaxRecordPerRead": {
                return Optional.ofNullable(clazz.cast(this.maxRecordPerRead()));
            }
            case "AddIdleTimeBetweenReads": {
                return Optional.ofNullable(clazz.cast(this.addIdleTimeBetweenReads()));
            }
            case "IdleTimeBetweenReadsInMs": {
                return Optional.ofNullable(clazz.cast(this.idleTimeBetweenReadsInMs()));
            }
            case "DescribeShardInterval": {
                return Optional.ofNullable(clazz.cast(this.describeShardInterval()));
            }
            case "NumRetries": {
                return Optional.ofNullable(clazz.cast(this.numRetries()));
            }
            case "RetryIntervalMs": {
                return Optional.ofNullable(clazz.cast(this.retryIntervalMs()));
            }
            case "MaxRetryIntervalMs": {
                return Optional.ofNullable(clazz.cast(this.maxRetryIntervalMs()));
            }
            case "AvoidEmptyBatches": {
                return Optional.ofNullable(clazz.cast(this.avoidEmptyBatches()));
            }
            case "StreamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "RoleSessionName": {
                return Optional.ofNullable(clazz.cast(this.roleSessionName()));
            }
            case "AddRecordTimestamp": {
                return Optional.ofNullable(clazz.cast(this.addRecordTimestamp()));
            }
            case "EmitConsumerLagMetrics": {
                return Optional.ofNullable(clazz.cast(this.emitConsumerLagMetrics()));
            }
            case "StartingTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startingTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EndpointUrl", ENDPOINT_URL_FIELD);
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("Classification", CLASSIFICATION_FIELD);
        map.put("Delimiter", DELIMITER_FIELD);
        map.put("StartingPosition", STARTING_POSITION_FIELD);
        map.put("MaxFetchTimeInMs", MAX_FETCH_TIME_IN_MS_FIELD);
        map.put("MaxFetchRecordsPerShard", MAX_FETCH_RECORDS_PER_SHARD_FIELD);
        map.put("MaxRecordPerRead", MAX_RECORD_PER_READ_FIELD);
        map.put("AddIdleTimeBetweenReads", ADD_IDLE_TIME_BETWEEN_READS_FIELD);
        map.put("IdleTimeBetweenReadsInMs", IDLE_TIME_BETWEEN_READS_IN_MS_FIELD);
        map.put("DescribeShardInterval", DESCRIBE_SHARD_INTERVAL_FIELD);
        map.put("NumRetries", NUM_RETRIES_FIELD);
        map.put("RetryIntervalMs", RETRY_INTERVAL_MS_FIELD);
        map.put("MaxRetryIntervalMs", MAX_RETRY_INTERVAL_MS_FIELD);
        map.put("AvoidEmptyBatches", AVOID_EMPTY_BATCHES_FIELD);
        map.put("StreamArn", STREAM_ARN_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("RoleSessionName", ROLE_SESSION_NAME_FIELD);
        map.put("AddRecordTimestamp", ADD_RECORD_TIMESTAMP_FIELD);
        map.put("EmitConsumerLagMetrics", EMIT_CONSUMER_LAG_METRICS_FIELD);
        map.put("StartingTimestamp", STARTING_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisStreamingSourceOptions, T> g) {
        return obj -> g.apply((KinesisStreamingSourceOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointUrl;
        private String streamName;
        private String classification;
        private String delimiter;
        private String startingPosition;
        private Long maxFetchTimeInMs;
        private Long maxFetchRecordsPerShard;
        private Long maxRecordPerRead;
        private Boolean addIdleTimeBetweenReads;
        private Long idleTimeBetweenReadsInMs;
        private Long describeShardInterval;
        private Integer numRetries;
        private Long retryIntervalMs;
        private Long maxRetryIntervalMs;
        private Boolean avoidEmptyBatches;
        private String streamArn;
        private String roleArn;
        private String roleSessionName;
        private String addRecordTimestamp;
        private String emitConsumerLagMetrics;
        private Instant startingTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamingSourceOptions model) {
            this.endpointUrl(model.endpointUrl);
            this.streamName(model.streamName);
            this.classification(model.classification);
            this.delimiter(model.delimiter);
            this.startingPosition(model.startingPosition);
            this.maxFetchTimeInMs(model.maxFetchTimeInMs);
            this.maxFetchRecordsPerShard(model.maxFetchRecordsPerShard);
            this.maxRecordPerRead(model.maxRecordPerRead);
            this.addIdleTimeBetweenReads(model.addIdleTimeBetweenReads);
            this.idleTimeBetweenReadsInMs(model.idleTimeBetweenReadsInMs);
            this.describeShardInterval(model.describeShardInterval);
            this.numRetries(model.numRetries);
            this.retryIntervalMs(model.retryIntervalMs);
            this.maxRetryIntervalMs(model.maxRetryIntervalMs);
            this.avoidEmptyBatches(model.avoidEmptyBatches);
            this.streamArn(model.streamArn);
            this.roleArn(model.roleArn);
            this.roleSessionName(model.roleSessionName);
            this.addRecordTimestamp(model.addRecordTimestamp);
            this.emitConsumerLagMetrics(model.emitConsumerLagMetrics);
            this.startingTimestamp(model.startingTimestamp);
        }

        public final String getEndpointUrl() {
            return this.endpointUrl;
        }

        public final void setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }

        @Override
        public final Builder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getClassification() {
            return this.classification;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final String getStartingPosition() {
            return this.startingPosition;
        }

        public final void setStartingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
        }

        @Override
        public final Builder startingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        @Override
        public final Builder startingPosition(StartingPosition startingPosition) {
            this.startingPosition(startingPosition == null ? null : startingPosition.toString());
            return this;
        }

        public final Long getMaxFetchTimeInMs() {
            return this.maxFetchTimeInMs;
        }

        public final void setMaxFetchTimeInMs(Long maxFetchTimeInMs) {
            this.maxFetchTimeInMs = maxFetchTimeInMs;
        }

        @Override
        public final Builder maxFetchTimeInMs(Long maxFetchTimeInMs) {
            this.maxFetchTimeInMs = maxFetchTimeInMs;
            return this;
        }

        public final Long getMaxFetchRecordsPerShard() {
            return this.maxFetchRecordsPerShard;
        }

        public final void setMaxFetchRecordsPerShard(Long maxFetchRecordsPerShard) {
            this.maxFetchRecordsPerShard = maxFetchRecordsPerShard;
        }

        @Override
        public final Builder maxFetchRecordsPerShard(Long maxFetchRecordsPerShard) {
            this.maxFetchRecordsPerShard = maxFetchRecordsPerShard;
            return this;
        }

        public final Long getMaxRecordPerRead() {
            return this.maxRecordPerRead;
        }

        public final void setMaxRecordPerRead(Long maxRecordPerRead) {
            this.maxRecordPerRead = maxRecordPerRead;
        }

        @Override
        public final Builder maxRecordPerRead(Long maxRecordPerRead) {
            this.maxRecordPerRead = maxRecordPerRead;
            return this;
        }

        public final Boolean getAddIdleTimeBetweenReads() {
            return this.addIdleTimeBetweenReads;
        }

        public final void setAddIdleTimeBetweenReads(Boolean addIdleTimeBetweenReads) {
            this.addIdleTimeBetweenReads = addIdleTimeBetweenReads;
        }

        @Override
        public final Builder addIdleTimeBetweenReads(Boolean addIdleTimeBetweenReads) {
            this.addIdleTimeBetweenReads = addIdleTimeBetweenReads;
            return this;
        }

        public final Long getIdleTimeBetweenReadsInMs() {
            return this.idleTimeBetweenReadsInMs;
        }

        public final void setIdleTimeBetweenReadsInMs(Long idleTimeBetweenReadsInMs) {
            this.idleTimeBetweenReadsInMs = idleTimeBetweenReadsInMs;
        }

        @Override
        public final Builder idleTimeBetweenReadsInMs(Long idleTimeBetweenReadsInMs) {
            this.idleTimeBetweenReadsInMs = idleTimeBetweenReadsInMs;
            return this;
        }

        public final Long getDescribeShardInterval() {
            return this.describeShardInterval;
        }

        public final void setDescribeShardInterval(Long describeShardInterval) {
            this.describeShardInterval = describeShardInterval;
        }

        @Override
        public final Builder describeShardInterval(Long describeShardInterval) {
            this.describeShardInterval = describeShardInterval;
            return this;
        }

        public final Integer getNumRetries() {
            return this.numRetries;
        }

        public final void setNumRetries(Integer numRetries) {
            this.numRetries = numRetries;
        }

        @Override
        public final Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public final Long getRetryIntervalMs() {
            return this.retryIntervalMs;
        }

        public final void setRetryIntervalMs(Long retryIntervalMs) {
            this.retryIntervalMs = retryIntervalMs;
        }

        @Override
        public final Builder retryIntervalMs(Long retryIntervalMs) {
            this.retryIntervalMs = retryIntervalMs;
            return this;
        }

        public final Long getMaxRetryIntervalMs() {
            return this.maxRetryIntervalMs;
        }

        public final void setMaxRetryIntervalMs(Long maxRetryIntervalMs) {
            this.maxRetryIntervalMs = maxRetryIntervalMs;
        }

        @Override
        public final Builder maxRetryIntervalMs(Long maxRetryIntervalMs) {
            this.maxRetryIntervalMs = maxRetryIntervalMs;
            return this;
        }

        public final Boolean getAvoidEmptyBatches() {
            return this.avoidEmptyBatches;
        }

        public final void setAvoidEmptyBatches(Boolean avoidEmptyBatches) {
            this.avoidEmptyBatches = avoidEmptyBatches;
        }

        @Override
        public final Builder avoidEmptyBatches(Boolean avoidEmptyBatches) {
            this.avoidEmptyBatches = avoidEmptyBatches;
            return this;
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getRoleSessionName() {
            return this.roleSessionName;
        }

        public final void setRoleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
        }

        @Override
        public final Builder roleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
            return this;
        }

        public final String getAddRecordTimestamp() {
            return this.addRecordTimestamp;
        }

        public final void setAddRecordTimestamp(String addRecordTimestamp) {
            this.addRecordTimestamp = addRecordTimestamp;
        }

        @Override
        public final Builder addRecordTimestamp(String addRecordTimestamp) {
            this.addRecordTimestamp = addRecordTimestamp;
            return this;
        }

        public final String getEmitConsumerLagMetrics() {
            return this.emitConsumerLagMetrics;
        }

        public final void setEmitConsumerLagMetrics(String emitConsumerLagMetrics) {
            this.emitConsumerLagMetrics = emitConsumerLagMetrics;
        }

        @Override
        public final Builder emitConsumerLagMetrics(String emitConsumerLagMetrics) {
            this.emitConsumerLagMetrics = emitConsumerLagMetrics;
            return this;
        }

        public final Instant getStartingTimestamp() {
            return this.startingTimestamp;
        }

        public final void setStartingTimestamp(Instant startingTimestamp) {
            this.startingTimestamp = startingTimestamp;
        }

        @Override
        public final Builder startingTimestamp(Instant startingTimestamp) {
            this.startingTimestamp = startingTimestamp;
            return this;
        }

        public KinesisStreamingSourceOptions build() {
            return new KinesisStreamingSourceOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisStreamingSourceOptions> {
        public Builder endpointUrl(String var1);

        public Builder streamName(String var1);

        public Builder classification(String var1);

        public Builder delimiter(String var1);

        public Builder startingPosition(String var1);

        public Builder startingPosition(StartingPosition var1);

        public Builder maxFetchTimeInMs(Long var1);

        public Builder maxFetchRecordsPerShard(Long var1);

        public Builder maxRecordPerRead(Long var1);

        public Builder addIdleTimeBetweenReads(Boolean var1);

        public Builder idleTimeBetweenReadsInMs(Long var1);

        public Builder describeShardInterval(Long var1);

        public Builder numRetries(Integer var1);

        public Builder retryIntervalMs(Long var1);

        public Builder maxRetryIntervalMs(Long var1);

        public Builder avoidEmptyBatches(Boolean var1);

        public Builder streamArn(String var1);

        public Builder roleArn(String var1);

        public Builder roleSessionName(String var1);

        public Builder addRecordTimestamp(String var1);

        public Builder emitConsumerLagMetrics(String var1);

        public Builder startingTimestamp(Instant var1);
    }
}

