/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.AdditionalOptionsCopier;
import software.amazon.awssdk.services.glue.model.DirectSchemaChangePolicy;
import software.amazon.awssdk.services.glue.model.GlueStudioPathListCopier;
import software.amazon.awssdk.services.glue.model.IcebergTargetCompressionType;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.services.glue.model.TargetFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3IcebergDirectTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3IcebergDirectTarget> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(S3IcebergDirectTarget.getter(S3IcebergDirectTarget::name)).setter(S3IcebergDirectTarget.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(S3IcebergDirectTarget.getter(S3IcebergDirectTarget::inputs)).setter(S3IcebergDirectTarget.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<List<String>>> PARTITION_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionKeys").getter(S3IcebergDirectTarget.getter(S3IcebergDirectTarget::partitionKeys)).setter(S3IcebergDirectTarget.setter(Builder::partitionKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(S3IcebergDirectTarget.getter(S3IcebergDirectTarget::path)).setter(S3IcebergDirectTarget.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(S3IcebergDirectTarget.getter(S3IcebergDirectTarget::formatAsString)).setter(S3IcebergDirectTarget.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalOptions").getter(S3IcebergDirectTarget.getter(S3IcebergDirectTarget::additionalOptions)).setter(S3IcebergDirectTarget.setter(Builder::additionalOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DirectSchemaChangePolicy> SCHEMA_CHANGE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaChangePolicy").getter(S3IcebergDirectTarget.getter(S3IcebergDirectTarget::schemaChangePolicy)).setter(S3IcebergDirectTarget.setter(Builder::schemaChangePolicy)).constructor(DirectSchemaChangePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaChangePolicy").build()}).build();
    private static final SdkField<String> COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Compression").getter(S3IcebergDirectTarget.getter(S3IcebergDirectTarget::compressionAsString)).setter(S3IcebergDirectTarget.setter(Builder::compression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compression").build()}).build();
    private static final SdkField<String> NUMBER_TARGET_PARTITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NumberTargetPartitions").getter(S3IcebergDirectTarget.getter(S3IcebergDirectTarget::numberTargetPartitions)).setter(S3IcebergDirectTarget.setter(Builder::numberTargetPartitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberTargetPartitions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, PARTITION_KEYS_FIELD, PATH_FIELD, FORMAT_FIELD, ADDITIONAL_OPTIONS_FIELD, SCHEMA_CHANGE_POLICY_FIELD, COMPRESSION_FIELD, NUMBER_TARGET_PARTITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3IcebergDirectTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final List<List<String>> partitionKeys;
    private final String path;
    private final String format;
    private final Map<String, String> additionalOptions;
    private final DirectSchemaChangePolicy schemaChangePolicy;
    private final String compression;
    private final String numberTargetPartitions;

    private S3IcebergDirectTarget(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.partitionKeys = builder.partitionKeys;
        this.path = builder.path;
        this.format = builder.format;
        this.additionalOptions = builder.additionalOptions;
        this.schemaChangePolicy = builder.schemaChangePolicy;
        this.compression = builder.compression;
        this.numberTargetPartitions = builder.numberTargetPartitions;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final boolean hasPartitionKeys() {
        return this.partitionKeys != null && !(this.partitionKeys instanceof SdkAutoConstructList);
    }

    public final List<List<String>> partitionKeys() {
        return this.partitionKeys;
    }

    public final String path() {
        return this.path;
    }

    public final TargetFormat format() {
        return TargetFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final boolean hasAdditionalOptions() {
        return this.additionalOptions != null && !(this.additionalOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalOptions() {
        return this.additionalOptions;
    }

    public final DirectSchemaChangePolicy schemaChangePolicy() {
        return this.schemaChangePolicy;
    }

    public final IcebergTargetCompressionType compression() {
        return IcebergTargetCompressionType.fromValue(this.compression);
    }

    public final String compressionAsString() {
        return this.compression;
    }

    public final String numberTargetPartitions() {
        return this.numberTargetPartitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionKeys() ? this.partitionKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalOptions() ? this.additionalOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaChangePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberTargetPartitions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3IcebergDirectTarget)) {
            return false;
        }
        S3IcebergDirectTarget other = (S3IcebergDirectTarget)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && this.hasPartitionKeys() == other.hasPartitionKeys() && Objects.equals(this.partitionKeys(), other.partitionKeys()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.formatAsString(), other.formatAsString()) && this.hasAdditionalOptions() == other.hasAdditionalOptions() && Objects.equals(this.additionalOptions(), other.additionalOptions()) && Objects.equals(this.schemaChangePolicy(), other.schemaChangePolicy()) && Objects.equals(this.compressionAsString(), other.compressionAsString()) && Objects.equals(this.numberTargetPartitions(), other.numberTargetPartitions());
    }

    public final String toString() {
        return ToString.builder((String)"S3IcebergDirectTarget").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("PartitionKeys", this.hasPartitionKeys() ? this.partitionKeys() : null).add("Path", (Object)this.path()).add("Format", (Object)this.formatAsString()).add("AdditionalOptions", this.hasAdditionalOptions() ? this.additionalOptions() : null).add("SchemaChangePolicy", (Object)this.schemaChangePolicy()).add("Compression", (Object)this.compressionAsString()).add("NumberTargetPartitions", (Object)this.numberTargetPartitions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "PartitionKeys": {
                return Optional.ofNullable(clazz.cast(this.partitionKeys()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "AdditionalOptions": {
                return Optional.ofNullable(clazz.cast(this.additionalOptions()));
            }
            case "SchemaChangePolicy": {
                return Optional.ofNullable(clazz.cast(this.schemaChangePolicy()));
            }
            case "Compression": {
                return Optional.ofNullable(clazz.cast(this.compressionAsString()));
            }
            case "NumberTargetPartitions": {
                return Optional.ofNullable(clazz.cast(this.numberTargetPartitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("PartitionKeys", PARTITION_KEYS_FIELD);
        map.put("Path", PATH_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("AdditionalOptions", ADDITIONAL_OPTIONS_FIELD);
        map.put("SchemaChangePolicy", SCHEMA_CHANGE_POLICY_FIELD);
        map.put("Compression", COMPRESSION_FIELD);
        map.put("NumberTargetPartitions", NUMBER_TARGET_PARTITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3IcebergDirectTarget, T> g) {
        return obj -> g.apply((S3IcebergDirectTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private List<List<String>> partitionKeys = DefaultSdkAutoConstructList.getInstance();
        private String path;
        private String format;
        private Map<String, String> additionalOptions = DefaultSdkAutoConstructMap.getInstance();
        private DirectSchemaChangePolicy schemaChangePolicy;
        private String compression;
        private String numberTargetPartitions;

        private BuilderImpl() {
        }

        private BuilderImpl(S3IcebergDirectTarget model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.partitionKeys(model.partitionKeys);
            this.path(model.path);
            this.format(model.format);
            this.additionalOptions(model.additionalOptions);
            this.schemaChangePolicy(model.schemaChangePolicy);
            this.compression(model.compression);
            this.numberTargetPartitions(model.numberTargetPartitions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final Collection<? extends Collection<String>> getPartitionKeys() {
            if (this.partitionKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionKeys;
        }

        public final void setPartitionKeys(Collection<? extends Collection<String>> partitionKeys) {
            this.partitionKeys = GlueStudioPathListCopier.copy(partitionKeys);
        }

        @Override
        public final Builder partitionKeys(Collection<? extends Collection<String>> partitionKeys) {
            this.partitionKeys = GlueStudioPathListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Collection<String> ... partitionKeys) {
            this.partitionKeys((Collection<? extends Collection<String>>)Arrays.asList(partitionKeys));
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(TargetFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Map<String, String> getAdditionalOptions() {
            if (this.additionalOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalOptions;
        }

        public final void setAdditionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = AdditionalOptionsCopier.copy(additionalOptions);
        }

        @Override
        public final Builder additionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = AdditionalOptionsCopier.copy(additionalOptions);
            return this;
        }

        public final DirectSchemaChangePolicy.Builder getSchemaChangePolicy() {
            return this.schemaChangePolicy != null ? this.schemaChangePolicy.toBuilder() : null;
        }

        public final void setSchemaChangePolicy(DirectSchemaChangePolicy.BuilderImpl schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy != null ? schemaChangePolicy.build() : null;
        }

        @Override
        public final Builder schemaChangePolicy(DirectSchemaChangePolicy schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy;
            return this;
        }

        public final String getCompression() {
            return this.compression;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(IcebergTargetCompressionType compression) {
            this.compression(compression == null ? null : compression.toString());
            return this;
        }

        public final String getNumberTargetPartitions() {
            return this.numberTargetPartitions;
        }

        public final void setNumberTargetPartitions(String numberTargetPartitions) {
            this.numberTargetPartitions = numberTargetPartitions;
        }

        @Override
        public final Builder numberTargetPartitions(String numberTargetPartitions) {
            this.numberTargetPartitions = numberTargetPartitions;
            return this;
        }

        public S3IcebergDirectTarget build() {
            return new S3IcebergDirectTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3IcebergDirectTarget> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder partitionKeys(Collection<? extends Collection<String>> var1);

        public Builder partitionKeys(Collection<String> ... var1);

        public Builder path(String var1);

        public Builder format(String var1);

        public Builder format(TargetFormat var1);

        public Builder additionalOptions(Map<String, String> var1);

        public Builder schemaChangePolicy(DirectSchemaChangePolicy var1);

        default public Builder schemaChangePolicy(Consumer<DirectSchemaChangePolicy.Builder> schemaChangePolicy) {
            return this.schemaChangePolicy((DirectSchemaChangePolicy)((DirectSchemaChangePolicy.Builder)DirectSchemaChangePolicy.builder().applyMutation(schemaChangePolicy)).build());
        }

        public Builder compression(String var1);

        public Builder compression(IcebergTargetCompressionType var1);

        public Builder numberTargetPartitions(String var1);
    }
}

