/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.DataQualityEvaluationRunAdditionalRunOptions;
import software.amazon.awssdk.services.glue.model.DataSource;
import software.amazon.awssdk.services.glue.model.DataSourceMapCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.RulesetNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDataQualityRulesetEvaluationRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, StartDataQualityRulesetEvaluationRunRequest> {
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(StartDataQualityRulesetEvaluationRunRequest.getter(StartDataQualityRulesetEvaluationRunRequest::dataSource)).setter(StartDataQualityRulesetEvaluationRunRequest.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(StartDataQualityRulesetEvaluationRunRequest.getter(StartDataQualityRulesetEvaluationRunRequest::role)).setter(StartDataQualityRulesetEvaluationRunRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfWorkers").getter(StartDataQualityRulesetEvaluationRunRequest.getter(StartDataQualityRulesetEvaluationRunRequest::numberOfWorkers)).setter(StartDataQualityRulesetEvaluationRunRequest.setter(Builder::numberOfWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(StartDataQualityRulesetEvaluationRunRequest.getter(StartDataQualityRulesetEvaluationRunRequest::timeout)).setter(StartDataQualityRulesetEvaluationRunRequest.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartDataQualityRulesetEvaluationRunRequest.getter(StartDataQualityRulesetEvaluationRunRequest::clientToken)).setter(StartDataQualityRulesetEvaluationRunRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<DataQualityEvaluationRunAdditionalRunOptions> ADDITIONAL_RUN_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalRunOptions").getter(StartDataQualityRulesetEvaluationRunRequest.getter(StartDataQualityRulesetEvaluationRunRequest::additionalRunOptions)).setter(StartDataQualityRulesetEvaluationRunRequest.setter(Builder::additionalRunOptions)).constructor(DataQualityEvaluationRunAdditionalRunOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalRunOptions").build()}).build();
    private static final SdkField<List<String>> RULESET_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RulesetNames").getter(StartDataQualityRulesetEvaluationRunRequest.getter(StartDataQualityRulesetEvaluationRunRequest::rulesetNames)).setter(StartDataQualityRulesetEvaluationRunRequest.setter(Builder::rulesetNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesetNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, DataSource>> ADDITIONAL_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalDataSources").getter(StartDataQualityRulesetEvaluationRunRequest.getter(StartDataQualityRulesetEvaluationRunRequest::additionalDataSources)).setter(StartDataQualityRulesetEvaluationRunRequest.setter(Builder::additionalDataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDataSources").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, ROLE_FIELD, NUMBER_OF_WORKERS_FIELD, TIMEOUT_FIELD, CLIENT_TOKEN_FIELD, ADDITIONAL_RUN_OPTIONS_FIELD, RULESET_NAMES_FIELD, ADDITIONAL_DATA_SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartDataQualityRulesetEvaluationRunRequest.memberNameToFieldInitializer();
    private final DataSource dataSource;
    private final String role;
    private final Integer numberOfWorkers;
    private final Integer timeout;
    private final String clientToken;
    private final DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions;
    private final List<String> rulesetNames;
    private final Map<String, DataSource> additionalDataSources;

    private StartDataQualityRulesetEvaluationRunRequest(BuilderImpl builder) {
        super(builder);
        this.dataSource = builder.dataSource;
        this.role = builder.role;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.timeout = builder.timeout;
        this.clientToken = builder.clientToken;
        this.additionalRunOptions = builder.additionalRunOptions;
        this.rulesetNames = builder.rulesetNames;
        this.additionalDataSources = builder.additionalDataSources;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public final String role() {
        return this.role;
    }

    public final Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions() {
        return this.additionalRunOptions;
    }

    public final boolean hasRulesetNames() {
        return this.rulesetNames != null && !(this.rulesetNames instanceof SdkAutoConstructList);
    }

    public final List<String> rulesetNames() {
        return this.rulesetNames;
    }

    public final boolean hasAdditionalDataSources() {
        return this.additionalDataSources != null && !(this.additionalDataSources instanceof SdkAutoConstructMap);
    }

    public final Map<String, DataSource> additionalDataSources() {
        return this.additionalDataSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalRunOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRulesetNames() ? this.rulesetNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalDataSources() ? this.additionalDataSources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDataQualityRulesetEvaluationRunRequest)) {
            return false;
        }
        StartDataQualityRulesetEvaluationRunRequest other = (StartDataQualityRulesetEvaluationRunRequest)((Object)obj);
        return Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.additionalRunOptions(), other.additionalRunOptions()) && this.hasRulesetNames() == other.hasRulesetNames() && Objects.equals(this.rulesetNames(), other.rulesetNames()) && this.hasAdditionalDataSources() == other.hasAdditionalDataSources() && Objects.equals(this.additionalDataSources(), other.additionalDataSources());
    }

    public final String toString() {
        return ToString.builder((String)"StartDataQualityRulesetEvaluationRunRequest").add("DataSource", (Object)this.dataSource()).add("Role", (Object)this.role()).add("NumberOfWorkers", (Object)this.numberOfWorkers()).add("Timeout", (Object)this.timeout()).add("ClientToken", (Object)this.clientToken()).add("AdditionalRunOptions", (Object)this.additionalRunOptions()).add("RulesetNames", this.hasRulesetNames() ? this.rulesetNames() : null).add("AdditionalDataSources", this.hasAdditionalDataSources() ? this.additionalDataSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "NumberOfWorkers": {
                return Optional.ofNullable(clazz.cast(this.numberOfWorkers()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "AdditionalRunOptions": {
                return Optional.ofNullable(clazz.cast(this.additionalRunOptions()));
            }
            case "RulesetNames": {
                return Optional.ofNullable(clazz.cast(this.rulesetNames()));
            }
            case "AdditionalDataSources": {
                return Optional.ofNullable(clazz.cast(this.additionalDataSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("NumberOfWorkers", NUMBER_OF_WORKERS_FIELD);
        map.put("Timeout", TIMEOUT_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("AdditionalRunOptions", ADDITIONAL_RUN_OPTIONS_FIELD);
        map.put("RulesetNames", RULESET_NAMES_FIELD);
        map.put("AdditionalDataSources", ADDITIONAL_DATA_SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDataQualityRulesetEvaluationRunRequest, T> g) {
        return obj -> g.apply((StartDataQualityRulesetEvaluationRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private DataSource dataSource;
        private String role;
        private Integer numberOfWorkers;
        private Integer timeout;
        private String clientToken;
        private DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions;
        private List<String> rulesetNames = DefaultSdkAutoConstructList.getInstance();
        private Map<String, DataSource> additionalDataSources = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartDataQualityRulesetEvaluationRunRequest model) {
            super(model);
            this.dataSource(model.dataSource);
            this.role(model.role);
            this.numberOfWorkers(model.numberOfWorkers);
            this.timeout(model.timeout);
            this.clientToken(model.clientToken);
            this.additionalRunOptions(model.additionalRunOptions);
            this.rulesetNames(model.rulesetNames);
            this.additionalDataSources(model.additionalDataSources);
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DataQualityEvaluationRunAdditionalRunOptions.Builder getAdditionalRunOptions() {
            return this.additionalRunOptions != null ? this.additionalRunOptions.toBuilder() : null;
        }

        public final void setAdditionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions.BuilderImpl additionalRunOptions) {
            this.additionalRunOptions = additionalRunOptions != null ? additionalRunOptions.build() : null;
        }

        @Override
        public final Builder additionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions) {
            this.additionalRunOptions = additionalRunOptions;
            return this;
        }

        public final Collection<String> getRulesetNames() {
            if (this.rulesetNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rulesetNames;
        }

        public final void setRulesetNames(Collection<String> rulesetNames) {
            this.rulesetNames = RulesetNamesCopier.copy(rulesetNames);
        }

        @Override
        public final Builder rulesetNames(Collection<String> rulesetNames) {
            this.rulesetNames = RulesetNamesCopier.copy(rulesetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesetNames(String ... rulesetNames) {
            this.rulesetNames(Arrays.asList(rulesetNames));
            return this;
        }

        public final Map<String, DataSource.Builder> getAdditionalDataSources() {
            Map<String, DataSource.Builder> result = DataSourceMapCopier.copyToBuilder(this.additionalDataSources);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAdditionalDataSources(Map<String, DataSource.BuilderImpl> additionalDataSources) {
            this.additionalDataSources = DataSourceMapCopier.copyFromBuilder(additionalDataSources);
        }

        @Override
        public final Builder additionalDataSources(Map<String, DataSource> additionalDataSources) {
            this.additionalDataSources = DataSourceMapCopier.copy(additionalDataSources);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDataQualityRulesetEvaluationRunRequest build() {
            return new StartDataQualityRulesetEvaluationRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDataQualityRulesetEvaluationRunRequest> {
        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder role(String var1);

        public Builder numberOfWorkers(Integer var1);

        public Builder timeout(Integer var1);

        public Builder clientToken(String var1);

        public Builder additionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions var1);

        default public Builder additionalRunOptions(Consumer<DataQualityEvaluationRunAdditionalRunOptions.Builder> additionalRunOptions) {
            return this.additionalRunOptions((DataQualityEvaluationRunAdditionalRunOptions)((DataQualityEvaluationRunAdditionalRunOptions.Builder)DataQualityEvaluationRunAdditionalRunOptions.builder().applyMutation(additionalRunOptions)).build());
        }

        public Builder rulesetNames(Collection<String> var1);

        public Builder rulesetNames(String ... var1);

        public Builder additionalDataSources(Map<String, DataSource> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

