/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.Capabilities;
import software.amazon.awssdk.services.glue.model.ConnectionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionTypeBrief
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionTypeBrief> {
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(ConnectionTypeBrief.getter(ConnectionTypeBrief::connectionTypeAsString)).setter(ConnectionTypeBrief.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ConnectionTypeBrief.getter(ConnectionTypeBrief::description)).setter(ConnectionTypeBrief.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Capabilities> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Capabilities").getter(ConnectionTypeBrief.getter(ConnectionTypeBrief::capabilities)).setter(ConnectionTypeBrief.setter(Builder::capabilities)).constructor(Capabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_TYPE_FIELD, DESCRIPTION_FIELD, CAPABILITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectionTypeBrief.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectionType;
    private final String description;
    private final Capabilities capabilities;

    private ConnectionTypeBrief(BuilderImpl builder) {
        this.connectionType = builder.connectionType;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final String description() {
        return this.description;
    }

    public final Capabilities capabilities() {
        return this.capabilities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilities());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionTypeBrief)) {
            return false;
        }
        ConnectionTypeBrief other = (ConnectionTypeBrief)obj;
        return Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.capabilities(), other.capabilities());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionTypeBrief").add("ConnectionType", (Object)this.connectionTypeAsString()).add("Description", (Object)this.description()).add("Capabilities", (Object)this.capabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionTypeBrief, T> g) {
        return obj -> g.apply((ConnectionTypeBrief)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionType;
        private String description;
        private Capabilities capabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionTypeBrief model) {
            this.connectionType(model.connectionType);
            this.description(model.description);
            this.capabilities(model.capabilities);
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Capabilities.Builder getCapabilities() {
            return this.capabilities != null ? this.capabilities.toBuilder() : null;
        }

        public final void setCapabilities(Capabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(Capabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public ConnectionTypeBrief build() {
            return new ConnectionTypeBrief(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionTypeBrief> {
        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder description(String var1);

        public Builder capabilities(Capabilities var1);

        default public Builder capabilities(Consumer<Capabilities.Builder> capabilities) {
            return this.capabilities((Capabilities)((Capabilities.Builder)Capabilities.builder().applyMutation(capabilities)).build());
        }
    }
}

