/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.IntegrationFilter;
import software.amazon.awssdk.services.glue.model.IntegrationFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIntegrationsRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, DescribeIntegrationsRequest> {
    private static final SdkField<String> INTEGRATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationIdentifier").getter(DescribeIntegrationsRequest.getter(DescribeIntegrationsRequest::integrationIdentifier)).setter(DescribeIntegrationsRequest.setter(Builder::integrationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationIdentifier").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeIntegrationsRequest.getter(DescribeIntegrationsRequest::marker)).setter(DescribeIntegrationsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeIntegrationsRequest.getter(DescribeIntegrationsRequest::maxRecords)).setter(DescribeIntegrationsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<List<IntegrationFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeIntegrationsRequest.getter(DescribeIntegrationsRequest::filters)).setter(DescribeIntegrationsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IntegrationFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_IDENTIFIER_FIELD, MARKER_FIELD, MAX_RECORDS_FIELD, FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeIntegrationsRequest.memberNameToFieldInitializer();
    private final String integrationIdentifier;
    private final String marker;
    private final Integer maxRecords;
    private final List<IntegrationFilter> filters;

    private DescribeIntegrationsRequest(BuilderImpl builder) {
        super(builder);
        this.integrationIdentifier = builder.integrationIdentifier;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
        this.filters = builder.filters;
    }

    public final String integrationIdentifier() {
        return this.integrationIdentifier;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<IntegrationFilter> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIntegrationsRequest)) {
            return false;
        }
        DescribeIntegrationsRequest other = (DescribeIntegrationsRequest)((Object)obj);
        return Objects.equals(this.integrationIdentifier(), other.integrationIdentifier()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxRecords(), other.maxRecords()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIntegrationsRequest").add("IntegrationIdentifier", (Object)this.integrationIdentifier()).add("Marker", (Object)this.marker()).add("MaxRecords", (Object)this.maxRecords()).add("Filters", this.hasFilters() ? this.filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntegrationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.integrationIdentifier()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IntegrationIdentifier", INTEGRATION_IDENTIFIER_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIntegrationsRequest, T> g) {
        return obj -> g.apply((DescribeIntegrationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String integrationIdentifier;
        private String marker;
        private Integer maxRecords;
        private List<IntegrationFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIntegrationsRequest model) {
            super(model);
            this.integrationIdentifier(model.integrationIdentifier);
            this.marker(model.marker);
            this.maxRecords(model.maxRecords);
            this.filters(model.filters);
        }

        public final String getIntegrationIdentifier() {
            return this.integrationIdentifier;
        }

        public final void setIntegrationIdentifier(String integrationIdentifier) {
            this.integrationIdentifier = integrationIdentifier;
        }

        @Override
        public final Builder integrationIdentifier(String integrationIdentifier) {
            this.integrationIdentifier = integrationIdentifier;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final List<IntegrationFilter.Builder> getFilters() {
            List<IntegrationFilter.Builder> result = IntegrationFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<IntegrationFilter.BuilderImpl> filters) {
            this.filters = IntegrationFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<IntegrationFilter> filters) {
            this.filters = IntegrationFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(IntegrationFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<IntegrationFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (IntegrationFilter)((IntegrationFilter.Builder)IntegrationFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeIntegrationsRequest build() {
            return new DescribeIntegrationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIntegrationsRequest> {
        public Builder integrationIdentifier(String var1);

        public Builder marker(String var1);

        public Builder maxRecords(Integer var1);

        public Builder filters(Collection<IntegrationFilter> var1);

        public Builder filters(IntegrationFilter ... var1);

        public Builder filters(Consumer<IntegrationFilter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

