/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQualityResultDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQualityResultDescription> {
    private static final SdkField<String> RESULT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultId").getter(DataQualityResultDescription.getter(DataQualityResultDescription::resultId)).setter(DataQualityResultDescription.setter(Builder::resultId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultId").build()}).build();
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(DataQualityResultDescription.getter(DataQualityResultDescription::dataSource)).setter(DataQualityResultDescription.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(DataQualityResultDescription.getter(DataQualityResultDescription::jobName)).setter(DataQualityResultDescription.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobRunId").getter(DataQualityResultDescription.getter(DataQualityResultDescription::jobRunId)).setter(DataQualityResultDescription.setter(Builder::jobRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunId").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedOn").getter(DataQualityResultDescription.getter(DataQualityResultDescription::startedOn)).setter(DataQualityResultDescription.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_ID_FIELD, DATA_SOURCE_FIELD, JOB_NAME_FIELD, JOB_RUN_ID_FIELD, STARTED_ON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataQualityResultDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resultId;
    private final DataSource dataSource;
    private final String jobName;
    private final String jobRunId;
    private final Instant startedOn;

    private DataQualityResultDescription(BuilderImpl builder) {
        this.resultId = builder.resultId;
        this.dataSource = builder.dataSource;
        this.jobName = builder.jobName;
        this.jobRunId = builder.jobRunId;
        this.startedOn = builder.startedOn;
    }

    public final String resultId() {
        return this.resultId;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String jobRunId() {
        return this.jobRunId;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityResultDescription)) {
            return false;
        }
        DataQualityResultDescription other = (DataQualityResultDescription)obj;
        return Objects.equals(this.resultId(), other.resultId()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobRunId(), other.jobRunId()) && Objects.equals(this.startedOn(), other.startedOn());
    }

    public final String toString() {
        return ToString.builder((String)"DataQualityResultDescription").add("ResultId", (Object)this.resultId()).add("DataSource", (Object)this.dataSource()).add("JobName", (Object)this.jobName()).add("JobRunId", (Object)this.jobRunId()).add("StartedOn", (Object)this.startedOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultId": {
                return Optional.ofNullable(clazz.cast(this.resultId()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobRunId": {
                return Optional.ofNullable(clazz.cast(this.jobRunId()));
            }
            case "StartedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResultId", RESULT_ID_FIELD);
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("JobName", JOB_NAME_FIELD);
        map.put("JobRunId", JOB_RUN_ID_FIELD);
        map.put("StartedOn", STARTED_ON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualityResultDescription, T> g) {
        return obj -> g.apply((DataQualityResultDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resultId;
        private DataSource dataSource;
        private String jobName;
        private String jobRunId;
        private Instant startedOn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityResultDescription model) {
            this.resultId(model.resultId);
            this.dataSource(model.dataSource);
            this.jobName(model.jobName);
            this.jobRunId(model.jobRunId);
            this.startedOn(model.startedOn);
        }

        public final String getResultId() {
            return this.resultId;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobRunId() {
            return this.jobRunId;
        }

        public final void setJobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
        }

        @Override
        public final Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public DataQualityResultDescription build() {
            return new DataQualityResultDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQualityResultDescription> {
        public Builder resultId(String var1);

        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder jobName(String var1);

        public Builder jobRunId(String var1);

        public Builder startedOn(Instant var1);
    }
}

