/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueStudioSchemaColumn;
import software.amazon.awssdk.services.glue.model.GlueStudioSchemaColumnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlueSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlueSchema> {
    private static final SdkField<List<GlueStudioSchemaColumn>> COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Columns").getter(GlueSchema.getter(GlueSchema::columns)).setter(GlueSchema.setter(Builder::columns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlueStudioSchemaColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GlueSchema.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<GlueStudioSchemaColumn> columns;

    private GlueSchema(BuilderImpl builder) {
        this.columns = builder.columns;
    }

    public final boolean hasColumns() {
        return this.columns != null && !(this.columns instanceof SdkAutoConstructList);
    }

    public final List<GlueStudioSchemaColumn> columns() {
        return this.columns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumns() ? this.columns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueSchema)) {
            return false;
        }
        GlueSchema other = (GlueSchema)obj;
        return this.hasColumns() == other.hasColumns() && Objects.equals(this.columns(), other.columns());
    }

    public final String toString() {
        return ToString.builder((String)"GlueSchema").add("Columns", this.hasColumns() ? this.columns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Columns": {
                return Optional.ofNullable(clazz.cast(this.columns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<GlueStudioSchemaColumn>>> map = new HashMap<String, SdkField<List<GlueStudioSchemaColumn>>>();
        map.put("Columns", COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlueSchema, T> g) {
        return obj -> g.apply((GlueSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GlueStudioSchemaColumn> columns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GlueSchema model) {
            this.columns(model.columns);
        }

        public final List<GlueStudioSchemaColumn.Builder> getColumns() {
            List<GlueStudioSchemaColumn.Builder> result = GlueStudioSchemaColumnListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<GlueStudioSchemaColumn.BuilderImpl> columns) {
            this.columns = GlueStudioSchemaColumnListCopier.copyFromBuilder(columns);
        }

        @Override
        public final Builder columns(Collection<GlueStudioSchemaColumn> columns) {
            this.columns = GlueStudioSchemaColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(GlueStudioSchemaColumn ... columns) {
            this.columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<GlueStudioSchemaColumn.Builder> ... columns) {
            this.columns(Stream.of(columns).map(c -> (GlueStudioSchemaColumn)((GlueStudioSchemaColumn.Builder)GlueStudioSchemaColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GlueSchema build() {
            return new GlueSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlueSchema> {
        public Builder columns(Collection<GlueStudioSchemaColumn> var1);

        public Builder columns(GlueStudioSchemaColumn ... var1);

        public Builder columns(Consumer<GlueStudioSchemaColumn.Builder> ... var1);
    }
}

