/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.TransformFilterCriteria;
import software.amazon.awssdk.services.glue.model.TransformSortCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMlTransformsRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetMlTransformsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetMlTransformsRequest.getter(GetMlTransformsRequest::nextToken)).setter(GetMlTransformsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetMlTransformsRequest.getter(GetMlTransformsRequest::maxResults)).setter(GetMlTransformsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<TransformFilterCriteria> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(GetMlTransformsRequest.getter(GetMlTransformsRequest::filter)).setter(GetMlTransformsRequest.setter(Builder::filter)).constructor(TransformFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<TransformSortCriteria> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sort").getter(GetMlTransformsRequest.getter(GetMlTransformsRequest::sort)).setter(GetMlTransformsRequest.setter(Builder::sort)).constructor(TransformSortCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTER_FIELD, SORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMlTransformsRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;
    private final TransformFilterCriteria filter;
    private final TransformSortCriteria sort;

    private GetMlTransformsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filter = builder.filter;
        this.sort = builder.sort;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final TransformFilterCriteria filter() {
        return this.filter;
    }

    public final TransformSortCriteria sort() {
        return this.sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlTransformsRequest)) {
            return false;
        }
        GetMlTransformsRequest other = (GetMlTransformsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.sort(), other.sort());
    }

    public final String toString() {
        return ToString.builder((String)"GetMlTransformsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Filter", (Object)this.filter()).add("Sort", (Object)this.sort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("Sort", SORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMlTransformsRequest, T> g) {
        return obj -> g.apply((GetMlTransformsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private TransformFilterCriteria filter;
        private TransformSortCriteria sort;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlTransformsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.filter(model.filter);
            this.sort(model.sort);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final TransformFilterCriteria.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(TransformFilterCriteria.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(TransformFilterCriteria filter) {
            this.filter = filter;
            return this;
        }

        public final TransformSortCriteria.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(TransformSortCriteria.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(TransformSortCriteria sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMlTransformsRequest build() {
            return new GetMlTransformsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMlTransformsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder filter(TransformFilterCriteria var1);

        default public Builder filter(Consumer<TransformFilterCriteria.Builder> filter) {
            return this.filter((TransformFilterCriteria)((TransformFilterCriteria.Builder)TransformFilterCriteria.builder().applyMutation(filter)).build());
        }

        public Builder sort(TransformSortCriteria var1);

        default public Builder sort(Consumer<TransformSortCriteria.Builder> sort) {
            return this.sort((TransformSortCriteria)((TransformSortCriteria.Builder)TransformSortCriteria.builder().applyMutation(sort)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

