/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DataQualityEncryptionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQualityEncryption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQualityEncryption> {
    private static final SdkField<String> DATA_QUALITY_ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataQualityEncryptionMode").getter(DataQualityEncryption.getter(DataQualityEncryption::dataQualityEncryptionModeAsString)).setter(DataQualityEncryption.setter(Builder::dataQualityEncryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityEncryptionMode").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(DataQualityEncryption.getter(DataQualityEncryption::kmsKeyArn)).setter(DataQualityEncryption.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_QUALITY_ENCRYPTION_MODE_FIELD, KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataQualityEncryption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataQualityEncryptionMode;
    private final String kmsKeyArn;

    private DataQualityEncryption(BuilderImpl builder) {
        this.dataQualityEncryptionMode = builder.dataQualityEncryptionMode;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final DataQualityEncryptionMode dataQualityEncryptionMode() {
        return DataQualityEncryptionMode.fromValue(this.dataQualityEncryptionMode);
    }

    public final String dataQualityEncryptionModeAsString() {
        return this.dataQualityEncryptionMode;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualityEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityEncryption)) {
            return false;
        }
        DataQualityEncryption other = (DataQualityEncryption)obj;
        return Objects.equals(this.dataQualityEncryptionModeAsString(), other.dataQualityEncryptionModeAsString()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"DataQualityEncryption").add("DataQualityEncryptionMode", (Object)this.dataQualityEncryptionModeAsString()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataQualityEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.dataQualityEncryptionModeAsString()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DataQualityEncryptionMode", DATA_QUALITY_ENCRYPTION_MODE_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualityEncryption, T> g) {
        return obj -> g.apply((DataQualityEncryption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataQualityEncryptionMode;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityEncryption model) {
            this.dataQualityEncryptionMode(model.dataQualityEncryptionMode);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getDataQualityEncryptionMode() {
            return this.dataQualityEncryptionMode;
        }

        public final void setDataQualityEncryptionMode(String dataQualityEncryptionMode) {
            this.dataQualityEncryptionMode = dataQualityEncryptionMode;
        }

        @Override
        public final Builder dataQualityEncryptionMode(String dataQualityEncryptionMode) {
            this.dataQualityEncryptionMode = dataQualityEncryptionMode;
            return this;
        }

        @Override
        public final Builder dataQualityEncryptionMode(DataQualityEncryptionMode dataQualityEncryptionMode) {
            this.dataQualityEncryptionMode(dataQualityEncryptionMode == null ? null : dataQualityEncryptionMode.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public DataQualityEncryption build() {
            return new DataQualityEncryption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQualityEncryption> {
        public Builder dataQualityEncryptionMode(String var1);

        public Builder dataQualityEncryptionMode(DataQualityEncryptionMode var1);

        public Builder kmsKeyArn(String var1);
    }
}

