/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the dialect of the view, and the query that defines the view.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViewRepresentation implements SdkPojo, Serializable,
        ToCopyableBuilder<ViewRepresentation.Builder, ViewRepresentation> {
    private static final SdkField<String> DIALECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Dialect")
            .getter(getter(ViewRepresentation::dialectAsString)).setter(setter(Builder::dialect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dialect").build()).build();

    private static final SdkField<String> DIALECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DialectVersion").getter(getter(ViewRepresentation::dialectVersion))
            .setter(setter(Builder::dialectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DialectVersion").build()).build();

    private static final SdkField<String> VIEW_ORIGINAL_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewOriginalText").getter(getter(ViewRepresentation::viewOriginalText))
            .setter(setter(Builder::viewOriginalText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewOriginalText").build()).build();

    private static final SdkField<String> VIEW_EXPANDED_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewExpandedText").getter(getter(ViewRepresentation::viewExpandedText))
            .setter(setter(Builder::viewExpandedText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewExpandedText").build()).build();

    private static final SdkField<String> VALIDATION_CONNECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationConnection").getter(getter(ViewRepresentation::validationConnection))
            .setter(setter(Builder::validationConnection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationConnection").build())
            .build();

    private static final SdkField<Boolean> IS_STALE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsStale").getter(getter(ViewRepresentation::isStale)).setter(setter(Builder::isStale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsStale").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIALECT_FIELD,
            DIALECT_VERSION_FIELD, VIEW_ORIGINAL_TEXT_FIELD, VIEW_EXPANDED_TEXT_FIELD, VALIDATION_CONNECTION_FIELD,
            IS_STALE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dialect;

    private final String dialectVersion;

    private final String viewOriginalText;

    private final String viewExpandedText;

    private final String validationConnection;

    private final Boolean isStale;

    private ViewRepresentation(BuilderImpl builder) {
        this.dialect = builder.dialect;
        this.dialectVersion = builder.dialectVersion;
        this.viewOriginalText = builder.viewOriginalText;
        this.viewExpandedText = builder.viewExpandedText;
        this.validationConnection = builder.validationConnection;
        this.isStale = builder.isStale;
    }

    /**
     * <p>
     * The dialect of the query engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dialect} will
     * return {@link ViewDialect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dialectAsString}.
     * </p>
     * 
     * @return The dialect of the query engine.
     * @see ViewDialect
     */
    public final ViewDialect dialect() {
        return ViewDialect.fromValue(dialect);
    }

    /**
     * <p>
     * The dialect of the query engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dialect} will
     * return {@link ViewDialect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dialectAsString}.
     * </p>
     * 
     * @return The dialect of the query engine.
     * @see ViewDialect
     */
    public final String dialectAsString() {
        return dialect;
    }

    /**
     * <p>
     * The version of the dialect of the query engine. For example, 3.0.0.
     * </p>
     * 
     * @return The version of the dialect of the query engine. For example, 3.0.0.
     */
    public final String dialectVersion() {
        return dialectVersion;
    }

    /**
     * <p>
     * The <code>SELECT</code> query provided by the customer during <code>CREATE VIEW DDL</code>. This SQL is not used
     * during a query on a view (<code>ViewExpandedText</code> is used instead). <code>ViewOriginalText</code> is used
     * for cases like <code>SHOW CREATE VIEW</code> where users want to see the original DDL command that created the
     * view.
     * </p>
     * 
     * @return The <code>SELECT</code> query provided by the customer during <code>CREATE VIEW DDL</code>. This SQL is
     *         not used during a query on a view (<code>ViewExpandedText</code> is used instead).
     *         <code>ViewOriginalText</code> is used for cases like <code>SHOW CREATE VIEW</code> where users want to
     *         see the original DDL command that created the view.
     */
    public final String viewOriginalText() {
        return viewOriginalText;
    }

    /**
     * <p>
     * The expanded SQL for the view. This SQL is used by engines while processing a query on a view. Engines may
     * perform operations during view creation to transform <code>ViewOriginalText</code> to
     * <code>ViewExpandedText</code>. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Fully qualified identifiers: <code>SELECT * from table1 -&gt; SELECT * from db1.table1</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The expanded SQL for the view. This SQL is used by engines while processing a query on a view. Engines
     *         may perform operations during view creation to transform <code>ViewOriginalText</code> to
     *         <code>ViewExpandedText</code>. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Fully qualified identifiers: <code>SELECT * from table1 -&gt; SELECT * from db1.table1</code>
     *         </p>
     *         </li>
     */
    public final String viewExpandedText() {
        return viewExpandedText;
    }

    /**
     * <p>
     * The name of the connection to be used to validate the specific representation of the view.
     * </p>
     * 
     * @return The name of the connection to be used to validate the specific representation of the view.
     */
    public final String validationConnection() {
        return validationConnection;
    }

    /**
     * <p>
     * Dialects marked as stale are no longer valid and must be updated before they can be queried in their respective
     * query engines.
     * </p>
     * 
     * @return Dialects marked as stale are no longer valid and must be updated before they can be queried in their
     *         respective query engines.
     */
    public final Boolean isStale() {
        return isStale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dialectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dialectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(viewOriginalText());
        hashCode = 31 * hashCode + Objects.hashCode(viewExpandedText());
        hashCode = 31 * hashCode + Objects.hashCode(validationConnection());
        hashCode = 31 * hashCode + Objects.hashCode(isStale());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewRepresentation)) {
            return false;
        }
        ViewRepresentation other = (ViewRepresentation) obj;
        return Objects.equals(dialectAsString(), other.dialectAsString())
                && Objects.equals(dialectVersion(), other.dialectVersion())
                && Objects.equals(viewOriginalText(), other.viewOriginalText())
                && Objects.equals(viewExpandedText(), other.viewExpandedText())
                && Objects.equals(validationConnection(), other.validationConnection())
                && Objects.equals(isStale(), other.isStale());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ViewRepresentation").add("Dialect", dialectAsString()).add("DialectVersion", dialectVersion())
                .add("ViewOriginalText", viewOriginalText()).add("ViewExpandedText", viewExpandedText())
                .add("ValidationConnection", validationConnection()).add("IsStale", isStale()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dialect":
            return Optional.ofNullable(clazz.cast(dialectAsString()));
        case "DialectVersion":
            return Optional.ofNullable(clazz.cast(dialectVersion()));
        case "ViewOriginalText":
            return Optional.ofNullable(clazz.cast(viewOriginalText()));
        case "ViewExpandedText":
            return Optional.ofNullable(clazz.cast(viewExpandedText()));
        case "ValidationConnection":
            return Optional.ofNullable(clazz.cast(validationConnection()));
        case "IsStale":
            return Optional.ofNullable(clazz.cast(isStale()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Dialect", DIALECT_FIELD);
        map.put("DialectVersion", DIALECT_VERSION_FIELD);
        map.put("ViewOriginalText", VIEW_ORIGINAL_TEXT_FIELD);
        map.put("ViewExpandedText", VIEW_EXPANDED_TEXT_FIELD);
        map.put("ValidationConnection", VALIDATION_CONNECTION_FIELD);
        map.put("IsStale", IS_STALE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViewRepresentation, T> g) {
        return obj -> g.apply((ViewRepresentation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViewRepresentation> {
        /**
         * <p>
         * The dialect of the query engine.
         * </p>
         * 
         * @param dialect
         *        The dialect of the query engine.
         * @see ViewDialect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewDialect
         */
        Builder dialect(String dialect);

        /**
         * <p>
         * The dialect of the query engine.
         * </p>
         * 
         * @param dialect
         *        The dialect of the query engine.
         * @see ViewDialect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewDialect
         */
        Builder dialect(ViewDialect dialect);

        /**
         * <p>
         * The version of the dialect of the query engine. For example, 3.0.0.
         * </p>
         * 
         * @param dialectVersion
         *        The version of the dialect of the query engine. For example, 3.0.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialectVersion(String dialectVersion);

        /**
         * <p>
         * The <code>SELECT</code> query provided by the customer during <code>CREATE VIEW DDL</code>. This SQL is not
         * used during a query on a view (<code>ViewExpandedText</code> is used instead). <code>ViewOriginalText</code>
         * is used for cases like <code>SHOW CREATE VIEW</code> where users want to see the original DDL command that
         * created the view.
         * </p>
         * 
         * @param viewOriginalText
         *        The <code>SELECT</code> query provided by the customer during <code>CREATE VIEW DDL</code>. This SQL
         *        is not used during a query on a view (<code>ViewExpandedText</code> is used instead).
         *        <code>ViewOriginalText</code> is used for cases like <code>SHOW CREATE VIEW</code> where users want to
         *        see the original DDL command that created the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewOriginalText(String viewOriginalText);

        /**
         * <p>
         * The expanded SQL for the view. This SQL is used by engines while processing a query on a view. Engines may
         * perform operations during view creation to transform <code>ViewOriginalText</code> to
         * <code>ViewExpandedText</code>. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Fully qualified identifiers: <code>SELECT * from table1 -&gt; SELECT * from db1.table1</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param viewExpandedText
         *        The expanded SQL for the view. This SQL is used by engines while processing a query on a view. Engines
         *        may perform operations during view creation to transform <code>ViewOriginalText</code> to
         *        <code>ViewExpandedText</code>. For example:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Fully qualified identifiers: <code>SELECT * from table1 -&gt; SELECT * from db1.table1</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewExpandedText(String viewExpandedText);

        /**
         * <p>
         * The name of the connection to be used to validate the specific representation of the view.
         * </p>
         * 
         * @param validationConnection
         *        The name of the connection to be used to validate the specific representation of the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationConnection(String validationConnection);

        /**
         * <p>
         * Dialects marked as stale are no longer valid and must be updated before they can be queried in their
         * respective query engines.
         * </p>
         * 
         * @param isStale
         *        Dialects marked as stale are no longer valid and must be updated before they can be queried in their
         *        respective query engines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isStale(Boolean isStale);
    }

    static final class BuilderImpl implements Builder {
        private String dialect;

        private String dialectVersion;

        private String viewOriginalText;

        private String viewExpandedText;

        private String validationConnection;

        private Boolean isStale;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewRepresentation model) {
            dialect(model.dialect);
            dialectVersion(model.dialectVersion);
            viewOriginalText(model.viewOriginalText);
            viewExpandedText(model.viewExpandedText);
            validationConnection(model.validationConnection);
            isStale(model.isStale);
        }

        public final String getDialect() {
            return dialect;
        }

        public final void setDialect(String dialect) {
            this.dialect = dialect;
        }

        @Override
        public final Builder dialect(String dialect) {
            this.dialect = dialect;
            return this;
        }

        @Override
        public final Builder dialect(ViewDialect dialect) {
            this.dialect(dialect == null ? null : dialect.toString());
            return this;
        }

        public final String getDialectVersion() {
            return dialectVersion;
        }

        public final void setDialectVersion(String dialectVersion) {
            this.dialectVersion = dialectVersion;
        }

        @Override
        public final Builder dialectVersion(String dialectVersion) {
            this.dialectVersion = dialectVersion;
            return this;
        }

        public final String getViewOriginalText() {
            return viewOriginalText;
        }

        public final void setViewOriginalText(String viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
        }

        @Override
        public final Builder viewOriginalText(String viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
            return this;
        }

        public final String getViewExpandedText() {
            return viewExpandedText;
        }

        public final void setViewExpandedText(String viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
        }

        @Override
        public final Builder viewExpandedText(String viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
            return this;
        }

        public final String getValidationConnection() {
            return validationConnection;
        }

        public final void setValidationConnection(String validationConnection) {
            this.validationConnection = validationConnection;
        }

        @Override
        public final Builder validationConnection(String validationConnection) {
            this.validationConnection = validationConnection;
            return this;
        }

        public final Boolean getIsStale() {
            return isStale;
        }

        public final void setIsStale(Boolean isStale) {
            this.isStale = isStale;
        }

        @Override
        public final Builder isStale(Boolean isStale) {
            this.isStale = isStale;
            return this;
        }

        @Override
        public ViewRepresentation build() {
            return new ViewRepresentation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
