/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration for Snowflake nodes in Glue Studio.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowflakeNodeData implements SdkPojo, Serializable,
        ToCopyableBuilder<SnowflakeNodeData.Builder, SnowflakeNodeData> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(SnowflakeNodeData::sourceType)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<Option> CONNECTION_FIELD = SdkField.<Option> builder(MarshallingType.SDK_POJO)
            .memberName("Connection").getter(getter(SnowflakeNodeData::connection)).setter(setter(Builder::connection))
            .constructor(Option::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connection").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Schema")
            .getter(getter(SnowflakeNodeData::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<String> TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Table")
            .getter(getter(SnowflakeNodeData::table)).setter(setter(Builder::table))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(SnowflakeNodeData::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> TEMP_DIR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TempDir").getter(getter(SnowflakeNodeData::tempDir)).setter(setter(Builder::tempDir))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TempDir").build()).build();

    private static final SdkField<Option> IAM_ROLE_FIELD = SdkField.<Option> builder(MarshallingType.SDK_POJO)
            .memberName("IamRole").getter(getter(SnowflakeNodeData::iamRole)).setter(setter(Builder::iamRole))
            .constructor(Option::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()).build();

    private static final SdkField<Map<String, String>> ADDITIONAL_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdditionalOptions")
            .getter(getter(SnowflakeNodeData::additionalOptions))
            .setter(setter(Builder::additionalOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SAMPLE_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SampleQuery").getter(getter(SnowflakeNodeData::sampleQuery)).setter(setter(Builder::sampleQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleQuery").build()).build();

    private static final SdkField<String> PRE_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreAction").getter(getter(SnowflakeNodeData::preAction)).setter(setter(Builder::preAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreAction").build()).build();

    private static final SdkField<String> POST_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostAction").getter(getter(SnowflakeNodeData::postAction)).setter(setter(Builder::postAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostAction").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(SnowflakeNodeData::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<Boolean> UPSERT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Upsert").getter(getter(SnowflakeNodeData::upsert)).setter(setter(Builder::upsert))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Upsert").build()).build();

    private static final SdkField<String> MERGE_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MergeAction").getter(getter(SnowflakeNodeData::mergeAction)).setter(setter(Builder::mergeAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeAction").build()).build();

    private static final SdkField<String> MERGE_WHEN_MATCHED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MergeWhenMatched").getter(getter(SnowflakeNodeData::mergeWhenMatched))
            .setter(setter(Builder::mergeWhenMatched))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeWhenMatched").build()).build();

    private static final SdkField<String> MERGE_WHEN_NOT_MATCHED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MergeWhenNotMatched").getter(getter(SnowflakeNodeData::mergeWhenNotMatched))
            .setter(setter(Builder::mergeWhenNotMatched))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeWhenNotMatched").build())
            .build();

    private static final SdkField<String> MERGE_CLAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MergeClause").getter(getter(SnowflakeNodeData::mergeClause)).setter(setter(Builder::mergeClause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeClause").build()).build();

    private static final SdkField<String> STAGING_TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StagingTable").getter(getter(SnowflakeNodeData::stagingTable)).setter(setter(Builder::stagingTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StagingTable").build()).build();

    private static final SdkField<List<Option>> SELECTED_COLUMNS_FIELD = SdkField
            .<List<Option>> builder(MarshallingType.LIST)
            .memberName("SelectedColumns")
            .getter(getter(SnowflakeNodeData::selectedColumns))
            .setter(setter(Builder::selectedColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Option> builder(MarshallingType.SDK_POJO)
                                            .constructor(Option::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> AUTO_PUSHDOWN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoPushdown").getter(getter(SnowflakeNodeData::autoPushdown)).setter(setter(Builder::autoPushdown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPushdown").build()).build();

    private static final SdkField<List<Option>> TABLE_SCHEMA_FIELD = SdkField
            .<List<Option>> builder(MarshallingType.LIST)
            .memberName("TableSchema")
            .getter(getter(SnowflakeNodeData::tableSchema))
            .setter(setter(Builder::tableSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableSchema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Option> builder(MarshallingType.SDK_POJO)
                                            .constructor(Option::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD,
            CONNECTION_FIELD, SCHEMA_FIELD, TABLE_FIELD, DATABASE_FIELD, TEMP_DIR_FIELD, IAM_ROLE_FIELD,
            ADDITIONAL_OPTIONS_FIELD, SAMPLE_QUERY_FIELD, PRE_ACTION_FIELD, POST_ACTION_FIELD, ACTION_FIELD, UPSERT_FIELD,
            MERGE_ACTION_FIELD, MERGE_WHEN_MATCHED_FIELD, MERGE_WHEN_NOT_MATCHED_FIELD, MERGE_CLAUSE_FIELD, STAGING_TABLE_FIELD,
            SELECTED_COLUMNS_FIELD, AUTO_PUSHDOWN_FIELD, TABLE_SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceType;

    private final Option connection;

    private final String schema;

    private final String table;

    private final String database;

    private final String tempDir;

    private final Option iamRole;

    private final Map<String, String> additionalOptions;

    private final String sampleQuery;

    private final String preAction;

    private final String postAction;

    private final String action;

    private final Boolean upsert;

    private final String mergeAction;

    private final String mergeWhenMatched;

    private final String mergeWhenNotMatched;

    private final String mergeClause;

    private final String stagingTable;

    private final List<Option> selectedColumns;

    private final Boolean autoPushdown;

    private final List<Option> tableSchema;

    private SnowflakeNodeData(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.connection = builder.connection;
        this.schema = builder.schema;
        this.table = builder.table;
        this.database = builder.database;
        this.tempDir = builder.tempDir;
        this.iamRole = builder.iamRole;
        this.additionalOptions = builder.additionalOptions;
        this.sampleQuery = builder.sampleQuery;
        this.preAction = builder.preAction;
        this.postAction = builder.postAction;
        this.action = builder.action;
        this.upsert = builder.upsert;
        this.mergeAction = builder.mergeAction;
        this.mergeWhenMatched = builder.mergeWhenMatched;
        this.mergeWhenNotMatched = builder.mergeWhenNotMatched;
        this.mergeClause = builder.mergeClause;
        this.stagingTable = builder.stagingTable;
        this.selectedColumns = builder.selectedColumns;
        this.autoPushdown = builder.autoPushdown;
        this.tableSchema = builder.tableSchema;
    }

    /**
     * <p>
     * Specifies how retrieved data is specified. Valid values: <code>"table"</code>, <code> "query"</code>.
     * </p>
     * 
     * @return Specifies how retrieved data is specified. Valid values: <code>"table"</code>, <code> "query"</code>.
     */
    public final String sourceType() {
        return sourceType;
    }

    /**
     * <p>
     * Specifies a Glue Data Catalog Connection to a Snowflake endpoint.
     * </p>
     * 
     * @return Specifies a Glue Data Catalog Connection to a Snowflake endpoint.
     */
    public final Option connection() {
        return connection;
    }

    /**
     * <p>
     * Specifies a Snowflake database schema for your node to use.
     * </p>
     * 
     * @return Specifies a Snowflake database schema for your node to use.
     */
    public final String schema() {
        return schema;
    }

    /**
     * <p>
     * Specifies a Snowflake table for your node to use.
     * </p>
     * 
     * @return Specifies a Snowflake table for your node to use.
     */
    public final String table() {
        return table;
    }

    /**
     * <p>
     * Specifies a Snowflake database for your node to use.
     * </p>
     * 
     * @return Specifies a Snowflake database for your node to use.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * Not currently used.
     * </p>
     * 
     * @return Not currently used.
     */
    public final String tempDir() {
        return tempDir;
    }

    /**
     * <p>
     * Not currently used.
     * </p>
     * 
     * @return Not currently used.
     */
    public final Option iamRole() {
        return iamRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalOptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalOptions() {
        return additionalOptions != null && !(additionalOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies additional options passed to the Snowflake connector. If options are specified elsewhere in this node,
     * this will take precedence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalOptions} method.
     * </p>
     * 
     * @return Specifies additional options passed to the Snowflake connector. If options are specified elsewhere in
     *         this node, this will take precedence.
     */
    public final Map<String, String> additionalOptions() {
        return additionalOptions;
    }

    /**
     * <p>
     * A SQL string used to retrieve data with the <code>query</code> sourcetype.
     * </p>
     * 
     * @return A SQL string used to retrieve data with the <code>query</code> sourcetype.
     */
    public final String sampleQuery() {
        return sampleQuery;
    }

    /**
     * <p>
     * A SQL string run before the Snowflake connector performs its standard actions.
     * </p>
     * 
     * @return A SQL string run before the Snowflake connector performs its standard actions.
     */
    public final String preAction() {
        return preAction;
    }

    /**
     * <p>
     * A SQL string run after the Snowflake connector performs its standard actions.
     * </p>
     * 
     * @return A SQL string run after the Snowflake connector performs its standard actions.
     */
    public final String postAction() {
        return postAction;
    }

    /**
     * <p>
     * Specifies what action to take when writing to a table with preexisting data. Valid values: <code> append</code>,
     * <code>merge</code>, <code>truncate</code>, <code>drop</code>.
     * </p>
     * 
     * @return Specifies what action to take when writing to a table with preexisting data. Valid values:
     *         <code> append</code>, <code>merge</code>, <code>truncate</code>, <code>drop</code>.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * Used when Action is <code>append</code>. Specifies the resolution behavior when a row already exists. If true,
     * preexisting rows will be updated. If false, those rows will be inserted.
     * </p>
     * 
     * @return Used when Action is <code>append</code>. Specifies the resolution behavior when a row already exists. If
     *         true, preexisting rows will be updated. If false, those rows will be inserted.
     */
    public final Boolean upsert() {
        return upsert;
    }

    /**
     * <p>
     * Specifies a merge action. Valid values: <code>simple</code>, <code>custom</code>. If simple, merge behavior is
     * defined by <code>MergeWhenMatched</code> and <code> MergeWhenNotMatched</code>. If custom, defined by
     * <code>MergeClause</code>.
     * </p>
     * 
     * @return Specifies a merge action. Valid values: <code>simple</code>, <code>custom</code>. If simple, merge
     *         behavior is defined by <code>MergeWhenMatched</code> and <code> MergeWhenNotMatched</code>. If custom,
     *         defined by <code>MergeClause</code>.
     */
    public final String mergeAction() {
        return mergeAction;
    }

    /**
     * <p>
     * Specifies how to resolve records that match preexisting data when merging. Valid values: <code> update</code>,
     * <code>delete</code>.
     * </p>
     * 
     * @return Specifies how to resolve records that match preexisting data when merging. Valid values:
     *         <code> update</code>, <code>delete</code>.
     */
    public final String mergeWhenMatched() {
        return mergeWhenMatched;
    }

    /**
     * <p>
     * Specifies how to process records that do not match preexisting data when merging. Valid values:
     * <code>insert</code>, <code>none</code>.
     * </p>
     * 
     * @return Specifies how to process records that do not match preexisting data when merging. Valid values:
     *         <code>insert</code>, <code>none</code>.
     */
    public final String mergeWhenNotMatched() {
        return mergeWhenNotMatched;
    }

    /**
     * <p>
     * A SQL statement that specifies a custom merge behavior.
     * </p>
     * 
     * @return A SQL statement that specifies a custom merge behavior.
     */
    public final String mergeClause() {
        return mergeClause;
    }

    /**
     * <p>
     * The name of a staging table used when performing <code>merge</code> or upsert <code>append</code> actions. Data
     * is written to this table, then moved to <code>table</code> by a generated postaction.
     * </p>
     * 
     * @return The name of a staging table used when performing <code>merge</code> or upsert <code>append</code>
     *         actions. Data is written to this table, then moved to <code>table</code> by a generated postaction.
     */
    public final String stagingTable() {
        return stagingTable;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedColumns() {
        return selectedColumns != null && !(selectedColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the columns combined to identify a record when detecting matches for merges and upserts. A list of
     * structures with <code>value</code>, <code>label</code> and <code> description</code> keys. Each structure
     * describes a column.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedColumns} method.
     * </p>
     * 
     * @return Specifies the columns combined to identify a record when detecting matches for merges and upserts. A list
     *         of structures with <code>value</code>, <code>label</code> and <code> description</code> keys. Each
     *         structure describes a column.
     */
    public final List<Option> selectedColumns() {
        return selectedColumns;
    }

    /**
     * <p>
     * Specifies whether automatic query pushdown is enabled. If pushdown is enabled, then when a query is run on Spark,
     * if part of the query can be "pushed down" to the Snowflake server, it is pushed down. This improves performance
     * of some queries.
     * </p>
     * 
     * @return Specifies whether automatic query pushdown is enabled. If pushdown is enabled, then when a query is run
     *         on Spark, if part of the query can be "pushed down" to the Snowflake server, it is pushed down. This
     *         improves performance of some queries.
     */
    public final Boolean autoPushdown() {
        return autoPushdown;
    }

    /**
     * For responses, this returns true if the service returned a value for the TableSchema property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTableSchema() {
        return tableSchema != null && !(tableSchema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Manually defines the target schema for the node. A list of structures with <code>value</code> ,
     * <code>label</code> and <code>description</code> keys. Each structure defines a column.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTableSchema} method.
     * </p>
     * 
     * @return Manually defines the target schema for the node. A list of structures with <code>value</code> ,
     *         <code>label</code> and <code>description</code> keys. Each structure defines a column.
     */
    public final List<Option> tableSchema() {
        return tableSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(connection());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(tempDir());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalOptions() ? additionalOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sampleQuery());
        hashCode = 31 * hashCode + Objects.hashCode(preAction());
        hashCode = 31 * hashCode + Objects.hashCode(postAction());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(upsert());
        hashCode = 31 * hashCode + Objects.hashCode(mergeAction());
        hashCode = 31 * hashCode + Objects.hashCode(mergeWhenMatched());
        hashCode = 31 * hashCode + Objects.hashCode(mergeWhenNotMatched());
        hashCode = 31 * hashCode + Objects.hashCode(mergeClause());
        hashCode = 31 * hashCode + Objects.hashCode(stagingTable());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedColumns() ? selectedColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoPushdown());
        hashCode = 31 * hashCode + Objects.hashCode(hasTableSchema() ? tableSchema() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeNodeData)) {
            return false;
        }
        SnowflakeNodeData other = (SnowflakeNodeData) obj;
        return Objects.equals(sourceType(), other.sourceType()) && Objects.equals(connection(), other.connection())
                && Objects.equals(schema(), other.schema()) && Objects.equals(table(), other.table())
                && Objects.equals(database(), other.database()) && Objects.equals(tempDir(), other.tempDir())
                && Objects.equals(iamRole(), other.iamRole()) && hasAdditionalOptions() == other.hasAdditionalOptions()
                && Objects.equals(additionalOptions(), other.additionalOptions())
                && Objects.equals(sampleQuery(), other.sampleQuery()) && Objects.equals(preAction(), other.preAction())
                && Objects.equals(postAction(), other.postAction()) && Objects.equals(action(), other.action())
                && Objects.equals(upsert(), other.upsert()) && Objects.equals(mergeAction(), other.mergeAction())
                && Objects.equals(mergeWhenMatched(), other.mergeWhenMatched())
                && Objects.equals(mergeWhenNotMatched(), other.mergeWhenNotMatched())
                && Objects.equals(mergeClause(), other.mergeClause()) && Objects.equals(stagingTable(), other.stagingTable())
                && hasSelectedColumns() == other.hasSelectedColumns()
                && Objects.equals(selectedColumns(), other.selectedColumns())
                && Objects.equals(autoPushdown(), other.autoPushdown()) && hasTableSchema() == other.hasTableSchema()
                && Objects.equals(tableSchema(), other.tableSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowflakeNodeData").add("SourceType", sourceType()).add("Connection", connection())
                .add("Schema", schema()).add("Table", table()).add("Database", database()).add("TempDir", tempDir())
                .add("IamRole", iamRole()).add("AdditionalOptions", hasAdditionalOptions() ? additionalOptions() : null)
                .add("SampleQuery", sampleQuery()).add("PreAction", preAction()).add("PostAction", postAction())
                .add("Action", action()).add("Upsert", upsert()).add("MergeAction", mergeAction())
                .add("MergeWhenMatched", mergeWhenMatched()).add("MergeWhenNotMatched", mergeWhenNotMatched())
                .add("MergeClause", mergeClause()).add("StagingTable", stagingTable())
                .add("SelectedColumns", hasSelectedColumns() ? selectedColumns() : null).add("AutoPushdown", autoPushdown())
                .add("TableSchema", hasTableSchema() ? tableSchema() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "Connection":
            return Optional.ofNullable(clazz.cast(connection()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "TempDir":
            return Optional.ofNullable(clazz.cast(tempDir()));
        case "IamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "AdditionalOptions":
            return Optional.ofNullable(clazz.cast(additionalOptions()));
        case "SampleQuery":
            return Optional.ofNullable(clazz.cast(sampleQuery()));
        case "PreAction":
            return Optional.ofNullable(clazz.cast(preAction()));
        case "PostAction":
            return Optional.ofNullable(clazz.cast(postAction()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Upsert":
            return Optional.ofNullable(clazz.cast(upsert()));
        case "MergeAction":
            return Optional.ofNullable(clazz.cast(mergeAction()));
        case "MergeWhenMatched":
            return Optional.ofNullable(clazz.cast(mergeWhenMatched()));
        case "MergeWhenNotMatched":
            return Optional.ofNullable(clazz.cast(mergeWhenNotMatched()));
        case "MergeClause":
            return Optional.ofNullable(clazz.cast(mergeClause()));
        case "StagingTable":
            return Optional.ofNullable(clazz.cast(stagingTable()));
        case "SelectedColumns":
            return Optional.ofNullable(clazz.cast(selectedColumns()));
        case "AutoPushdown":
            return Optional.ofNullable(clazz.cast(autoPushdown()));
        case "TableSchema":
            return Optional.ofNullable(clazz.cast(tableSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("Connection", CONNECTION_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        map.put("Table", TABLE_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("TempDir", TEMP_DIR_FIELD);
        map.put("IamRole", IAM_ROLE_FIELD);
        map.put("AdditionalOptions", ADDITIONAL_OPTIONS_FIELD);
        map.put("SampleQuery", SAMPLE_QUERY_FIELD);
        map.put("PreAction", PRE_ACTION_FIELD);
        map.put("PostAction", POST_ACTION_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("Upsert", UPSERT_FIELD);
        map.put("MergeAction", MERGE_ACTION_FIELD);
        map.put("MergeWhenMatched", MERGE_WHEN_MATCHED_FIELD);
        map.put("MergeWhenNotMatched", MERGE_WHEN_NOT_MATCHED_FIELD);
        map.put("MergeClause", MERGE_CLAUSE_FIELD);
        map.put("StagingTable", STAGING_TABLE_FIELD);
        map.put("SelectedColumns", SELECTED_COLUMNS_FIELD);
        map.put("AutoPushdown", AUTO_PUSHDOWN_FIELD);
        map.put("TableSchema", TABLE_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeNodeData, T> g) {
        return obj -> g.apply((SnowflakeNodeData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowflakeNodeData> {
        /**
         * <p>
         * Specifies how retrieved data is specified. Valid values: <code>"table"</code>, <code> "query"</code>.
         * </p>
         * 
         * @param sourceType
         *        Specifies how retrieved data is specified. Valid values: <code>"table"</code>, <code> "query"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * Specifies a Glue Data Catalog Connection to a Snowflake endpoint.
         * </p>
         * 
         * @param connection
         *        Specifies a Glue Data Catalog Connection to a Snowflake endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connection(Option connection);

        /**
         * <p>
         * Specifies a Glue Data Catalog Connection to a Snowflake endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link Option.Builder} avoiding the need to
         * create one manually via {@link Option#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Option.Builder#build()} is called immediately and its result is
         * passed to {@link #connection(Option)}.
         * 
         * @param connection
         *        a consumer that will call methods on {@link Option.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connection(Option)
         */
        default Builder connection(Consumer<Option.Builder> connection) {
            return connection(Option.builder().applyMutation(connection).build());
        }

        /**
         * <p>
         * Specifies a Snowflake database schema for your node to use.
         * </p>
         * 
         * @param schema
         *        Specifies a Snowflake database schema for your node to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * Specifies a Snowflake table for your node to use.
         * </p>
         * 
         * @param table
         *        Specifies a Snowflake table for your node to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(String table);

        /**
         * <p>
         * Specifies a Snowflake database for your node to use.
         * </p>
         * 
         * @param database
         *        Specifies a Snowflake database for your node to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * Not currently used.
         * </p>
         * 
         * @param tempDir
         *        Not currently used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tempDir(String tempDir);

        /**
         * <p>
         * Not currently used.
         * </p>
         * 
         * @param iamRole
         *        Not currently used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(Option iamRole);

        /**
         * <p>
         * Not currently used.
         * </p>
         * This is a convenience method that creates an instance of the {@link Option.Builder} avoiding the need to
         * create one manually via {@link Option#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Option.Builder#build()} is called immediately and its result is
         * passed to {@link #iamRole(Option)}.
         * 
         * @param iamRole
         *        a consumer that will call methods on {@link Option.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamRole(Option)
         */
        default Builder iamRole(Consumer<Option.Builder> iamRole) {
            return iamRole(Option.builder().applyMutation(iamRole).build());
        }

        /**
         * <p>
         * Specifies additional options passed to the Snowflake connector. If options are specified elsewhere in this
         * node, this will take precedence.
         * </p>
         * 
         * @param additionalOptions
         *        Specifies additional options passed to the Snowflake connector. If options are specified elsewhere in
         *        this node, this will take precedence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalOptions(Map<String, String> additionalOptions);

        /**
         * <p>
         * A SQL string used to retrieve data with the <code>query</code> sourcetype.
         * </p>
         * 
         * @param sampleQuery
         *        A SQL string used to retrieve data with the <code>query</code> sourcetype.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleQuery(String sampleQuery);

        /**
         * <p>
         * A SQL string run before the Snowflake connector performs its standard actions.
         * </p>
         * 
         * @param preAction
         *        A SQL string run before the Snowflake connector performs its standard actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preAction(String preAction);

        /**
         * <p>
         * A SQL string run after the Snowflake connector performs its standard actions.
         * </p>
         * 
         * @param postAction
         *        A SQL string run after the Snowflake connector performs its standard actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postAction(String postAction);

        /**
         * <p>
         * Specifies what action to take when writing to a table with preexisting data. Valid values:
         * <code> append</code>, <code>merge</code>, <code>truncate</code>, <code>drop</code>.
         * </p>
         * 
         * @param action
         *        Specifies what action to take when writing to a table with preexisting data. Valid values:
         *        <code> append</code>, <code>merge</code>, <code>truncate</code>, <code>drop</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * Used when Action is <code>append</code>. Specifies the resolution behavior when a row already exists. If
         * true, preexisting rows will be updated. If false, those rows will be inserted.
         * </p>
         * 
         * @param upsert
         *        Used when Action is <code>append</code>. Specifies the resolution behavior when a row already exists.
         *        If true, preexisting rows will be updated. If false, those rows will be inserted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upsert(Boolean upsert);

        /**
         * <p>
         * Specifies a merge action. Valid values: <code>simple</code>, <code>custom</code>. If simple, merge behavior
         * is defined by <code>MergeWhenMatched</code> and <code> MergeWhenNotMatched</code>. If custom, defined by
         * <code>MergeClause</code>.
         * </p>
         * 
         * @param mergeAction
         *        Specifies a merge action. Valid values: <code>simple</code>, <code>custom</code>. If simple, merge
         *        behavior is defined by <code>MergeWhenMatched</code> and <code> MergeWhenNotMatched</code>. If custom,
         *        defined by <code>MergeClause</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeAction(String mergeAction);

        /**
         * <p>
         * Specifies how to resolve records that match preexisting data when merging. Valid values: <code> update</code>, <code>delete</code>.
         * </p>
         * 
         * @param mergeWhenMatched
         *        Specifies how to resolve records that match preexisting data when merging. Valid values:
         *        <code> update</code>, <code>delete</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeWhenMatched(String mergeWhenMatched);

        /**
         * <p>
         * Specifies how to process records that do not match preexisting data when merging. Valid values:
         * <code>insert</code>, <code>none</code>.
         * </p>
         * 
         * @param mergeWhenNotMatched
         *        Specifies how to process records that do not match preexisting data when merging. Valid values:
         *        <code>insert</code>, <code>none</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeWhenNotMatched(String mergeWhenNotMatched);

        /**
         * <p>
         * A SQL statement that specifies a custom merge behavior.
         * </p>
         * 
         * @param mergeClause
         *        A SQL statement that specifies a custom merge behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeClause(String mergeClause);

        /**
         * <p>
         * The name of a staging table used when performing <code>merge</code> or upsert <code>append</code> actions.
         * Data is written to this table, then moved to <code>table</code> by a generated postaction.
         * </p>
         * 
         * @param stagingTable
         *        The name of a staging table used when performing <code>merge</code> or upsert <code>append</code>
         *        actions. Data is written to this table, then moved to <code>table</code> by a generated postaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingTable(String stagingTable);

        /**
         * <p>
         * Specifies the columns combined to identify a record when detecting matches for merges and upserts. A list of
         * structures with <code>value</code>, <code>label</code> and <code> description</code> keys. Each structure
         * describes a column.
         * </p>
         * 
         * @param selectedColumns
         *        Specifies the columns combined to identify a record when detecting matches for merges and upserts. A
         *        list of structures with <code>value</code>, <code>label</code> and <code> description</code> keys.
         *        Each structure describes a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedColumns(Collection<Option> selectedColumns);

        /**
         * <p>
         * Specifies the columns combined to identify a record when detecting matches for merges and upserts. A list of
         * structures with <code>value</code>, <code>label</code> and <code> description</code> keys. Each structure
         * describes a column.
         * </p>
         * 
         * @param selectedColumns
         *        Specifies the columns combined to identify a record when detecting matches for merges and upserts. A
         *        list of structures with <code>value</code>, <code>label</code> and <code> description</code> keys.
         *        Each structure describes a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedColumns(Option... selectedColumns);

        /**
         * <p>
         * Specifies the columns combined to identify a record when detecting matches for merges and upserts. A list of
         * structures with <code>value</code>, <code>label</code> and <code> description</code> keys. Each structure
         * describes a column.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.Option.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.glue.model.Option#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.Option.Builder#build()} is called immediately and its
         * result is passed to {@link #selectedColumns(List<Option>)}.
         * 
         * @param selectedColumns
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.glue.model.Option.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectedColumns(java.util.Collection<Option>)
         */
        Builder selectedColumns(Consumer<Option.Builder>... selectedColumns);

        /**
         * <p>
         * Specifies whether automatic query pushdown is enabled. If pushdown is enabled, then when a query is run on
         * Spark, if part of the query can be "pushed down" to the Snowflake server, it is pushed down. This improves
         * performance of some queries.
         * </p>
         * 
         * @param autoPushdown
         *        Specifies whether automatic query pushdown is enabled. If pushdown is enabled, then when a query is
         *        run on Spark, if part of the query can be "pushed down" to the Snowflake server, it is pushed down.
         *        This improves performance of some queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoPushdown(Boolean autoPushdown);

        /**
         * <p>
         * Manually defines the target schema for the node. A list of structures with <code>value</code> ,
         * <code>label</code> and <code>description</code> keys. Each structure defines a column.
         * </p>
         * 
         * @param tableSchema
         *        Manually defines the target schema for the node. A list of structures with <code>value</code> ,
         *        <code>label</code> and <code>description</code> keys. Each structure defines a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableSchema(Collection<Option> tableSchema);

        /**
         * <p>
         * Manually defines the target schema for the node. A list of structures with <code>value</code> ,
         * <code>label</code> and <code>description</code> keys. Each structure defines a column.
         * </p>
         * 
         * @param tableSchema
         *        Manually defines the target schema for the node. A list of structures with <code>value</code> ,
         *        <code>label</code> and <code>description</code> keys. Each structure defines a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableSchema(Option... tableSchema);

        /**
         * <p>
         * Manually defines the target schema for the node. A list of structures with <code>value</code> ,
         * <code>label</code> and <code>description</code> keys. Each structure defines a column.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.Option.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.glue.model.Option#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.Option.Builder#build()} is called immediately and its
         * result is passed to {@link #tableSchema(List<Option>)}.
         * 
         * @param tableSchema
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.glue.model.Option.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableSchema(java.util.Collection<Option>)
         */
        Builder tableSchema(Consumer<Option.Builder>... tableSchema);
    }

    static final class BuilderImpl implements Builder {
        private String sourceType;

        private Option connection;

        private String schema;

        private String table;

        private String database;

        private String tempDir;

        private Option iamRole;

        private Map<String, String> additionalOptions = DefaultSdkAutoConstructMap.getInstance();

        private String sampleQuery;

        private String preAction;

        private String postAction;

        private String action;

        private Boolean upsert;

        private String mergeAction;

        private String mergeWhenMatched;

        private String mergeWhenNotMatched;

        private String mergeClause;

        private String stagingTable;

        private List<Option> selectedColumns = DefaultSdkAutoConstructList.getInstance();

        private Boolean autoPushdown;

        private List<Option> tableSchema = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeNodeData model) {
            sourceType(model.sourceType);
            connection(model.connection);
            schema(model.schema);
            table(model.table);
            database(model.database);
            tempDir(model.tempDir);
            iamRole(model.iamRole);
            additionalOptions(model.additionalOptions);
            sampleQuery(model.sampleQuery);
            preAction(model.preAction);
            postAction(model.postAction);
            action(model.action);
            upsert(model.upsert);
            mergeAction(model.mergeAction);
            mergeWhenMatched(model.mergeWhenMatched);
            mergeWhenNotMatched(model.mergeWhenNotMatched);
            mergeClause(model.mergeClause);
            stagingTable(model.stagingTable);
            selectedColumns(model.selectedColumns);
            autoPushdown(model.autoPushdown);
            tableSchema(model.tableSchema);
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final Option.Builder getConnection() {
            return connection != null ? connection.toBuilder() : null;
        }

        public final void setConnection(Option.BuilderImpl connection) {
            this.connection = connection != null ? connection.build() : null;
        }

        @Override
        public final Builder connection(Option connection) {
            this.connection = connection;
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getTable() {
            return table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getTempDir() {
            return tempDir;
        }

        public final void setTempDir(String tempDir) {
            this.tempDir = tempDir;
        }

        @Override
        public final Builder tempDir(String tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public final Option.Builder getIamRole() {
            return iamRole != null ? iamRole.toBuilder() : null;
        }

        public final void setIamRole(Option.BuilderImpl iamRole) {
            this.iamRole = iamRole != null ? iamRole.build() : null;
        }

        @Override
        public final Builder iamRole(Option iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final Map<String, String> getAdditionalOptions() {
            if (additionalOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalOptions;
        }

        public final void setAdditionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = AdditionalOptionsCopier.copy(additionalOptions);
        }

        @Override
        public final Builder additionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = AdditionalOptionsCopier.copy(additionalOptions);
            return this;
        }

        public final String getSampleQuery() {
            return sampleQuery;
        }

        public final void setSampleQuery(String sampleQuery) {
            this.sampleQuery = sampleQuery;
        }

        @Override
        public final Builder sampleQuery(String sampleQuery) {
            this.sampleQuery = sampleQuery;
            return this;
        }

        public final String getPreAction() {
            return preAction;
        }

        public final void setPreAction(String preAction) {
            this.preAction = preAction;
        }

        @Override
        public final Builder preAction(String preAction) {
            this.preAction = preAction;
            return this;
        }

        public final String getPostAction() {
            return postAction;
        }

        public final void setPostAction(String postAction) {
            this.postAction = postAction;
        }

        @Override
        public final Builder postAction(String postAction) {
            this.postAction = postAction;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final Boolean getUpsert() {
            return upsert;
        }

        public final void setUpsert(Boolean upsert) {
            this.upsert = upsert;
        }

        @Override
        public final Builder upsert(Boolean upsert) {
            this.upsert = upsert;
            return this;
        }

        public final String getMergeAction() {
            return mergeAction;
        }

        public final void setMergeAction(String mergeAction) {
            this.mergeAction = mergeAction;
        }

        @Override
        public final Builder mergeAction(String mergeAction) {
            this.mergeAction = mergeAction;
            return this;
        }

        public final String getMergeWhenMatched() {
            return mergeWhenMatched;
        }

        public final void setMergeWhenMatched(String mergeWhenMatched) {
            this.mergeWhenMatched = mergeWhenMatched;
        }

        @Override
        public final Builder mergeWhenMatched(String mergeWhenMatched) {
            this.mergeWhenMatched = mergeWhenMatched;
            return this;
        }

        public final String getMergeWhenNotMatched() {
            return mergeWhenNotMatched;
        }

        public final void setMergeWhenNotMatched(String mergeWhenNotMatched) {
            this.mergeWhenNotMatched = mergeWhenNotMatched;
        }

        @Override
        public final Builder mergeWhenNotMatched(String mergeWhenNotMatched) {
            this.mergeWhenNotMatched = mergeWhenNotMatched;
            return this;
        }

        public final String getMergeClause() {
            return mergeClause;
        }

        public final void setMergeClause(String mergeClause) {
            this.mergeClause = mergeClause;
        }

        @Override
        public final Builder mergeClause(String mergeClause) {
            this.mergeClause = mergeClause;
            return this;
        }

        public final String getStagingTable() {
            return stagingTable;
        }

        public final void setStagingTable(String stagingTable) {
            this.stagingTable = stagingTable;
        }

        @Override
        public final Builder stagingTable(String stagingTable) {
            this.stagingTable = stagingTable;
            return this;
        }

        public final List<Option.Builder> getSelectedColumns() {
            List<Option.Builder> result = OptionListCopier.copyToBuilder(this.selectedColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectedColumns(Collection<Option.BuilderImpl> selectedColumns) {
            this.selectedColumns = OptionListCopier.copyFromBuilder(selectedColumns);
        }

        @Override
        public final Builder selectedColumns(Collection<Option> selectedColumns) {
            this.selectedColumns = OptionListCopier.copy(selectedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedColumns(Option... selectedColumns) {
            selectedColumns(Arrays.asList(selectedColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedColumns(Consumer<Option.Builder>... selectedColumns) {
            selectedColumns(Stream.of(selectedColumns).map(c -> Option.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAutoPushdown() {
            return autoPushdown;
        }

        public final void setAutoPushdown(Boolean autoPushdown) {
            this.autoPushdown = autoPushdown;
        }

        @Override
        public final Builder autoPushdown(Boolean autoPushdown) {
            this.autoPushdown = autoPushdown;
            return this;
        }

        public final List<Option.Builder> getTableSchema() {
            List<Option.Builder> result = OptionListCopier.copyToBuilder(this.tableSchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableSchema(Collection<Option.BuilderImpl> tableSchema) {
            this.tableSchema = OptionListCopier.copyFromBuilder(tableSchema);
        }

        @Override
        public final Builder tableSchema(Collection<Option> tableSchema) {
            this.tableSchema = OptionListCopier.copy(tableSchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableSchema(Option... tableSchema) {
            tableSchema(Arrays.asList(tableSchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableSchema(Consumer<Option.Builder>... tableSchema) {
            tableSchema(Stream.of(tableSchema).map(c -> Option.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SnowflakeNodeData build() {
            return new SnowflakeNodeData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
