/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunStatementRequest extends GlueRequest implements
        ToCopyableBuilder<RunStatementRequest.Builder, RunStatementRequest> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(RunStatementRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(RunStatementRequest::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> REQUEST_ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestOrigin").getter(getter(RunStatementRequest::requestOrigin))
            .setter(setter(Builder::requestOrigin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestOrigin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, CODE_FIELD,
            REQUEST_ORIGIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionId;

    private final String code;

    private final String requestOrigin;

    private RunStatementRequest(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.code = builder.code;
        this.requestOrigin = builder.requestOrigin;
    }

    /**
     * <p>
     * The Session Id of the statement to be run.
     * </p>
     * 
     * @return The Session Id of the statement to be run.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The statement code to be run.
     * </p>
     * 
     * @return The statement code to be run.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The origin of the request.
     * </p>
     * 
     * @return The origin of the request.
     */
    public final String requestOrigin() {
        return requestOrigin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(requestOrigin());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunStatementRequest)) {
            return false;
        }
        RunStatementRequest other = (RunStatementRequest) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(code(), other.code())
                && Objects.equals(requestOrigin(), other.requestOrigin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunStatementRequest").add("SessionId", sessionId()).add("Code", code())
                .add("RequestOrigin", requestOrigin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "RequestOrigin":
            return Optional.ofNullable(clazz.cast(requestOrigin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("Code", CODE_FIELD);
        map.put("RequestOrigin", REQUEST_ORIGIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RunStatementRequest, T> g) {
        return obj -> g.apply((RunStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, RunStatementRequest> {
        /**
         * <p>
         * The Session Id of the statement to be run.
         * </p>
         * 
         * @param sessionId
         *        The Session Id of the statement to be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The statement code to be run.
         * </p>
         * 
         * @param code
         *        The statement code to be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The origin of the request.
         * </p>
         * 
         * @param requestOrigin
         *        The origin of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestOrigin(String requestOrigin);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String sessionId;

        private String code;

        private String requestOrigin;

        private BuilderImpl() {
        }

        private BuilderImpl(RunStatementRequest model) {
            super(model);
            sessionId(model.sessionId);
            code(model.code);
            requestOrigin(model.requestOrigin);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getRequestOrigin() {
            return requestOrigin;
        }

        public final void setRequestOrigin(String requestOrigin) {
            this.requestOrigin = requestOrigin;
        }

        @Override
        public final Builder requestOrigin(String requestOrigin) {
            this.requestOrigin = requestOrigin;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RunStatementRequest build() {
            return new RunStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
