/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input properties to configure data lake access for your catalog resource in the Glue Data Catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeAccessProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeAccessProperties.Builder, DataLakeAccessProperties> {
    private static final SdkField<Boolean> DATA_LAKE_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DataLakeAccess").getter(getter(DataLakeAccessProperties::dataLakeAccess))
            .setter(setter(Builder::dataLakeAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeAccess").build()).build();

    private static final SdkField<String> DATA_TRANSFER_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTransferRole").getter(getter(DataLakeAccessProperties::dataTransferRole))
            .setter(setter(Builder::dataTransferRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferRole").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KmsKey")
            .getter(getter(DataLakeAccessProperties::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()).build();

    private static final SdkField<String> CATALOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogType").getter(getter(DataLakeAccessProperties::catalogType)).setter(setter(Builder::catalogType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LAKE_ACCESS_FIELD,
            DATA_TRANSFER_ROLE_FIELD, KMS_KEY_FIELD, CATALOG_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean dataLakeAccess;

    private final String dataTransferRole;

    private final String kmsKey;

    private final String catalogType;

    private DataLakeAccessProperties(BuilderImpl builder) {
        this.dataLakeAccess = builder.dataLakeAccess;
        this.dataTransferRole = builder.dataTransferRole;
        this.kmsKey = builder.kmsKey;
        this.catalogType = builder.catalogType;
    }

    /**
     * <p>
     * Turns on or off data lake access for Apache Spark applications that access Amazon Redshift databases in the Data
     * Catalog from any non-Redshift engine, such as Amazon Athena, Amazon EMR, or Glue ETL.
     * </p>
     * 
     * @return Turns on or off data lake access for Apache Spark applications that access Amazon Redshift databases in
     *         the Data Catalog from any non-Redshift engine, such as Amazon Athena, Amazon EMR, or Glue ETL.
     */
    public final Boolean dataLakeAccess() {
        return dataLakeAccess;
    }

    /**
     * <p>
     * A role that will be assumed by Glue for transferring data into/out of the staging bucket during a query.
     * </p>
     * 
     * @return A role that will be assumed by Glue for transferring data into/out of the staging bucket during a query.
     */
    public final String dataTransferRole() {
        return dataTransferRole;
    }

    /**
     * <p>
     * An encryption key that will be used for the staging bucket that will be created along with the catalog.
     * </p>
     * 
     * @return An encryption key that will be used for the staging bucket that will be created along with the catalog.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * Specifies a federated catalog type for the native catalog resource. The currently supported type is
     * <code>aws:redshift</code>.
     * </p>
     * 
     * @return Specifies a federated catalog type for the native catalog resource. The currently supported type is
     *         <code>aws:redshift</code>.
     */
    public final String catalogType() {
        return catalogType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataLakeAccess());
        hashCode = 31 * hashCode + Objects.hashCode(dataTransferRole());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(catalogType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeAccessProperties)) {
            return false;
        }
        DataLakeAccessProperties other = (DataLakeAccessProperties) obj;
        return Objects.equals(dataLakeAccess(), other.dataLakeAccess())
                && Objects.equals(dataTransferRole(), other.dataTransferRole()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(catalogType(), other.catalogType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeAccessProperties").add("DataLakeAccess", dataLakeAccess())
                .add("DataTransferRole", dataTransferRole()).add("KmsKey", kmsKey()).add("CatalogType", catalogType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataLakeAccess":
            return Optional.ofNullable(clazz.cast(dataLakeAccess()));
        case "DataTransferRole":
            return Optional.ofNullable(clazz.cast(dataTransferRole()));
        case "KmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "CatalogType":
            return Optional.ofNullable(clazz.cast(catalogType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataLakeAccess", DATA_LAKE_ACCESS_FIELD);
        map.put("DataTransferRole", DATA_TRANSFER_ROLE_FIELD);
        map.put("KmsKey", KMS_KEY_FIELD);
        map.put("CatalogType", CATALOG_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeAccessProperties, T> g) {
        return obj -> g.apply((DataLakeAccessProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeAccessProperties> {
        /**
         * <p>
         * Turns on or off data lake access for Apache Spark applications that access Amazon Redshift databases in the
         * Data Catalog from any non-Redshift engine, such as Amazon Athena, Amazon EMR, or Glue ETL.
         * </p>
         * 
         * @param dataLakeAccess
         *        Turns on or off data lake access for Apache Spark applications that access Amazon Redshift databases
         *        in the Data Catalog from any non-Redshift engine, such as Amazon Athena, Amazon EMR, or Glue ETL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLakeAccess(Boolean dataLakeAccess);

        /**
         * <p>
         * A role that will be assumed by Glue for transferring data into/out of the staging bucket during a query.
         * </p>
         * 
         * @param dataTransferRole
         *        A role that will be assumed by Glue for transferring data into/out of the staging bucket during a
         *        query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferRole(String dataTransferRole);

        /**
         * <p>
         * An encryption key that will be used for the staging bucket that will be created along with the catalog.
         * </p>
         * 
         * @param kmsKey
         *        An encryption key that will be used for the staging bucket that will be created along with the
         *        catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * Specifies a federated catalog type for the native catalog resource. The currently supported type is
         * <code>aws:redshift</code>.
         * </p>
         * 
         * @param catalogType
         *        Specifies a federated catalog type for the native catalog resource. The currently supported type is
         *        <code>aws:redshift</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogType(String catalogType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean dataLakeAccess;

        private String dataTransferRole;

        private String kmsKey;

        private String catalogType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeAccessProperties model) {
            dataLakeAccess(model.dataLakeAccess);
            dataTransferRole(model.dataTransferRole);
            kmsKey(model.kmsKey);
            catalogType(model.catalogType);
        }

        public final Boolean getDataLakeAccess() {
            return dataLakeAccess;
        }

        public final void setDataLakeAccess(Boolean dataLakeAccess) {
            this.dataLakeAccess = dataLakeAccess;
        }

        @Override
        public final Builder dataLakeAccess(Boolean dataLakeAccess) {
            this.dataLakeAccess = dataLakeAccess;
            return this;
        }

        public final String getDataTransferRole() {
            return dataTransferRole;
        }

        public final void setDataTransferRole(String dataTransferRole) {
            this.dataTransferRole = dataTransferRole;
        }

        @Override
        public final Builder dataTransferRole(String dataTransferRole) {
            this.dataTransferRole = dataTransferRole;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getCatalogType() {
            return catalogType;
        }

        public final void setCatalogType(String catalogType) {
            this.catalogType = catalogType;
        }

        @Override
        public final Builder catalogType(String catalogType) {
            this.catalogType = catalogType;
            return this;
        }

        @Override
        public DataLakeAccessProperties build() {
            return new DataLakeAccessProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
