/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a connection to a data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Connection implements SdkPojo, Serializable, ToCopyableBuilder<Connection.Builder, Connection> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Connection::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Connection::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionType").getter(getter(Connection::connectionTypeAsString))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()).build();

    private static final SdkField<List<String>> MATCH_CRITERIA_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchCriteria")
            .getter(getter(Connection::matchCriteria))
            .setter(setter(Builder::matchCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchCriteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> CONNECTION_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ConnectionProperties")
            .getter(getter(Connection::connectionPropertiesAsStrings))
            .setter(setter(Builder::connectionPropertiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SPARK_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("SparkProperties")
            .getter(getter(Connection::sparkProperties))
            .setter(setter(Builder::sparkProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SparkProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ATHENA_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AthenaProperties")
            .getter(getter(Connection::athenaProperties))
            .setter(setter(Builder::athenaProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> PYTHON_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("PythonProperties")
            .getter(getter(Connection::pythonProperties))
            .setter(setter(Builder::pythonProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PythonProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<PhysicalConnectionRequirements> PHYSICAL_CONNECTION_REQUIREMENTS_FIELD = SdkField
            .<PhysicalConnectionRequirements> builder(MarshallingType.SDK_POJO)
            .memberName("PhysicalConnectionRequirements")
            .getter(getter(Connection::physicalConnectionRequirements))
            .setter(setter(Builder::physicalConnectionRequirements))
            .constructor(PhysicalConnectionRequirements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalConnectionRequirements")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Connection::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(Connection::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedBy").getter(getter(Connection::lastUpdatedBy)).setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBy").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Connection::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(Connection::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> LAST_CONNECTION_VALIDATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastConnectionValidationTime")
            .getter(getter(Connection::lastConnectionValidationTime))
            .setter(setter(Builder::lastConnectionValidationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastConnectionValidationTime")
                    .build()).build();

    private static final SdkField<AuthenticationConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField
            .<AuthenticationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("AuthenticationConfiguration")
            .getter(getter(Connection::authenticationConfiguration))
            .setter(setter(Builder::authenticationConfiguration))
            .constructor(AuthenticationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfiguration")
                    .build()).build();

    private static final SdkField<Integer> CONNECTION_SCHEMA_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConnectionSchemaVersion").getter(getter(Connection::connectionSchemaVersion))
            .setter(setter(Builder::connectionSchemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionSchemaVersion").build())
            .build();

    private static final SdkField<List<String>> COMPATIBLE_COMPUTE_ENVIRONMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CompatibleComputeEnvironments")
            .getter(getter(Connection::compatibleComputeEnvironmentsAsStrings))
            .setter(setter(Builder::compatibleComputeEnvironmentsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleComputeEnvironments")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CONNECTION_TYPE_FIELD, MATCH_CRITERIA_FIELD, CONNECTION_PROPERTIES_FIELD, SPARK_PROPERTIES_FIELD,
            ATHENA_PROPERTIES_FIELD, PYTHON_PROPERTIES_FIELD, PHYSICAL_CONNECTION_REQUIREMENTS_FIELD, CREATION_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD, LAST_UPDATED_BY_FIELD, STATUS_FIELD, STATUS_REASON_FIELD,
            LAST_CONNECTION_VALIDATION_TIME_FIELD, AUTHENTICATION_CONFIGURATION_FIELD, CONNECTION_SCHEMA_VERSION_FIELD,
            COMPATIBLE_COMPUTE_ENVIRONMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String connectionType;

    private final List<String> matchCriteria;

    private final Map<String, String> connectionProperties;

    private final Map<String, String> sparkProperties;

    private final Map<String, String> athenaProperties;

    private final Map<String, String> pythonProperties;

    private final PhysicalConnectionRequirements physicalConnectionRequirements;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private final String lastUpdatedBy;

    private final String status;

    private final String statusReason;

    private final Instant lastConnectionValidationTime;

    private final AuthenticationConfiguration authenticationConfiguration;

    private final Integer connectionSchemaVersion;

    private final List<String> compatibleComputeEnvironments;

    private Connection(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.connectionType = builder.connectionType;
        this.matchCriteria = builder.matchCriteria;
        this.connectionProperties = builder.connectionProperties;
        this.sparkProperties = builder.sparkProperties;
        this.athenaProperties = builder.athenaProperties;
        this.pythonProperties = builder.pythonProperties;
        this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.lastConnectionValidationTime = builder.lastConnectionValidationTime;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.connectionSchemaVersion = builder.connectionSchemaVersion;
        this.compatibleComputeEnvironments = builder.compatibleComputeEnvironments;
    }

    /**
     * <p>
     * The name of the connection definition.
     * </p>
     * 
     * @return The name of the connection definition.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the connection.
     * </p>
     * 
     * @return The description of the connection.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of the connection. Currently, SFTP is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of the connection. Currently, SFTP is not supported.
     * @see ConnectionType
     */
    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The type of the connection. Currently, SFTP is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of the connection. Currently, SFTP is not supported.
     * @see ConnectionType
     */
    public final String connectionTypeAsString() {
        return connectionType;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchCriteria property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchCriteria() {
        return matchCriteria != null && !(matchCriteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of criteria that can be used in selecting this connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchCriteria} method.
     * </p>
     * 
     * @return A list of criteria that can be used in selecting this connection.
     */
    public final List<String> matchCriteria() {
        return matchCriteria;
    }

    /**
     * <p>
     * These key-value pairs define parameters for the connection when using the version 1 Connection schema:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HOST</code> - The host URI: either the fully qualified domain name (FQDN) or the IPv4 address of the
     * database host.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PORT</code> - The port number, between 1024 and 65535, of the port on which the database host is listening
     * for database connections.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>USER_NAME</code> - The name under which to log in to the database. The value string for
     * <code>USER_NAME</code> is "<code>USERNAME</code>".
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PASSWORD</code> - A password, if one is used, for the user name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENCRYPTED_PASSWORD</code> - When you enable connection password protection by setting
     * <code>ConnectionPasswordEncryption</code> in the Data Catalog encryption settings, this field stores the
     * encrypted password.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JDBC_DRIVER_JAR_URI</code> - The Amazon Simple Storage Service (Amazon S3) path of the JAR file that
     * contains the JDBC driver to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JDBC_DRIVER_CLASS_NAME</code> - The class name of the JDBC driver to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JDBC_ENGINE</code> - The name of the JDBC engine to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JDBC_ENGINE_VERSION</code> - The version of the JDBC engine to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONFIG_FILES</code> - (Reserved for future use.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE_ID</code> - The instance ID to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JDBC_CONNECTION_URL</code> - The URL for connecting to a JDBC data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JDBC_ENFORCE_SSL</code> - A Boolean string (true, false) specifying whether Secure Sockets Layer (SSL) with
     * hostname matching is enforced for the JDBC connection on the client. The default is false.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM_JDBC_CERT</code> - An Amazon S3 location specifying the customer's root certificate. Glue uses this
     * root certificate to validate the customer’s certificate when connecting to the customer database. Glue only
     * handles X.509 certificates. The certificate provided must be DER-encoded and supplied in Base64 encoding PEM
     * format.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code> - By default, this is <code>false</code>. Glue validates the
     * Signature algorithm and Subject Public Key Algorithm for the customer certificate. The only permitted algorithms
     * for the Signature algorithm are SHA256withRSA, SHA384withRSA or SHA512withRSA. For the Subject Public Key
     * Algorithm, the key length must be at least 2048. You can set the value of this property to <code>true</code> to
     * skip Glue’s validation of the customer certificate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM_JDBC_CERT_STRING</code> - A custom JDBC certificate string which is used for domain match or
     * distinguished name match to prevent a man-in-the-middle attack. In Oracle database, this is used as the
     * <code>SSL_SERVER_CERT_DN</code>; in Microsoft SQL Server, this is used as the <code>hostNameInCertificate</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONNECTION_URL</code> - The URL for connecting to a general (non-JDBC) data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SECRET_ID</code> - The secret ID used for the secret manager of credentials.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONNECTOR_URL</code> - The connector URL for a MARKETPLACE or CUSTOM connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONNECTOR_TYPE</code> - The connector type for a MARKETPLACE or CUSTOM connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONNECTOR_CLASS_NAME</code> - The connector class name for a MARKETPLACE or CUSTOM connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_BOOTSTRAP_SERVERS</code> - A comma-separated list of host and port pairs that are the addresses of
     * the Apache Kafka brokers in a Kafka cluster to which a Kafka client will connect to and bootstrap itself.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SSL_ENABLED</code> - Whether to enable or disable SSL on an Apache Kafka connection. Default value is
     * "true".
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_CUSTOM_CERT</code> - The Amazon S3 URL for the private CA cert file (.pem format). The default is an
     * empty string.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code> - Whether to skip the validation of the CA cert file or not. Glue
     * validates for three algorithms: SHA256withRSA, SHA384withRSA and SHA512withRSA. Default value is "false".
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_CLIENT_KEYSTORE</code> - The Amazon S3 location of the client keystore file for Kafka client side
     * authentication (Optional).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The password to access the provided keystore (Optional).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_CLIENT_KEY_PASSWORD</code> - A keystore can consist of multiple keys, so this is the password to
     * access the client key to be used with the Kafka server side key (Optional).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The encrypted version of the Kafka client keystore
     * password (if the user has the Glue encrypt passwords setting selected).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code> - The encrypted version of the Kafka client key password (if the
     * user has the Glue encrypt passwords setting selected).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_MECHANISM</code> - <code>"SCRAM-SHA-512"</code>, <code>"GSSAPI"</code>,
     * <code>"AWS_MSK_IAM"</code>, or <code>"PLAIN"</code>. These are the supported <a
     * href="https://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml">SASL Mechanisms</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_PLAIN_USERNAME</code> - A plaintext username used to authenticate with the "PLAIN" mechanism.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_PLAIN_PASSWORD</code> - A plaintext password used to authenticate with the "PLAIN" mechanism.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENCRYPTED_KAFKA_SASL_PLAIN_PASSWORD</code> - The encrypted version of the Kafka SASL PLAIN password (if the
     * user has the Glue encrypt passwords setting selected).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_SCRAM_USERNAME</code> - A plaintext username used to authenticate with the "SCRAM-SHA-512"
     * mechanism.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_SCRAM_PASSWORD</code> - A plaintext password used to authenticate with the "SCRAM-SHA-512"
     * mechanism.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code> - The encrypted version of the Kafka SASL SCRAM password (if the
     * user has the Glue encrypt passwords setting selected).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_SCRAM_SECRETS_ARN</code> - The Amazon Resource Name of a secret in Amazon Web Services Secrets
     * Manager.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_GSSAPI_KEYTAB</code> - The S3 location of a Kerberos <code>keytab</code> file. A keytab stores
     * long-term keys for one or more principals. For more information, see <a
     * href="https://web.mit.edu/kerberos/krb5-latest/doc/basic/keytab_def.html">MIT Kerberos Documentation: Keytab</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code> - The S3 location of a Kerberos <code>krb5.conf</code> file. A krb5.conf
     * stores Kerberos configuration information, such as the location of the KDC server. For more information, see <a
     * href="https://web.mit.edu/kerberos/krb5-1.12/doc/admin/conf_files/krb5_conf.html">MIT Kerberos Documentation:
     * krb5.conf</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_GSSAPI_SERVICE</code> - The Kerberos service name, as set with
     * <code>sasl.kerberos.service.name</code> in your <a
     * href="https://kafka.apache.org/documentation/#brokerconfigs_sasl.kerberos.service.name">Kafka Configuration</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code> - The name of the Kerberos princial used by Glue. For more information,
     * see <a href="https://kafka.apache.org/documentation/#security_sasl_kerberos_clientconfig">Kafka Documentation:
     * Configuring Kafka Brokers</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROLE_ARN</code> - The role to be used for running queries.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION</code> - The Amazon Web Services Region where queries will be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WORKGROUP_NAME</code> - The name of an Amazon Redshift serverless workgroup or Amazon Athena workgroup in
     * which queries will run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CLUSTER_IDENTIFIER</code> - The cluster identifier of an Amazon Redshift cluster in which queries will run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DATABASE</code> - The Amazon Redshift database that you are connecting to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionProperties} method.
     * </p>
     * 
     * @return These key-value pairs define parameters for the connection when using the version 1 Connection
     *         schema:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HOST</code> - The host URI: either the fully qualified domain name (FQDN) or the IPv4 address of
     *         the database host.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PORT</code> - The port number, between 1024 and 65535, of the port on which the database host is
     *         listening for database connections.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>USER_NAME</code> - The name under which to log in to the database. The value string for
     *         <code>USER_NAME</code> is "<code>USERNAME</code>".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PASSWORD</code> - A password, if one is used, for the user name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENCRYPTED_PASSWORD</code> - When you enable connection password protection by setting
     *         <code>ConnectionPasswordEncryption</code> in the Data Catalog encryption settings, this field stores the
     *         encrypted password.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JDBC_DRIVER_JAR_URI</code> - The Amazon Simple Storage Service (Amazon S3) path of the JAR file
     *         that contains the JDBC driver to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JDBC_DRIVER_CLASS_NAME</code> - The class name of the JDBC driver to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JDBC_ENGINE</code> - The name of the JDBC engine to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JDBC_ENGINE_VERSION</code> - The version of the JDBC engine to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONFIG_FILES</code> - (Reserved for future use.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTANCE_ID</code> - The instance ID to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JDBC_CONNECTION_URL</code> - The URL for connecting to a JDBC data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JDBC_ENFORCE_SSL</code> - A Boolean string (true, false) specifying whether Secure Sockets Layer
     *         (SSL) with hostname matching is enforced for the JDBC connection on the client. The default is false.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM_JDBC_CERT</code> - An Amazon S3 location specifying the customer's root certificate. Glue
     *         uses this root certificate to validate the customer’s certificate when connecting to the customer
     *         database. Glue only handles X.509 certificates. The certificate provided must be DER-encoded and supplied
     *         in Base64 encoding PEM format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code> - By default, this is <code>false</code>. Glue validates
     *         the Signature algorithm and Subject Public Key Algorithm for the customer certificate. The only permitted
     *         algorithms for the Signature algorithm are SHA256withRSA, SHA384withRSA or SHA512withRSA. For the Subject
     *         Public Key Algorithm, the key length must be at least 2048. You can set the value of this property to
     *         <code>true</code> to skip Glue’s validation of the customer certificate.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM_JDBC_CERT_STRING</code> - A custom JDBC certificate string which is used for domain match or
     *         distinguished name match to prevent a man-in-the-middle attack. In Oracle database, this is used as the
     *         <code>SSL_SERVER_CERT_DN</code>; in Microsoft SQL Server, this is used as the
     *         <code>hostNameInCertificate</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONNECTION_URL</code> - The URL for connecting to a general (non-JDBC) data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SECRET_ID</code> - The secret ID used for the secret manager of credentials.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONNECTOR_URL</code> - The connector URL for a MARKETPLACE or CUSTOM connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONNECTOR_TYPE</code> - The connector type for a MARKETPLACE or CUSTOM connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONNECTOR_CLASS_NAME</code> - The connector class name for a MARKETPLACE or CUSTOM connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_BOOTSTRAP_SERVERS</code> - A comma-separated list of host and port pairs that are the
     *         addresses of the Apache Kafka brokers in a Kafka cluster to which a Kafka client will connect to and
     *         bootstrap itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SSL_ENABLED</code> - Whether to enable or disable SSL on an Apache Kafka connection. Default
     *         value is "true".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_CUSTOM_CERT</code> - The Amazon S3 URL for the private CA cert file (.pem format). The
     *         default is an empty string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code> - Whether to skip the validation of the CA cert file or
     *         not. Glue validates for three algorithms: SHA256withRSA, SHA384withRSA and SHA512withRSA. Default value
     *         is "false".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_CLIENT_KEYSTORE</code> - The Amazon S3 location of the client keystore file for Kafka client
     *         side authentication (Optional).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The password to access the provided keystore (Optional).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_CLIENT_KEY_PASSWORD</code> - A keystore can consist of multiple keys, so this is the password
     *         to access the client key to be used with the Kafka server side key (Optional).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The encrypted version of the Kafka client
     *         keystore password (if the user has the Glue encrypt passwords setting selected).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code> - The encrypted version of the Kafka client key password
     *         (if the user has the Glue encrypt passwords setting selected).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_MECHANISM</code> - <code>"SCRAM-SHA-512"</code>, <code>"GSSAPI"</code>,
     *         <code>"AWS_MSK_IAM"</code>, or <code>"PLAIN"</code>. These are the supported <a
     *         href="https://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml">SASL Mechanisms</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_PLAIN_USERNAME</code> - A plaintext username used to authenticate with the "PLAIN"
     *         mechanism.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_PLAIN_PASSWORD</code> - A plaintext password used to authenticate with the "PLAIN"
     *         mechanism.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENCRYPTED_KAFKA_SASL_PLAIN_PASSWORD</code> - The encrypted version of the Kafka SASL PLAIN password
     *         (if the user has the Glue encrypt passwords setting selected).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_SCRAM_USERNAME</code> - A plaintext username used to authenticate with the
     *         "SCRAM-SHA-512" mechanism.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_SCRAM_PASSWORD</code> - A plaintext password used to authenticate with the
     *         "SCRAM-SHA-512" mechanism.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code> - The encrypted version of the Kafka SASL SCRAM password
     *         (if the user has the Glue encrypt passwords setting selected).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_SCRAM_SECRETS_ARN</code> - The Amazon Resource Name of a secret in Amazon Web Services
     *         Secrets Manager.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_GSSAPI_KEYTAB</code> - The S3 location of a Kerberos <code>keytab</code> file. A keytab
     *         stores long-term keys for one or more principals. For more information, see <a
     *         href="https://web.mit.edu/kerberos/krb5-latest/doc/basic/keytab_def.html">MIT Kerberos Documentation:
     *         Keytab</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code> - The S3 location of a Kerberos <code>krb5.conf</code> file. A
     *         krb5.conf stores Kerberos configuration information, such as the location of the KDC server. For more
     *         information, see <a href="https://web.mit.edu/kerberos/krb5-1.12/doc/admin/conf_files/krb5_conf.html">MIT
     *         Kerberos Documentation: krb5.conf</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_GSSAPI_SERVICE</code> - The Kerberos service name, as set with
     *         <code>sasl.kerberos.service.name</code> in your <a
     *         href="https://kafka.apache.org/documentation/#brokerconfigs_sasl.kerberos.service.name">Kafka
     *         Configuration</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code> - The name of the Kerberos princial used by Glue. For more
     *         information, see <a
     *         href="https://kafka.apache.org/documentation/#security_sasl_kerberos_clientconfig">Kafka Documentation:
     *         Configuring Kafka Brokers</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROLE_ARN</code> - The role to be used for running queries.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGION</code> - The Amazon Web Services Region where queries will be run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WORKGROUP_NAME</code> - The name of an Amazon Redshift serverless workgroup or Amazon Athena
     *         workgroup in which queries will run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CLUSTER_IDENTIFIER</code> - The cluster identifier of an Amazon Redshift cluster in which queries
     *         will run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DATABASE</code> - The Amazon Redshift database that you are connecting to.
     *         </p>
     *         </li>
     */
    public final Map<ConnectionPropertyKey, String> connectionProperties() {
        return ConnectionPropertiesCopier.copyStringToEnum(connectionProperties);
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectionProperties() {
        return connectionProperties != null && !(connectionProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * These key-value pairs define parameters for the connection when using the version 1 Connection schema:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HOST</code> - The host URI: either the fully qualified domain name (FQDN) or the IPv4 address of the
     * database host.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PORT</code> - The port number, between 1024 and 65535, of the port on which the database host is listening
     * for database connections.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>USER_NAME</code> - The name under which to log in to the database. The value string for
     * <code>USER_NAME</code> is "<code>USERNAME</code>".
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PASSWORD</code> - A password, if one is used, for the user name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENCRYPTED_PASSWORD</code> - When you enable connection password protection by setting
     * <code>ConnectionPasswordEncryption</code> in the Data Catalog encryption settings, this field stores the
     * encrypted password.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JDBC_DRIVER_JAR_URI</code> - The Amazon Simple Storage Service (Amazon S3) path of the JAR file that
     * contains the JDBC driver to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JDBC_DRIVER_CLASS_NAME</code> - The class name of the JDBC driver to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JDBC_ENGINE</code> - The name of the JDBC engine to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JDBC_ENGINE_VERSION</code> - The version of the JDBC engine to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONFIG_FILES</code> - (Reserved for future use.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE_ID</code> - The instance ID to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JDBC_CONNECTION_URL</code> - The URL for connecting to a JDBC data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JDBC_ENFORCE_SSL</code> - A Boolean string (true, false) specifying whether Secure Sockets Layer (SSL) with
     * hostname matching is enforced for the JDBC connection on the client. The default is false.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM_JDBC_CERT</code> - An Amazon S3 location specifying the customer's root certificate. Glue uses this
     * root certificate to validate the customer’s certificate when connecting to the customer database. Glue only
     * handles X.509 certificates. The certificate provided must be DER-encoded and supplied in Base64 encoding PEM
     * format.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code> - By default, this is <code>false</code>. Glue validates the
     * Signature algorithm and Subject Public Key Algorithm for the customer certificate. The only permitted algorithms
     * for the Signature algorithm are SHA256withRSA, SHA384withRSA or SHA512withRSA. For the Subject Public Key
     * Algorithm, the key length must be at least 2048. You can set the value of this property to <code>true</code> to
     * skip Glue’s validation of the customer certificate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM_JDBC_CERT_STRING</code> - A custom JDBC certificate string which is used for domain match or
     * distinguished name match to prevent a man-in-the-middle attack. In Oracle database, this is used as the
     * <code>SSL_SERVER_CERT_DN</code>; in Microsoft SQL Server, this is used as the <code>hostNameInCertificate</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONNECTION_URL</code> - The URL for connecting to a general (non-JDBC) data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SECRET_ID</code> - The secret ID used for the secret manager of credentials.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONNECTOR_URL</code> - The connector URL for a MARKETPLACE or CUSTOM connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONNECTOR_TYPE</code> - The connector type for a MARKETPLACE or CUSTOM connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONNECTOR_CLASS_NAME</code> - The connector class name for a MARKETPLACE or CUSTOM connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_BOOTSTRAP_SERVERS</code> - A comma-separated list of host and port pairs that are the addresses of
     * the Apache Kafka brokers in a Kafka cluster to which a Kafka client will connect to and bootstrap itself.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SSL_ENABLED</code> - Whether to enable or disable SSL on an Apache Kafka connection. Default value is
     * "true".
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_CUSTOM_CERT</code> - The Amazon S3 URL for the private CA cert file (.pem format). The default is an
     * empty string.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code> - Whether to skip the validation of the CA cert file or not. Glue
     * validates for three algorithms: SHA256withRSA, SHA384withRSA and SHA512withRSA. Default value is "false".
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_CLIENT_KEYSTORE</code> - The Amazon S3 location of the client keystore file for Kafka client side
     * authentication (Optional).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The password to access the provided keystore (Optional).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_CLIENT_KEY_PASSWORD</code> - A keystore can consist of multiple keys, so this is the password to
     * access the client key to be used with the Kafka server side key (Optional).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The encrypted version of the Kafka client keystore
     * password (if the user has the Glue encrypt passwords setting selected).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code> - The encrypted version of the Kafka client key password (if the
     * user has the Glue encrypt passwords setting selected).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_MECHANISM</code> - <code>"SCRAM-SHA-512"</code>, <code>"GSSAPI"</code>,
     * <code>"AWS_MSK_IAM"</code>, or <code>"PLAIN"</code>. These are the supported <a
     * href="https://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml">SASL Mechanisms</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_PLAIN_USERNAME</code> - A plaintext username used to authenticate with the "PLAIN" mechanism.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_PLAIN_PASSWORD</code> - A plaintext password used to authenticate with the "PLAIN" mechanism.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENCRYPTED_KAFKA_SASL_PLAIN_PASSWORD</code> - The encrypted version of the Kafka SASL PLAIN password (if the
     * user has the Glue encrypt passwords setting selected).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_SCRAM_USERNAME</code> - A plaintext username used to authenticate with the "SCRAM-SHA-512"
     * mechanism.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_SCRAM_PASSWORD</code> - A plaintext password used to authenticate with the "SCRAM-SHA-512"
     * mechanism.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code> - The encrypted version of the Kafka SASL SCRAM password (if the
     * user has the Glue encrypt passwords setting selected).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_SCRAM_SECRETS_ARN</code> - The Amazon Resource Name of a secret in Amazon Web Services Secrets
     * Manager.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_GSSAPI_KEYTAB</code> - The S3 location of a Kerberos <code>keytab</code> file. A keytab stores
     * long-term keys for one or more principals. For more information, see <a
     * href="https://web.mit.edu/kerberos/krb5-latest/doc/basic/keytab_def.html">MIT Kerberos Documentation: Keytab</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code> - The S3 location of a Kerberos <code>krb5.conf</code> file. A krb5.conf
     * stores Kerberos configuration information, such as the location of the KDC server. For more information, see <a
     * href="https://web.mit.edu/kerberos/krb5-1.12/doc/admin/conf_files/krb5_conf.html">MIT Kerberos Documentation:
     * krb5.conf</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_GSSAPI_SERVICE</code> - The Kerberos service name, as set with
     * <code>sasl.kerberos.service.name</code> in your <a
     * href="https://kafka.apache.org/documentation/#brokerconfigs_sasl.kerberos.service.name">Kafka Configuration</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code> - The name of the Kerberos princial used by Glue. For more information,
     * see <a href="https://kafka.apache.org/documentation/#security_sasl_kerberos_clientconfig">Kafka Documentation:
     * Configuring Kafka Brokers</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROLE_ARN</code> - The role to be used for running queries.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION</code> - The Amazon Web Services Region where queries will be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WORKGROUP_NAME</code> - The name of an Amazon Redshift serverless workgroup or Amazon Athena workgroup in
     * which queries will run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CLUSTER_IDENTIFIER</code> - The cluster identifier of an Amazon Redshift cluster in which queries will run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DATABASE</code> - The Amazon Redshift database that you are connecting to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionProperties} method.
     * </p>
     * 
     * @return These key-value pairs define parameters for the connection when using the version 1 Connection
     *         schema:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HOST</code> - The host URI: either the fully qualified domain name (FQDN) or the IPv4 address of
     *         the database host.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PORT</code> - The port number, between 1024 and 65535, of the port on which the database host is
     *         listening for database connections.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>USER_NAME</code> - The name under which to log in to the database. The value string for
     *         <code>USER_NAME</code> is "<code>USERNAME</code>".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PASSWORD</code> - A password, if one is used, for the user name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENCRYPTED_PASSWORD</code> - When you enable connection password protection by setting
     *         <code>ConnectionPasswordEncryption</code> in the Data Catalog encryption settings, this field stores the
     *         encrypted password.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JDBC_DRIVER_JAR_URI</code> - The Amazon Simple Storage Service (Amazon S3) path of the JAR file
     *         that contains the JDBC driver to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JDBC_DRIVER_CLASS_NAME</code> - The class name of the JDBC driver to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JDBC_ENGINE</code> - The name of the JDBC engine to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JDBC_ENGINE_VERSION</code> - The version of the JDBC engine to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONFIG_FILES</code> - (Reserved for future use.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTANCE_ID</code> - The instance ID to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JDBC_CONNECTION_URL</code> - The URL for connecting to a JDBC data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JDBC_ENFORCE_SSL</code> - A Boolean string (true, false) specifying whether Secure Sockets Layer
     *         (SSL) with hostname matching is enforced for the JDBC connection on the client. The default is false.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM_JDBC_CERT</code> - An Amazon S3 location specifying the customer's root certificate. Glue
     *         uses this root certificate to validate the customer’s certificate when connecting to the customer
     *         database. Glue only handles X.509 certificates. The certificate provided must be DER-encoded and supplied
     *         in Base64 encoding PEM format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code> - By default, this is <code>false</code>. Glue validates
     *         the Signature algorithm and Subject Public Key Algorithm for the customer certificate. The only permitted
     *         algorithms for the Signature algorithm are SHA256withRSA, SHA384withRSA or SHA512withRSA. For the Subject
     *         Public Key Algorithm, the key length must be at least 2048. You can set the value of this property to
     *         <code>true</code> to skip Glue’s validation of the customer certificate.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM_JDBC_CERT_STRING</code> - A custom JDBC certificate string which is used for domain match or
     *         distinguished name match to prevent a man-in-the-middle attack. In Oracle database, this is used as the
     *         <code>SSL_SERVER_CERT_DN</code>; in Microsoft SQL Server, this is used as the
     *         <code>hostNameInCertificate</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONNECTION_URL</code> - The URL for connecting to a general (non-JDBC) data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SECRET_ID</code> - The secret ID used for the secret manager of credentials.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONNECTOR_URL</code> - The connector URL for a MARKETPLACE or CUSTOM connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONNECTOR_TYPE</code> - The connector type for a MARKETPLACE or CUSTOM connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONNECTOR_CLASS_NAME</code> - The connector class name for a MARKETPLACE or CUSTOM connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_BOOTSTRAP_SERVERS</code> - A comma-separated list of host and port pairs that are the
     *         addresses of the Apache Kafka brokers in a Kafka cluster to which a Kafka client will connect to and
     *         bootstrap itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SSL_ENABLED</code> - Whether to enable or disable SSL on an Apache Kafka connection. Default
     *         value is "true".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_CUSTOM_CERT</code> - The Amazon S3 URL for the private CA cert file (.pem format). The
     *         default is an empty string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code> - Whether to skip the validation of the CA cert file or
     *         not. Glue validates for three algorithms: SHA256withRSA, SHA384withRSA and SHA512withRSA. Default value
     *         is "false".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_CLIENT_KEYSTORE</code> - The Amazon S3 location of the client keystore file for Kafka client
     *         side authentication (Optional).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The password to access the provided keystore (Optional).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_CLIENT_KEY_PASSWORD</code> - A keystore can consist of multiple keys, so this is the password
     *         to access the client key to be used with the Kafka server side key (Optional).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The encrypted version of the Kafka client
     *         keystore password (if the user has the Glue encrypt passwords setting selected).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code> - The encrypted version of the Kafka client key password
     *         (if the user has the Glue encrypt passwords setting selected).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_MECHANISM</code> - <code>"SCRAM-SHA-512"</code>, <code>"GSSAPI"</code>,
     *         <code>"AWS_MSK_IAM"</code>, or <code>"PLAIN"</code>. These are the supported <a
     *         href="https://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml">SASL Mechanisms</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_PLAIN_USERNAME</code> - A plaintext username used to authenticate with the "PLAIN"
     *         mechanism.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_PLAIN_PASSWORD</code> - A plaintext password used to authenticate with the "PLAIN"
     *         mechanism.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENCRYPTED_KAFKA_SASL_PLAIN_PASSWORD</code> - The encrypted version of the Kafka SASL PLAIN password
     *         (if the user has the Glue encrypt passwords setting selected).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_SCRAM_USERNAME</code> - A plaintext username used to authenticate with the
     *         "SCRAM-SHA-512" mechanism.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_SCRAM_PASSWORD</code> - A plaintext password used to authenticate with the
     *         "SCRAM-SHA-512" mechanism.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code> - The encrypted version of the Kafka SASL SCRAM password
     *         (if the user has the Glue encrypt passwords setting selected).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_SCRAM_SECRETS_ARN</code> - The Amazon Resource Name of a secret in Amazon Web Services
     *         Secrets Manager.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_GSSAPI_KEYTAB</code> - The S3 location of a Kerberos <code>keytab</code> file. A keytab
     *         stores long-term keys for one or more principals. For more information, see <a
     *         href="https://web.mit.edu/kerberos/krb5-latest/doc/basic/keytab_def.html">MIT Kerberos Documentation:
     *         Keytab</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code> - The S3 location of a Kerberos <code>krb5.conf</code> file. A
     *         krb5.conf stores Kerberos configuration information, such as the location of the KDC server. For more
     *         information, see <a href="https://web.mit.edu/kerberos/krb5-1.12/doc/admin/conf_files/krb5_conf.html">MIT
     *         Kerberos Documentation: krb5.conf</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_GSSAPI_SERVICE</code> - The Kerberos service name, as set with
     *         <code>sasl.kerberos.service.name</code> in your <a
     *         href="https://kafka.apache.org/documentation/#brokerconfigs_sasl.kerberos.service.name">Kafka
     *         Configuration</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code> - The name of the Kerberos princial used by Glue. For more
     *         information, see <a
     *         href="https://kafka.apache.org/documentation/#security_sasl_kerberos_clientconfig">Kafka Documentation:
     *         Configuring Kafka Brokers</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROLE_ARN</code> - The role to be used for running queries.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGION</code> - The Amazon Web Services Region where queries will be run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WORKGROUP_NAME</code> - The name of an Amazon Redshift serverless workgroup or Amazon Athena
     *         workgroup in which queries will run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CLUSTER_IDENTIFIER</code> - The cluster identifier of an Amazon Redshift cluster in which queries
     *         will run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DATABASE</code> - The Amazon Redshift database that you are connecting to.
     *         </p>
     *         </li>
     */
    public final Map<String, String> connectionPropertiesAsStrings() {
        return connectionProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the SparkProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSparkProperties() {
        return sparkProperties != null && !(sparkProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Connection properties specific to the Spark compute environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSparkProperties} method.
     * </p>
     * 
     * @return Connection properties specific to the Spark compute environment.
     */
    public final Map<String, String> sparkProperties() {
        return sparkProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the AthenaProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAthenaProperties() {
        return athenaProperties != null && !(athenaProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Connection properties specific to the Athena compute environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAthenaProperties} method.
     * </p>
     * 
     * @return Connection properties specific to the Athena compute environment.
     */
    public final Map<String, String> athenaProperties() {
        return athenaProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the PythonProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPythonProperties() {
        return pythonProperties != null && !(pythonProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Connection properties specific to the Python compute environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPythonProperties} method.
     * </p>
     * 
     * @return Connection properties specific to the Python compute environment.
     */
    public final Map<String, String> pythonProperties() {
        return pythonProperties;
    }

    /**
     * <p>
     * The physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>, that
     * are needed to make this connection successfully.
     * </p>
     * 
     * @return The physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>,
     *         that are needed to make this connection successfully.
     */
    public final PhysicalConnectionRequirements physicalConnectionRequirements() {
        return physicalConnectionRequirements;
    }

    /**
     * <p>
     * The timestamp of the time that this connection definition was created.
     * </p>
     * 
     * @return The timestamp of the time that this connection definition was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The timestamp of the last time the connection definition was updated.
     * </p>
     * 
     * @return The timestamp of the last time the connection definition was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The user, group, or role that last updated this connection definition.
     * </p>
     * 
     * @return The user, group, or role that last updated this connection definition.
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * <p>
     * The status of the connection. Can be one of: <code>READY</code>, <code>IN_PROGRESS</code>, or <code>FAILED</code>
     * .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the connection. Can be one of: <code>READY</code>, <code>IN_PROGRESS</code>, or
     *         <code>FAILED</code>.
     * @see ConnectionStatus
     */
    public final ConnectionStatus status() {
        return ConnectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the connection. Can be one of: <code>READY</code>, <code>IN_PROGRESS</code>, or <code>FAILED</code>
     * .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the connection. Can be one of: <code>READY</code>, <code>IN_PROGRESS</code>, or
     *         <code>FAILED</code>.
     * @see ConnectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the connection status.
     * </p>
     * 
     * @return The reason for the connection status.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * A timestamp of the time this connection was last validated.
     * </p>
     * 
     * @return A timestamp of the time this connection was last validated.
     */
    public final Instant lastConnectionValidationTime() {
        return lastConnectionValidationTime;
    }

    /**
     * <p>
     * The authentication properties of the connection.
     * </p>
     * 
     * @return The authentication properties of the connection.
     */
    public final AuthenticationConfiguration authenticationConfiguration() {
        return authenticationConfiguration;
    }

    /**
     * <p>
     * The version of the connection schema for this connection. Version 2 supports properties for specific compute
     * environments.
     * </p>
     * 
     * @return The version of the connection schema for this connection. Version 2 supports properties for specific
     *         compute environments.
     */
    public final Integer connectionSchemaVersion() {
        return connectionSchemaVersion;
    }

    /**
     * <p>
     * A list of compute environments compatible with the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleComputeEnvironments} method.
     * </p>
     * 
     * @return A list of compute environments compatible with the connection.
     */
    public final List<ComputeEnvironment> compatibleComputeEnvironments() {
        return ComputeEnvironmentListCopier.copyStringToEnum(compatibleComputeEnvironments);
    }

    /**
     * For responses, this returns true if the service returned a value for the CompatibleComputeEnvironments property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCompatibleComputeEnvironments() {
        return compatibleComputeEnvironments != null && !(compatibleComputeEnvironments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of compute environments compatible with the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleComputeEnvironments} method.
     * </p>
     * 
     * @return A list of compute environments compatible with the connection.
     */
    public final List<String> compatibleComputeEnvironmentsAsStrings() {
        return compatibleComputeEnvironments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchCriteria() ? matchCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionProperties() ? connectionPropertiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSparkProperties() ? sparkProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAthenaProperties() ? athenaProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPythonProperties() ? pythonProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(physicalConnectionRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastConnectionValidationTime());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(connectionSchemaVersion());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCompatibleComputeEnvironments() ? compatibleComputeEnvironmentsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connection)) {
            return false;
        }
        Connection other = (Connection) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(connectionTypeAsString(), other.connectionTypeAsString())
                && hasMatchCriteria() == other.hasMatchCriteria() && Objects.equals(matchCriteria(), other.matchCriteria())
                && hasConnectionProperties() == other.hasConnectionProperties()
                && Objects.equals(connectionPropertiesAsStrings(), other.connectionPropertiesAsStrings())
                && hasSparkProperties() == other.hasSparkProperties()
                && Objects.equals(sparkProperties(), other.sparkProperties())
                && hasAthenaProperties() == other.hasAthenaProperties()
                && Objects.equals(athenaProperties(), other.athenaProperties())
                && hasPythonProperties() == other.hasPythonProperties()
                && Objects.equals(pythonProperties(), other.pythonProperties())
                && Objects.equals(physicalConnectionRequirements(), other.physicalConnectionRequirements())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(lastConnectionValidationTime(), other.lastConnectionValidationTime())
                && Objects.equals(authenticationConfiguration(), other.authenticationConfiguration())
                && Objects.equals(connectionSchemaVersion(), other.connectionSchemaVersion())
                && hasCompatibleComputeEnvironments() == other.hasCompatibleComputeEnvironments()
                && Objects.equals(compatibleComputeEnvironmentsAsStrings(), other.compatibleComputeEnvironmentsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("Connection")
                .add("Name", name())
                .add("Description", description())
                .add("ConnectionType", connectionTypeAsString())
                .add("MatchCriteria", hasMatchCriteria() ? matchCriteria() : null)
                .add("ConnectionProperties", hasConnectionProperties() ? connectionPropertiesAsStrings() : null)
                .add("SparkProperties", hasSparkProperties() ? sparkProperties() : null)
                .add("AthenaProperties", hasAthenaProperties() ? athenaProperties() : null)
                .add("PythonProperties", hasPythonProperties() ? pythonProperties() : null)
                .add("PhysicalConnectionRequirements", physicalConnectionRequirements())
                .add("CreationTime", creationTime())
                .add("LastUpdatedTime", lastUpdatedTime())
                .add("LastUpdatedBy", lastUpdatedBy())
                .add("Status", statusAsString())
                .add("StatusReason", statusReason())
                .add("LastConnectionValidationTime", lastConnectionValidationTime())
                .add("AuthenticationConfiguration", authenticationConfiguration())
                .add("ConnectionSchemaVersion", connectionSchemaVersion())
                .add("CompatibleComputeEnvironments",
                        hasCompatibleComputeEnvironments() ? compatibleComputeEnvironmentsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        case "MatchCriteria":
            return Optional.ofNullable(clazz.cast(matchCriteria()));
        case "ConnectionProperties":
            return Optional.ofNullable(clazz.cast(connectionPropertiesAsStrings()));
        case "SparkProperties":
            return Optional.ofNullable(clazz.cast(sparkProperties()));
        case "AthenaProperties":
            return Optional.ofNullable(clazz.cast(athenaProperties()));
        case "PythonProperties":
            return Optional.ofNullable(clazz.cast(pythonProperties()));
        case "PhysicalConnectionRequirements":
            return Optional.ofNullable(clazz.cast(physicalConnectionRequirements()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "LastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "LastConnectionValidationTime":
            return Optional.ofNullable(clazz.cast(lastConnectionValidationTime()));
        case "AuthenticationConfiguration":
            return Optional.ofNullable(clazz.cast(authenticationConfiguration()));
        case "ConnectionSchemaVersion":
            return Optional.ofNullable(clazz.cast(connectionSchemaVersion()));
        case "CompatibleComputeEnvironments":
            return Optional.ofNullable(clazz.cast(compatibleComputeEnvironmentsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("MatchCriteria", MATCH_CRITERIA_FIELD);
        map.put("ConnectionProperties", CONNECTION_PROPERTIES_FIELD);
        map.put("SparkProperties", SPARK_PROPERTIES_FIELD);
        map.put("AthenaProperties", ATHENA_PROPERTIES_FIELD);
        map.put("PythonProperties", PYTHON_PROPERTIES_FIELD);
        map.put("PhysicalConnectionRequirements", PHYSICAL_CONNECTION_REQUIREMENTS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("LastUpdatedBy", LAST_UPDATED_BY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("LastConnectionValidationTime", LAST_CONNECTION_VALIDATION_TIME_FIELD);
        map.put("AuthenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
        map.put("ConnectionSchemaVersion", CONNECTION_SCHEMA_VERSION_FIELD);
        map.put("CompatibleComputeEnvironments", COMPATIBLE_COMPUTE_ENVIRONMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Connection, T> g) {
        return obj -> g.apply((Connection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Connection> {
        /**
         * <p>
         * The name of the connection definition.
         * </p>
         * 
         * @param name
         *        The name of the connection definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the connection.
         * </p>
         * 
         * @param description
         *        The description of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of the connection. Currently, SFTP is not supported.
         * </p>
         * 
         * @param connectionType
         *        The type of the connection. Currently, SFTP is not supported.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The type of the connection. Currently, SFTP is not supported.
         * </p>
         * 
         * @param connectionType
         *        The type of the connection. Currently, SFTP is not supported.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);

        /**
         * <p>
         * A list of criteria that can be used in selecting this connection.
         * </p>
         * 
         * @param matchCriteria
         *        A list of criteria that can be used in selecting this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(Collection<String> matchCriteria);

        /**
         * <p>
         * A list of criteria that can be used in selecting this connection.
         * </p>
         * 
         * @param matchCriteria
         *        A list of criteria that can be used in selecting this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(String... matchCriteria);

        /**
         * <p>
         * These key-value pairs define parameters for the connection when using the version 1 Connection schema:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HOST</code> - The host URI: either the fully qualified domain name (FQDN) or the IPv4 address of the
         * database host.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PORT</code> - The port number, between 1024 and 65535, of the port on which the database host is
         * listening for database connections.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>USER_NAME</code> - The name under which to log in to the database. The value string for
         * <code>USER_NAME</code> is "<code>USERNAME</code>".
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PASSWORD</code> - A password, if one is used, for the user name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENCRYPTED_PASSWORD</code> - When you enable connection password protection by setting
         * <code>ConnectionPasswordEncryption</code> in the Data Catalog encryption settings, this field stores the
         * encrypted password.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JDBC_DRIVER_JAR_URI</code> - The Amazon Simple Storage Service (Amazon S3) path of the JAR file that
         * contains the JDBC driver to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JDBC_DRIVER_CLASS_NAME</code> - The class name of the JDBC driver to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JDBC_ENGINE</code> - The name of the JDBC engine to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JDBC_ENGINE_VERSION</code> - The version of the JDBC engine to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONFIG_FILES</code> - (Reserved for future use.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE_ID</code> - The instance ID to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JDBC_CONNECTION_URL</code> - The URL for connecting to a JDBC data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JDBC_ENFORCE_SSL</code> - A Boolean string (true, false) specifying whether Secure Sockets Layer (SSL)
         * with hostname matching is enforced for the JDBC connection on the client. The default is false.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM_JDBC_CERT</code> - An Amazon S3 location specifying the customer's root certificate. Glue uses
         * this root certificate to validate the customer’s certificate when connecting to the customer database. Glue
         * only handles X.509 certificates. The certificate provided must be DER-encoded and supplied in Base64 encoding
         * PEM format.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code> - By default, this is <code>false</code>. Glue validates the
         * Signature algorithm and Subject Public Key Algorithm for the customer certificate. The only permitted
         * algorithms for the Signature algorithm are SHA256withRSA, SHA384withRSA or SHA512withRSA. For the Subject
         * Public Key Algorithm, the key length must be at least 2048. You can set the value of this property to
         * <code>true</code> to skip Glue’s validation of the customer certificate.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM_JDBC_CERT_STRING</code> - A custom JDBC certificate string which is used for domain match or
         * distinguished name match to prevent a man-in-the-middle attack. In Oracle database, this is used as the
         * <code>SSL_SERVER_CERT_DN</code>; in Microsoft SQL Server, this is used as the
         * <code>hostNameInCertificate</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONNECTION_URL</code> - The URL for connecting to a general (non-JDBC) data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SECRET_ID</code> - The secret ID used for the secret manager of credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONNECTOR_URL</code> - The connector URL for a MARKETPLACE or CUSTOM connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONNECTOR_TYPE</code> - The connector type for a MARKETPLACE or CUSTOM connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONNECTOR_CLASS_NAME</code> - The connector class name for a MARKETPLACE or CUSTOM connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_BOOTSTRAP_SERVERS</code> - A comma-separated list of host and port pairs that are the addresses
         * of the Apache Kafka brokers in a Kafka cluster to which a Kafka client will connect to and bootstrap itself.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SSL_ENABLED</code> - Whether to enable or disable SSL on an Apache Kafka connection. Default
         * value is "true".
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_CUSTOM_CERT</code> - The Amazon S3 URL for the private CA cert file (.pem format). The default is
         * an empty string.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code> - Whether to skip the validation of the CA cert file or not.
         * Glue validates for three algorithms: SHA256withRSA, SHA384withRSA and SHA512withRSA. Default value is
         * "false".
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_CLIENT_KEYSTORE</code> - The Amazon S3 location of the client keystore file for Kafka client side
         * authentication (Optional).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The password to access the provided keystore (Optional).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_CLIENT_KEY_PASSWORD</code> - A keystore can consist of multiple keys, so this is the password to
         * access the client key to be used with the Kafka server side key (Optional).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The encrypted version of the Kafka client keystore
         * password (if the user has the Glue encrypt passwords setting selected).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code> - The encrypted version of the Kafka client key password (if
         * the user has the Glue encrypt passwords setting selected).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_MECHANISM</code> - <code>"SCRAM-SHA-512"</code>, <code>"GSSAPI"</code>,
         * <code>"AWS_MSK_IAM"</code>, or <code>"PLAIN"</code>. These are the supported <a
         * href="https://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml">SASL Mechanisms</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_PLAIN_USERNAME</code> - A plaintext username used to authenticate with the "PLAIN"
         * mechanism.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_PLAIN_PASSWORD</code> - A plaintext password used to authenticate with the "PLAIN"
         * mechanism.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENCRYPTED_KAFKA_SASL_PLAIN_PASSWORD</code> - The encrypted version of the Kafka SASL PLAIN password (if
         * the user has the Glue encrypt passwords setting selected).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_SCRAM_USERNAME</code> - A plaintext username used to authenticate with the "SCRAM-SHA-512"
         * mechanism.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_SCRAM_PASSWORD</code> - A plaintext password used to authenticate with the "SCRAM-SHA-512"
         * mechanism.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code> - The encrypted version of the Kafka SASL SCRAM password (if
         * the user has the Glue encrypt passwords setting selected).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_SCRAM_SECRETS_ARN</code> - The Amazon Resource Name of a secret in Amazon Web Services
         * Secrets Manager.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_GSSAPI_KEYTAB</code> - The S3 location of a Kerberos <code>keytab</code> file. A keytab
         * stores long-term keys for one or more principals. For more information, see <a
         * href="https://web.mit.edu/kerberos/krb5-latest/doc/basic/keytab_def.html">MIT Kerberos Documentation:
         * Keytab</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code> - The S3 location of a Kerberos <code>krb5.conf</code> file. A
         * krb5.conf stores Kerberos configuration information, such as the location of the KDC server. For more
         * information, see <a href="https://web.mit.edu/kerberos/krb5-1.12/doc/admin/conf_files/krb5_conf.html">MIT
         * Kerberos Documentation: krb5.conf</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_GSSAPI_SERVICE</code> - The Kerberos service name, as set with
         * <code>sasl.kerberos.service.name</code> in your <a
         * href="https://kafka.apache.org/documentation/#brokerconfigs_sasl.kerberos.service.name">Kafka
         * Configuration</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code> - The name of the Kerberos princial used by Glue. For more
         * information, see <a href="https://kafka.apache.org/documentation/#security_sasl_kerberos_clientconfig">Kafka
         * Documentation: Configuring Kafka Brokers</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROLE_ARN</code> - The role to be used for running queries.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGION</code> - The Amazon Web Services Region where queries will be run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WORKGROUP_NAME</code> - The name of an Amazon Redshift serverless workgroup or Amazon Athena workgroup
         * in which queries will run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CLUSTER_IDENTIFIER</code> - The cluster identifier of an Amazon Redshift cluster in which queries will
         * run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DATABASE</code> - The Amazon Redshift database that you are connecting to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param connectionProperties
         *        These key-value pairs define parameters for the connection when using the version 1 Connection
         *        schema:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HOST</code> - The host URI: either the fully qualified domain name (FQDN) or the IPv4 address of
         *        the database host.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PORT</code> - The port number, between 1024 and 65535, of the port on which the database host is
         *        listening for database connections.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>USER_NAME</code> - The name under which to log in to the database. The value string for
         *        <code>USER_NAME</code> is "<code>USERNAME</code>".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PASSWORD</code> - A password, if one is used, for the user name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENCRYPTED_PASSWORD</code> - When you enable connection password protection by setting
         *        <code>ConnectionPasswordEncryption</code> in the Data Catalog encryption settings, this field stores
         *        the encrypted password.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JDBC_DRIVER_JAR_URI</code> - The Amazon Simple Storage Service (Amazon S3) path of the JAR file
         *        that contains the JDBC driver to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JDBC_DRIVER_CLASS_NAME</code> - The class name of the JDBC driver to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JDBC_ENGINE</code> - The name of the JDBC engine to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JDBC_ENGINE_VERSION</code> - The version of the JDBC engine to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONFIG_FILES</code> - (Reserved for future use.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTANCE_ID</code> - The instance ID to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JDBC_CONNECTION_URL</code> - The URL for connecting to a JDBC data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JDBC_ENFORCE_SSL</code> - A Boolean string (true, false) specifying whether Secure Sockets Layer
         *        (SSL) with hostname matching is enforced for the JDBC connection on the client. The default is false.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM_JDBC_CERT</code> - An Amazon S3 location specifying the customer's root certificate. Glue
         *        uses this root certificate to validate the customer’s certificate when connecting to the customer
         *        database. Glue only handles X.509 certificates. The certificate provided must be DER-encoded and
         *        supplied in Base64 encoding PEM format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code> - By default, this is <code>false</code>. Glue validates
         *        the Signature algorithm and Subject Public Key Algorithm for the customer certificate. The only
         *        permitted algorithms for the Signature algorithm are SHA256withRSA, SHA384withRSA or SHA512withRSA.
         *        For the Subject Public Key Algorithm, the key length must be at least 2048. You can set the value of
         *        this property to <code>true</code> to skip Glue’s validation of the customer certificate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM_JDBC_CERT_STRING</code> - A custom JDBC certificate string which is used for domain match
         *        or distinguished name match to prevent a man-in-the-middle attack. In Oracle database, this is used as
         *        the <code>SSL_SERVER_CERT_DN</code>; in Microsoft SQL Server, this is used as the
         *        <code>hostNameInCertificate</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONNECTION_URL</code> - The URL for connecting to a general (non-JDBC) data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SECRET_ID</code> - The secret ID used for the secret manager of credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONNECTOR_URL</code> - The connector URL for a MARKETPLACE or CUSTOM connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONNECTOR_TYPE</code> - The connector type for a MARKETPLACE or CUSTOM connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONNECTOR_CLASS_NAME</code> - The connector class name for a MARKETPLACE or CUSTOM connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_BOOTSTRAP_SERVERS</code> - A comma-separated list of host and port pairs that are the
         *        addresses of the Apache Kafka brokers in a Kafka cluster to which a Kafka client will connect to and
         *        bootstrap itself.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SSL_ENABLED</code> - Whether to enable or disable SSL on an Apache Kafka connection.
         *        Default value is "true".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_CUSTOM_CERT</code> - The Amazon S3 URL for the private CA cert file (.pem format). The
         *        default is an empty string.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code> - Whether to skip the validation of the CA cert file or
         *        not. Glue validates for three algorithms: SHA256withRSA, SHA384withRSA and SHA512withRSA. Default
         *        value is "false".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_CLIENT_KEYSTORE</code> - The Amazon S3 location of the client keystore file for Kafka
         *        client side authentication (Optional).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The password to access the provided keystore (Optional).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_CLIENT_KEY_PASSWORD</code> - A keystore can consist of multiple keys, so this is the
         *        password to access the client key to be used with the Kafka server side key (Optional).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The encrypted version of the Kafka client
         *        keystore password (if the user has the Glue encrypt passwords setting selected).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code> - The encrypted version of the Kafka client key
         *        password (if the user has the Glue encrypt passwords setting selected).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_MECHANISM</code> - <code>"SCRAM-SHA-512"</code>, <code>"GSSAPI"</code>,
         *        <code>"AWS_MSK_IAM"</code>, or <code>"PLAIN"</code>. These are the supported <a
         *        href="https://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml">SASL Mechanisms</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_PLAIN_USERNAME</code> - A plaintext username used to authenticate with the "PLAIN"
         *        mechanism.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_PLAIN_PASSWORD</code> - A plaintext password used to authenticate with the "PLAIN"
         *        mechanism.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENCRYPTED_KAFKA_SASL_PLAIN_PASSWORD</code> - The encrypted version of the Kafka SASL PLAIN
         *        password (if the user has the Glue encrypt passwords setting selected).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_SCRAM_USERNAME</code> - A plaintext username used to authenticate with the
         *        "SCRAM-SHA-512" mechanism.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_SCRAM_PASSWORD</code> - A plaintext password used to authenticate with the
         *        "SCRAM-SHA-512" mechanism.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code> - The encrypted version of the Kafka SASL SCRAM
         *        password (if the user has the Glue encrypt passwords setting selected).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_SCRAM_SECRETS_ARN</code> - The Amazon Resource Name of a secret in Amazon Web
         *        Services Secrets Manager.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_GSSAPI_KEYTAB</code> - The S3 location of a Kerberos <code>keytab</code> file. A
         *        keytab stores long-term keys for one or more principals. For more information, see <a
         *        href="https://web.mit.edu/kerberos/krb5-latest/doc/basic/keytab_def.html">MIT Kerberos Documentation:
         *        Keytab</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code> - The S3 location of a Kerberos <code>krb5.conf</code> file.
         *        A krb5.conf stores Kerberos configuration information, such as the location of the KDC server. For
         *        more information, see <a
         *        href="https://web.mit.edu/kerberos/krb5-1.12/doc/admin/conf_files/krb5_conf.html">MIT Kerberos
         *        Documentation: krb5.conf</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_GSSAPI_SERVICE</code> - The Kerberos service name, as set with
         *        <code>sasl.kerberos.service.name</code> in your <a
         *        href="https://kafka.apache.org/documentation/#brokerconfigs_sasl.kerberos.service.name">Kafka
         *        Configuration</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code> - The name of the Kerberos princial used by Glue. For more
         *        information, see <a
         *        href="https://kafka.apache.org/documentation/#security_sasl_kerberos_clientconfig">Kafka
         *        Documentation: Configuring Kafka Brokers</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROLE_ARN</code> - The role to be used for running queries.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGION</code> - The Amazon Web Services Region where queries will be run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WORKGROUP_NAME</code> - The name of an Amazon Redshift serverless workgroup or Amazon Athena
         *        workgroup in which queries will run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CLUSTER_IDENTIFIER</code> - The cluster identifier of an Amazon Redshift cluster in which
         *        queries will run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DATABASE</code> - The Amazon Redshift database that you are connecting to.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionPropertiesWithStrings(Map<String, String> connectionProperties);

        /**
         * <p>
         * These key-value pairs define parameters for the connection when using the version 1 Connection schema:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HOST</code> - The host URI: either the fully qualified domain name (FQDN) or the IPv4 address of the
         * database host.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PORT</code> - The port number, between 1024 and 65535, of the port on which the database host is
         * listening for database connections.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>USER_NAME</code> - The name under which to log in to the database. The value string for
         * <code>USER_NAME</code> is "<code>USERNAME</code>".
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PASSWORD</code> - A password, if one is used, for the user name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENCRYPTED_PASSWORD</code> - When you enable connection password protection by setting
         * <code>ConnectionPasswordEncryption</code> in the Data Catalog encryption settings, this field stores the
         * encrypted password.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JDBC_DRIVER_JAR_URI</code> - The Amazon Simple Storage Service (Amazon S3) path of the JAR file that
         * contains the JDBC driver to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JDBC_DRIVER_CLASS_NAME</code> - The class name of the JDBC driver to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JDBC_ENGINE</code> - The name of the JDBC engine to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JDBC_ENGINE_VERSION</code> - The version of the JDBC engine to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONFIG_FILES</code> - (Reserved for future use.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE_ID</code> - The instance ID to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JDBC_CONNECTION_URL</code> - The URL for connecting to a JDBC data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JDBC_ENFORCE_SSL</code> - A Boolean string (true, false) specifying whether Secure Sockets Layer (SSL)
         * with hostname matching is enforced for the JDBC connection on the client. The default is false.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM_JDBC_CERT</code> - An Amazon S3 location specifying the customer's root certificate. Glue uses
         * this root certificate to validate the customer’s certificate when connecting to the customer database. Glue
         * only handles X.509 certificates. The certificate provided must be DER-encoded and supplied in Base64 encoding
         * PEM format.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code> - By default, this is <code>false</code>. Glue validates the
         * Signature algorithm and Subject Public Key Algorithm for the customer certificate. The only permitted
         * algorithms for the Signature algorithm are SHA256withRSA, SHA384withRSA or SHA512withRSA. For the Subject
         * Public Key Algorithm, the key length must be at least 2048. You can set the value of this property to
         * <code>true</code> to skip Glue’s validation of the customer certificate.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM_JDBC_CERT_STRING</code> - A custom JDBC certificate string which is used for domain match or
         * distinguished name match to prevent a man-in-the-middle attack. In Oracle database, this is used as the
         * <code>SSL_SERVER_CERT_DN</code>; in Microsoft SQL Server, this is used as the
         * <code>hostNameInCertificate</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONNECTION_URL</code> - The URL for connecting to a general (non-JDBC) data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SECRET_ID</code> - The secret ID used for the secret manager of credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONNECTOR_URL</code> - The connector URL for a MARKETPLACE or CUSTOM connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONNECTOR_TYPE</code> - The connector type for a MARKETPLACE or CUSTOM connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONNECTOR_CLASS_NAME</code> - The connector class name for a MARKETPLACE or CUSTOM connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_BOOTSTRAP_SERVERS</code> - A comma-separated list of host and port pairs that are the addresses
         * of the Apache Kafka brokers in a Kafka cluster to which a Kafka client will connect to and bootstrap itself.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SSL_ENABLED</code> - Whether to enable or disable SSL on an Apache Kafka connection. Default
         * value is "true".
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_CUSTOM_CERT</code> - The Amazon S3 URL for the private CA cert file (.pem format). The default is
         * an empty string.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code> - Whether to skip the validation of the CA cert file or not.
         * Glue validates for three algorithms: SHA256withRSA, SHA384withRSA and SHA512withRSA. Default value is
         * "false".
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_CLIENT_KEYSTORE</code> - The Amazon S3 location of the client keystore file for Kafka client side
         * authentication (Optional).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The password to access the provided keystore (Optional).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_CLIENT_KEY_PASSWORD</code> - A keystore can consist of multiple keys, so this is the password to
         * access the client key to be used with the Kafka server side key (Optional).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The encrypted version of the Kafka client keystore
         * password (if the user has the Glue encrypt passwords setting selected).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code> - The encrypted version of the Kafka client key password (if
         * the user has the Glue encrypt passwords setting selected).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_MECHANISM</code> - <code>"SCRAM-SHA-512"</code>, <code>"GSSAPI"</code>,
         * <code>"AWS_MSK_IAM"</code>, or <code>"PLAIN"</code>. These are the supported <a
         * href="https://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml">SASL Mechanisms</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_PLAIN_USERNAME</code> - A plaintext username used to authenticate with the "PLAIN"
         * mechanism.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_PLAIN_PASSWORD</code> - A plaintext password used to authenticate with the "PLAIN"
         * mechanism.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENCRYPTED_KAFKA_SASL_PLAIN_PASSWORD</code> - The encrypted version of the Kafka SASL PLAIN password (if
         * the user has the Glue encrypt passwords setting selected).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_SCRAM_USERNAME</code> - A plaintext username used to authenticate with the "SCRAM-SHA-512"
         * mechanism.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_SCRAM_PASSWORD</code> - A plaintext password used to authenticate with the "SCRAM-SHA-512"
         * mechanism.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code> - The encrypted version of the Kafka SASL SCRAM password (if
         * the user has the Glue encrypt passwords setting selected).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_SCRAM_SECRETS_ARN</code> - The Amazon Resource Name of a secret in Amazon Web Services
         * Secrets Manager.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_GSSAPI_KEYTAB</code> - The S3 location of a Kerberos <code>keytab</code> file. A keytab
         * stores long-term keys for one or more principals. For more information, see <a
         * href="https://web.mit.edu/kerberos/krb5-latest/doc/basic/keytab_def.html">MIT Kerberos Documentation:
         * Keytab</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code> - The S3 location of a Kerberos <code>krb5.conf</code> file. A
         * krb5.conf stores Kerberos configuration information, such as the location of the KDC server. For more
         * information, see <a href="https://web.mit.edu/kerberos/krb5-1.12/doc/admin/conf_files/krb5_conf.html">MIT
         * Kerberos Documentation: krb5.conf</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_GSSAPI_SERVICE</code> - The Kerberos service name, as set with
         * <code>sasl.kerberos.service.name</code> in your <a
         * href="https://kafka.apache.org/documentation/#brokerconfigs_sasl.kerberos.service.name">Kafka
         * Configuration</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code> - The name of the Kerberos princial used by Glue. For more
         * information, see <a href="https://kafka.apache.org/documentation/#security_sasl_kerberos_clientconfig">Kafka
         * Documentation: Configuring Kafka Brokers</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROLE_ARN</code> - The role to be used for running queries.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGION</code> - The Amazon Web Services Region where queries will be run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WORKGROUP_NAME</code> - The name of an Amazon Redshift serverless workgroup or Amazon Athena workgroup
         * in which queries will run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CLUSTER_IDENTIFIER</code> - The cluster identifier of an Amazon Redshift cluster in which queries will
         * run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DATABASE</code> - The Amazon Redshift database that you are connecting to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param connectionProperties
         *        These key-value pairs define parameters for the connection when using the version 1 Connection
         *        schema:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HOST</code> - The host URI: either the fully qualified domain name (FQDN) or the IPv4 address of
         *        the database host.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PORT</code> - The port number, between 1024 and 65535, of the port on which the database host is
         *        listening for database connections.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>USER_NAME</code> - The name under which to log in to the database. The value string for
         *        <code>USER_NAME</code> is "<code>USERNAME</code>".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PASSWORD</code> - A password, if one is used, for the user name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENCRYPTED_PASSWORD</code> - When you enable connection password protection by setting
         *        <code>ConnectionPasswordEncryption</code> in the Data Catalog encryption settings, this field stores
         *        the encrypted password.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JDBC_DRIVER_JAR_URI</code> - The Amazon Simple Storage Service (Amazon S3) path of the JAR file
         *        that contains the JDBC driver to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JDBC_DRIVER_CLASS_NAME</code> - The class name of the JDBC driver to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JDBC_ENGINE</code> - The name of the JDBC engine to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JDBC_ENGINE_VERSION</code> - The version of the JDBC engine to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONFIG_FILES</code> - (Reserved for future use.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTANCE_ID</code> - The instance ID to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JDBC_CONNECTION_URL</code> - The URL for connecting to a JDBC data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JDBC_ENFORCE_SSL</code> - A Boolean string (true, false) specifying whether Secure Sockets Layer
         *        (SSL) with hostname matching is enforced for the JDBC connection on the client. The default is false.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM_JDBC_CERT</code> - An Amazon S3 location specifying the customer's root certificate. Glue
         *        uses this root certificate to validate the customer’s certificate when connecting to the customer
         *        database. Glue only handles X.509 certificates. The certificate provided must be DER-encoded and
         *        supplied in Base64 encoding PEM format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code> - By default, this is <code>false</code>. Glue validates
         *        the Signature algorithm and Subject Public Key Algorithm for the customer certificate. The only
         *        permitted algorithms for the Signature algorithm are SHA256withRSA, SHA384withRSA or SHA512withRSA.
         *        For the Subject Public Key Algorithm, the key length must be at least 2048. You can set the value of
         *        this property to <code>true</code> to skip Glue’s validation of the customer certificate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM_JDBC_CERT_STRING</code> - A custom JDBC certificate string which is used for domain match
         *        or distinguished name match to prevent a man-in-the-middle attack. In Oracle database, this is used as
         *        the <code>SSL_SERVER_CERT_DN</code>; in Microsoft SQL Server, this is used as the
         *        <code>hostNameInCertificate</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONNECTION_URL</code> - The URL for connecting to a general (non-JDBC) data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SECRET_ID</code> - The secret ID used for the secret manager of credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONNECTOR_URL</code> - The connector URL for a MARKETPLACE or CUSTOM connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONNECTOR_TYPE</code> - The connector type for a MARKETPLACE or CUSTOM connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONNECTOR_CLASS_NAME</code> - The connector class name for a MARKETPLACE or CUSTOM connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_BOOTSTRAP_SERVERS</code> - A comma-separated list of host and port pairs that are the
         *        addresses of the Apache Kafka brokers in a Kafka cluster to which a Kafka client will connect to and
         *        bootstrap itself.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SSL_ENABLED</code> - Whether to enable or disable SSL on an Apache Kafka connection.
         *        Default value is "true".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_CUSTOM_CERT</code> - The Amazon S3 URL for the private CA cert file (.pem format). The
         *        default is an empty string.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code> - Whether to skip the validation of the CA cert file or
         *        not. Glue validates for three algorithms: SHA256withRSA, SHA384withRSA and SHA512withRSA. Default
         *        value is "false".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_CLIENT_KEYSTORE</code> - The Amazon S3 location of the client keystore file for Kafka
         *        client side authentication (Optional).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The password to access the provided keystore (Optional).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_CLIENT_KEY_PASSWORD</code> - A keystore can consist of multiple keys, so this is the
         *        password to access the client key to be used with the Kafka server side key (Optional).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The encrypted version of the Kafka client
         *        keystore password (if the user has the Glue encrypt passwords setting selected).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code> - The encrypted version of the Kafka client key
         *        password (if the user has the Glue encrypt passwords setting selected).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_MECHANISM</code> - <code>"SCRAM-SHA-512"</code>, <code>"GSSAPI"</code>,
         *        <code>"AWS_MSK_IAM"</code>, or <code>"PLAIN"</code>. These are the supported <a
         *        href="https://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml">SASL Mechanisms</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_PLAIN_USERNAME</code> - A plaintext username used to authenticate with the "PLAIN"
         *        mechanism.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_PLAIN_PASSWORD</code> - A plaintext password used to authenticate with the "PLAIN"
         *        mechanism.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENCRYPTED_KAFKA_SASL_PLAIN_PASSWORD</code> - The encrypted version of the Kafka SASL PLAIN
         *        password (if the user has the Glue encrypt passwords setting selected).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_SCRAM_USERNAME</code> - A plaintext username used to authenticate with the
         *        "SCRAM-SHA-512" mechanism.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_SCRAM_PASSWORD</code> - A plaintext password used to authenticate with the
         *        "SCRAM-SHA-512" mechanism.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code> - The encrypted version of the Kafka SASL SCRAM
         *        password (if the user has the Glue encrypt passwords setting selected).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_SCRAM_SECRETS_ARN</code> - The Amazon Resource Name of a secret in Amazon Web
         *        Services Secrets Manager.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_GSSAPI_KEYTAB</code> - The S3 location of a Kerberos <code>keytab</code> file. A
         *        keytab stores long-term keys for one or more principals. For more information, see <a
         *        href="https://web.mit.edu/kerberos/krb5-latest/doc/basic/keytab_def.html">MIT Kerberos Documentation:
         *        Keytab</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code> - The S3 location of a Kerberos <code>krb5.conf</code> file.
         *        A krb5.conf stores Kerberos configuration information, such as the location of the KDC server. For
         *        more information, see <a
         *        href="https://web.mit.edu/kerberos/krb5-1.12/doc/admin/conf_files/krb5_conf.html">MIT Kerberos
         *        Documentation: krb5.conf</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_GSSAPI_SERVICE</code> - The Kerberos service name, as set with
         *        <code>sasl.kerberos.service.name</code> in your <a
         *        href="https://kafka.apache.org/documentation/#brokerconfigs_sasl.kerberos.service.name">Kafka
         *        Configuration</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code> - The name of the Kerberos princial used by Glue. For more
         *        information, see <a
         *        href="https://kafka.apache.org/documentation/#security_sasl_kerberos_clientconfig">Kafka
         *        Documentation: Configuring Kafka Brokers</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROLE_ARN</code> - The role to be used for running queries.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGION</code> - The Amazon Web Services Region where queries will be run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WORKGROUP_NAME</code> - The name of an Amazon Redshift serverless workgroup or Amazon Athena
         *        workgroup in which queries will run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CLUSTER_IDENTIFIER</code> - The cluster identifier of an Amazon Redshift cluster in which
         *        queries will run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DATABASE</code> - The Amazon Redshift database that you are connecting to.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionProperties(Map<ConnectionPropertyKey, String> connectionProperties);

        /**
         * <p>
         * Connection properties specific to the Spark compute environment.
         * </p>
         * 
         * @param sparkProperties
         *        Connection properties specific to the Spark compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkProperties(Map<String, String> sparkProperties);

        /**
         * <p>
         * Connection properties specific to the Athena compute environment.
         * </p>
         * 
         * @param athenaProperties
         *        Connection properties specific to the Athena compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaProperties(Map<String, String> athenaProperties);

        /**
         * <p>
         * Connection properties specific to the Python compute environment.
         * </p>
         * 
         * @param pythonProperties
         *        Connection properties specific to the Python compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pythonProperties(Map<String, String> pythonProperties);

        /**
         * <p>
         * The physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>,
         * that are needed to make this connection successfully.
         * </p>
         * 
         * @param physicalConnectionRequirements
         *        The physical connection requirements, such as virtual private cloud (VPC) and
         *        <code>SecurityGroup</code>, that are needed to make this connection successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements);

        /**
         * <p>
         * The physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>,
         * that are needed to make this connection successfully.
         * </p>
         * This is a convenience method that creates an instance of the {@link PhysicalConnectionRequirements.Builder}
         * avoiding the need to create one manually via {@link PhysicalConnectionRequirements#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PhysicalConnectionRequirements.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #physicalConnectionRequirements(PhysicalConnectionRequirements)}.
         * 
         * @param physicalConnectionRequirements
         *        a consumer that will call methods on {@link PhysicalConnectionRequirements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #physicalConnectionRequirements(PhysicalConnectionRequirements)
         */
        default Builder physicalConnectionRequirements(
                Consumer<PhysicalConnectionRequirements.Builder> physicalConnectionRequirements) {
            return physicalConnectionRequirements(PhysicalConnectionRequirements.builder()
                    .applyMutation(physicalConnectionRequirements).build());
        }

        /**
         * <p>
         * The timestamp of the time that this connection definition was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp of the time that this connection definition was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The timestamp of the last time the connection definition was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp of the last time the connection definition was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The user, group, or role that last updated this connection definition.
         * </p>
         * 
         * @param lastUpdatedBy
         *        The user, group, or role that last updated this connection definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * <p>
         * The status of the connection. Can be one of: <code>READY</code>, <code>IN_PROGRESS</code>, or
         * <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The status of the connection. Can be one of: <code>READY</code>, <code>IN_PROGRESS</code>, or
         *        <code>FAILED</code>.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the connection. Can be one of: <code>READY</code>, <code>IN_PROGRESS</code>, or
         * <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The status of the connection. Can be one of: <code>READY</code>, <code>IN_PROGRESS</code>, or
         *        <code>FAILED</code>.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder status(ConnectionStatus status);

        /**
         * <p>
         * The reason for the connection status.
         * </p>
         * 
         * @param statusReason
         *        The reason for the connection status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * A timestamp of the time this connection was last validated.
         * </p>
         * 
         * @param lastConnectionValidationTime
         *        A timestamp of the time this connection was last validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastConnectionValidationTime(Instant lastConnectionValidationTime);

        /**
         * <p>
         * The authentication properties of the connection.
         * </p>
         * 
         * @param authenticationConfiguration
         *        The authentication properties of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationConfiguration(AuthenticationConfiguration authenticationConfiguration);

        /**
         * <p>
         * The authentication properties of the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationConfiguration.Builder}
         * avoiding the need to create one manually via {@link AuthenticationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthenticationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #authenticationConfiguration(AuthenticationConfiguration)}.
         * 
         * @param authenticationConfiguration
         *        a consumer that will call methods on {@link AuthenticationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationConfiguration(AuthenticationConfiguration)
         */
        default Builder authenticationConfiguration(Consumer<AuthenticationConfiguration.Builder> authenticationConfiguration) {
            return authenticationConfiguration(AuthenticationConfiguration.builder().applyMutation(authenticationConfiguration)
                    .build());
        }

        /**
         * <p>
         * The version of the connection schema for this connection. Version 2 supports properties for specific compute
         * environments.
         * </p>
         * 
         * @param connectionSchemaVersion
         *        The version of the connection schema for this connection. Version 2 supports properties for specific
         *        compute environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionSchemaVersion(Integer connectionSchemaVersion);

        /**
         * <p>
         * A list of compute environments compatible with the connection.
         * </p>
         * 
         * @param compatibleComputeEnvironments
         *        A list of compute environments compatible with the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleComputeEnvironmentsWithStrings(Collection<String> compatibleComputeEnvironments);

        /**
         * <p>
         * A list of compute environments compatible with the connection.
         * </p>
         * 
         * @param compatibleComputeEnvironments
         *        A list of compute environments compatible with the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleComputeEnvironmentsWithStrings(String... compatibleComputeEnvironments);

        /**
         * <p>
         * A list of compute environments compatible with the connection.
         * </p>
         * 
         * @param compatibleComputeEnvironments
         *        A list of compute environments compatible with the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleComputeEnvironments(Collection<ComputeEnvironment> compatibleComputeEnvironments);

        /**
         * <p>
         * A list of compute environments compatible with the connection.
         * </p>
         * 
         * @param compatibleComputeEnvironments
         *        A list of compute environments compatible with the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleComputeEnvironments(ComputeEnvironment... compatibleComputeEnvironments);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String connectionType;

        private List<String> matchCriteria = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> connectionProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> sparkProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> athenaProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> pythonProperties = DefaultSdkAutoConstructMap.getInstance();

        private PhysicalConnectionRequirements physicalConnectionRequirements;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private String lastUpdatedBy;

        private String status;

        private String statusReason;

        private Instant lastConnectionValidationTime;

        private AuthenticationConfiguration authenticationConfiguration;

        private Integer connectionSchemaVersion;

        private List<String> compatibleComputeEnvironments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Connection model) {
            name(model.name);
            description(model.description);
            connectionType(model.connectionType);
            matchCriteria(model.matchCriteria);
            connectionPropertiesWithStrings(model.connectionProperties);
            sparkProperties(model.sparkProperties);
            athenaProperties(model.athenaProperties);
            pythonProperties(model.pythonProperties);
            physicalConnectionRequirements(model.physicalConnectionRequirements);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            lastUpdatedBy(model.lastUpdatedBy);
            status(model.status);
            statusReason(model.statusReason);
            lastConnectionValidationTime(model.lastConnectionValidationTime);
            authenticationConfiguration(model.authenticationConfiguration);
            connectionSchemaVersion(model.connectionSchemaVersion);
            compatibleComputeEnvironmentsWithStrings(model.compatibleComputeEnvironments);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final Collection<String> getMatchCriteria() {
            if (matchCriteria instanceof SdkAutoConstructList) {
                return null;
            }
            return matchCriteria;
        }

        public final void setMatchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
        }

        @Override
        public final Builder matchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchCriteria(String... matchCriteria) {
            matchCriteria(Arrays.asList(matchCriteria));
            return this;
        }

        public final Map<String, String> getConnectionProperties() {
            if (connectionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return connectionProperties;
        }

        public final void setConnectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        @Override
        public final Builder connectionPropertiesWithStrings(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        @Override
        public final Builder connectionProperties(Map<ConnectionPropertyKey, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copyEnumToString(connectionProperties);
            return this;
        }

        public final Map<String, String> getSparkProperties() {
            if (sparkProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return sparkProperties;
        }

        public final void setSparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = PropertyMapCopier.copy(sparkProperties);
        }

        @Override
        public final Builder sparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = PropertyMapCopier.copy(sparkProperties);
            return this;
        }

        public final Map<String, String> getAthenaProperties() {
            if (athenaProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return athenaProperties;
        }

        public final void setAthenaProperties(Map<String, String> athenaProperties) {
            this.athenaProperties = PropertyMapCopier.copy(athenaProperties);
        }

        @Override
        public final Builder athenaProperties(Map<String, String> athenaProperties) {
            this.athenaProperties = PropertyMapCopier.copy(athenaProperties);
            return this;
        }

        public final Map<String, String> getPythonProperties() {
            if (pythonProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return pythonProperties;
        }

        public final void setPythonProperties(Map<String, String> pythonProperties) {
            this.pythonProperties = PropertyMapCopier.copy(pythonProperties);
        }

        @Override
        public final Builder pythonProperties(Map<String, String> pythonProperties) {
            this.pythonProperties = PropertyMapCopier.copy(pythonProperties);
            return this;
        }

        public final PhysicalConnectionRequirements.Builder getPhysicalConnectionRequirements() {
            return physicalConnectionRequirements != null ? physicalConnectionRequirements.toBuilder() : null;
        }

        public final void setPhysicalConnectionRequirements(
                PhysicalConnectionRequirements.BuilderImpl physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements != null ? physicalConnectionRequirements.build()
                    : null;
        }

        @Override
        public final Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getLastConnectionValidationTime() {
            return lastConnectionValidationTime;
        }

        public final void setLastConnectionValidationTime(Instant lastConnectionValidationTime) {
            this.lastConnectionValidationTime = lastConnectionValidationTime;
        }

        @Override
        public final Builder lastConnectionValidationTime(Instant lastConnectionValidationTime) {
            this.lastConnectionValidationTime = lastConnectionValidationTime;
            return this;
        }

        public final AuthenticationConfiguration.Builder getAuthenticationConfiguration() {
            return authenticationConfiguration != null ? authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Integer getConnectionSchemaVersion() {
            return connectionSchemaVersion;
        }

        public final void setConnectionSchemaVersion(Integer connectionSchemaVersion) {
            this.connectionSchemaVersion = connectionSchemaVersion;
        }

        @Override
        public final Builder connectionSchemaVersion(Integer connectionSchemaVersion) {
            this.connectionSchemaVersion = connectionSchemaVersion;
            return this;
        }

        public final Collection<String> getCompatibleComputeEnvironments() {
            if (compatibleComputeEnvironments instanceof SdkAutoConstructList) {
                return null;
            }
            return compatibleComputeEnvironments;
        }

        public final void setCompatibleComputeEnvironments(Collection<String> compatibleComputeEnvironments) {
            this.compatibleComputeEnvironments = ComputeEnvironmentListCopier.copy(compatibleComputeEnvironments);
        }

        @Override
        public final Builder compatibleComputeEnvironmentsWithStrings(Collection<String> compatibleComputeEnvironments) {
            this.compatibleComputeEnvironments = ComputeEnvironmentListCopier.copy(compatibleComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleComputeEnvironmentsWithStrings(String... compatibleComputeEnvironments) {
            compatibleComputeEnvironmentsWithStrings(Arrays.asList(compatibleComputeEnvironments));
            return this;
        }

        @Override
        public final Builder compatibleComputeEnvironments(Collection<ComputeEnvironment> compatibleComputeEnvironments) {
            this.compatibleComputeEnvironments = ComputeEnvironmentListCopier.copyEnumToString(compatibleComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleComputeEnvironments(ComputeEnvironment... compatibleComputeEnvironments) {
            compatibleComputeEnvironments(Arrays.asList(compatibleComputeEnvironments));
            return this;
        }

        @Override
        public Connection build() {
            return new Connection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
