/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An argument or property of a node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeGenNodeArg implements SdkPojo, Serializable, ToCopyableBuilder<CodeGenNodeArg.Builder, CodeGenNodeArg> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CodeGenNodeArg::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(CodeGenNodeArg::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Boolean> PARAM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Param")
            .getter(getter(CodeGenNodeArg::param)).setter(setter(Builder::param))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Param").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD,
            PARAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String value;

    private final Boolean param;

    private CodeGenNodeArg(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.param = builder.param;
    }

    /**
     * <p>
     * The name of the argument or property.
     * </p>
     * 
     * @return The name of the argument or property.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The value of the argument or property.
     * </p>
     * 
     * @return The value of the argument or property.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * True if the value is used as a parameter.
     * </p>
     * 
     * @return True if the value is used as a parameter.
     */
    public final Boolean param() {
        return param;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(param());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeGenNodeArg)) {
            return false;
        }
        CodeGenNodeArg other = (CodeGenNodeArg) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value())
                && Objects.equals(param(), other.param());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeGenNodeArg").add("Name", name()).add("Value", value()).add("Param", param()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Param":
            return Optional.ofNullable(clazz.cast(param()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("Param", PARAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeGenNodeArg, T> g) {
        return obj -> g.apply((CodeGenNodeArg) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeGenNodeArg> {
        /**
         * <p>
         * The name of the argument or property.
         * </p>
         * 
         * @param name
         *        The name of the argument or property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value of the argument or property.
         * </p>
         * 
         * @param value
         *        The value of the argument or property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * True if the value is used as a parameter.
         * </p>
         * 
         * @param param
         *        True if the value is used as a parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder param(Boolean param);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private Boolean param;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeGenNodeArg model) {
            name(model.name);
            value(model.value);
            param(model.param);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Boolean getParam() {
            return param;
        }

        public final void setParam(Boolean param) {
            this.param = param;
        }

        @Override
        public final Builder param(Boolean param) {
            this.param = param;
            return this;
        }

        @Override
        public CodeGenNodeArg build() {
            return new CodeGenNodeArg(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
