/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an Glue Data Catalog target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CatalogTarget implements SdkPojo, Serializable, ToCopyableBuilder<CatalogTarget.Builder, CatalogTarget> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(CatalogTarget::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<List<String>> TABLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Tables")
            .getter(getter(CatalogTarget::tables))
            .setter(setter(Builder::tables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(CatalogTarget::connectionName)).setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<String> EVENT_QUEUE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventQueueArn").getter(getter(CatalogTarget::eventQueueArn)).setter(setter(Builder::eventQueueArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventQueueArn").build()).build();

    private static final SdkField<String> DLQ_EVENT_QUEUE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DlqEventQueueArn").getter(getter(CatalogTarget::dlqEventQueueArn))
            .setter(setter(Builder::dlqEventQueueArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlqEventQueueArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            TABLES_FIELD, CONNECTION_NAME_FIELD, EVENT_QUEUE_ARN_FIELD, DLQ_EVENT_QUEUE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String databaseName;

    private final List<String> tables;

    private final String connectionName;

    private final String eventQueueArn;

    private final String dlqEventQueueArn;

    private CatalogTarget(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.tables = builder.tables;
        this.connectionName = builder.connectionName;
        this.eventQueueArn = builder.eventQueueArn;
        this.dlqEventQueueArn = builder.dlqEventQueueArn;
    }

    /**
     * <p>
     * The name of the database to be synchronized.
     * </p>
     * 
     * @return The name of the database to be synchronized.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tables property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTables() {
        return tables != null && !(tables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the tables to be synchronized.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTables} method.
     * </p>
     * 
     * @return A list of the tables to be synchronized.
     */
    public final List<String> tables() {
        return tables;
    }

    /**
     * <p>
     * The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a
     * <code>Catalog</code> connection type paired with a <code>NETWORK</code> Connection type.
     * </p>
     * 
     * @return The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when
     *         using a <code>Catalog</code> connection type paired with a <code>NETWORK</code> Connection type.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * <p>
     * A valid Amazon SQS ARN. For example, <code>arn:aws:sqs:region:account:sqs</code>.
     * </p>
     * 
     * @return A valid Amazon SQS ARN. For example, <code>arn:aws:sqs:region:account:sqs</code>.
     */
    public final String eventQueueArn() {
        return eventQueueArn;
    }

    /**
     * <p>
     * A valid Amazon dead-letter SQS ARN. For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code>.
     * </p>
     * 
     * @return A valid Amazon dead-letter SQS ARN. For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code>.
     */
    public final String dlqEventQueueArn() {
        return dlqEventQueueArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTables() ? tables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(eventQueueArn());
        hashCode = 31 * hashCode + Objects.hashCode(dlqEventQueueArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogTarget)) {
            return false;
        }
        CatalogTarget other = (CatalogTarget) obj;
        return Objects.equals(databaseName(), other.databaseName()) && hasTables() == other.hasTables()
                && Objects.equals(tables(), other.tables()) && Objects.equals(connectionName(), other.connectionName())
                && Objects.equals(eventQueueArn(), other.eventQueueArn())
                && Objects.equals(dlqEventQueueArn(), other.dlqEventQueueArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CatalogTarget").add("DatabaseName", databaseName()).add("Tables", hasTables() ? tables() : null)
                .add("ConnectionName", connectionName()).add("EventQueueArn", eventQueueArn())
                .add("DlqEventQueueArn", dlqEventQueueArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "Tables":
            return Optional.ofNullable(clazz.cast(tables()));
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "EventQueueArn":
            return Optional.ofNullable(clazz.cast(eventQueueArn()));
        case "DlqEventQueueArn":
            return Optional.ofNullable(clazz.cast(dlqEventQueueArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("Tables", TABLES_FIELD);
        map.put("ConnectionName", CONNECTION_NAME_FIELD);
        map.put("EventQueueArn", EVENT_QUEUE_ARN_FIELD);
        map.put("DlqEventQueueArn", DLQ_EVENT_QUEUE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CatalogTarget, T> g) {
        return obj -> g.apply((CatalogTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CatalogTarget> {
        /**
         * <p>
         * The name of the database to be synchronized.
         * </p>
         * 
         * @param databaseName
         *        The name of the database to be synchronized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A list of the tables to be synchronized.
         * </p>
         * 
         * @param tables
         *        A list of the tables to be synchronized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tables(Collection<String> tables);

        /**
         * <p>
         * A list of the tables to be synchronized.
         * </p>
         * 
         * @param tables
         *        A list of the tables to be synchronized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tables(String... tables);

        /**
         * <p>
         * The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using
         * a <code>Catalog</code> connection type paired with a <code>NETWORK</code> Connection type.
         * </p>
         * 
         * @param connectionName
         *        The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when
         *        using a <code>Catalog</code> connection type paired with a <code>NETWORK</code> Connection type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * A valid Amazon SQS ARN. For example, <code>arn:aws:sqs:region:account:sqs</code>.
         * </p>
         * 
         * @param eventQueueArn
         *        A valid Amazon SQS ARN. For example, <code>arn:aws:sqs:region:account:sqs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventQueueArn(String eventQueueArn);

        /**
         * <p>
         * A valid Amazon dead-letter SQS ARN. For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code>.
         * </p>
         * 
         * @param dlqEventQueueArn
         *        A valid Amazon dead-letter SQS ARN. For example,
         *        <code>arn:aws:sqs:region:account:deadLetterQueue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dlqEventQueueArn(String dlqEventQueueArn);
    }

    static final class BuilderImpl implements Builder {
        private String databaseName;

        private List<String> tables = DefaultSdkAutoConstructList.getInstance();

        private String connectionName;

        private String eventQueueArn;

        private String dlqEventQueueArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogTarget model) {
            databaseName(model.databaseName);
            tables(model.tables);
            connectionName(model.connectionName);
            eventQueueArn(model.eventQueueArn);
            dlqEventQueueArn(model.dlqEventQueueArn);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final Collection<String> getTables() {
            if (tables instanceof SdkAutoConstructList) {
                return null;
            }
            return tables;
        }

        public final void setTables(Collection<String> tables) {
            this.tables = CatalogTablesListCopier.copy(tables);
        }

        @Override
        public final Builder tables(Collection<String> tables) {
            this.tables = CatalogTablesListCopier.copy(tables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(String... tables) {
            tables(Arrays.asList(tables));
            return this;
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getEventQueueArn() {
            return eventQueueArn;
        }

        public final void setEventQueueArn(String eventQueueArn) {
            this.eventQueueArn = eventQueueArn;
        }

        @Override
        public final Builder eventQueueArn(String eventQueueArn) {
            this.eventQueueArn = eventQueueArn;
            return this;
        }

        public final String getDlqEventQueueArn() {
            return dlqEventQueueArn;
        }

        public final void setDlqEventQueueArn(String dlqEventQueueArn) {
            this.dlqEventQueueArn = dlqEventQueueArn;
        }

        @Override
        public final Builder dlqEventQueueArn(String dlqEventQueueArn) {
            this.dlqEventQueueArn = dlqEventQueueArn;
            return this;
        }

        @Override
        public CatalogTarget build() {
            return new CatalogTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
