/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetTableOptimizerResponse extends GlueResponse implements
        ToCopyableBuilder<BatchGetTableOptimizerResponse.Builder, BatchGetTableOptimizerResponse> {
    private static final SdkField<List<BatchTableOptimizer>> TABLE_OPTIMIZERS_FIELD = SdkField
            .<List<BatchTableOptimizer>> builder(MarshallingType.LIST)
            .memberName("TableOptimizers")
            .getter(getter(BatchGetTableOptimizerResponse::tableOptimizers))
            .setter(setter(Builder::tableOptimizers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableOptimizers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchTableOptimizer> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchTableOptimizer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetTableOptimizerError>> FAILURES_FIELD = SdkField
            .<List<BatchGetTableOptimizerError>> builder(MarshallingType.LIST)
            .memberName("Failures")
            .getter(getter(BatchGetTableOptimizerResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetTableOptimizerError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetTableOptimizerError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_OPTIMIZERS_FIELD,
            FAILURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchTableOptimizer> tableOptimizers;

    private final List<BatchGetTableOptimizerError> failures;

    private BatchGetTableOptimizerResponse(BuilderImpl builder) {
        super(builder);
        this.tableOptimizers = builder.tableOptimizers;
        this.failures = builder.failures;
    }

    /**
     * For responses, this returns true if the service returned a value for the TableOptimizers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTableOptimizers() {
        return tableOptimizers != null && !(tableOptimizers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>BatchTableOptimizer</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTableOptimizers} method.
     * </p>
     * 
     * @return A list of <code>BatchTableOptimizer</code> objects.
     */
    public final List<BatchTableOptimizer> tableOptimizers() {
        return tableOptimizers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failures property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors from the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailures} method.
     * </p>
     * 
     * @return A list of errors from the operation.
     */
    public final List<BatchGetTableOptimizerError> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTableOptimizers() ? tableOptimizers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailures() ? failures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTableOptimizerResponse)) {
            return false;
        }
        BatchGetTableOptimizerResponse other = (BatchGetTableOptimizerResponse) obj;
        return hasTableOptimizers() == other.hasTableOptimizers() && Objects.equals(tableOptimizers(), other.tableOptimizers())
                && hasFailures() == other.hasFailures() && Objects.equals(failures(), other.failures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetTableOptimizerResponse")
                .add("TableOptimizers", hasTableOptimizers() ? tableOptimizers() : null)
                .add("Failures", hasFailures() ? failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableOptimizers":
            return Optional.ofNullable(clazz.cast(tableOptimizers()));
        case "Failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TableOptimizers", TABLE_OPTIMIZERS_FIELD);
        map.put("Failures", FAILURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTableOptimizerResponse, T> g) {
        return obj -> g.apply((BatchGetTableOptimizerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetTableOptimizerResponse> {
        /**
         * <p>
         * A list of <code>BatchTableOptimizer</code> objects.
         * </p>
         * 
         * @param tableOptimizers
         *        A list of <code>BatchTableOptimizer</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableOptimizers(Collection<BatchTableOptimizer> tableOptimizers);

        /**
         * <p>
         * A list of <code>BatchTableOptimizer</code> objects.
         * </p>
         * 
         * @param tableOptimizers
         *        A list of <code>BatchTableOptimizer</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableOptimizers(BatchTableOptimizer... tableOptimizers);

        /**
         * <p>
         * A list of <code>BatchTableOptimizer</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.BatchTableOptimizer.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.BatchTableOptimizer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.BatchTableOptimizer.Builder#build()} is called immediately
         * and its result is passed to {@link #tableOptimizers(List<BatchTableOptimizer>)}.
         * 
         * @param tableOptimizers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.BatchTableOptimizer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableOptimizers(java.util.Collection<BatchTableOptimizer>)
         */
        Builder tableOptimizers(Consumer<BatchTableOptimizer.Builder>... tableOptimizers);

        /**
         * <p>
         * A list of errors from the operation.
         * </p>
         * 
         * @param failures
         *        A list of errors from the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<BatchGetTableOptimizerError> failures);

        /**
         * <p>
         * A list of errors from the operation.
         * </p>
         * 
         * @param failures
         *        A list of errors from the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(BatchGetTableOptimizerError... failures);

        /**
         * <p>
         * A list of errors from the operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.BatchGetTableOptimizerError.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.glue.model.BatchGetTableOptimizerError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.BatchGetTableOptimizerError.Builder#build()} is called
         * immediately and its result is passed to {@link #failures(List<BatchGetTableOptimizerError>)}.
         * 
         * @param failures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.BatchGetTableOptimizerError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(java.util.Collection<BatchGetTableOptimizerError>)
         */
        Builder failures(Consumer<BatchGetTableOptimizerError.Builder>... failures);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<BatchTableOptimizer> tableOptimizers = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetTableOptimizerError> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTableOptimizerResponse model) {
            super(model);
            tableOptimizers(model.tableOptimizers);
            failures(model.failures);
        }

        public final List<BatchTableOptimizer.Builder> getTableOptimizers() {
            List<BatchTableOptimizer.Builder> result = BatchTableOptimizersCopier.copyToBuilder(this.tableOptimizers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableOptimizers(Collection<BatchTableOptimizer.BuilderImpl> tableOptimizers) {
            this.tableOptimizers = BatchTableOptimizersCopier.copyFromBuilder(tableOptimizers);
        }

        @Override
        public final Builder tableOptimizers(Collection<BatchTableOptimizer> tableOptimizers) {
            this.tableOptimizers = BatchTableOptimizersCopier.copy(tableOptimizers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableOptimizers(BatchTableOptimizer... tableOptimizers) {
            tableOptimizers(Arrays.asList(tableOptimizers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableOptimizers(Consumer<BatchTableOptimizer.Builder>... tableOptimizers) {
            tableOptimizers(Stream.of(tableOptimizers).map(c -> BatchTableOptimizer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetTableOptimizerError.Builder> getFailures() {
            List<BatchGetTableOptimizerError.Builder> result = BatchGetTableOptimizerErrorsCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<BatchGetTableOptimizerError.BuilderImpl> failures) {
            this.failures = BatchGetTableOptimizerErrorsCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<BatchGetTableOptimizerError> failures) {
            this.failures = BatchGetTableOptimizerErrorsCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(BatchGetTableOptimizerError... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<BatchGetTableOptimizerError.Builder>... failures) {
            failures(Stream.of(failures).map(c -> BatchGetTableOptimizerError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetTableOptimizerResponse build() {
            return new BatchGetTableOptimizerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
