/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing the Lake Formation audit context.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditContext implements SdkPojo, Serializable, ToCopyableBuilder<AuditContext.Builder, AuditContext> {
    private static final SdkField<String> ADDITIONAL_AUDIT_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdditionalAuditContext").getter(getter(AuditContext::additionalAuditContext))
            .setter(setter(Builder::additionalAuditContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAuditContext").build())
            .build();

    private static final SdkField<List<String>> REQUESTED_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RequestedColumns")
            .getter(getter(AuditContext::requestedColumns))
            .setter(setter(Builder::requestedColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALL_COLUMNS_REQUESTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllColumnsRequested").getter(getter(AuditContext::allColumnsRequested))
            .setter(setter(Builder::allColumnsRequested))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllColumnsRequested").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDITIONAL_AUDIT_CONTEXT_FIELD, REQUESTED_COLUMNS_FIELD, ALL_COLUMNS_REQUESTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String additionalAuditContext;

    private final List<String> requestedColumns;

    private final Boolean allColumnsRequested;

    private AuditContext(BuilderImpl builder) {
        this.additionalAuditContext = builder.additionalAuditContext;
        this.requestedColumns = builder.requestedColumns;
        this.allColumnsRequested = builder.allColumnsRequested;
    }

    /**
     * <p>
     * A string containing the additional audit context information.
     * </p>
     * 
     * @return A string containing the additional audit context information.
     */
    public final String additionalAuditContext() {
        return additionalAuditContext;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestedColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequestedColumns() {
        return requestedColumns != null && !(requestedColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The requested columns for audit.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestedColumns} method.
     * </p>
     * 
     * @return The requested columns for audit.
     */
    public final List<String> requestedColumns() {
        return requestedColumns;
    }

    /**
     * <p>
     * All columns request for audit.
     * </p>
     * 
     * @return All columns request for audit.
     */
    public final Boolean allColumnsRequested() {
        return allColumnsRequested;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalAuditContext());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestedColumns() ? requestedColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allColumnsRequested());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditContext)) {
            return false;
        }
        AuditContext other = (AuditContext) obj;
        return Objects.equals(additionalAuditContext(), other.additionalAuditContext())
                && hasRequestedColumns() == other.hasRequestedColumns()
                && Objects.equals(requestedColumns(), other.requestedColumns())
                && Objects.equals(allColumnsRequested(), other.allColumnsRequested());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuditContext").add("AdditionalAuditContext", additionalAuditContext())
                .add("RequestedColumns", hasRequestedColumns() ? requestedColumns() : null)
                .add("AllColumnsRequested", allColumnsRequested()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalAuditContext":
            return Optional.ofNullable(clazz.cast(additionalAuditContext()));
        case "RequestedColumns":
            return Optional.ofNullable(clazz.cast(requestedColumns()));
        case "AllColumnsRequested":
            return Optional.ofNullable(clazz.cast(allColumnsRequested()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdditionalAuditContext", ADDITIONAL_AUDIT_CONTEXT_FIELD);
        map.put("RequestedColumns", REQUESTED_COLUMNS_FIELD);
        map.put("AllColumnsRequested", ALL_COLUMNS_REQUESTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditContext, T> g) {
        return obj -> g.apply((AuditContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditContext> {
        /**
         * <p>
         * A string containing the additional audit context information.
         * </p>
         * 
         * @param additionalAuditContext
         *        A string containing the additional audit context information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAuditContext(String additionalAuditContext);

        /**
         * <p>
         * The requested columns for audit.
         * </p>
         * 
         * @param requestedColumns
         *        The requested columns for audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedColumns(Collection<String> requestedColumns);

        /**
         * <p>
         * The requested columns for audit.
         * </p>
         * 
         * @param requestedColumns
         *        The requested columns for audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedColumns(String... requestedColumns);

        /**
         * <p>
         * All columns request for audit.
         * </p>
         * 
         * @param allColumnsRequested
         *        All columns request for audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allColumnsRequested(Boolean allColumnsRequested);
    }

    static final class BuilderImpl implements Builder {
        private String additionalAuditContext;

        private List<String> requestedColumns = DefaultSdkAutoConstructList.getInstance();

        private Boolean allColumnsRequested;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditContext model) {
            additionalAuditContext(model.additionalAuditContext);
            requestedColumns(model.requestedColumns);
            allColumnsRequested(model.allColumnsRequested);
        }

        public final String getAdditionalAuditContext() {
            return additionalAuditContext;
        }

        public final void setAdditionalAuditContext(String additionalAuditContext) {
            this.additionalAuditContext = additionalAuditContext;
        }

        @Override
        public final Builder additionalAuditContext(String additionalAuditContext) {
            this.additionalAuditContext = additionalAuditContext;
            return this;
        }

        public final Collection<String> getRequestedColumns() {
            if (requestedColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return requestedColumns;
        }

        public final void setRequestedColumns(Collection<String> requestedColumns) {
            this.requestedColumns = AuditColumnNamesListCopier.copy(requestedColumns);
        }

        @Override
        public final Builder requestedColumns(Collection<String> requestedColumns) {
            this.requestedColumns = AuditColumnNamesListCopier.copy(requestedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedColumns(String... requestedColumns) {
            requestedColumns(Arrays.asList(requestedColumns));
            return this;
        }

        public final Boolean getAllColumnsRequested() {
            return allColumnsRequested;
        }

        public final void setAllColumnsRequested(Boolean allColumnsRequested) {
            this.allColumnsRequested = allColumnsRequested;
        }

        @Override
        public final Builder allColumnsRequested(Boolean allColumnsRequested) {
            this.allColumnsRequested = allColumnsRequested;
            return this;
        }

        @Override
        public AuditContext build() {
            return new AuditContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
