/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Language {
    PYTHON("PYTHON"),
    SCALA("SCALA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Language(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Language fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Language.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Language> knownValues() {
        return Stream.of(Language.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

