/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.GenericMapCopier;
import software.amazon.awssdk.services.glue.model.JobRunState;
import software.amazon.awssdk.services.glue.model.NotificationProperty;
import software.amazon.awssdk.services.glue.model.Predecessor;
import software.amazon.awssdk.services.glue.model.PredecessorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobRun> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobRun.getter(JobRun::id)).setter(JobRun.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Integer> ATTEMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobRun.getter(JobRun::attempt)).setter(JobRun.setter(Builder::attempt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attempt").build()}).build();
    private static final SdkField<String> PREVIOUS_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobRun.getter(JobRun::previousRunId)).setter(JobRun.setter(Builder::previousRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousRunId").build()}).build();
    private static final SdkField<String> TRIGGER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobRun.getter(JobRun::triggerName)).setter(JobRun.setter(Builder::triggerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerName").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobRun.getter(JobRun::jobName)).setter(JobRun.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(JobRun.getter(JobRun::startedOn)).setter(JobRun.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(JobRun.getter(JobRun::lastModifiedOn)).setter(JobRun.setter(Builder::lastModifiedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()}).build();
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(JobRun.getter(JobRun::completedOn)).setter(JobRun.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()}).build();
    private static final SdkField<String> JOB_RUN_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobRun.getter(JobRun::jobRunStateAsString)).setter(JobRun.setter(Builder::jobRunState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunState").build()}).build();
    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(JobRun.getter(JobRun::arguments)).setter(JobRun.setter(Builder::arguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobRun.getter(JobRun::errorMessage)).setter(JobRun.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<List<Predecessor>> PREDECESSOR_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(JobRun.getter(JobRun::predecessorRuns)).setter(JobRun.setter(Builder::predecessorRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredecessorRuns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Predecessor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> ALLOCATED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobRun.getter(JobRun::allocatedCapacity)).setter(JobRun.setter(Builder::allocatedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedCapacity").build()}).build();
    private static final SdkField<Integer> EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobRun.getter(JobRun::executionTime)).setter(JobRun.setter(Builder::executionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobRun.getter(JobRun::timeout)).setter(JobRun.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<NotificationProperty> NOTIFICATION_PROPERTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobRun.getter(JobRun::notificationProperty)).setter(JobRun.setter(Builder::notificationProperty)).constructor(NotificationProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationProperty").build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobRun.getter(JobRun::securityConfiguration)).setter(JobRun.setter(Builder::securityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobRun.getter(JobRun::logGroupName)).setter(JobRun.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ATTEMPT_FIELD, PREVIOUS_RUN_ID_FIELD, TRIGGER_NAME_FIELD, JOB_NAME_FIELD, STARTED_ON_FIELD, LAST_MODIFIED_ON_FIELD, COMPLETED_ON_FIELD, JOB_RUN_STATE_FIELD, ARGUMENTS_FIELD, ERROR_MESSAGE_FIELD, PREDECESSOR_RUNS_FIELD, ALLOCATED_CAPACITY_FIELD, EXECUTION_TIME_FIELD, TIMEOUT_FIELD, NOTIFICATION_PROPERTY_FIELD, SECURITY_CONFIGURATION_FIELD, LOG_GROUP_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Integer attempt;
    private final String previousRunId;
    private final String triggerName;
    private final String jobName;
    private final Instant startedOn;
    private final Instant lastModifiedOn;
    private final Instant completedOn;
    private final String jobRunState;
    private final Map<String, String> arguments;
    private final String errorMessage;
    private final List<Predecessor> predecessorRuns;
    private final Integer allocatedCapacity;
    private final Integer executionTime;
    private final Integer timeout;
    private final NotificationProperty notificationProperty;
    private final String securityConfiguration;
    private final String logGroupName;

    private JobRun(BuilderImpl builder) {
        this.id = builder.id;
        this.attempt = builder.attempt;
        this.previousRunId = builder.previousRunId;
        this.triggerName = builder.triggerName;
        this.jobName = builder.jobName;
        this.startedOn = builder.startedOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.completedOn = builder.completedOn;
        this.jobRunState = builder.jobRunState;
        this.arguments = builder.arguments;
        this.errorMessage = builder.errorMessage;
        this.predecessorRuns = builder.predecessorRuns;
        this.allocatedCapacity = builder.allocatedCapacity;
        this.executionTime = builder.executionTime;
        this.timeout = builder.timeout;
        this.notificationProperty = builder.notificationProperty;
        this.securityConfiguration = builder.securityConfiguration;
        this.logGroupName = builder.logGroupName;
    }

    public String id() {
        return this.id;
    }

    public Integer attempt() {
        return this.attempt;
    }

    public String previousRunId() {
        return this.previousRunId;
    }

    public String triggerName() {
        return this.triggerName;
    }

    public String jobName() {
        return this.jobName;
    }

    public Instant startedOn() {
        return this.startedOn;
    }

    public Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public Instant completedOn() {
        return this.completedOn;
    }

    public JobRunState jobRunState() {
        return JobRunState.fromValue(this.jobRunState);
    }

    public String jobRunStateAsString() {
        return this.jobRunState;
    }

    public Map<String, String> arguments() {
        return this.arguments;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<Predecessor> predecessorRuns() {
        return this.predecessorRuns;
    }

    public Integer allocatedCapacity() {
        return this.allocatedCapacity;
    }

    public Integer executionTime() {
        return this.executionTime;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public NotificationProperty notificationProperty() {
        return this.notificationProperty;
    }

    public String securityConfiguration() {
        return this.securityConfiguration;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.attempt());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arguments());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.predecessorRuns());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationProperty());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobRun)) {
            return false;
        }
        JobRun other = (JobRun)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.attempt(), other.attempt()) && Objects.equals(this.previousRunId(), other.previousRunId()) && Objects.equals(this.triggerName(), other.triggerName()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.jobRunStateAsString(), other.jobRunStateAsString()) && Objects.equals(this.arguments(), other.arguments()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.predecessorRuns(), other.predecessorRuns()) && Objects.equals(this.allocatedCapacity(), other.allocatedCapacity()) && Objects.equals(this.executionTime(), other.executionTime()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.notificationProperty(), other.notificationProperty()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && Objects.equals(this.logGroupName(), other.logGroupName());
    }

    public String toString() {
        return ToString.builder((String)"JobRun").add("Id", (Object)this.id()).add("Attempt", (Object)this.attempt()).add("PreviousRunId", (Object)this.previousRunId()).add("TriggerName", (Object)this.triggerName()).add("JobName", (Object)this.jobName()).add("StartedOn", (Object)this.startedOn()).add("LastModifiedOn", (Object)this.lastModifiedOn()).add("CompletedOn", (Object)this.completedOn()).add("JobRunState", (Object)this.jobRunStateAsString()).add("Arguments", this.arguments()).add("ErrorMessage", (Object)this.errorMessage()).add("PredecessorRuns", this.predecessorRuns()).add("AllocatedCapacity", (Object)this.allocatedCapacity()).add("ExecutionTime", (Object)this.executionTime()).add("Timeout", (Object)this.timeout()).add("NotificationProperty", (Object)this.notificationProperty()).add("SecurityConfiguration", (Object)this.securityConfiguration()).add("LogGroupName", (Object)this.logGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Attempt": {
                return Optional.ofNullable(clazz.cast(this.attempt()));
            }
            case "PreviousRunId": {
                return Optional.ofNullable(clazz.cast(this.previousRunId()));
            }
            case "TriggerName": {
                return Optional.ofNullable(clazz.cast(this.triggerName()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "StartedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "LastModifiedOn": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedOn()));
            }
            case "CompletedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "JobRunState": {
                return Optional.ofNullable(clazz.cast(this.jobRunStateAsString()));
            }
            case "Arguments": {
                return Optional.ofNullable(clazz.cast(this.arguments()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "PredecessorRuns": {
                return Optional.ofNullable(clazz.cast(this.predecessorRuns()));
            }
            case "AllocatedCapacity": {
                return Optional.ofNullable(clazz.cast(this.allocatedCapacity()));
            }
            case "ExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.executionTime()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "NotificationProperty": {
                return Optional.ofNullable(clazz.cast(this.notificationProperty()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
            case "LogGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobRun, T> g) {
        return obj -> g.apply((JobRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Integer attempt;
        private String previousRunId;
        private String triggerName;
        private String jobName;
        private Instant startedOn;
        private Instant lastModifiedOn;
        private Instant completedOn;
        private String jobRunState;
        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();
        private String errorMessage;
        private List<Predecessor> predecessorRuns = DefaultSdkAutoConstructList.getInstance();
        private Integer allocatedCapacity;
        private Integer executionTime;
        private Integer timeout;
        private NotificationProperty notificationProperty;
        private String securityConfiguration;
        private String logGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(JobRun model) {
            this.id(model.id);
            this.attempt(model.attempt);
            this.previousRunId(model.previousRunId);
            this.triggerName(model.triggerName);
            this.jobName(model.jobName);
            this.startedOn(model.startedOn);
            this.lastModifiedOn(model.lastModifiedOn);
            this.completedOn(model.completedOn);
            this.jobRunState(model.jobRunState);
            this.arguments(model.arguments);
            this.errorMessage(model.errorMessage);
            this.predecessorRuns(model.predecessorRuns);
            this.allocatedCapacity(model.allocatedCapacity);
            this.executionTime(model.executionTime);
            this.timeout(model.timeout);
            this.notificationProperty(model.notificationProperty);
            this.securityConfiguration(model.securityConfiguration);
            this.logGroupName(model.logGroupName);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Integer getAttempt() {
            return this.attempt;
        }

        @Override
        public final Builder attempt(Integer attempt) {
            this.attempt = attempt;
            return this;
        }

        public final void setAttempt(Integer attempt) {
            this.attempt = attempt;
        }

        public final String getPreviousRunId() {
            return this.previousRunId;
        }

        @Override
        public final Builder previousRunId(String previousRunId) {
            this.previousRunId = previousRunId;
            return this;
        }

        public final void setPreviousRunId(String previousRunId) {
            this.previousRunId = previousRunId;
        }

        public final String getTriggerName() {
            return this.triggerName;
        }

        @Override
        public final Builder triggerName(String triggerName) {
            this.triggerName = triggerName;
            return this;
        }

        public final void setTriggerName(String triggerName) {
            this.triggerName = triggerName;
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        public final String getJobRunStateAsString() {
            return this.jobRunState;
        }

        @Override
        public final Builder jobRunState(String jobRunState) {
            this.jobRunState = jobRunState;
            return this;
        }

        @Override
        public final Builder jobRunState(JobRunState jobRunState) {
            this.jobRunState(jobRunState.toString());
            return this;
        }

        public final void setJobRunState(String jobRunState) {
            this.jobRunState = jobRunState;
        }

        public final Map<String, String> getArguments() {
            return this.arguments;
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
            return this;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Collection<Predecessor.Builder> getPredecessorRuns() {
            return this.predecessorRuns != null ? (Collection)this.predecessorRuns.stream().map(Predecessor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder predecessorRuns(Collection<Predecessor> predecessorRuns) {
            this.predecessorRuns = PredecessorListCopier.copy(predecessorRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predecessorRuns(Predecessor ... predecessorRuns) {
            this.predecessorRuns(Arrays.asList(predecessorRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predecessorRuns(Consumer<Predecessor.Builder> ... predecessorRuns) {
            this.predecessorRuns(Stream.of(predecessorRuns).map(c -> (Predecessor)((Predecessor.Builder)Predecessor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPredecessorRuns(Collection<Predecessor.BuilderImpl> predecessorRuns) {
            this.predecessorRuns = PredecessorListCopier.copyFromBuilder(predecessorRuns);
        }

        public final Integer getAllocatedCapacity() {
            return this.allocatedCapacity;
        }

        @Override
        public final Builder allocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
            return this;
        }

        public final void setAllocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
        }

        public final Integer getExecutionTime() {
            return this.executionTime;
        }

        @Override
        public final Builder executionTime(Integer executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final void setExecutionTime(Integer executionTime) {
            this.executionTime = executionTime;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final NotificationProperty.Builder getNotificationProperty() {
            return this.notificationProperty != null ? this.notificationProperty.toBuilder() : null;
        }

        @Override
        public final Builder notificationProperty(NotificationProperty notificationProperty) {
            this.notificationProperty = notificationProperty;
            return this;
        }

        public final void setNotificationProperty(NotificationProperty.BuilderImpl notificationProperty) {
            this.notificationProperty = notificationProperty != null ? notificationProperty.build() : null;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public JobRun build() {
            return new JobRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobRun> {
        public Builder id(String var1);

        public Builder attempt(Integer var1);

        public Builder previousRunId(String var1);

        public Builder triggerName(String var1);

        public Builder jobName(String var1);

        public Builder startedOn(Instant var1);

        public Builder lastModifiedOn(Instant var1);

        public Builder completedOn(Instant var1);

        public Builder jobRunState(String var1);

        public Builder jobRunState(JobRunState var1);

        public Builder arguments(Map<String, String> var1);

        public Builder errorMessage(String var1);

        public Builder predecessorRuns(Collection<Predecessor> var1);

        public Builder predecessorRuns(Predecessor ... var1);

        public Builder predecessorRuns(Consumer<Predecessor.Builder> ... var1);

        public Builder allocatedCapacity(Integer var1);

        public Builder executionTime(Integer var1);

        public Builder timeout(Integer var1);

        public Builder notificationProperty(NotificationProperty var1);

        default public Builder notificationProperty(Consumer<NotificationProperty.Builder> notificationProperty) {
            return this.notificationProperty((NotificationProperty)((NotificationProperty.Builder)NotificationProperty.builder().applyMutation(notificationProperty)).build());
        }

        public Builder securityConfiguration(String var1);

        public Builder logGroupName(String var1);
    }
}

