/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionValueListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.Partition;
import software.amazon.awssdk.services.glue.model.PartitionListCopier;
import software.amazon.awssdk.services.glue.model.PartitionValueList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetPartitionResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchGetPartitionResponse> {
    private static final SdkField<List<Partition>> PARTITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Partitions").getter(BatchGetPartitionResponse.getter(BatchGetPartitionResponse::partitions)).setter(BatchGetPartitionResponse.setter(Builder::partitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Partition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PartitionValueList>> UNPROCESSED_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedKeys").getter(BatchGetPartitionResponse.getter(BatchGetPartitionResponse::unprocessedKeys)).setter(BatchGetPartitionResponse.setter(Builder::unprocessedKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartitionValueList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITIONS_FIELD, UNPROCESSED_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Partitions", PARTITIONS_FIELD);
            this.put("UnprocessedKeys", UNPROCESSED_KEYS_FIELD);
        }
    });
    private final List<Partition> partitions;
    private final List<PartitionValueList> unprocessedKeys;

    private BatchGetPartitionResponse(BuilderImpl builder) {
        super(builder);
        this.partitions = builder.partitions;
        this.unprocessedKeys = builder.unprocessedKeys;
    }

    public final boolean hasPartitions() {
        return this.partitions != null && !(this.partitions instanceof SdkAutoConstructList);
    }

    public final List<Partition> partitions() {
        return this.partitions;
    }

    public final boolean hasUnprocessedKeys() {
        return this.unprocessedKeys != null && !(this.unprocessedKeys instanceof SdkAutoConstructList);
    }

    public final List<PartitionValueList> unprocessedKeys() {
        return this.unprocessedKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitions() ? this.partitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedKeys() ? this.unprocessedKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetPartitionResponse)) {
            return false;
        }
        BatchGetPartitionResponse other = (BatchGetPartitionResponse)((Object)obj);
        return this.hasPartitions() == other.hasPartitions() && Objects.equals(this.partitions(), other.partitions()) && this.hasUnprocessedKeys() == other.hasUnprocessedKeys() && Objects.equals(this.unprocessedKeys(), other.unprocessedKeys());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetPartitionResponse").add("Partitions", this.hasPartitions() ? this.partitions() : null).add("UnprocessedKeys", this.hasUnprocessedKeys() ? this.unprocessedKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Partitions": {
                return Optional.ofNullable(clazz.cast(this.partitions()));
            }
            case "UnprocessedKeys": {
                return Optional.ofNullable(clazz.cast(this.unprocessedKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetPartitionResponse, T> g) {
        return obj -> g.apply((BatchGetPartitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Partition> partitions = DefaultSdkAutoConstructList.getInstance();
        private List<PartitionValueList> unprocessedKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetPartitionResponse model) {
            super(model);
            this.partitions(model.partitions);
            this.unprocessedKeys(model.unprocessedKeys);
        }

        public final List<Partition.Builder> getPartitions() {
            List<Partition.Builder> result = PartitionListCopier.copyToBuilder(this.partitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartitions(Collection<Partition.BuilderImpl> partitions) {
            this.partitions = PartitionListCopier.copyFromBuilder(partitions);
        }

        @Override
        public final Builder partitions(Collection<Partition> partitions) {
            this.partitions = PartitionListCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Partition ... partitions) {
            this.partitions(Arrays.asList(partitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Consumer<Partition.Builder> ... partitions) {
            this.partitions(Stream.of(partitions).map(c -> (Partition)((Partition.Builder)Partition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PartitionValueList.Builder> getUnprocessedKeys() {
            List<PartitionValueList.Builder> result = BatchGetPartitionValueListCopier.copyToBuilder(this.unprocessedKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedKeys(Collection<PartitionValueList.BuilderImpl> unprocessedKeys) {
            this.unprocessedKeys = BatchGetPartitionValueListCopier.copyFromBuilder(unprocessedKeys);
        }

        @Override
        public final Builder unprocessedKeys(Collection<PartitionValueList> unprocessedKeys) {
            this.unprocessedKeys = BatchGetPartitionValueListCopier.copy(unprocessedKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedKeys(PartitionValueList ... unprocessedKeys) {
            this.unprocessedKeys(Arrays.asList(unprocessedKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedKeys(Consumer<PartitionValueList.Builder> ... unprocessedKeys) {
            this.unprocessedKeys(Stream.of(unprocessedKeys).map(c -> (PartitionValueList)((PartitionValueList.Builder)PartitionValueList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetPartitionResponse build() {
            return new BatchGetPartitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetPartitionResponse> {
        public Builder partitions(Collection<Partition> var1);

        public Builder partitions(Partition ... var1);

        public Builder partitions(Consumer<Partition.Builder> ... var1);

        public Builder unprocessedKeys(Collection<PartitionValueList> var1);

        public Builder unprocessedKeys(PartitionValueList ... var1);

        public Builder unprocessedKeys(Consumer<PartitionValueList.Builder> ... var1);
    }
}

