/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueSchema;
import software.amazon.awssdk.services.glue.model.GlueSchemasCopier;
import software.amazon.awssdk.services.glue.model.ManyInputsCopier;
import software.amazon.awssdk.services.glue.model.SqlAlias;
import software.amazon.awssdk.services.glue.model.SqlAliasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SparkSQL
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SparkSQL> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SparkSQL.getter(SparkSQL::name)).setter(SparkSQL.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(SparkSQL.getter(SparkSQL::inputs)).setter(SparkSQL.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SQL_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SqlQuery").getter(SparkSQL.getter(SparkSQL::sqlQuery)).setter(SparkSQL.setter(Builder::sqlQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlQuery").build()}).build();
    private static final SdkField<List<SqlAlias>> SQL_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SqlAliases").getter(SparkSQL.getter(SparkSQL::sqlAliases)).setter(SparkSQL.setter(Builder::sqlAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SqlAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GlueSchema>> OUTPUT_SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputSchemas").getter(SparkSQL.getter(SparkSQL::outputSchemas)).setter(SparkSQL.setter(Builder::outputSchemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSchemas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlueSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, SQL_QUERY_FIELD, SQL_ALIASES_FIELD, OUTPUT_SCHEMAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SparkSQL.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final String sqlQuery;
    private final List<SqlAlias> sqlAliases;
    private final List<GlueSchema> outputSchemas;

    private SparkSQL(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.sqlQuery = builder.sqlQuery;
        this.sqlAliases = builder.sqlAliases;
        this.outputSchemas = builder.outputSchemas;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final String sqlQuery() {
        return this.sqlQuery;
    }

    public final boolean hasSqlAliases() {
        return this.sqlAliases != null && !(this.sqlAliases instanceof SdkAutoConstructList);
    }

    public final List<SqlAlias> sqlAliases() {
        return this.sqlAliases;
    }

    public final boolean hasOutputSchemas() {
        return this.outputSchemas != null && !(this.outputSchemas instanceof SdkAutoConstructList);
    }

    public final List<GlueSchema> outputSchemas() {
        return this.outputSchemas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSqlAliases() ? this.sqlAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputSchemas() ? this.outputSchemas() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparkSQL)) {
            return false;
        }
        SparkSQL other = (SparkSQL)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.sqlQuery(), other.sqlQuery()) && this.hasSqlAliases() == other.hasSqlAliases() && Objects.equals(this.sqlAliases(), other.sqlAliases()) && this.hasOutputSchemas() == other.hasOutputSchemas() && Objects.equals(this.outputSchemas(), other.outputSchemas());
    }

    public final String toString() {
        return ToString.builder((String)"SparkSQL").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("SqlQuery", (Object)this.sqlQuery()).add("SqlAliases", this.hasSqlAliases() ? this.sqlAliases() : null).add("OutputSchemas", this.hasOutputSchemas() ? this.outputSchemas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "SqlQuery": {
                return Optional.ofNullable(clazz.cast(this.sqlQuery()));
            }
            case "SqlAliases": {
                return Optional.ofNullable(clazz.cast(this.sqlAliases()));
            }
            case "OutputSchemas": {
                return Optional.ofNullable(clazz.cast(this.outputSchemas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("SqlQuery", SQL_QUERY_FIELD);
        map.put("SqlAliases", SQL_ALIASES_FIELD);
        map.put("OutputSchemas", OUTPUT_SCHEMAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SparkSQL, T> g) {
        return obj -> g.apply((SparkSQL)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private String sqlQuery;
        private List<SqlAlias> sqlAliases = DefaultSdkAutoConstructList.getInstance();
        private List<GlueSchema> outputSchemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SparkSQL model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.sqlQuery(model.sqlQuery);
            this.sqlAliases(model.sqlAliases);
            this.outputSchemas(model.outputSchemas);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = ManyInputsCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = ManyInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getSqlQuery() {
            return this.sqlQuery;
        }

        public final void setSqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
        }

        @Override
        public final Builder sqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
            return this;
        }

        public final List<SqlAlias.Builder> getSqlAliases() {
            List<SqlAlias.Builder> result = SqlAliasesCopier.copyToBuilder(this.sqlAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSqlAliases(Collection<SqlAlias.BuilderImpl> sqlAliases) {
            this.sqlAliases = SqlAliasesCopier.copyFromBuilder(sqlAliases);
        }

        @Override
        public final Builder sqlAliases(Collection<SqlAlias> sqlAliases) {
            this.sqlAliases = SqlAliasesCopier.copy(sqlAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlAliases(SqlAlias ... sqlAliases) {
            this.sqlAliases(Arrays.asList(sqlAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlAliases(Consumer<SqlAlias.Builder> ... sqlAliases) {
            this.sqlAliases(Stream.of(sqlAliases).map(c -> (SqlAlias)((SqlAlias.Builder)SqlAlias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GlueSchema.Builder> getOutputSchemas() {
            List<GlueSchema.Builder> result = GlueSchemasCopier.copyToBuilder(this.outputSchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSchemas(Collection<GlueSchema.BuilderImpl> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copyFromBuilder(outputSchemas);
        }

        @Override
        public final Builder outputSchemas(Collection<GlueSchema> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copy(outputSchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(GlueSchema ... outputSchemas) {
            this.outputSchemas(Arrays.asList(outputSchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(Consumer<GlueSchema.Builder> ... outputSchemas) {
            this.outputSchemas(Stream.of(outputSchemas).map(c -> (GlueSchema)((GlueSchema.Builder)GlueSchema.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SparkSQL build() {
            return new SparkSQL(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SparkSQL> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder sqlQuery(String var1);

        public Builder sqlAliases(Collection<SqlAlias> var1);

        public Builder sqlAliases(SqlAlias ... var1);

        public Builder sqlAliases(Consumer<SqlAlias.Builder> ... var1);

        public Builder outputSchemas(Collection<GlueSchema> var1);

        public Builder outputSchemas(GlueSchema ... var1);

        public Builder outputSchemas(Consumer<GlueSchema.Builder> ... var1);
    }
}

