/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.FederationSourceErrorCode;
import software.amazon.awssdk.services.glue.model.GlueException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FederationSourceException
extends GlueException
implements ToCopyableBuilder<Builder, FederationSourceException> {
    private static final SdkField<String> FEDERATION_SOURCE_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FederationSourceErrorCode").getter(FederationSourceException.getter(FederationSourceException::federationSourceErrorCodeAsString)).setter(FederationSourceException.setter(Builder::federationSourceErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederationSourceErrorCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEDERATION_SOURCE_ERROR_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FederationSourceException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String federationSourceErrorCode;

    private FederationSourceException(BuilderImpl builder) {
        super(builder);
        this.federationSourceErrorCode = builder.federationSourceErrorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public FederationSourceErrorCode federationSourceErrorCode() {
        return FederationSourceErrorCode.fromValue(this.federationSourceErrorCode);
    }

    public String federationSourceErrorCodeAsString() {
        return this.federationSourceErrorCode;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FederationSourceErrorCode", FEDERATION_SOURCE_ERROR_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FederationSourceException, T> g) {
        return obj -> g.apply((FederationSourceException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueException.BuilderImpl
    implements Builder {
        private String federationSourceErrorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(FederationSourceException model) {
            super(model);
            this.federationSourceErrorCode(model.federationSourceErrorCode);
        }

        public final String getFederationSourceErrorCode() {
            return this.federationSourceErrorCode;
        }

        public final void setFederationSourceErrorCode(String federationSourceErrorCode) {
            this.federationSourceErrorCode = federationSourceErrorCode;
        }

        @Override
        public final Builder federationSourceErrorCode(String federationSourceErrorCode) {
            this.federationSourceErrorCode = federationSourceErrorCode;
            return this;
        }

        @Override
        public final Builder federationSourceErrorCode(FederationSourceErrorCode federationSourceErrorCode) {
            this.federationSourceErrorCode(federationSourceErrorCode == null ? null : federationSourceErrorCode.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public FederationSourceException build() {
            return new FederationSourceException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FederationSourceException>,
    GlueException.Builder {
        public Builder federationSourceErrorCode(String var1);

        public Builder federationSourceErrorCode(FederationSourceErrorCode var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);
    }
}

