/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.BlueprintRunState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlueprintRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlueprintRun> {
    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlueprintName").getter(BlueprintRun.getter(BlueprintRun::blueprintName)).setter(BlueprintRun.setter(Builder::blueprintName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintName").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunId").getter(BlueprintRun.getter(BlueprintRun::runId)).setter(BlueprintRun.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowName").getter(BlueprintRun.getter(BlueprintRun::workflowName)).setter(BlueprintRun.setter(Builder::workflowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(BlueprintRun.getter(BlueprintRun::stateAsString)).setter(BlueprintRun.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedOn").getter(BlueprintRun.getter(BlueprintRun::startedOn)).setter(BlueprintRun.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()}).build();
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedOn").getter(BlueprintRun.getter(BlueprintRun::completedOn)).setter(BlueprintRun.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(BlueprintRun.getter(BlueprintRun::errorMessage)).setter(BlueprintRun.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> ROLLBACK_ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RollbackErrorMessage").getter(BlueprintRun.getter(BlueprintRun::rollbackErrorMessage)).setter(BlueprintRun.setter(Builder::rollbackErrorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackErrorMessage").build()}).build();
    private static final SdkField<String> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Parameters").getter(BlueprintRun.getter(BlueprintRun::parameters)).setter(BlueprintRun.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(BlueprintRun.getter(BlueprintRun::roleArn)).setter(BlueprintRun.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_NAME_FIELD, RUN_ID_FIELD, WORKFLOW_NAME_FIELD, STATE_FIELD, STARTED_ON_FIELD, COMPLETED_ON_FIELD, ERROR_MESSAGE_FIELD, ROLLBACK_ERROR_MESSAGE_FIELD, PARAMETERS_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BlueprintName", BLUEPRINT_NAME_FIELD);
            this.put("RunId", RUN_ID_FIELD);
            this.put("WorkflowName", WORKFLOW_NAME_FIELD);
            this.put("State", STATE_FIELD);
            this.put("StartedOn", STARTED_ON_FIELD);
            this.put("CompletedOn", COMPLETED_ON_FIELD);
            this.put("ErrorMessage", ERROR_MESSAGE_FIELD);
            this.put("RollbackErrorMessage", ROLLBACK_ERROR_MESSAGE_FIELD);
            this.put("Parameters", PARAMETERS_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String blueprintName;
    private final String runId;
    private final String workflowName;
    private final String state;
    private final Instant startedOn;
    private final Instant completedOn;
    private final String errorMessage;
    private final String rollbackErrorMessage;
    private final String parameters;
    private final String roleArn;

    private BlueprintRun(BuilderImpl builder) {
        this.blueprintName = builder.blueprintName;
        this.runId = builder.runId;
        this.workflowName = builder.workflowName;
        this.state = builder.state;
        this.startedOn = builder.startedOn;
        this.completedOn = builder.completedOn;
        this.errorMessage = builder.errorMessage;
        this.rollbackErrorMessage = builder.rollbackErrorMessage;
        this.parameters = builder.parameters;
        this.roleArn = builder.roleArn;
    }

    public final String blueprintName() {
        return this.blueprintName;
    }

    public final String runId() {
        return this.runId;
    }

    public final String workflowName() {
        return this.workflowName;
    }

    public final BlueprintRunState state() {
        return BlueprintRunState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String rollbackErrorMessage() {
        return this.rollbackErrorMessage;
    }

    public final String parameters() {
        return this.parameters;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueprintRun)) {
            return false;
        }
        BlueprintRun other = (BlueprintRun)obj;
        return Objects.equals(this.blueprintName(), other.blueprintName()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.workflowName(), other.workflowName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.rollbackErrorMessage(), other.rollbackErrorMessage()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"BlueprintRun").add("BlueprintName", (Object)this.blueprintName()).add("RunId", (Object)this.runId()).add("WorkflowName", (Object)this.workflowName()).add("State", (Object)this.stateAsString()).add("StartedOn", (Object)this.startedOn()).add("CompletedOn", (Object)this.completedOn()).add("ErrorMessage", (Object)this.errorMessage()).add("RollbackErrorMessage", (Object)this.rollbackErrorMessage()).add("Parameters", (Object)this.parameters()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlueprintName": {
                return Optional.ofNullable(clazz.cast(this.blueprintName()));
            }
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "WorkflowName": {
                return Optional.ofNullable(clazz.cast(this.workflowName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StartedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "CompletedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "RollbackErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.rollbackErrorMessage()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BlueprintRun, T> g) {
        return obj -> g.apply((BlueprintRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String blueprintName;
        private String runId;
        private String workflowName;
        private String state;
        private Instant startedOn;
        private Instant completedOn;
        private String errorMessage;
        private String rollbackErrorMessage;
        private String parameters;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueprintRun model) {
            this.blueprintName(model.blueprintName);
            this.runId(model.runId);
            this.workflowName(model.workflowName);
            this.state(model.state);
            this.startedOn(model.startedOn);
            this.completedOn(model.completedOn);
            this.errorMessage(model.errorMessage);
            this.rollbackErrorMessage(model.rollbackErrorMessage);
            this.parameters(model.parameters);
            this.roleArn(model.roleArn);
        }

        public final String getBlueprintName() {
            return this.blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getWorkflowName() {
            return this.workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(BlueprintRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getRollbackErrorMessage() {
            return this.rollbackErrorMessage;
        }

        public final void setRollbackErrorMessage(String rollbackErrorMessage) {
            this.rollbackErrorMessage = rollbackErrorMessage;
        }

        @Override
        public final Builder rollbackErrorMessage(String rollbackErrorMessage) {
            this.rollbackErrorMessage = rollbackErrorMessage;
            return this;
        }

        public final String getParameters() {
            return this.parameters;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public BlueprintRun build() {
            return new BlueprintRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlueprintRun> {
        public Builder blueprintName(String var1);

        public Builder runId(String var1);

        public Builder workflowName(String var1);

        public Builder state(String var1);

        public Builder state(BlueprintRunState var1);

        public Builder startedOn(Instant var1);

        public Builder completedOn(Instant var1);

        public Builder errorMessage(String var1);

        public Builder rollbackErrorMessage(String var1);

        public Builder parameters(String var1);

        public Builder roleArn(String var1);
    }
}

