/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ColumnNameListCopier;
import software.amazon.awssdk.services.glue.model.ReferenceDatasetsListCopier;
import software.amazon.awssdk.services.glue.model.RunIdentifier;
import software.amazon.awssdk.services.glue.model.StatisticEvaluationLevel;
import software.amazon.awssdk.services.glue.model.StatisticPropertiesMapCopier;
import software.amazon.awssdk.services.glue.model.TimestampedInclusionAnnotation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatisticSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatisticSummary> {
    private static final SdkField<String> STATISTIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatisticId").getter(StatisticSummary.getter(StatisticSummary::statisticId)).setter(StatisticSummary.setter(Builder::statisticId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticId").build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(StatisticSummary.getter(StatisticSummary::profileId)).setter(StatisticSummary.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final SdkField<RunIdentifier> RUN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RunIdentifier").getter(StatisticSummary.getter(StatisticSummary::runIdentifier)).setter(StatisticSummary.setter(Builder::runIdentifier)).constructor(RunIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunIdentifier").build()}).build();
    private static final SdkField<String> STATISTIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatisticName").getter(StatisticSummary.getter(StatisticSummary::statisticName)).setter(StatisticSummary.setter(Builder::statisticName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticName").build()}).build();
    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DoubleValue").getter(StatisticSummary.getter(StatisticSummary::doubleValue)).setter(StatisticSummary.setter(Builder::doubleValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DoubleValue").build()}).build();
    private static final SdkField<String> EVALUATION_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationLevel").getter(StatisticSummary.getter(StatisticSummary::evaluationLevelAsString)).setter(StatisticSummary.setter(Builder::evaluationLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationLevel").build()}).build();
    private static final SdkField<List<String>> COLUMNS_REFERENCED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnsReferenced").getter(StatisticSummary.getter(StatisticSummary::columnsReferenced)).setter(StatisticSummary.setter(Builder::columnsReferenced)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnsReferenced").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REFERENCED_DATASETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferencedDatasets").getter(StatisticSummary.getter(StatisticSummary::referencedDatasets)).setter(StatisticSummary.setter(Builder::referencedDatasets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencedDatasets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> STATISTIC_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("StatisticProperties").getter(StatisticSummary.getter(StatisticSummary::statisticProperties)).setter(StatisticSummary.setter(Builder::statisticProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> RECORDED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RecordedOn").getter(StatisticSummary.getter(StatisticSummary::recordedOn)).setter(StatisticSummary.setter(Builder::recordedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordedOn").build()}).build();
    private static final SdkField<TimestampedInclusionAnnotation> INCLUSION_ANNOTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InclusionAnnotation").getter(StatisticSummary.getter(StatisticSummary::inclusionAnnotation)).setter(StatisticSummary.setter(Builder::inclusionAnnotation)).constructor(TimestampedInclusionAnnotation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionAnnotation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTIC_ID_FIELD, PROFILE_ID_FIELD, RUN_IDENTIFIER_FIELD, STATISTIC_NAME_FIELD, DOUBLE_VALUE_FIELD, EVALUATION_LEVEL_FIELD, COLUMNS_REFERENCED_FIELD, REFERENCED_DATASETS_FIELD, STATISTIC_PROPERTIES_FIELD, RECORDED_ON_FIELD, INCLUSION_ANNOTATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StatisticId", STATISTIC_ID_FIELD);
            this.put("ProfileId", PROFILE_ID_FIELD);
            this.put("RunIdentifier", RUN_IDENTIFIER_FIELD);
            this.put("StatisticName", STATISTIC_NAME_FIELD);
            this.put("DoubleValue", DOUBLE_VALUE_FIELD);
            this.put("EvaluationLevel", EVALUATION_LEVEL_FIELD);
            this.put("ColumnsReferenced", COLUMNS_REFERENCED_FIELD);
            this.put("ReferencedDatasets", REFERENCED_DATASETS_FIELD);
            this.put("StatisticProperties", STATISTIC_PROPERTIES_FIELD);
            this.put("RecordedOn", RECORDED_ON_FIELD);
            this.put("InclusionAnnotation", INCLUSION_ANNOTATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String statisticId;
    private final String profileId;
    private final RunIdentifier runIdentifier;
    private final String statisticName;
    private final Double doubleValue;
    private final String evaluationLevel;
    private final List<String> columnsReferenced;
    private final List<String> referencedDatasets;
    private final Map<String, String> statisticProperties;
    private final Instant recordedOn;
    private final TimestampedInclusionAnnotation inclusionAnnotation;

    private StatisticSummary(BuilderImpl builder) {
        this.statisticId = builder.statisticId;
        this.profileId = builder.profileId;
        this.runIdentifier = builder.runIdentifier;
        this.statisticName = builder.statisticName;
        this.doubleValue = builder.doubleValue;
        this.evaluationLevel = builder.evaluationLevel;
        this.columnsReferenced = builder.columnsReferenced;
        this.referencedDatasets = builder.referencedDatasets;
        this.statisticProperties = builder.statisticProperties;
        this.recordedOn = builder.recordedOn;
        this.inclusionAnnotation = builder.inclusionAnnotation;
    }

    public final String statisticId() {
        return this.statisticId;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final RunIdentifier runIdentifier() {
        return this.runIdentifier;
    }

    public final String statisticName() {
        return this.statisticName;
    }

    public final Double doubleValue() {
        return this.doubleValue;
    }

    public final StatisticEvaluationLevel evaluationLevel() {
        return StatisticEvaluationLevel.fromValue(this.evaluationLevel);
    }

    public final String evaluationLevelAsString() {
        return this.evaluationLevel;
    }

    public final boolean hasColumnsReferenced() {
        return this.columnsReferenced != null && !(this.columnsReferenced instanceof SdkAutoConstructList);
    }

    public final List<String> columnsReferenced() {
        return this.columnsReferenced;
    }

    public final boolean hasReferencedDatasets() {
        return this.referencedDatasets != null && !(this.referencedDatasets instanceof SdkAutoConstructList);
    }

    public final List<String> referencedDatasets() {
        return this.referencedDatasets;
    }

    public final boolean hasStatisticProperties() {
        return this.statisticProperties != null && !(this.statisticProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> statisticProperties() {
        return this.statisticProperties;
    }

    public final Instant recordedOn() {
        return this.recordedOn;
    }

    public final TimestampedInclusionAnnotation inclusionAnnotation() {
        return this.inclusionAnnotation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticId());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticName());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnsReferenced() ? this.columnsReferenced() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferencedDatasets() ? this.referencedDatasets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatisticProperties() ? this.statisticProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recordedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusionAnnotation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticSummary)) {
            return false;
        }
        StatisticSummary other = (StatisticSummary)obj;
        return Objects.equals(this.statisticId(), other.statisticId()) && Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.runIdentifier(), other.runIdentifier()) && Objects.equals(this.statisticName(), other.statisticName()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.evaluationLevelAsString(), other.evaluationLevelAsString()) && this.hasColumnsReferenced() == other.hasColumnsReferenced() && Objects.equals(this.columnsReferenced(), other.columnsReferenced()) && this.hasReferencedDatasets() == other.hasReferencedDatasets() && Objects.equals(this.referencedDatasets(), other.referencedDatasets()) && this.hasStatisticProperties() == other.hasStatisticProperties() && Objects.equals(this.statisticProperties(), other.statisticProperties()) && Objects.equals(this.recordedOn(), other.recordedOn()) && Objects.equals(this.inclusionAnnotation(), other.inclusionAnnotation());
    }

    public final String toString() {
        return ToString.builder((String)"StatisticSummary").add("StatisticId", (Object)this.statisticId()).add("ProfileId", (Object)this.profileId()).add("RunIdentifier", (Object)this.runIdentifier()).add("StatisticName", (Object)this.statisticName()).add("DoubleValue", (Object)this.doubleValue()).add("EvaluationLevel", (Object)this.evaluationLevelAsString()).add("ColumnsReferenced", this.hasColumnsReferenced() ? this.columnsReferenced() : null).add("ReferencedDatasets", this.hasReferencedDatasets() ? this.referencedDatasets() : null).add("StatisticProperties", (Object)(this.statisticProperties() == null ? null : "*** Sensitive Data Redacted ***")).add("RecordedOn", (Object)this.recordedOn()).add("InclusionAnnotation", (Object)this.inclusionAnnotation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatisticId": {
                return Optional.ofNullable(clazz.cast(this.statisticId()));
            }
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "RunIdentifier": {
                return Optional.ofNullable(clazz.cast(this.runIdentifier()));
            }
            case "StatisticName": {
                return Optional.ofNullable(clazz.cast(this.statisticName()));
            }
            case "DoubleValue": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "EvaluationLevel": {
                return Optional.ofNullable(clazz.cast(this.evaluationLevelAsString()));
            }
            case "ColumnsReferenced": {
                return Optional.ofNullable(clazz.cast(this.columnsReferenced()));
            }
            case "ReferencedDatasets": {
                return Optional.ofNullable(clazz.cast(this.referencedDatasets()));
            }
            case "StatisticProperties": {
                return Optional.ofNullable(clazz.cast(this.statisticProperties()));
            }
            case "RecordedOn": {
                return Optional.ofNullable(clazz.cast(this.recordedOn()));
            }
            case "InclusionAnnotation": {
                return Optional.ofNullable(clazz.cast(this.inclusionAnnotation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StatisticSummary, T> g) {
        return obj -> g.apply((StatisticSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String statisticId;
        private String profileId;
        private RunIdentifier runIdentifier;
        private String statisticName;
        private Double doubleValue;
        private String evaluationLevel;
        private List<String> columnsReferenced = DefaultSdkAutoConstructList.getInstance();
        private List<String> referencedDatasets = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> statisticProperties = DefaultSdkAutoConstructMap.getInstance();
        private Instant recordedOn;
        private TimestampedInclusionAnnotation inclusionAnnotation;

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticSummary model) {
            this.statisticId(model.statisticId);
            this.profileId(model.profileId);
            this.runIdentifier(model.runIdentifier);
            this.statisticName(model.statisticName);
            this.doubleValue(model.doubleValue);
            this.evaluationLevel(model.evaluationLevel);
            this.columnsReferenced(model.columnsReferenced);
            this.referencedDatasets(model.referencedDatasets);
            this.statisticProperties(model.statisticProperties);
            this.recordedOn(model.recordedOn);
            this.inclusionAnnotation(model.inclusionAnnotation);
        }

        public final String getStatisticId() {
            return this.statisticId;
        }

        public final void setStatisticId(String statisticId) {
            this.statisticId = statisticId;
        }

        @Override
        public final Builder statisticId(String statisticId) {
            this.statisticId = statisticId;
            return this;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final RunIdentifier.Builder getRunIdentifier() {
            return this.runIdentifier != null ? this.runIdentifier.toBuilder() : null;
        }

        public final void setRunIdentifier(RunIdentifier.BuilderImpl runIdentifier) {
            this.runIdentifier = runIdentifier != null ? runIdentifier.build() : null;
        }

        @Override
        public final Builder runIdentifier(RunIdentifier runIdentifier) {
            this.runIdentifier = runIdentifier;
            return this;
        }

        public final String getStatisticName() {
            return this.statisticName;
        }

        public final void setStatisticName(String statisticName) {
            this.statisticName = statisticName;
        }

        @Override
        public final Builder statisticName(String statisticName) {
            this.statisticName = statisticName;
            return this;
        }

        public final Double getDoubleValue() {
            return this.doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final String getEvaluationLevel() {
            return this.evaluationLevel;
        }

        public final void setEvaluationLevel(String evaluationLevel) {
            this.evaluationLevel = evaluationLevel;
        }

        @Override
        public final Builder evaluationLevel(String evaluationLevel) {
            this.evaluationLevel = evaluationLevel;
            return this;
        }

        @Override
        public final Builder evaluationLevel(StatisticEvaluationLevel evaluationLevel) {
            this.evaluationLevel(evaluationLevel == null ? null : evaluationLevel.toString());
            return this;
        }

        public final Collection<String> getColumnsReferenced() {
            if (this.columnsReferenced instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnsReferenced;
        }

        public final void setColumnsReferenced(Collection<String> columnsReferenced) {
            this.columnsReferenced = ColumnNameListCopier.copy(columnsReferenced);
        }

        @Override
        public final Builder columnsReferenced(Collection<String> columnsReferenced) {
            this.columnsReferenced = ColumnNameListCopier.copy(columnsReferenced);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnsReferenced(String ... columnsReferenced) {
            this.columnsReferenced(Arrays.asList(columnsReferenced));
            return this;
        }

        public final Collection<String> getReferencedDatasets() {
            if (this.referencedDatasets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.referencedDatasets;
        }

        public final void setReferencedDatasets(Collection<String> referencedDatasets) {
            this.referencedDatasets = ReferenceDatasetsListCopier.copy(referencedDatasets);
        }

        @Override
        public final Builder referencedDatasets(Collection<String> referencedDatasets) {
            this.referencedDatasets = ReferenceDatasetsListCopier.copy(referencedDatasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referencedDatasets(String ... referencedDatasets) {
            this.referencedDatasets(Arrays.asList(referencedDatasets));
            return this;
        }

        public final Map<String, String> getStatisticProperties() {
            if (this.statisticProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.statisticProperties;
        }

        public final void setStatisticProperties(Map<String, String> statisticProperties) {
            this.statisticProperties = StatisticPropertiesMapCopier.copy(statisticProperties);
        }

        @Override
        public final Builder statisticProperties(Map<String, String> statisticProperties) {
            this.statisticProperties = StatisticPropertiesMapCopier.copy(statisticProperties);
            return this;
        }

        public final Instant getRecordedOn() {
            return this.recordedOn;
        }

        public final void setRecordedOn(Instant recordedOn) {
            this.recordedOn = recordedOn;
        }

        @Override
        public final Builder recordedOn(Instant recordedOn) {
            this.recordedOn = recordedOn;
            return this;
        }

        public final TimestampedInclusionAnnotation.Builder getInclusionAnnotation() {
            return this.inclusionAnnotation != null ? this.inclusionAnnotation.toBuilder() : null;
        }

        public final void setInclusionAnnotation(TimestampedInclusionAnnotation.BuilderImpl inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation != null ? inclusionAnnotation.build() : null;
        }

        @Override
        public final Builder inclusionAnnotation(TimestampedInclusionAnnotation inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation;
            return this;
        }

        public StatisticSummary build() {
            return new StatisticSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatisticSummary> {
        public Builder statisticId(String var1);

        public Builder profileId(String var1);

        public Builder runIdentifier(RunIdentifier var1);

        default public Builder runIdentifier(Consumer<RunIdentifier.Builder> runIdentifier) {
            return this.runIdentifier((RunIdentifier)((RunIdentifier.Builder)RunIdentifier.builder().applyMutation(runIdentifier)).build());
        }

        public Builder statisticName(String var1);

        public Builder doubleValue(Double var1);

        public Builder evaluationLevel(String var1);

        public Builder evaluationLevel(StatisticEvaluationLevel var1);

        public Builder columnsReferenced(Collection<String> var1);

        public Builder columnsReferenced(String ... var1);

        public Builder referencedDatasets(Collection<String> var1);

        public Builder referencedDatasets(String ... var1);

        public Builder statisticProperties(Map<String, String> var1);

        public Builder recordedOn(Instant var1);

        public Builder inclusionAnnotation(TimestampedInclusionAnnotation var1);

        default public Builder inclusionAnnotation(Consumer<TimestampedInclusionAnnotation.Builder> inclusionAnnotation) {
            return this.inclusionAnnotation((TimestampedInclusionAnnotation)((TimestampedInclusionAnnotation.Builder)TimestampedInclusionAnnotation.builder().applyMutation(inclusionAnnotation)).build());
        }
    }
}

