/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.AuthorizationCodeProperties;
import software.amazon.awssdk.services.glue.model.OAuth2ClientApplication;
import software.amazon.awssdk.services.glue.model.OAuth2Credentials;
import software.amazon.awssdk.services.glue.model.OAuth2GrantType;
import software.amazon.awssdk.services.glue.model.TokenUrlParametersMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OAuth2PropertiesInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OAuth2PropertiesInput> {
    private static final SdkField<String> O_AUTH2_GRANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OAuth2GrantType").getter(OAuth2PropertiesInput.getter(OAuth2PropertiesInput::oAuth2GrantTypeAsString)).setter(OAuth2PropertiesInput.setter(Builder::oAuth2GrantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuth2GrantType").build()}).build();
    private static final SdkField<OAuth2ClientApplication> O_AUTH2_CLIENT_APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OAuth2ClientApplication").getter(OAuth2PropertiesInput.getter(OAuth2PropertiesInput::oAuth2ClientApplication)).setter(OAuth2PropertiesInput.setter(Builder::oAuth2ClientApplication)).constructor(OAuth2ClientApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuth2ClientApplication").build()}).build();
    private static final SdkField<String> TOKEN_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenUrl").getter(OAuth2PropertiesInput.getter(OAuth2PropertiesInput::tokenUrl)).setter(OAuth2PropertiesInput.setter(Builder::tokenUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenUrl").build()}).build();
    private static final SdkField<Map<String, String>> TOKEN_URL_PARAMETERS_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TokenUrlParametersMap").getter(OAuth2PropertiesInput.getter(OAuth2PropertiesInput::tokenUrlParametersMap)).setter(OAuth2PropertiesInput.setter(Builder::tokenUrlParametersMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenUrlParametersMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AuthorizationCodeProperties> AUTHORIZATION_CODE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthorizationCodeProperties").getter(OAuth2PropertiesInput.getter(OAuth2PropertiesInput::authorizationCodeProperties)).setter(OAuth2PropertiesInput.setter(Builder::authorizationCodeProperties)).constructor(AuthorizationCodeProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationCodeProperties").build()}).build();
    private static final SdkField<OAuth2Credentials> O_AUTH2_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OAuth2Credentials").getter(OAuth2PropertiesInput.getter(OAuth2PropertiesInput::oAuth2Credentials)).setter(OAuth2PropertiesInput.setter(Builder::oAuth2Credentials)).constructor(OAuth2Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuth2Credentials").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(O_AUTH2_GRANT_TYPE_FIELD, O_AUTH2_CLIENT_APPLICATION_FIELD, TOKEN_URL_FIELD, TOKEN_URL_PARAMETERS_MAP_FIELD, AUTHORIZATION_CODE_PROPERTIES_FIELD, O_AUTH2_CREDENTIALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OAuth2GrantType", O_AUTH2_GRANT_TYPE_FIELD);
            this.put("OAuth2ClientApplication", O_AUTH2_CLIENT_APPLICATION_FIELD);
            this.put("TokenUrl", TOKEN_URL_FIELD);
            this.put("TokenUrlParametersMap", TOKEN_URL_PARAMETERS_MAP_FIELD);
            this.put("AuthorizationCodeProperties", AUTHORIZATION_CODE_PROPERTIES_FIELD);
            this.put("OAuth2Credentials", O_AUTH2_CREDENTIALS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String oAuth2GrantType;
    private final OAuth2ClientApplication oAuth2ClientApplication;
    private final String tokenUrl;
    private final Map<String, String> tokenUrlParametersMap;
    private final AuthorizationCodeProperties authorizationCodeProperties;
    private final OAuth2Credentials oAuth2Credentials;

    private OAuth2PropertiesInput(BuilderImpl builder) {
        this.oAuth2GrantType = builder.oAuth2GrantType;
        this.oAuth2ClientApplication = builder.oAuth2ClientApplication;
        this.tokenUrl = builder.tokenUrl;
        this.tokenUrlParametersMap = builder.tokenUrlParametersMap;
        this.authorizationCodeProperties = builder.authorizationCodeProperties;
        this.oAuth2Credentials = builder.oAuth2Credentials;
    }

    public final OAuth2GrantType oAuth2GrantType() {
        return OAuth2GrantType.fromValue(this.oAuth2GrantType);
    }

    public final String oAuth2GrantTypeAsString() {
        return this.oAuth2GrantType;
    }

    public final OAuth2ClientApplication oAuth2ClientApplication() {
        return this.oAuth2ClientApplication;
    }

    public final String tokenUrl() {
        return this.tokenUrl;
    }

    public final boolean hasTokenUrlParametersMap() {
        return this.tokenUrlParametersMap != null && !(this.tokenUrlParametersMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tokenUrlParametersMap() {
        return this.tokenUrlParametersMap;
    }

    public final AuthorizationCodeProperties authorizationCodeProperties() {
        return this.authorizationCodeProperties;
    }

    public final OAuth2Credentials oAuth2Credentials() {
        return this.oAuth2Credentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2GrantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2ClientApplication());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenUrlParametersMap() ? this.tokenUrlParametersMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationCodeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2Credentials());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2PropertiesInput)) {
            return false;
        }
        OAuth2PropertiesInput other = (OAuth2PropertiesInput)obj;
        return Objects.equals(this.oAuth2GrantTypeAsString(), other.oAuth2GrantTypeAsString()) && Objects.equals(this.oAuth2ClientApplication(), other.oAuth2ClientApplication()) && Objects.equals(this.tokenUrl(), other.tokenUrl()) && this.hasTokenUrlParametersMap() == other.hasTokenUrlParametersMap() && Objects.equals(this.tokenUrlParametersMap(), other.tokenUrlParametersMap()) && Objects.equals(this.authorizationCodeProperties(), other.authorizationCodeProperties()) && Objects.equals(this.oAuth2Credentials(), other.oAuth2Credentials());
    }

    public final String toString() {
        return ToString.builder((String)"OAuth2PropertiesInput").add("OAuth2GrantType", (Object)this.oAuth2GrantTypeAsString()).add("OAuth2ClientApplication", (Object)this.oAuth2ClientApplication()).add("TokenUrl", (Object)this.tokenUrl()).add("TokenUrlParametersMap", this.hasTokenUrlParametersMap() ? this.tokenUrlParametersMap() : null).add("AuthorizationCodeProperties", (Object)this.authorizationCodeProperties()).add("OAuth2Credentials", (Object)this.oAuth2Credentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OAuth2GrantType": {
                return Optional.ofNullable(clazz.cast(this.oAuth2GrantTypeAsString()));
            }
            case "OAuth2ClientApplication": {
                return Optional.ofNullable(clazz.cast(this.oAuth2ClientApplication()));
            }
            case "TokenUrl": {
                return Optional.ofNullable(clazz.cast(this.tokenUrl()));
            }
            case "TokenUrlParametersMap": {
                return Optional.ofNullable(clazz.cast(this.tokenUrlParametersMap()));
            }
            case "AuthorizationCodeProperties": {
                return Optional.ofNullable(clazz.cast(this.authorizationCodeProperties()));
            }
            case "OAuth2Credentials": {
                return Optional.ofNullable(clazz.cast(this.oAuth2Credentials()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OAuth2PropertiesInput, T> g) {
        return obj -> g.apply((OAuth2PropertiesInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String oAuth2GrantType;
        private OAuth2ClientApplication oAuth2ClientApplication;
        private String tokenUrl;
        private Map<String, String> tokenUrlParametersMap = DefaultSdkAutoConstructMap.getInstance();
        private AuthorizationCodeProperties authorizationCodeProperties;
        private OAuth2Credentials oAuth2Credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2PropertiesInput model) {
            this.oAuth2GrantType(model.oAuth2GrantType);
            this.oAuth2ClientApplication(model.oAuth2ClientApplication);
            this.tokenUrl(model.tokenUrl);
            this.tokenUrlParametersMap(model.tokenUrlParametersMap);
            this.authorizationCodeProperties(model.authorizationCodeProperties);
            this.oAuth2Credentials(model.oAuth2Credentials);
        }

        public final String getOAuth2GrantType() {
            return this.oAuth2GrantType;
        }

        public final void setOAuth2GrantType(String oAuth2GrantType) {
            this.oAuth2GrantType = oAuth2GrantType;
        }

        @Override
        public final Builder oAuth2GrantType(String oAuth2GrantType) {
            this.oAuth2GrantType = oAuth2GrantType;
            return this;
        }

        @Override
        public final Builder oAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
            this.oAuth2GrantType(oAuth2GrantType == null ? null : oAuth2GrantType.toString());
            return this;
        }

        public final OAuth2ClientApplication.Builder getOAuth2ClientApplication() {
            return this.oAuth2ClientApplication != null ? this.oAuth2ClientApplication.toBuilder() : null;
        }

        public final void setOAuth2ClientApplication(OAuth2ClientApplication.BuilderImpl oAuth2ClientApplication) {
            this.oAuth2ClientApplication = oAuth2ClientApplication != null ? oAuth2ClientApplication.build() : null;
        }

        @Override
        public final Builder oAuth2ClientApplication(OAuth2ClientApplication oAuth2ClientApplication) {
            this.oAuth2ClientApplication = oAuth2ClientApplication;
            return this;
        }

        public final String getTokenUrl() {
            return this.tokenUrl;
        }

        public final void setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
        }

        @Override
        public final Builder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public final Map<String, String> getTokenUrlParametersMap() {
            if (this.tokenUrlParametersMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tokenUrlParametersMap;
        }

        public final void setTokenUrlParametersMap(Map<String, String> tokenUrlParametersMap) {
            this.tokenUrlParametersMap = TokenUrlParametersMapCopier.copy(tokenUrlParametersMap);
        }

        @Override
        public final Builder tokenUrlParametersMap(Map<String, String> tokenUrlParametersMap) {
            this.tokenUrlParametersMap = TokenUrlParametersMapCopier.copy(tokenUrlParametersMap);
            return this;
        }

        public final AuthorizationCodeProperties.Builder getAuthorizationCodeProperties() {
            return this.authorizationCodeProperties != null ? this.authorizationCodeProperties.toBuilder() : null;
        }

        public final void setAuthorizationCodeProperties(AuthorizationCodeProperties.BuilderImpl authorizationCodeProperties) {
            this.authorizationCodeProperties = authorizationCodeProperties != null ? authorizationCodeProperties.build() : null;
        }

        @Override
        public final Builder authorizationCodeProperties(AuthorizationCodeProperties authorizationCodeProperties) {
            this.authorizationCodeProperties = authorizationCodeProperties;
            return this;
        }

        public final OAuth2Credentials.Builder getOAuth2Credentials() {
            return this.oAuth2Credentials != null ? this.oAuth2Credentials.toBuilder() : null;
        }

        public final void setOAuth2Credentials(OAuth2Credentials.BuilderImpl oAuth2Credentials) {
            this.oAuth2Credentials = oAuth2Credentials != null ? oAuth2Credentials.build() : null;
        }

        @Override
        public final Builder oAuth2Credentials(OAuth2Credentials oAuth2Credentials) {
            this.oAuth2Credentials = oAuth2Credentials;
            return this;
        }

        public OAuth2PropertiesInput build() {
            return new OAuth2PropertiesInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OAuth2PropertiesInput> {
        public Builder oAuth2GrantType(String var1);

        public Builder oAuth2GrantType(OAuth2GrantType var1);

        public Builder oAuth2ClientApplication(OAuth2ClientApplication var1);

        default public Builder oAuth2ClientApplication(Consumer<OAuth2ClientApplication.Builder> oAuth2ClientApplication) {
            return this.oAuth2ClientApplication((OAuth2ClientApplication)((OAuth2ClientApplication.Builder)OAuth2ClientApplication.builder().applyMutation(oAuth2ClientApplication)).build());
        }

        public Builder tokenUrl(String var1);

        public Builder tokenUrlParametersMap(Map<String, String> var1);

        public Builder authorizationCodeProperties(AuthorizationCodeProperties var1);

        default public Builder authorizationCodeProperties(Consumer<AuthorizationCodeProperties.Builder> authorizationCodeProperties) {
            return this.authorizationCodeProperties((AuthorizationCodeProperties)((AuthorizationCodeProperties.Builder)AuthorizationCodeProperties.builder().applyMutation(authorizationCodeProperties)).build());
        }

        public Builder oAuth2Credentials(OAuth2Credentials var1);

        default public Builder oAuth2Credentials(Consumer<OAuth2Credentials.Builder> oAuth2Credentials) {
            return this.oAuth2Credentials((OAuth2Credentials)((OAuth2Credentials.Builder)OAuth2Credentials.builder().applyMutation(oAuth2Credentials)).build());
        }
    }
}

