/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntitiesRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, ListEntitiesRequest> {
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(ListEntitiesRequest.getter(ListEntitiesRequest::connectionName)).setter(ListEntitiesRequest.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(ListEntitiesRequest.getter(ListEntitiesRequest::catalogId)).setter(ListEntitiesRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> PARENT_ENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentEntityName").getter(ListEntitiesRequest.getter(ListEntitiesRequest::parentEntityName)).setter(ListEntitiesRequest.setter(Builder::parentEntityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentEntityName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEntitiesRequest.getter(ListEntitiesRequest::nextToken)).setter(ListEntitiesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> DATA_STORE_API_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataStoreApiVersion").getter(ListEntitiesRequest.getter(ListEntitiesRequest::dataStoreApiVersion)).setter(ListEntitiesRequest.setter(Builder::dataStoreApiVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStoreApiVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NAME_FIELD, CATALOG_ID_FIELD, PARENT_ENTITY_NAME_FIELD, NEXT_TOKEN_FIELD, DATA_STORE_API_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConnectionName", CONNECTION_NAME_FIELD);
            this.put("CatalogId", CATALOG_ID_FIELD);
            this.put("ParentEntityName", PARENT_ENTITY_NAME_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("DataStoreApiVersion", DATA_STORE_API_VERSION_FIELD);
        }
    });
    private final String connectionName;
    private final String catalogId;
    private final String parentEntityName;
    private final String nextToken;
    private final String dataStoreApiVersion;

    private ListEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.connectionName = builder.connectionName;
        this.catalogId = builder.catalogId;
        this.parentEntityName = builder.parentEntityName;
        this.nextToken = builder.nextToken;
        this.dataStoreApiVersion = builder.dataStoreApiVersion;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String parentEntityName() {
        return this.parentEntityName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String dataStoreApiVersion() {
        return this.dataStoreApiVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentEntityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStoreApiVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesRequest)) {
            return false;
        }
        ListEntitiesRequest other = (ListEntitiesRequest)((Object)obj);
        return Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.parentEntityName(), other.parentEntityName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.dataStoreApiVersion(), other.dataStoreApiVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ListEntitiesRequest").add("ConnectionName", (Object)this.connectionName()).add("CatalogId", (Object)this.catalogId()).add("ParentEntityName", (Object)this.parentEntityName()).add("NextToken", (Object)this.nextToken()).add("DataStoreApiVersion", (Object)this.dataStoreApiVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "ParentEntityName": {
                return Optional.ofNullable(clazz.cast(this.parentEntityName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DataStoreApiVersion": {
                return Optional.ofNullable(clazz.cast(this.dataStoreApiVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListEntitiesRequest, T> g) {
        return obj -> g.apply((ListEntitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String connectionName;
        private String catalogId;
        private String parentEntityName;
        private String nextToken;
        private String dataStoreApiVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesRequest model) {
            super(model);
            this.connectionName(model.connectionName);
            this.catalogId(model.catalogId);
            this.parentEntityName(model.parentEntityName);
            this.nextToken(model.nextToken);
            this.dataStoreApiVersion(model.dataStoreApiVersion);
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getParentEntityName() {
            return this.parentEntityName;
        }

        public final void setParentEntityName(String parentEntityName) {
            this.parentEntityName = parentEntityName;
        }

        @Override
        public final Builder parentEntityName(String parentEntityName) {
            this.parentEntityName = parentEntityName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDataStoreApiVersion() {
            return this.dataStoreApiVersion;
        }

        public final void setDataStoreApiVersion(String dataStoreApiVersion) {
            this.dataStoreApiVersion = dataStoreApiVersion;
        }

        @Override
        public final Builder dataStoreApiVersion(String dataStoreApiVersion) {
            this.dataStoreApiVersion = dataStoreApiVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEntitiesRequest build() {
            return new ListEntitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEntitiesRequest> {
        public Builder connectionName(String var1);

        public Builder catalogId(String var1);

        public Builder parentEntityName(String var1);

        public Builder nextToken(String var1);

        public Builder dataStoreApiVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

