/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CodeGenEdge;
import software.amazon.awssdk.services.glue.model.CodeGenNode;
import software.amazon.awssdk.services.glue.model.DagEdgesCopier;
import software.amazon.awssdk.services.glue.model.DagNodesCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.Language;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateScriptRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateScriptRequest> {
    private static final SdkField<List<CodeGenNode>> DAG_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DagNodes").getter(CreateScriptRequest.getter(CreateScriptRequest::dagNodes)).setter(CreateScriptRequest.setter(Builder::dagNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagNodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeGenNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CodeGenEdge>> DAG_EDGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DagEdges").getter(CreateScriptRequest.getter(CreateScriptRequest::dagEdges)).setter(CreateScriptRequest.setter(Builder::dagEdges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagEdges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeGenEdge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(CreateScriptRequest.getter(CreateScriptRequest::languageAsString)).setter(CreateScriptRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAG_NODES_FIELD, DAG_EDGES_FIELD, LANGUAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DagNodes", DAG_NODES_FIELD);
            this.put("DagEdges", DAG_EDGES_FIELD);
            this.put("Language", LANGUAGE_FIELD);
        }
    });
    private final List<CodeGenNode> dagNodes;
    private final List<CodeGenEdge> dagEdges;
    private final String language;

    private CreateScriptRequest(BuilderImpl builder) {
        super(builder);
        this.dagNodes = builder.dagNodes;
        this.dagEdges = builder.dagEdges;
        this.language = builder.language;
    }

    public final boolean hasDagNodes() {
        return this.dagNodes != null && !(this.dagNodes instanceof SdkAutoConstructList);
    }

    public final List<CodeGenNode> dagNodes() {
        return this.dagNodes;
    }

    public final boolean hasDagEdges() {
        return this.dagEdges != null && !(this.dagEdges instanceof SdkAutoConstructList);
    }

    public final List<CodeGenEdge> dagEdges() {
        return this.dagEdges;
    }

    public final Language language() {
        return Language.fromValue(this.language);
    }

    public final String languageAsString() {
        return this.language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDagNodes() ? this.dagNodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDagEdges() ? this.dagEdges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.languageAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScriptRequest)) {
            return false;
        }
        CreateScriptRequest other = (CreateScriptRequest)((Object)obj);
        return this.hasDagNodes() == other.hasDagNodes() && Objects.equals(this.dagNodes(), other.dagNodes()) && this.hasDagEdges() == other.hasDagEdges() && Objects.equals(this.dagEdges(), other.dagEdges()) && Objects.equals(this.languageAsString(), other.languageAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateScriptRequest").add("DagNodes", this.hasDagNodes() ? this.dagNodes() : null).add("DagEdges", this.hasDagEdges() ? this.dagEdges() : null).add("Language", (Object)this.languageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DagNodes": {
                return Optional.ofNullable(clazz.cast(this.dagNodes()));
            }
            case "DagEdges": {
                return Optional.ofNullable(clazz.cast(this.dagEdges()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.languageAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateScriptRequest, T> g) {
        return obj -> g.apply((CreateScriptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private List<CodeGenNode> dagNodes = DefaultSdkAutoConstructList.getInstance();
        private List<CodeGenEdge> dagEdges = DefaultSdkAutoConstructList.getInstance();
        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScriptRequest model) {
            super(model);
            this.dagNodes(model.dagNodes);
            this.dagEdges(model.dagEdges);
            this.language(model.language);
        }

        public final List<CodeGenNode.Builder> getDagNodes() {
            List<CodeGenNode.Builder> result = DagNodesCopier.copyToBuilder(this.dagNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDagNodes(Collection<CodeGenNode.BuilderImpl> dagNodes) {
            this.dagNodes = DagNodesCopier.copyFromBuilder(dagNodes);
        }

        @Override
        public final Builder dagNodes(Collection<CodeGenNode> dagNodes) {
            this.dagNodes = DagNodesCopier.copy(dagNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dagNodes(CodeGenNode ... dagNodes) {
            this.dagNodes(Arrays.asList(dagNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dagNodes(Consumer<CodeGenNode.Builder> ... dagNodes) {
            this.dagNodes(Stream.of(dagNodes).map(c -> (CodeGenNode)((CodeGenNode.Builder)CodeGenNode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CodeGenEdge.Builder> getDagEdges() {
            List<CodeGenEdge.Builder> result = DagEdgesCopier.copyToBuilder(this.dagEdges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDagEdges(Collection<CodeGenEdge.BuilderImpl> dagEdges) {
            this.dagEdges = DagEdgesCopier.copyFromBuilder(dagEdges);
        }

        @Override
        public final Builder dagEdges(Collection<CodeGenEdge> dagEdges) {
            this.dagEdges = DagEdgesCopier.copy(dagEdges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dagEdges(CodeGenEdge ... dagEdges) {
            this.dagEdges(Arrays.asList(dagEdges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dagEdges(Consumer<CodeGenEdge.Builder> ... dagEdges) {
            this.dagEdges(Stream.of(dagEdges).map(c -> (CodeGenEdge)((CodeGenEdge.Builder)CodeGenEdge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(Language language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScriptRequest build() {
            return new CreateScriptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateScriptRequest> {
        public Builder dagNodes(Collection<CodeGenNode> var1);

        public Builder dagNodes(CodeGenNode ... var1);

        public Builder dagNodes(Consumer<CodeGenNode.Builder> ... var1);

        public Builder dagEdges(Collection<CodeGenEdge> var1);

        public Builder dagEdges(CodeGenEdge ... var1);

        public Builder dagEdges(Consumer<CodeGenEdge.Builder> ... var1);

        public Builder language(String var1);

        public Builder language(Language var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

