/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.AuthenticationType;
import software.amazon.awssdk.services.glue.model.AuthenticationTypesCopier;
import software.amazon.awssdk.services.glue.model.ComputeEnvironment;
import software.amazon.awssdk.services.glue.model.ComputeEnvironmentsCopier;
import software.amazon.awssdk.services.glue.model.DataOperation;
import software.amazon.awssdk.services.glue.model.DataOperationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Capabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Capabilities> {
    private static final SdkField<List<String>> SUPPORTED_AUTHENTICATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedAuthenticationTypes").getter(Capabilities.getter(Capabilities::supportedAuthenticationTypesAsStrings)).setter(Capabilities.setter(Builder::supportedAuthenticationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedAuthenticationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_DATA_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedDataOperations").getter(Capabilities.getter(Capabilities::supportedDataOperationsAsStrings)).setter(Capabilities.setter(Builder::supportedDataOperationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedDataOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_COMPUTE_ENVIRONMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedComputeEnvironments").getter(Capabilities.getter(Capabilities::supportedComputeEnvironmentsAsStrings)).setter(Capabilities.setter(Builder::supportedComputeEnvironmentsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedComputeEnvironments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_AUTHENTICATION_TYPES_FIELD, SUPPORTED_DATA_OPERATIONS_FIELD, SUPPORTED_COMPUTE_ENVIRONMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SupportedAuthenticationTypes", SUPPORTED_AUTHENTICATION_TYPES_FIELD);
            this.put("SupportedDataOperations", SUPPORTED_DATA_OPERATIONS_FIELD);
            this.put("SupportedComputeEnvironments", SUPPORTED_COMPUTE_ENVIRONMENTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> supportedAuthenticationTypes;
    private final List<String> supportedDataOperations;
    private final List<String> supportedComputeEnvironments;

    private Capabilities(BuilderImpl builder) {
        this.supportedAuthenticationTypes = builder.supportedAuthenticationTypes;
        this.supportedDataOperations = builder.supportedDataOperations;
        this.supportedComputeEnvironments = builder.supportedComputeEnvironments;
    }

    public final List<AuthenticationType> supportedAuthenticationTypes() {
        return AuthenticationTypesCopier.copyStringToEnum(this.supportedAuthenticationTypes);
    }

    public final boolean hasSupportedAuthenticationTypes() {
        return this.supportedAuthenticationTypes != null && !(this.supportedAuthenticationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedAuthenticationTypesAsStrings() {
        return this.supportedAuthenticationTypes;
    }

    public final List<DataOperation> supportedDataOperations() {
        return DataOperationsCopier.copyStringToEnum(this.supportedDataOperations);
    }

    public final boolean hasSupportedDataOperations() {
        return this.supportedDataOperations != null && !(this.supportedDataOperations instanceof SdkAutoConstructList);
    }

    public final List<String> supportedDataOperationsAsStrings() {
        return this.supportedDataOperations;
    }

    public final List<ComputeEnvironment> supportedComputeEnvironments() {
        return ComputeEnvironmentsCopier.copyStringToEnum(this.supportedComputeEnvironments);
    }

    public final boolean hasSupportedComputeEnvironments() {
        return this.supportedComputeEnvironments != null && !(this.supportedComputeEnvironments instanceof SdkAutoConstructList);
    }

    public final List<String> supportedComputeEnvironmentsAsStrings() {
        return this.supportedComputeEnvironments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedAuthenticationTypes() ? this.supportedAuthenticationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedDataOperations() ? this.supportedDataOperationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedComputeEnvironments() ? this.supportedComputeEnvironmentsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Capabilities)) {
            return false;
        }
        Capabilities other = (Capabilities)obj;
        return this.hasSupportedAuthenticationTypes() == other.hasSupportedAuthenticationTypes() && Objects.equals(this.supportedAuthenticationTypesAsStrings(), other.supportedAuthenticationTypesAsStrings()) && this.hasSupportedDataOperations() == other.hasSupportedDataOperations() && Objects.equals(this.supportedDataOperationsAsStrings(), other.supportedDataOperationsAsStrings()) && this.hasSupportedComputeEnvironments() == other.hasSupportedComputeEnvironments() && Objects.equals(this.supportedComputeEnvironmentsAsStrings(), other.supportedComputeEnvironmentsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"Capabilities").add("SupportedAuthenticationTypes", this.hasSupportedAuthenticationTypes() ? this.supportedAuthenticationTypesAsStrings() : null).add("SupportedDataOperations", this.hasSupportedDataOperations() ? this.supportedDataOperationsAsStrings() : null).add("SupportedComputeEnvironments", this.hasSupportedComputeEnvironments() ? this.supportedComputeEnvironmentsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SupportedAuthenticationTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedAuthenticationTypesAsStrings()));
            }
            case "SupportedDataOperations": {
                return Optional.ofNullable(clazz.cast(this.supportedDataOperationsAsStrings()));
            }
            case "SupportedComputeEnvironments": {
                return Optional.ofNullable(clazz.cast(this.supportedComputeEnvironmentsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Capabilities, T> g) {
        return obj -> g.apply((Capabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> supportedAuthenticationTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedDataOperations = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedComputeEnvironments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Capabilities model) {
            this.supportedAuthenticationTypesWithStrings(model.supportedAuthenticationTypes);
            this.supportedDataOperationsWithStrings(model.supportedDataOperations);
            this.supportedComputeEnvironmentsWithStrings(model.supportedComputeEnvironments);
        }

        public final Collection<String> getSupportedAuthenticationTypes() {
            if (this.supportedAuthenticationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedAuthenticationTypes;
        }

        public final void setSupportedAuthenticationTypes(Collection<String> supportedAuthenticationTypes) {
            this.supportedAuthenticationTypes = AuthenticationTypesCopier.copy(supportedAuthenticationTypes);
        }

        @Override
        public final Builder supportedAuthenticationTypesWithStrings(Collection<String> supportedAuthenticationTypes) {
            this.supportedAuthenticationTypes = AuthenticationTypesCopier.copy(supportedAuthenticationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAuthenticationTypesWithStrings(String ... supportedAuthenticationTypes) {
            this.supportedAuthenticationTypesWithStrings(Arrays.asList(supportedAuthenticationTypes));
            return this;
        }

        @Override
        public final Builder supportedAuthenticationTypes(Collection<AuthenticationType> supportedAuthenticationTypes) {
            this.supportedAuthenticationTypes = AuthenticationTypesCopier.copyEnumToString(supportedAuthenticationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAuthenticationTypes(AuthenticationType ... supportedAuthenticationTypes) {
            this.supportedAuthenticationTypes(Arrays.asList(supportedAuthenticationTypes));
            return this;
        }

        public final Collection<String> getSupportedDataOperations() {
            if (this.supportedDataOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedDataOperations;
        }

        public final void setSupportedDataOperations(Collection<String> supportedDataOperations) {
            this.supportedDataOperations = DataOperationsCopier.copy(supportedDataOperations);
        }

        @Override
        public final Builder supportedDataOperationsWithStrings(Collection<String> supportedDataOperations) {
            this.supportedDataOperations = DataOperationsCopier.copy(supportedDataOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataOperationsWithStrings(String ... supportedDataOperations) {
            this.supportedDataOperationsWithStrings(Arrays.asList(supportedDataOperations));
            return this;
        }

        @Override
        public final Builder supportedDataOperations(Collection<DataOperation> supportedDataOperations) {
            this.supportedDataOperations = DataOperationsCopier.copyEnumToString(supportedDataOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataOperations(DataOperation ... supportedDataOperations) {
            this.supportedDataOperations(Arrays.asList(supportedDataOperations));
            return this;
        }

        public final Collection<String> getSupportedComputeEnvironments() {
            if (this.supportedComputeEnvironments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedComputeEnvironments;
        }

        public final void setSupportedComputeEnvironments(Collection<String> supportedComputeEnvironments) {
            this.supportedComputeEnvironments = ComputeEnvironmentsCopier.copy(supportedComputeEnvironments);
        }

        @Override
        public final Builder supportedComputeEnvironmentsWithStrings(Collection<String> supportedComputeEnvironments) {
            this.supportedComputeEnvironments = ComputeEnvironmentsCopier.copy(supportedComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedComputeEnvironmentsWithStrings(String ... supportedComputeEnvironments) {
            this.supportedComputeEnvironmentsWithStrings(Arrays.asList(supportedComputeEnvironments));
            return this;
        }

        @Override
        public final Builder supportedComputeEnvironments(Collection<ComputeEnvironment> supportedComputeEnvironments) {
            this.supportedComputeEnvironments = ComputeEnvironmentsCopier.copyEnumToString(supportedComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedComputeEnvironments(ComputeEnvironment ... supportedComputeEnvironments) {
            this.supportedComputeEnvironments(Arrays.asList(supportedComputeEnvironments));
            return this;
        }

        public Capabilities build() {
            return new Capabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Capabilities> {
        public Builder supportedAuthenticationTypesWithStrings(Collection<String> var1);

        public Builder supportedAuthenticationTypesWithStrings(String ... var1);

        public Builder supportedAuthenticationTypes(Collection<AuthenticationType> var1);

        public Builder supportedAuthenticationTypes(AuthenticationType ... var1);

        public Builder supportedDataOperationsWithStrings(Collection<String> var1);

        public Builder supportedDataOperationsWithStrings(String ... var1);

        public Builder supportedDataOperations(Collection<DataOperation> var1);

        public Builder supportedDataOperations(DataOperation ... var1);

        public Builder supportedComputeEnvironmentsWithStrings(Collection<String> var1);

        public Builder supportedComputeEnvironmentsWithStrings(String ... var1);

        public Builder supportedComputeEnvironments(Collection<ComputeEnvironment> var1);

        public Builder supportedComputeEnvironments(ComputeEnvironment ... var1);
    }
}

