/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.TableAttributes;
import software.amazon.awssdk.services.glue.model.TableAttributesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTablesRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetTablesRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(GetTablesRequest.getter(GetTablesRequest::catalogId)).setter(GetTablesRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(GetTablesRequest.getter(GetTablesRequest::databaseName)).setter(GetTablesRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expression").getter(GetTablesRequest.getter(GetTablesRequest::expression)).setter(GetTablesRequest.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTablesRequest.getter(GetTablesRequest::nextToken)).setter(GetTablesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetTablesRequest.getter(GetTablesRequest::maxResults)).setter(GetTablesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransactionId").getter(GetTablesRequest.getter(GetTablesRequest::transactionId)).setter(GetTablesRequest.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()}).build();
    private static final SdkField<Instant> QUERY_AS_OF_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("QueryAsOfTime").getter(GetTablesRequest.getter(GetTablesRequest::queryAsOfTime)).setter(GetTablesRequest.setter(Builder::queryAsOfTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAsOfTime").build()}).build();
    private static final SdkField<Boolean> INCLUDE_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeStatusDetails").getter(GetTablesRequest.getter(GetTablesRequest::includeStatusDetails)).setter(GetTablesRequest.setter(Builder::includeStatusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeStatusDetails").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTES_TO_GET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributesToGet").getter(GetTablesRequest.getter(GetTablesRequest::attributesToGetAsStrings)).setter(GetTablesRequest.setter(Builder::attributesToGetWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToGet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, EXPRESSION_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, TRANSACTION_ID_FIELD, QUERY_AS_OF_TIME_FIELD, INCLUDE_STATUS_DETAILS_FIELD, ATTRIBUTES_TO_GET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CatalogId", CATALOG_ID_FIELD);
            this.put("DatabaseName", DATABASE_NAME_FIELD);
            this.put("Expression", EXPRESSION_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("TransactionId", TRANSACTION_ID_FIELD);
            this.put("QueryAsOfTime", QUERY_AS_OF_TIME_FIELD);
            this.put("IncludeStatusDetails", INCLUDE_STATUS_DETAILS_FIELD);
            this.put("AttributesToGet", ATTRIBUTES_TO_GET_FIELD);
        }
    });
    private final String catalogId;
    private final String databaseName;
    private final String expression;
    private final String nextToken;
    private final Integer maxResults;
    private final String transactionId;
    private final Instant queryAsOfTime;
    private final Boolean includeStatusDetails;
    private final List<String> attributesToGet;

    private GetTablesRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.expression = builder.expression;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.transactionId = builder.transactionId;
        this.queryAsOfTime = builder.queryAsOfTime;
        this.includeStatusDetails = builder.includeStatusDetails;
        this.attributesToGet = builder.attributesToGet;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String expression() {
        return this.expression;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    public final Instant queryAsOfTime() {
        return this.queryAsOfTime;
    }

    public final Boolean includeStatusDetails() {
        return this.includeStatusDetails;
    }

    public final List<TableAttributes> attributesToGet() {
        return TableAttributesListCopier.copyStringToEnum(this.attributesToGet);
    }

    public final boolean hasAttributesToGet() {
        return this.attributesToGet != null && !(this.attributesToGet instanceof SdkAutoConstructList);
    }

    public final List<String> attributesToGetAsStrings() {
        return this.attributesToGet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryAsOfTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributesToGet() ? this.attributesToGetAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTablesRequest)) {
            return false;
        }
        GetTablesRequest other = (GetTablesRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.expression(), other.expression()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.transactionId(), other.transactionId()) && Objects.equals(this.queryAsOfTime(), other.queryAsOfTime()) && Objects.equals(this.includeStatusDetails(), other.includeStatusDetails()) && this.hasAttributesToGet() == other.hasAttributesToGet() && Objects.equals(this.attributesToGetAsStrings(), other.attributesToGetAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetTablesRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("Expression", (Object)this.expression()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("TransactionId", (Object)this.transactionId()).add("QueryAsOfTime", (Object)this.queryAsOfTime()).add("IncludeStatusDetails", (Object)this.includeStatusDetails()).add("AttributesToGet", this.hasAttributesToGet() ? this.attributesToGetAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "TransactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "QueryAsOfTime": {
                return Optional.ofNullable(clazz.cast(this.queryAsOfTime()));
            }
            case "IncludeStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.includeStatusDetails()));
            }
            case "AttributesToGet": {
                return Optional.ofNullable(clazz.cast(this.attributesToGetAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTablesRequest, T> g) {
        return obj -> g.apply((GetTablesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String expression;
        private String nextToken;
        private Integer maxResults;
        private String transactionId;
        private Instant queryAsOfTime;
        private Boolean includeStatusDetails;
        private List<String> attributesToGet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTablesRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.expression(model.expression);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.transactionId(model.transactionId);
            this.queryAsOfTime(model.queryAsOfTime);
            this.includeStatusDetails(model.includeStatusDetails);
            this.attributesToGetWithStrings(model.attributesToGet);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final Instant getQueryAsOfTime() {
            return this.queryAsOfTime;
        }

        public final void setQueryAsOfTime(Instant queryAsOfTime) {
            this.queryAsOfTime = queryAsOfTime;
        }

        @Override
        public final Builder queryAsOfTime(Instant queryAsOfTime) {
            this.queryAsOfTime = queryAsOfTime;
            return this;
        }

        public final Boolean getIncludeStatusDetails() {
            return this.includeStatusDetails;
        }

        public final void setIncludeStatusDetails(Boolean includeStatusDetails) {
            this.includeStatusDetails = includeStatusDetails;
        }

        @Override
        public final Builder includeStatusDetails(Boolean includeStatusDetails) {
            this.includeStatusDetails = includeStatusDetails;
            return this;
        }

        public final Collection<String> getAttributesToGet() {
            if (this.attributesToGet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributesToGet;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = TableAttributesListCopier.copy(attributesToGet);
        }

        @Override
        public final Builder attributesToGetWithStrings(Collection<String> attributesToGet) {
            this.attributesToGet = TableAttributesListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGetWithStrings(String ... attributesToGet) {
            this.attributesToGetWithStrings(Arrays.asList(attributesToGet));
            return this;
        }

        @Override
        public final Builder attributesToGet(Collection<TableAttributes> attributesToGet) {
            this.attributesToGet = TableAttributesListCopier.copyEnumToString(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(TableAttributes ... attributesToGet) {
            this.attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTablesRequest build() {
            return new GetTablesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTablesRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder expression(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder transactionId(String var1);

        public Builder queryAsOfTime(Instant var1);

        public Builder includeStatusDetails(Boolean var1);

        public Builder attributesToGetWithStrings(Collection<String> var1);

        public Builder attributesToGetWithStrings(String ... var1);

        public Builder attributesToGet(Collection<TableAttributes> var1);

        public Builder attributesToGet(TableAttributes ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

