/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GetTableVersionsListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.TableVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableVersionsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetTableVersionsResponse> {
    private static final SdkField<List<TableVersion>> TABLE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TableVersions").getter(GetTableVersionsResponse.getter(GetTableVersionsResponse::tableVersions)).setter(GetTableVersionsResponse.setter(Builder::tableVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTableVersionsResponse.getter(GetTableVersionsResponse::nextToken)).setter(GetTableVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TableVersions", TABLE_VERSIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<TableVersion> tableVersions;
    private final String nextToken;

    private GetTableVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.tableVersions = builder.tableVersions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTableVersions() {
        return this.tableVersions != null && !(this.tableVersions instanceof SdkAutoConstructList);
    }

    public final List<TableVersion> tableVersions() {
        return this.tableVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableVersions() ? this.tableVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableVersionsResponse)) {
            return false;
        }
        GetTableVersionsResponse other = (GetTableVersionsResponse)((Object)obj);
        return this.hasTableVersions() == other.hasTableVersions() && Objects.equals(this.tableVersions(), other.tableVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableVersionsResponse").add("TableVersions", this.hasTableVersions() ? this.tableVersions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableVersions": {
                return Optional.ofNullable(clazz.cast(this.tableVersions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTableVersionsResponse, T> g) {
        return obj -> g.apply((GetTableVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<TableVersion> tableVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableVersionsResponse model) {
            super(model);
            this.tableVersions(model.tableVersions);
            this.nextToken(model.nextToken);
        }

        public final List<TableVersion.Builder> getTableVersions() {
            List<TableVersion.Builder> result = GetTableVersionsListCopier.copyToBuilder(this.tableVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableVersions(Collection<TableVersion.BuilderImpl> tableVersions) {
            this.tableVersions = GetTableVersionsListCopier.copyFromBuilder(tableVersions);
        }

        @Override
        public final Builder tableVersions(Collection<TableVersion> tableVersions) {
            this.tableVersions = GetTableVersionsListCopier.copy(tableVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableVersions(TableVersion ... tableVersions) {
            this.tableVersions(Arrays.asList(tableVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableVersions(Consumer<TableVersion.Builder> ... tableVersions) {
            this.tableVersions(Stream.of(tableVersions).map(c -> (TableVersion)((TableVersion.Builder)TableVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetTableVersionsResponse build() {
            return new GetTableVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableVersionsResponse> {
        public Builder tableVersions(Collection<TableVersion> var1);

        public Builder tableVersions(TableVersion ... var1);

        public Builder tableVersions(Consumer<TableVersion.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

