/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.DataLakeAccessPropertiesOutput;
import software.amazon.awssdk.services.glue.model.ParametersMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CatalogPropertiesOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CatalogPropertiesOutput> {
    private static final SdkField<DataLakeAccessPropertiesOutput> DATA_LAKE_ACCESS_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataLakeAccessProperties").getter(CatalogPropertiesOutput.getter(CatalogPropertiesOutput::dataLakeAccessProperties)).setter(CatalogPropertiesOutput.setter(Builder::dataLakeAccessProperties)).constructor(DataLakeAccessPropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeAccessProperties").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomProperties").getter(CatalogPropertiesOutput.getter(CatalogPropertiesOutput::customProperties)).setter(CatalogPropertiesOutput.setter(Builder::customProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LAKE_ACCESS_PROPERTIES_FIELD, CUSTOM_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataLakeAccessProperties", DATA_LAKE_ACCESS_PROPERTIES_FIELD);
            this.put("CustomProperties", CUSTOM_PROPERTIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final DataLakeAccessPropertiesOutput dataLakeAccessProperties;
    private final Map<String, String> customProperties;

    private CatalogPropertiesOutput(BuilderImpl builder) {
        this.dataLakeAccessProperties = builder.dataLakeAccessProperties;
        this.customProperties = builder.customProperties;
    }

    public final DataLakeAccessPropertiesOutput dataLakeAccessProperties() {
        return this.dataLakeAccessProperties;
    }

    public final boolean hasCustomProperties() {
        return this.customProperties != null && !(this.customProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customProperties() {
        return this.customProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLakeAccessProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomProperties() ? this.customProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogPropertiesOutput)) {
            return false;
        }
        CatalogPropertiesOutput other = (CatalogPropertiesOutput)obj;
        return Objects.equals(this.dataLakeAccessProperties(), other.dataLakeAccessProperties()) && this.hasCustomProperties() == other.hasCustomProperties() && Objects.equals(this.customProperties(), other.customProperties());
    }

    public final String toString() {
        return ToString.builder((String)"CatalogPropertiesOutput").add("DataLakeAccessProperties", (Object)this.dataLakeAccessProperties()).add("CustomProperties", this.hasCustomProperties() ? this.customProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataLakeAccessProperties": {
                return Optional.ofNullable(clazz.cast(this.dataLakeAccessProperties()));
            }
            case "CustomProperties": {
                return Optional.ofNullable(clazz.cast(this.customProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CatalogPropertiesOutput, T> g) {
        return obj -> g.apply((CatalogPropertiesOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataLakeAccessPropertiesOutput dataLakeAccessProperties;
        private Map<String, String> customProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogPropertiesOutput model) {
            this.dataLakeAccessProperties(model.dataLakeAccessProperties);
            this.customProperties(model.customProperties);
        }

        public final DataLakeAccessPropertiesOutput.Builder getDataLakeAccessProperties() {
            return this.dataLakeAccessProperties != null ? this.dataLakeAccessProperties.toBuilder() : null;
        }

        public final void setDataLakeAccessProperties(DataLakeAccessPropertiesOutput.BuilderImpl dataLakeAccessProperties) {
            this.dataLakeAccessProperties = dataLakeAccessProperties != null ? dataLakeAccessProperties.build() : null;
        }

        @Override
        public final Builder dataLakeAccessProperties(DataLakeAccessPropertiesOutput dataLakeAccessProperties) {
            this.dataLakeAccessProperties = dataLakeAccessProperties;
            return this;
        }

        public final Map<String, String> getCustomProperties() {
            if (this.customProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customProperties;
        }

        public final void setCustomProperties(Map<String, String> customProperties) {
            this.customProperties = ParametersMapCopier.copy(customProperties);
        }

        @Override
        public final Builder customProperties(Map<String, String> customProperties) {
            this.customProperties = ParametersMapCopier.copy(customProperties);
            return this;
        }

        public CatalogPropertiesOutput build() {
            return new CatalogPropertiesOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CatalogPropertiesOutput> {
        public Builder dataLakeAccessProperties(DataLakeAccessPropertiesOutput var1);

        default public Builder dataLakeAccessProperties(Consumer<DataLakeAccessPropertiesOutput.Builder> dataLakeAccessProperties) {
            return this.dataLakeAccessProperties((DataLakeAccessPropertiesOutput)((DataLakeAccessPropertiesOutput.Builder)DataLakeAccessPropertiesOutput.builder().applyMutation(dataLakeAccessProperties)).build());
        }

        public Builder customProperties(Map<String, String> var1);
    }
}

