/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.OrchestrationStringListCopier;
import software.amazon.awssdk.services.glue.model.StatementOutputData;
import software.amazon.awssdk.services.glue.model.StatementState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatementOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatementOutput> {
    private static final SdkField<StatementOutputData> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Data").getter(StatementOutput.getter(StatementOutput::data)).setter(StatementOutput.setter(Builder::data)).constructor(StatementOutputData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()}).build();
    private static final SdkField<Integer> EXECUTION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExecutionCount").getter(StatementOutput.getter(StatementOutput::executionCount)).setter(StatementOutput.setter(Builder::executionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionCount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StatementOutput.getter(StatementOutput::statusAsString)).setter(StatementOutput.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorName").getter(StatementOutput.getter(StatementOutput::errorName)).setter(StatementOutput.setter(Builder::errorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorName").build()}).build();
    private static final SdkField<String> ERROR_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorValue").getter(StatementOutput.getter(StatementOutput::errorValue)).setter(StatementOutput.setter(Builder::errorValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorValue").build()}).build();
    private static final SdkField<List<String>> TRACEBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Traceback").getter(StatementOutput.getter(StatementOutput::traceback)).setter(StatementOutput.setter(Builder::traceback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traceback").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD, EXECUTION_COUNT_FIELD, STATUS_FIELD, ERROR_NAME_FIELD, ERROR_VALUE_FIELD, TRACEBACK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Data", DATA_FIELD);
            this.put("ExecutionCount", EXECUTION_COUNT_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("ErrorName", ERROR_NAME_FIELD);
            this.put("ErrorValue", ERROR_VALUE_FIELD);
            this.put("Traceback", TRACEBACK_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final StatementOutputData data;
    private final Integer executionCount;
    private final String status;
    private final String errorName;
    private final String errorValue;
    private final List<String> traceback;

    private StatementOutput(BuilderImpl builder) {
        this.data = builder.data;
        this.executionCount = builder.executionCount;
        this.status = builder.status;
        this.errorName = builder.errorName;
        this.errorValue = builder.errorValue;
        this.traceback = builder.traceback;
    }

    public final StatementOutputData data() {
        return this.data;
    }

    public final Integer executionCount() {
        return this.executionCount;
    }

    public final StatementState status() {
        return StatementState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorName() {
        return this.errorName;
    }

    public final String errorValue() {
        return this.errorValue;
    }

    public final boolean hasTraceback() {
        return this.traceback != null && !(this.traceback instanceof SdkAutoConstructList);
    }

    public final List<String> traceback() {
        return this.traceback;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTraceback() ? this.traceback() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatementOutput)) {
            return false;
        }
        StatementOutput other = (StatementOutput)obj;
        return Objects.equals(this.data(), other.data()) && Objects.equals(this.executionCount(), other.executionCount()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorName(), other.errorName()) && Objects.equals(this.errorValue(), other.errorValue()) && this.hasTraceback() == other.hasTraceback() && Objects.equals(this.traceback(), other.traceback());
    }

    public final String toString() {
        return ToString.builder((String)"StatementOutput").add("Data", (Object)this.data()).add("ExecutionCount", (Object)this.executionCount()).add("Status", (Object)this.statusAsString()).add("ErrorName", (Object)this.errorName()).add("ErrorValue", (Object)this.errorValue()).add("Traceback", this.hasTraceback() ? this.traceback() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "ExecutionCount": {
                return Optional.ofNullable(clazz.cast(this.executionCount()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ErrorName": {
                return Optional.ofNullable(clazz.cast(this.errorName()));
            }
            case "ErrorValue": {
                return Optional.ofNullable(clazz.cast(this.errorValue()));
            }
            case "Traceback": {
                return Optional.ofNullable(clazz.cast(this.traceback()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StatementOutput, T> g) {
        return obj -> g.apply((StatementOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private StatementOutputData data;
        private Integer executionCount;
        private String status;
        private String errorName;
        private String errorValue;
        private List<String> traceback = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StatementOutput model) {
            this.data(model.data);
            this.executionCount(model.executionCount);
            this.status(model.status);
            this.errorName(model.errorName);
            this.errorValue(model.errorValue);
            this.traceback(model.traceback);
        }

        public final StatementOutputData.Builder getData() {
            return this.data != null ? this.data.toBuilder() : null;
        }

        public final void setData(StatementOutputData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(StatementOutputData data) {
            this.data = data;
            return this;
        }

        public final Integer getExecutionCount() {
            return this.executionCount;
        }

        public final void setExecutionCount(Integer executionCount) {
            this.executionCount = executionCount;
        }

        @Override
        public final Builder executionCount(Integer executionCount) {
            this.executionCount = executionCount;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatementState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorName() {
            return this.errorName;
        }

        public final void setErrorName(String errorName) {
            this.errorName = errorName;
        }

        @Override
        public final Builder errorName(String errorName) {
            this.errorName = errorName;
            return this;
        }

        public final String getErrorValue() {
            return this.errorValue;
        }

        public final void setErrorValue(String errorValue) {
            this.errorValue = errorValue;
        }

        @Override
        public final Builder errorValue(String errorValue) {
            this.errorValue = errorValue;
            return this;
        }

        public final Collection<String> getTraceback() {
            if (this.traceback instanceof SdkAutoConstructList) {
                return null;
            }
            return this.traceback;
        }

        public final void setTraceback(Collection<String> traceback) {
            this.traceback = OrchestrationStringListCopier.copy(traceback);
        }

        @Override
        public final Builder traceback(Collection<String> traceback) {
            this.traceback = OrchestrationStringListCopier.copy(traceback);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traceback(String ... traceback) {
            this.traceback(Arrays.asList(traceback));
            return this;
        }

        public StatementOutput build() {
            return new StatementOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatementOutput> {
        public Builder data(StatementOutputData var1);

        default public Builder data(Consumer<StatementOutputData.Builder> data) {
            return this.data((StatementOutputData)((StatementOutputData.Builder)StatementOutputData.builder().applyMutation(data)).build());
        }

        public Builder executionCount(Integer var1);

        public Builder status(String var1);

        public Builder status(StatementState var1);

        public Builder errorName(String var1);

        public Builder errorValue(String var1);

        public Builder traceback(Collection<String> var1);

        public Builder traceback(String ... var1);
    }
}

