/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DatabaseAttributes;
import software.amazon.awssdk.services.glue.model.DatabaseAttributesListCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.ResourceShareType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDatabasesRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetDatabasesRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(GetDatabasesRequest.getter(GetDatabasesRequest::catalogId)).setter(GetDatabasesRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetDatabasesRequest.getter(GetDatabasesRequest::nextToken)).setter(GetDatabasesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetDatabasesRequest.getter(GetDatabasesRequest::maxResults)).setter(GetDatabasesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> RESOURCE_SHARE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceShareType").getter(GetDatabasesRequest.getter(GetDatabasesRequest::resourceShareTypeAsString)).setter(GetDatabasesRequest.setter(Builder::resourceShareType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceShareType").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTES_TO_GET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributesToGet").getter(GetDatabasesRequest.getter(GetDatabasesRequest::attributesToGetAsStrings)).setter(GetDatabasesRequest.setter(Builder::attributesToGetWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToGet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RESOURCE_SHARE_TYPE_FIELD, ATTRIBUTES_TO_GET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CatalogId", CATALOG_ID_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("ResourceShareType", RESOURCE_SHARE_TYPE_FIELD);
            this.put("AttributesToGet", ATTRIBUTES_TO_GET_FIELD);
        }
    });
    private final String catalogId;
    private final String nextToken;
    private final Integer maxResults;
    private final String resourceShareType;
    private final List<String> attributesToGet;

    private GetDatabasesRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resourceShareType = builder.resourceShareType;
        this.attributesToGet = builder.attributesToGet;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ResourceShareType resourceShareType() {
        return ResourceShareType.fromValue(this.resourceShareType);
    }

    public final String resourceShareTypeAsString() {
        return this.resourceShareType;
    }

    public final List<DatabaseAttributes> attributesToGet() {
        return DatabaseAttributesListCopier.copyStringToEnum(this.attributesToGet);
    }

    public final boolean hasAttributesToGet() {
        return this.attributesToGet != null && !(this.attributesToGet instanceof SdkAutoConstructList);
    }

    public final List<String> attributesToGetAsStrings() {
        return this.attributesToGet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributesToGet() ? this.attributesToGetAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatabasesRequest)) {
            return false;
        }
        GetDatabasesRequest other = (GetDatabasesRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.resourceShareTypeAsString(), other.resourceShareTypeAsString()) && this.hasAttributesToGet() == other.hasAttributesToGet() && Objects.equals(this.attributesToGetAsStrings(), other.attributesToGetAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetDatabasesRequest").add("CatalogId", (Object)this.catalogId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ResourceShareType", (Object)this.resourceShareTypeAsString()).add("AttributesToGet", this.hasAttributesToGet() ? this.attributesToGetAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ResourceShareType": {
                return Optional.ofNullable(clazz.cast(this.resourceShareTypeAsString()));
            }
            case "AttributesToGet": {
                return Optional.ofNullable(clazz.cast(this.attributesToGetAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDatabasesRequest, T> g) {
        return obj -> g.apply((GetDatabasesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String nextToken;
        private Integer maxResults;
        private String resourceShareType;
        private List<String> attributesToGet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatabasesRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.resourceShareType(model.resourceShareType);
            this.attributesToGetWithStrings(model.attributesToGet);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getResourceShareType() {
            return this.resourceShareType;
        }

        public final void setResourceShareType(String resourceShareType) {
            this.resourceShareType = resourceShareType;
        }

        @Override
        public final Builder resourceShareType(String resourceShareType) {
            this.resourceShareType = resourceShareType;
            return this;
        }

        @Override
        public final Builder resourceShareType(ResourceShareType resourceShareType) {
            this.resourceShareType(resourceShareType == null ? null : resourceShareType.toString());
            return this;
        }

        public final Collection<String> getAttributesToGet() {
            if (this.attributesToGet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributesToGet;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = DatabaseAttributesListCopier.copy(attributesToGet);
        }

        @Override
        public final Builder attributesToGetWithStrings(Collection<String> attributesToGet) {
            this.attributesToGet = DatabaseAttributesListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGetWithStrings(String ... attributesToGet) {
            this.attributesToGetWithStrings(Arrays.asList(attributesToGet));
            return this;
        }

        @Override
        public final Builder attributesToGet(Collection<DatabaseAttributes> attributesToGet) {
            this.attributesToGet = DatabaseAttributesListCopier.copyEnumToString(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(DatabaseAttributes ... attributesToGet) {
            this.attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDatabasesRequest build() {
            return new GetDatabasesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDatabasesRequest> {
        public Builder catalogId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder resourceShareType(String var1);

        public Builder resourceShareType(ResourceShareType var1);

        public Builder attributesToGetWithStrings(Collection<String> var1);

        public Builder attributesToGetWithStrings(String ... var1);

        public Builder attributesToGet(Collection<DatabaseAttributes> var1);

        public Builder attributesToGet(DatabaseAttributes ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

