/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.EnclosedInStringPropertiesMinOneCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpsertRedshiftTargetOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpsertRedshiftTargetOptions> {
    private static final SdkField<String> TABLE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableLocation").getter(UpsertRedshiftTargetOptions.getter(UpsertRedshiftTargetOptions::tableLocation)).setter(UpsertRedshiftTargetOptions.setter(Builder::tableLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableLocation").build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(UpsertRedshiftTargetOptions.getter(UpsertRedshiftTargetOptions::connectionName)).setter(UpsertRedshiftTargetOptions.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<List<String>> UPSERT_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UpsertKeys").getter(UpsertRedshiftTargetOptions.getter(UpsertRedshiftTargetOptions::upsertKeys)).setter(UpsertRedshiftTargetOptions.setter(Builder::upsertKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpsertKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_LOCATION_FIELD, CONNECTION_NAME_FIELD, UPSERT_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TableLocation", TABLE_LOCATION_FIELD);
            this.put("ConnectionName", CONNECTION_NAME_FIELD);
            this.put("UpsertKeys", UPSERT_KEYS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String tableLocation;
    private final String connectionName;
    private final List<String> upsertKeys;

    private UpsertRedshiftTargetOptions(BuilderImpl builder) {
        this.tableLocation = builder.tableLocation;
        this.connectionName = builder.connectionName;
        this.upsertKeys = builder.upsertKeys;
    }

    public final String tableLocation() {
        return this.tableLocation;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final boolean hasUpsertKeys() {
        return this.upsertKeys != null && !(this.upsertKeys instanceof SdkAutoConstructList);
    }

    public final List<String> upsertKeys() {
        return this.upsertKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpsertKeys() ? this.upsertKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpsertRedshiftTargetOptions)) {
            return false;
        }
        UpsertRedshiftTargetOptions other = (UpsertRedshiftTargetOptions)obj;
        return Objects.equals(this.tableLocation(), other.tableLocation()) && Objects.equals(this.connectionName(), other.connectionName()) && this.hasUpsertKeys() == other.hasUpsertKeys() && Objects.equals(this.upsertKeys(), other.upsertKeys());
    }

    public final String toString() {
        return ToString.builder((String)"UpsertRedshiftTargetOptions").add("TableLocation", (Object)this.tableLocation()).add("ConnectionName", (Object)this.connectionName()).add("UpsertKeys", this.hasUpsertKeys() ? this.upsertKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableLocation": {
                return Optional.ofNullable(clazz.cast(this.tableLocation()));
            }
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "UpsertKeys": {
                return Optional.ofNullable(clazz.cast(this.upsertKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpsertRedshiftTargetOptions, T> g) {
        return obj -> g.apply((UpsertRedshiftTargetOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableLocation;
        private String connectionName;
        private List<String> upsertKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpsertRedshiftTargetOptions model) {
            this.tableLocation(model.tableLocation);
            this.connectionName(model.connectionName);
            this.upsertKeys(model.upsertKeys);
        }

        public final String getTableLocation() {
            return this.tableLocation;
        }

        public final void setTableLocation(String tableLocation) {
            this.tableLocation = tableLocation;
        }

        @Override
        public final Builder tableLocation(String tableLocation) {
            this.tableLocation = tableLocation;
            return this;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final Collection<String> getUpsertKeys() {
            if (this.upsertKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.upsertKeys;
        }

        public final void setUpsertKeys(Collection<String> upsertKeys) {
            this.upsertKeys = EnclosedInStringPropertiesMinOneCopier.copy(upsertKeys);
        }

        @Override
        public final Builder upsertKeys(Collection<String> upsertKeys) {
            this.upsertKeys = EnclosedInStringPropertiesMinOneCopier.copy(upsertKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upsertKeys(String ... upsertKeys) {
            this.upsertKeys(Arrays.asList(upsertKeys));
            return this;
        }

        public UpsertRedshiftTargetOptions build() {
            return new UpsertRedshiftTargetOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpsertRedshiftTargetOptions> {
        public Builder tableLocation(String var1);

        public Builder connectionName(String var1);

        public Builder upsertKeys(Collection<String> var1);

        public Builder upsertKeys(String ... var1);
    }
}

