/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.NameStringListCopier;
import software.amazon.awssdk.services.glue.model.Partition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUnfilteredPartitionMetadataResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetUnfilteredPartitionMetadataResponse> {
    private static final SdkField<Partition> PARTITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Partition").getter(GetUnfilteredPartitionMetadataResponse.getter(GetUnfilteredPartitionMetadataResponse::partition)).setter(GetUnfilteredPartitionMetadataResponse.setter(Builder::partition)).constructor(Partition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partition").build()}).build();
    private static final SdkField<List<String>> AUTHORIZED_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedColumns").getter(GetUnfilteredPartitionMetadataResponse.getter(GetUnfilteredPartitionMetadataResponse::authorizedColumns)).setter(GetUnfilteredPartitionMetadataResponse.setter(Builder::authorizedColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_REGISTERED_WITH_LAKE_FORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsRegisteredWithLakeFormation").getter(GetUnfilteredPartitionMetadataResponse.getter(GetUnfilteredPartitionMetadataResponse::isRegisteredWithLakeFormation)).setter(GetUnfilteredPartitionMetadataResponse.setter(Builder::isRegisteredWithLakeFormation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRegisteredWithLakeFormation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_FIELD, AUTHORIZED_COLUMNS_FIELD, IS_REGISTERED_WITH_LAKE_FORMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Partition", PARTITION_FIELD);
            this.put("AuthorizedColumns", AUTHORIZED_COLUMNS_FIELD);
            this.put("IsRegisteredWithLakeFormation", IS_REGISTERED_WITH_LAKE_FORMATION_FIELD);
        }
    });
    private final Partition partition;
    private final List<String> authorizedColumns;
    private final Boolean isRegisteredWithLakeFormation;

    private GetUnfilteredPartitionMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.partition = builder.partition;
        this.authorizedColumns = builder.authorizedColumns;
        this.isRegisteredWithLakeFormation = builder.isRegisteredWithLakeFormation;
    }

    public final Partition partition() {
        return this.partition;
    }

    public final boolean hasAuthorizedColumns() {
        return this.authorizedColumns != null && !(this.authorizedColumns instanceof SdkAutoConstructList);
    }

    public final List<String> authorizedColumns() {
        return this.authorizedColumns;
    }

    public final Boolean isRegisteredWithLakeFormation() {
        return this.isRegisteredWithLakeFormation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.partition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedColumns() ? this.authorizedColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isRegisteredWithLakeFormation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUnfilteredPartitionMetadataResponse)) {
            return false;
        }
        GetUnfilteredPartitionMetadataResponse other = (GetUnfilteredPartitionMetadataResponse)((Object)obj);
        return Objects.equals(this.partition(), other.partition()) && this.hasAuthorizedColumns() == other.hasAuthorizedColumns() && Objects.equals(this.authorizedColumns(), other.authorizedColumns()) && Objects.equals(this.isRegisteredWithLakeFormation(), other.isRegisteredWithLakeFormation());
    }

    public final String toString() {
        return ToString.builder((String)"GetUnfilteredPartitionMetadataResponse").add("Partition", (Object)this.partition()).add("AuthorizedColumns", this.hasAuthorizedColumns() ? this.authorizedColumns() : null).add("IsRegisteredWithLakeFormation", (Object)this.isRegisteredWithLakeFormation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Partition": {
                return Optional.ofNullable(clazz.cast(this.partition()));
            }
            case "AuthorizedColumns": {
                return Optional.ofNullable(clazz.cast(this.authorizedColumns()));
            }
            case "IsRegisteredWithLakeFormation": {
                return Optional.ofNullable(clazz.cast(this.isRegisteredWithLakeFormation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetUnfilteredPartitionMetadataResponse, T> g) {
        return obj -> g.apply((GetUnfilteredPartitionMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private Partition partition;
        private List<String> authorizedColumns = DefaultSdkAutoConstructList.getInstance();
        private Boolean isRegisteredWithLakeFormation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUnfilteredPartitionMetadataResponse model) {
            super(model);
            this.partition(model.partition);
            this.authorizedColumns(model.authorizedColumns);
            this.isRegisteredWithLakeFormation(model.isRegisteredWithLakeFormation);
        }

        public final Partition.Builder getPartition() {
            return this.partition != null ? this.partition.toBuilder() : null;
        }

        public final void setPartition(Partition.BuilderImpl partition) {
            this.partition = partition != null ? partition.build() : null;
        }

        @Override
        public final Builder partition(Partition partition) {
            this.partition = partition;
            return this;
        }

        public final Collection<String> getAuthorizedColumns() {
            if (this.authorizedColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorizedColumns;
        }

        public final void setAuthorizedColumns(Collection<String> authorizedColumns) {
            this.authorizedColumns = NameStringListCopier.copy(authorizedColumns);
        }

        @Override
        public final Builder authorizedColumns(Collection<String> authorizedColumns) {
            this.authorizedColumns = NameStringListCopier.copy(authorizedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedColumns(String ... authorizedColumns) {
            this.authorizedColumns(Arrays.asList(authorizedColumns));
            return this;
        }

        public final Boolean getIsRegisteredWithLakeFormation() {
            return this.isRegisteredWithLakeFormation;
        }

        public final void setIsRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
            this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
        }

        @Override
        public final Builder isRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
            this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
            return this;
        }

        @Override
        public GetUnfilteredPartitionMetadataResponse build() {
            return new GetUnfilteredPartitionMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUnfilteredPartitionMetadataResponse> {
        public Builder partition(Partition var1);

        default public Builder partition(Consumer<Partition.Builder> partition) {
            return this.partition((Partition)((Partition.Builder)Partition.builder().applyMutation(partition)).build());
        }

        public Builder authorizedColumns(Collection<String> var1);

        public Builder authorizedColumns(String ... var1);

        public Builder isRegisteredWithLakeFormation(Boolean var1);
    }
}

