/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.S3EncryptionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Encryption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Encryption> {
    private static final SdkField<String> S3_ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3EncryptionMode").getter(S3Encryption.getter(S3Encryption::s3EncryptionModeAsString)).setter(S3Encryption.setter(Builder::s3EncryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3EncryptionMode").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(S3Encryption.getter(S3Encryption::kmsKeyArn)).setter(S3Encryption.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ENCRYPTION_MODE_FIELD, KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("S3EncryptionMode", S3_ENCRYPTION_MODE_FIELD);
            this.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String s3EncryptionMode;
    private final String kmsKeyArn;

    private S3Encryption(BuilderImpl builder) {
        this.s3EncryptionMode = builder.s3EncryptionMode;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final S3EncryptionMode s3EncryptionMode() {
        return S3EncryptionMode.fromValue(this.s3EncryptionMode);
    }

    public final String s3EncryptionModeAsString() {
        return this.s3EncryptionMode;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3EncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Encryption)) {
            return false;
        }
        S3Encryption other = (S3Encryption)obj;
        return Objects.equals(this.s3EncryptionModeAsString(), other.s3EncryptionModeAsString()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"S3Encryption").add("S3EncryptionMode", (Object)this.s3EncryptionModeAsString()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3EncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.s3EncryptionModeAsString()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3Encryption, T> g) {
        return obj -> g.apply((S3Encryption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3EncryptionMode;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Encryption model) {
            this.s3EncryptionMode(model.s3EncryptionMode);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getS3EncryptionMode() {
            return this.s3EncryptionMode;
        }

        public final void setS3EncryptionMode(String s3EncryptionMode) {
            this.s3EncryptionMode = s3EncryptionMode;
        }

        @Override
        public final Builder s3EncryptionMode(String s3EncryptionMode) {
            this.s3EncryptionMode = s3EncryptionMode;
            return this;
        }

        @Override
        public final Builder s3EncryptionMode(S3EncryptionMode s3EncryptionMode) {
            this.s3EncryptionMode(s3EncryptionMode == null ? null : s3EncryptionMode.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public S3Encryption build() {
            return new S3Encryption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Encryption> {
        public Builder s3EncryptionMode(String var1);

        public Builder s3EncryptionMode(S3EncryptionMode var1);

        public Builder kmsKeyArn(String var1);
    }
}

