/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListColumnStatisticsTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.ListColumnStatisticsTaskRunsResponse;

public class ListColumnStatisticsTaskRunsPublisher
implements SdkPublisher<ListColumnStatisticsTaskRunsResponse> {
    private final GlueAsyncClient client;
    private final ListColumnStatisticsTaskRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListColumnStatisticsTaskRunsPublisher(GlueAsyncClient client, ListColumnStatisticsTaskRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListColumnStatisticsTaskRunsPublisher(GlueAsyncClient client, ListColumnStatisticsTaskRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListColumnStatisticsTaskRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListColumnStatisticsTaskRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListColumnStatisticsTaskRunsResponseFetcher
    implements AsyncPageFetcher<ListColumnStatisticsTaskRunsResponse> {
        private ListColumnStatisticsTaskRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListColumnStatisticsTaskRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListColumnStatisticsTaskRunsResponse> nextPage(ListColumnStatisticsTaskRunsResponse previousPage) {
            if (previousPage == null) {
                return ListColumnStatisticsTaskRunsPublisher.this.client.listColumnStatisticsTaskRuns(ListColumnStatisticsTaskRunsPublisher.this.firstRequest);
            }
            return ListColumnStatisticsTaskRunsPublisher.this.client.listColumnStatisticsTaskRuns((ListColumnStatisticsTaskRunsRequest)((Object)ListColumnStatisticsTaskRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

