/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CustomEntityType;
import software.amazon.awssdk.services.glue.model.CustomEntityTypesCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomEntityTypesResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, ListCustomEntityTypesResponse> {
    private static final SdkField<List<CustomEntityType>> CUSTOM_ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomEntityTypes").getter(ListCustomEntityTypesResponse.getter(ListCustomEntityTypesResponse::customEntityTypes)).setter(ListCustomEntityTypesResponse.setter(Builder::customEntityTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEntityTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomEntityType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCustomEntityTypesResponse.getter(ListCustomEntityTypesResponse::nextToken)).setter(ListCustomEntityTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ENTITY_TYPES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CustomEntityTypes", CUSTOM_ENTITY_TYPES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<CustomEntityType> customEntityTypes;
    private final String nextToken;

    private ListCustomEntityTypesResponse(BuilderImpl builder) {
        super(builder);
        this.customEntityTypes = builder.customEntityTypes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCustomEntityTypes() {
        return this.customEntityTypes != null && !(this.customEntityTypes instanceof SdkAutoConstructList);
    }

    public final List<CustomEntityType> customEntityTypes() {
        return this.customEntityTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomEntityTypes() ? this.customEntityTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomEntityTypesResponse)) {
            return false;
        }
        ListCustomEntityTypesResponse other = (ListCustomEntityTypesResponse)((Object)obj);
        return this.hasCustomEntityTypes() == other.hasCustomEntityTypes() && Objects.equals(this.customEntityTypes(), other.customEntityTypes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomEntityTypesResponse").add("CustomEntityTypes", this.hasCustomEntityTypes() ? this.customEntityTypes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomEntityTypes": {
                return Optional.ofNullable(clazz.cast(this.customEntityTypes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomEntityTypesResponse, T> g) {
        return obj -> g.apply((ListCustomEntityTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<CustomEntityType> customEntityTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomEntityTypesResponse model) {
            super(model);
            this.customEntityTypes(model.customEntityTypes);
            this.nextToken(model.nextToken);
        }

        public final List<CustomEntityType.Builder> getCustomEntityTypes() {
            List<CustomEntityType.Builder> result = CustomEntityTypesCopier.copyToBuilder(this.customEntityTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomEntityTypes(Collection<CustomEntityType.BuilderImpl> customEntityTypes) {
            this.customEntityTypes = CustomEntityTypesCopier.copyFromBuilder(customEntityTypes);
        }

        @Override
        public final Builder customEntityTypes(Collection<CustomEntityType> customEntityTypes) {
            this.customEntityTypes = CustomEntityTypesCopier.copy(customEntityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customEntityTypes(CustomEntityType ... customEntityTypes) {
            this.customEntityTypes(Arrays.asList(customEntityTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customEntityTypes(Consumer<CustomEntityType.Builder> ... customEntityTypes) {
            this.customEntityTypes(Stream.of(customEntityTypes).map(c -> (CustomEntityType)((CustomEntityType.Builder)CustomEntityType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomEntityTypesResponse build() {
            return new ListCustomEntityTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomEntityTypesResponse> {
        public Builder customEntityTypes(Collection<CustomEntityType> var1);

        public Builder customEntityTypes(CustomEntityType ... var1);

        public Builder customEntityTypes(Consumer<CustomEntityType.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

