/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ColumnStatisticsTaskRun;
import software.amazon.awssdk.services.glue.model.ColumnStatisticsTaskRunsListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetColumnStatisticsTaskRunsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetColumnStatisticsTaskRunsResponse> {
    private static final SdkField<List<ColumnStatisticsTaskRun>> COLUMN_STATISTICS_TASK_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnStatisticsTaskRuns").getter(GetColumnStatisticsTaskRunsResponse.getter(GetColumnStatisticsTaskRunsResponse::columnStatisticsTaskRuns)).setter(GetColumnStatisticsTaskRunsResponse.setter(Builder::columnStatisticsTaskRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsTaskRuns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnStatisticsTaskRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetColumnStatisticsTaskRunsResponse.getter(GetColumnStatisticsTaskRunsResponse::nextToken)).setter(GetColumnStatisticsTaskRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_STATISTICS_TASK_RUNS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ColumnStatisticsTaskRuns", COLUMN_STATISTICS_TASK_RUNS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ColumnStatisticsTaskRun> columnStatisticsTaskRuns;
    private final String nextToken;

    private GetColumnStatisticsTaskRunsResponse(BuilderImpl builder) {
        super(builder);
        this.columnStatisticsTaskRuns = builder.columnStatisticsTaskRuns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasColumnStatisticsTaskRuns() {
        return this.columnStatisticsTaskRuns != null && !(this.columnStatisticsTaskRuns instanceof SdkAutoConstructList);
    }

    public final List<ColumnStatisticsTaskRun> columnStatisticsTaskRuns() {
        return this.columnStatisticsTaskRuns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnStatisticsTaskRuns() ? this.columnStatisticsTaskRuns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetColumnStatisticsTaskRunsResponse)) {
            return false;
        }
        GetColumnStatisticsTaskRunsResponse other = (GetColumnStatisticsTaskRunsResponse)((Object)obj);
        return this.hasColumnStatisticsTaskRuns() == other.hasColumnStatisticsTaskRuns() && Objects.equals(this.columnStatisticsTaskRuns(), other.columnStatisticsTaskRuns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetColumnStatisticsTaskRunsResponse").add("ColumnStatisticsTaskRuns", this.hasColumnStatisticsTaskRuns() ? this.columnStatisticsTaskRuns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnStatisticsTaskRuns": {
                return Optional.ofNullable(clazz.cast(this.columnStatisticsTaskRuns()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetColumnStatisticsTaskRunsResponse, T> g) {
        return obj -> g.apply((GetColumnStatisticsTaskRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<ColumnStatisticsTaskRun> columnStatisticsTaskRuns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetColumnStatisticsTaskRunsResponse model) {
            super(model);
            this.columnStatisticsTaskRuns(model.columnStatisticsTaskRuns);
            this.nextToken(model.nextToken);
        }

        public final List<ColumnStatisticsTaskRun.Builder> getColumnStatisticsTaskRuns() {
            List<ColumnStatisticsTaskRun.Builder> result = ColumnStatisticsTaskRunsListCopier.copyToBuilder(this.columnStatisticsTaskRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnStatisticsTaskRuns(Collection<ColumnStatisticsTaskRun.BuilderImpl> columnStatisticsTaskRuns) {
            this.columnStatisticsTaskRuns = ColumnStatisticsTaskRunsListCopier.copyFromBuilder(columnStatisticsTaskRuns);
        }

        @Override
        public final Builder columnStatisticsTaskRuns(Collection<ColumnStatisticsTaskRun> columnStatisticsTaskRuns) {
            this.columnStatisticsTaskRuns = ColumnStatisticsTaskRunsListCopier.copy(columnStatisticsTaskRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnStatisticsTaskRuns(ColumnStatisticsTaskRun ... columnStatisticsTaskRuns) {
            this.columnStatisticsTaskRuns(Arrays.asList(columnStatisticsTaskRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnStatisticsTaskRuns(Consumer<ColumnStatisticsTaskRun.Builder> ... columnStatisticsTaskRuns) {
            this.columnStatisticsTaskRuns(Stream.of(columnStatisticsTaskRuns).map(c -> (ColumnStatisticsTaskRun)((ColumnStatisticsTaskRun.Builder)ColumnStatisticsTaskRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetColumnStatisticsTaskRunsResponse build() {
            return new GetColumnStatisticsTaskRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetColumnStatisticsTaskRunsResponse> {
        public Builder columnStatisticsTaskRuns(Collection<ColumnStatisticsTaskRun> var1);

        public Builder columnStatisticsTaskRuns(ColumnStatisticsTaskRun ... var1);

        public Builder columnStatisticsTaskRuns(Consumer<ColumnStatisticsTaskRun.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

