/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartImportLabelsTaskRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, StartImportLabelsTaskRunRequest> {
    private static final SdkField<String> TRANSFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformId").getter(StartImportLabelsTaskRunRequest.getter(StartImportLabelsTaskRunRequest::transformId)).setter(StartImportLabelsTaskRunRequest.setter(Builder::transformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformId").build()}).build();
    private static final SdkField<String> INPUT_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputS3Path").getter(StartImportLabelsTaskRunRequest.getter(StartImportLabelsTaskRunRequest::inputS3Path)).setter(StartImportLabelsTaskRunRequest.setter(Builder::inputS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputS3Path").build()}).build();
    private static final SdkField<Boolean> REPLACE_ALL_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReplaceAllLabels").getter(StartImportLabelsTaskRunRequest.getter(StartImportLabelsTaskRunRequest::replaceAllLabels)).setter(StartImportLabelsTaskRunRequest.setter(Builder::replaceAllLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceAllLabels").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_ID_FIELD, INPUT_S3_PATH_FIELD, REPLACE_ALL_LABELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TransformId", TRANSFORM_ID_FIELD);
            this.put("InputS3Path", INPUT_S3_PATH_FIELD);
            this.put("ReplaceAllLabels", REPLACE_ALL_LABELS_FIELD);
        }
    });
    private final String transformId;
    private final String inputS3Path;
    private final Boolean replaceAllLabels;

    private StartImportLabelsTaskRunRequest(BuilderImpl builder) {
        super(builder);
        this.transformId = builder.transformId;
        this.inputS3Path = builder.inputS3Path;
        this.replaceAllLabels = builder.replaceAllLabels;
    }

    public final String transformId() {
        return this.transformId;
    }

    public final String inputS3Path() {
        return this.inputS3Path;
    }

    public final Boolean replaceAllLabels() {
        return this.replaceAllLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.replaceAllLabels());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportLabelsTaskRunRequest)) {
            return false;
        }
        StartImportLabelsTaskRunRequest other = (StartImportLabelsTaskRunRequest)((Object)obj);
        return Objects.equals(this.transformId(), other.transformId()) && Objects.equals(this.inputS3Path(), other.inputS3Path()) && Objects.equals(this.replaceAllLabels(), other.replaceAllLabels());
    }

    public final String toString() {
        return ToString.builder((String)"StartImportLabelsTaskRunRequest").add("TransformId", (Object)this.transformId()).add("InputS3Path", (Object)this.inputS3Path()).add("ReplaceAllLabels", (Object)this.replaceAllLabels()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformId": {
                return Optional.ofNullable(clazz.cast(this.transformId()));
            }
            case "InputS3Path": {
                return Optional.ofNullable(clazz.cast(this.inputS3Path()));
            }
            case "ReplaceAllLabels": {
                return Optional.ofNullable(clazz.cast(this.replaceAllLabels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartImportLabelsTaskRunRequest, T> g) {
        return obj -> g.apply((StartImportLabelsTaskRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String transformId;
        private String inputS3Path;
        private Boolean replaceAllLabels;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportLabelsTaskRunRequest model) {
            super(model);
            this.transformId(model.transformId);
            this.inputS3Path(model.inputS3Path);
            this.replaceAllLabels(model.replaceAllLabels);
        }

        public final String getTransformId() {
            return this.transformId;
        }

        public final void setTransformId(String transformId) {
            this.transformId = transformId;
        }

        @Override
        public final Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public final String getInputS3Path() {
            return this.inputS3Path;
        }

        public final void setInputS3Path(String inputS3Path) {
            this.inputS3Path = inputS3Path;
        }

        @Override
        public final Builder inputS3Path(String inputS3Path) {
            this.inputS3Path = inputS3Path;
            return this;
        }

        public final Boolean getReplaceAllLabels() {
            return this.replaceAllLabels;
        }

        public final void setReplaceAllLabels(Boolean replaceAllLabels) {
            this.replaceAllLabels = replaceAllLabels;
        }

        @Override
        public final Builder replaceAllLabels(Boolean replaceAllLabels) {
            this.replaceAllLabels = replaceAllLabels;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportLabelsTaskRunRequest build() {
            return new StartImportLabelsTaskRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartImportLabelsTaskRunRequest> {
        public Builder transformId(String var1);

        public Builder inputS3Path(String var1);

        public Builder replaceAllLabels(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

